// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewS3ServiceDeleteParams creates a new S3ServiceDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3ServiceDeleteParams() *S3ServiceDeleteParams {
	return &S3ServiceDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3ServiceDeleteParamsWithTimeout creates a new S3ServiceDeleteParams object
// with the ability to set a timeout on a request.
func NewS3ServiceDeleteParamsWithTimeout(timeout time.Duration) *S3ServiceDeleteParams {
	return &S3ServiceDeleteParams{
		timeout: timeout,
	}
}

// NewS3ServiceDeleteParamsWithContext creates a new S3ServiceDeleteParams object
// with the ability to set a context for a request.
func NewS3ServiceDeleteParamsWithContext(ctx context.Context) *S3ServiceDeleteParams {
	return &S3ServiceDeleteParams{
		Context: ctx,
	}
}

// NewS3ServiceDeleteParamsWithHTTPClient creates a new S3ServiceDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3ServiceDeleteParamsWithHTTPClient(client *http.Client) *S3ServiceDeleteParams {
	return &S3ServiceDeleteParams{
		HTTPClient: client,
	}
}

/*
S3ServiceDeleteParams contains all the parameters to send to the API endpoint

	for the s3 service delete operation.

	Typically these are written to a http.Request.
*/
type S3ServiceDeleteParams struct {

	/* DeleteAll.

	   Delete S3 server and associated users and empty buckets.

	   Default: true
	*/
	DeleteAll *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 service delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3ServiceDeleteParams) WithDefaults() *S3ServiceDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 service delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3ServiceDeleteParams) SetDefaults() {
	var (
		deleteAllDefault = bool(true)

		returnTimeoutDefault = int64(0)
	)

	val := S3ServiceDeleteParams{
		DeleteAll:     &deleteAllDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the s3 service delete params
func (o *S3ServiceDeleteParams) WithTimeout(timeout time.Duration) *S3ServiceDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 service delete params
func (o *S3ServiceDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 service delete params
func (o *S3ServiceDeleteParams) WithContext(ctx context.Context) *S3ServiceDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 service delete params
func (o *S3ServiceDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 service delete params
func (o *S3ServiceDeleteParams) WithHTTPClient(client *http.Client) *S3ServiceDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 service delete params
func (o *S3ServiceDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDeleteAll adds the deleteAll to the s3 service delete params
func (o *S3ServiceDeleteParams) WithDeleteAll(deleteAll *bool) *S3ServiceDeleteParams {
	o.SetDeleteAll(deleteAll)
	return o
}

// SetDeleteAll adds the deleteAll to the s3 service delete params
func (o *S3ServiceDeleteParams) SetDeleteAll(deleteAll *bool) {
	o.DeleteAll = deleteAll
}

// WithReturnTimeout adds the returnTimeout to the s3 service delete params
func (o *S3ServiceDeleteParams) WithReturnTimeout(returnTimeout *int64) *S3ServiceDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the s3 service delete params
func (o *S3ServiceDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmUUID adds the svmUUID to the s3 service delete params
func (o *S3ServiceDeleteParams) WithSvmUUID(svmUUID string) *S3ServiceDeleteParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 service delete params
func (o *S3ServiceDeleteParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *S3ServiceDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DeleteAll != nil {

		// query param delete_all
		var qrDeleteAll bool

		if o.DeleteAll != nil {
			qrDeleteAll = *o.DeleteAll
		}
		qDeleteAll := swag.FormatBool(qrDeleteAll)
		if qDeleteAll != "" {

			if err := r.SetQueryParam("delete_all", qDeleteAll); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
