// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3ServiceDeleteReader is a Reader for the S3ServiceDelete structure.
type S3ServiceDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3ServiceDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3ServiceDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewS3ServiceDeleteAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3ServiceDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3ServiceDeleteOK creates a S3ServiceDeleteOK with default headers values
func NewS3ServiceDeleteOK() *S3ServiceDeleteOK {
	return &S3ServiceDeleteOK{}
}

/*
S3ServiceDeleteOK describes a response with status code 200, with default header values.

OK
*/
type S3ServiceDeleteOK struct {
	Payload *models.S3ServiceJobLinkResponse
}

// IsSuccess returns true when this s3 service delete o k response has a 2xx status code
func (o *S3ServiceDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 service delete o k response has a 3xx status code
func (o *S3ServiceDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 service delete o k response has a 4xx status code
func (o *S3ServiceDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 service delete o k response has a 5xx status code
func (o *S3ServiceDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 service delete o k response a status code equal to that given
func (o *S3ServiceDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 service delete o k response
func (o *S3ServiceDeleteOK) Code() int {
	return 200
}

func (o *S3ServiceDeleteOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}][%d] s3ServiceDeleteOK %s", 200, payload)
}

func (o *S3ServiceDeleteOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}][%d] s3ServiceDeleteOK %s", 200, payload)
}

func (o *S3ServiceDeleteOK) GetPayload() *models.S3ServiceJobLinkResponse {
	return o.Payload
}

func (o *S3ServiceDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3ServiceJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3ServiceDeleteAccepted creates a S3ServiceDeleteAccepted with default headers values
func NewS3ServiceDeleteAccepted() *S3ServiceDeleteAccepted {
	return &S3ServiceDeleteAccepted{}
}

/*
S3ServiceDeleteAccepted describes a response with status code 202, with default header values.

Accepted
*/
type S3ServiceDeleteAccepted struct {
	Payload *models.S3ServiceJobLinkResponse
}

// IsSuccess returns true when this s3 service delete accepted response has a 2xx status code
func (o *S3ServiceDeleteAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 service delete accepted response has a 3xx status code
func (o *S3ServiceDeleteAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 service delete accepted response has a 4xx status code
func (o *S3ServiceDeleteAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 service delete accepted response has a 5xx status code
func (o *S3ServiceDeleteAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 service delete accepted response a status code equal to that given
func (o *S3ServiceDeleteAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the s3 service delete accepted response
func (o *S3ServiceDeleteAccepted) Code() int {
	return 202
}

func (o *S3ServiceDeleteAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}][%d] s3ServiceDeleteAccepted %s", 202, payload)
}

func (o *S3ServiceDeleteAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}][%d] s3ServiceDeleteAccepted %s", 202, payload)
}

func (o *S3ServiceDeleteAccepted) GetPayload() *models.S3ServiceJobLinkResponse {
	return o.Payload
}

func (o *S3ServiceDeleteAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3ServiceJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3ServiceDeleteDefault creates a S3ServiceDeleteDefault with default headers values
func NewS3ServiceDeleteDefault(code int) *S3ServiceDeleteDefault {
	return &S3ServiceDeleteDefault{
		_statusCode: code,
	}
}

/*
	S3ServiceDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 92405864   | An error occurs when deleting an S3 user or bucket. The reason for failure is detailed in the error message. Follow the error codes specified for the user or bucket endpoints to see details for the failure. |
*/
type S3ServiceDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 service delete default response has a 2xx status code
func (o *S3ServiceDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 service delete default response has a 3xx status code
func (o *S3ServiceDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 service delete default response has a 4xx status code
func (o *S3ServiceDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 service delete default response has a 5xx status code
func (o *S3ServiceDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 service delete default response a status code equal to that given
func (o *S3ServiceDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 service delete default response
func (o *S3ServiceDeleteDefault) Code() int {
	return o._statusCode
}

func (o *S3ServiceDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}][%d] s3_service_delete default %s", o._statusCode, payload)
}

func (o *S3ServiceDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}][%d] s3_service_delete default %s", o._statusCode, payload)
}

func (o *S3ServiceDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3ServiceDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
