// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewS3ServiceGetParams creates a new S3ServiceGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3ServiceGetParams() *S3ServiceGetParams {
	return &S3ServiceGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3ServiceGetParamsWithTimeout creates a new S3ServiceGetParams object
// with the ability to set a timeout on a request.
func NewS3ServiceGetParamsWithTimeout(timeout time.Duration) *S3ServiceGetParams {
	return &S3ServiceGetParams{
		timeout: timeout,
	}
}

// NewS3ServiceGetParamsWithContext creates a new S3ServiceGetParams object
// with the ability to set a context for a request.
func NewS3ServiceGetParamsWithContext(ctx context.Context) *S3ServiceGetParams {
	return &S3ServiceGetParams{
		Context: ctx,
	}
}

// NewS3ServiceGetParamsWithHTTPClient creates a new S3ServiceGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3ServiceGetParamsWithHTTPClient(client *http.Client) *S3ServiceGetParams {
	return &S3ServiceGetParams{
		HTTPClient: client,
	}
}

/*
S3ServiceGetParams contains all the parameters to send to the API endpoint

	for the s3 service get operation.

	Typically these are written to a http.Request.
*/
type S3ServiceGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 service get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3ServiceGetParams) WithDefaults() *S3ServiceGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 service get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3ServiceGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the s3 service get params
func (o *S3ServiceGetParams) WithTimeout(timeout time.Duration) *S3ServiceGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 service get params
func (o *S3ServiceGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 service get params
func (o *S3ServiceGetParams) WithContext(ctx context.Context) *S3ServiceGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 service get params
func (o *S3ServiceGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 service get params
func (o *S3ServiceGetParams) WithHTTPClient(client *http.Client) *S3ServiceGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 service get params
func (o *S3ServiceGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the s3 service get params
func (o *S3ServiceGetParams) WithFields(fields []string) *S3ServiceGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the s3 service get params
func (o *S3ServiceGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithSvmUUID adds the svmUUID to the s3 service get params
func (o *S3ServiceGetParams) WithSvmUUID(svmUUID string) *S3ServiceGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 service get params
func (o *S3ServiceGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *S3ServiceGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamS3ServiceGet binds the parameter fields
func (o *S3ServiceGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
