// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3ServiceModifyCollectionReader is a Reader for the S3ServiceModifyCollection structure.
type S3ServiceModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3ServiceModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3ServiceModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3ServiceModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3ServiceModifyCollectionOK creates a S3ServiceModifyCollectionOK with default headers values
func NewS3ServiceModifyCollectionOK() *S3ServiceModifyCollectionOK {
	return &S3ServiceModifyCollectionOK{}
}

/*
S3ServiceModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type S3ServiceModifyCollectionOK struct {
}

// IsSuccess returns true when this s3 service modify collection o k response has a 2xx status code
func (o *S3ServiceModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 service modify collection o k response has a 3xx status code
func (o *S3ServiceModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 service modify collection o k response has a 4xx status code
func (o *S3ServiceModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 service modify collection o k response has a 5xx status code
func (o *S3ServiceModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 service modify collection o k response a status code equal to that given
func (o *S3ServiceModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 service modify collection o k response
func (o *S3ServiceModifyCollectionOK) Code() int {
	return 200
}

func (o *S3ServiceModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/s3/services][%d] s3ServiceModifyCollectionOK", 200)
}

func (o *S3ServiceModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/s3/services][%d] s3ServiceModifyCollectionOK", 200)
}

func (o *S3ServiceModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewS3ServiceModifyCollectionDefault creates a S3ServiceModifyCollectionDefault with default headers values
func NewS3ServiceModifyCollectionDefault(code int) *S3ServiceModifyCollectionDefault {
	return &S3ServiceModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	S3ServiceModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 92405789   | The name \\\"{object server name}\\\" is not valid. A valid object server name must be a fully qualified domain name. |
| 92405790   | Object store server name is not valid. Object store server names must have between 3 and 253 characters.  |
| 92405900   | Certificate not found for SVM \\\"{svm.name}\\\".  |
| 92405917   | The specified certificate name and UUID do not refer to the same certificate.   |
| 92406020   | Only certificates of type \\\"server\\\" are supported.  |
| 92406153   | Set the enabled field of the server to "down" before modifying following fields: {field name} |
| 92406231   | One or more object store buckets exist with a default retention period greater than the \\\"max_lock_retention_period\\\" specified. Check the default retention period set for each bucket in the specified SVM and try the operation again.
| 92406237   | One or more object store buckets exist with a default retention period less than the \\\"min_lock_retention_period\\\" specified. Check the default retention period set for each bucket in the specified SVM and try the operation again.
| 92406238   | The value for the \\\"min_lock_retention_period\\\" parameter cannot be greater than the \\\"max_lock_retention_period\\\" parameter for the object store server for SVM \\\"vs1\\\".
*/
type S3ServiceModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 service modify collection default response has a 2xx status code
func (o *S3ServiceModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 service modify collection default response has a 3xx status code
func (o *S3ServiceModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 service modify collection default response has a 4xx status code
func (o *S3ServiceModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 service modify collection default response has a 5xx status code
func (o *S3ServiceModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 service modify collection default response a status code equal to that given
func (o *S3ServiceModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 service modify collection default response
func (o *S3ServiceModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *S3ServiceModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services][%d] s3_service_modify_collection default %s", o._statusCode, payload)
}

func (o *S3ServiceModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services][%d] s3_service_modify_collection default %s", o._statusCode, payload)
}

func (o *S3ServiceModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3ServiceModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
S3ServiceModifyCollectionBody s3 service modify collection body
swagger:model S3ServiceModifyCollectionBody
*/
type S3ServiceModifyCollectionBody struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// certificate
	Certificate *models.S3ServiceInlineCertificate `json:"certificate,omitempty"`

	// Can contain any additional information about the server being created or modified.
	// Example: S3 server
	// Max Length: 256
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Specifies the default UNIX user for NAS Access.
	DefaultUnixUser *string `json:"default_unix_user,omitempty"`

	// Specifies the default Windows user for NAS Access.
	DefaultWinUser *string `json:"default_win_user,omitempty"`

	// Specifies whether the S3 server being created or modified should be up or down.
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies whether HTTP is enabled on the S3 server being created or modified. By default, HTTP is disabled on the S3 server.
	IsHTTPEnabled *bool `json:"is_http_enabled,omitempty"`

	// Specifies whether HTTPS is enabled on the S3 server being created or modified. By default, HTTPS is enabled on the S3 server.
	IsHTTPSEnabled *bool `json:"is_https_enabled,omitempty"`

	// Indicates the maximum time period that an S3 user can specify for the 'key_time_to_live' property.
	// * Valid format is: 'PnDTnHnMnS|PnW'. For example, P2DT6H3M10S specifies a time period of 2 days, 6 hours, 3 minutes, and 10 seconds.
	// * If no value is specified for this property or the value specified is '0' seconds, then a user can specify any valid value.
	//
	// Example: PT6H3M
	MaxKeyTimeToLive *string `json:"max_key_time_to_live,omitempty"`

	// Specifies the maximum value that can be set as the retention period for an object in a bucket with locking enabled. The value for this property can be in years or days, not both. The value represents a duration and must be specified in the ISO-8601 duration format.  A period specified for years and days is represented in the ISO-8601 format as "P<num>Y" and "P<num>D" respectively, for example "P10Y" represents a duration of 10 years.
	// Example: P10Y
	MaxLockRetentionPeriod *string `json:"max_lock_retention_period,omitempty"`

	// metric
	Metric *models.S3ServiceInlineMetric `json:"metric,omitempty"`

	// Specifies the minimum value that can be set as the retention period for an object in a bucket with locking enabled. The value for this property can be in years or days, not both. The value represents a duration and must be specified in the ISO-8601 duration format.  A period specified for years and days is represented in the ISO-8601 format as "P<num>Y" and "P<num>D" respectively, for example "P10Y" represents a duration of 10 years.
	// Example: P10Y
	MinLockRetentionPeriod *string `json:"min_lock_retention_period,omitempty"`

	// Specifies the name of the S3 server. A server name can contain 3 to 253 characters using only the following combination of characters':' 0-9, A-Z, a-z, ".", and "-".
	// Example: Server-1
	// Max Length: 253
	// Min Length: 3
	Name *string `json:"name,omitempty"`

	// Specifies the HTTP listener port for the S3 server. By default, HTTP is enabled on port 80. Valid values range from 1 to 65535.
	// Example: 80
	// Maximum: 65535
	// Minimum: 1
	Port *int64 `json:"port,omitempty"`

	// This field cannot be specified in a PATCH method.
	S3ServiceInlineBuckets []*models.S3Bucket `json:"buckets,omitempty"`

	// This field cannot be specified in a PATCH method.
	S3ServiceInlineUsers []*models.S3User `json:"users,omitempty"`

	// s3 service response inline records
	S3ServiceResponseInlineRecords []*models.S3Service `json:"records,omitempty"`

	// Specifies the HTTPS listener port for the S3 server. By default, HTTPS is enabled on port 443. Valid values range from 1 to 65535.
	// Example: 443
	// Maximum: 65535
	// Minimum: 1
	SecurePort *int64 `json:"secure_port,omitempty"`

	// statistics
	Statistics *models.S3ServiceInlineStatistics `json:"statistics,omitempty"`

	// svm
	Svm *models.S3ServiceInlineSvm `json:"svm,omitempty"`
}

// Validate validates this s3 service modify collection body
func (o *S3ServiceModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCertificate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePort(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateS3ServiceInlineBuckets(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateS3ServiceInlineUsers(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateS3ServiceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSecurePort(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3ServiceModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceModifyCollectionBody) validateCertificate(formats strfmt.Registry) error {
	if swag.IsZero(o.Certificate) { // not required
		return nil
	}

	if o.Certificate != nil {
		if err := o.Certificate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceModifyCollectionBody) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"comment", "body", *o.Comment, 256); err != nil {
		return err
	}

	return nil
}

func (o *S3ServiceModifyCollectionBody) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(o.Metric) { // not required
		return nil
	}

	if o.Metric != nil {
		if err := o.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 3); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 253); err != nil {
		return err
	}

	return nil
}

func (o *S3ServiceModifyCollectionBody) validatePort(formats strfmt.Registry) error {
	if swag.IsZero(o.Port) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"port", "body", *o.Port, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"port", "body", *o.Port, 65535, false); err != nil {
		return err
	}

	return nil
}

func (o *S3ServiceModifyCollectionBody) validateS3ServiceInlineBuckets(formats strfmt.Registry) error {
	if swag.IsZero(o.S3ServiceInlineBuckets) { // not required
		return nil
	}

	for i := 0; i < len(o.S3ServiceInlineBuckets); i++ {
		if swag.IsZero(o.S3ServiceInlineBuckets[i]) { // not required
			continue
		}

		if o.S3ServiceInlineBuckets[i] != nil {
			if err := o.S3ServiceInlineBuckets[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "buckets" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3ServiceModifyCollectionBody) validateS3ServiceInlineUsers(formats strfmt.Registry) error {
	if swag.IsZero(o.S3ServiceInlineUsers) { // not required
		return nil
	}

	for i := 0; i < len(o.S3ServiceInlineUsers); i++ {
		if swag.IsZero(o.S3ServiceInlineUsers[i]) { // not required
			continue
		}

		if o.S3ServiceInlineUsers[i] != nil {
			if err := o.S3ServiceInlineUsers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "users" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3ServiceModifyCollectionBody) validateS3ServiceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.S3ServiceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.S3ServiceResponseInlineRecords); i++ {
		if swag.IsZero(o.S3ServiceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.S3ServiceResponseInlineRecords[i] != nil {
			if err := o.S3ServiceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3ServiceModifyCollectionBody) validateSecurePort(formats strfmt.Registry) error {
	if swag.IsZero(o.SecurePort) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"secure_port", "body", *o.SecurePort, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"secure_port", "body", *o.SecurePort, 65535, false); err != nil {
		return err
	}

	return nil
}

func (o *S3ServiceModifyCollectionBody) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(o.Statistics) { // not required
		return nil
	}

	if o.Statistics != nil {
		if err := o.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 service modify collection body based on the context it is used
func (o *S3ServiceModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCertificate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateS3ServiceInlineBuckets(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateS3ServiceInlineUsers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateS3ServiceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3ServiceModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceModifyCollectionBody) contextValidateCertificate(ctx context.Context, formats strfmt.Registry) error {

	if o.Certificate != nil {
		if err := o.Certificate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceModifyCollectionBody) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if o.Metric != nil {
		if err := o.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceModifyCollectionBody) contextValidateS3ServiceInlineBuckets(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3ServiceInlineBuckets); i++ {

		if o.S3ServiceInlineBuckets[i] != nil {
			if err := o.S3ServiceInlineBuckets[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "buckets" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3ServiceModifyCollectionBody) contextValidateS3ServiceInlineUsers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3ServiceInlineUsers); i++ {

		if o.S3ServiceInlineUsers[i] != nil {
			if err := o.S3ServiceInlineUsers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "users" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3ServiceModifyCollectionBody) contextValidateS3ServiceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3ServiceResponseInlineRecords); i++ {

		if o.S3ServiceResponseInlineRecords[i] != nil {
			if err := o.S3ServiceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3ServiceModifyCollectionBody) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if o.Statistics != nil {
		if err := o.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3ServiceModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3ServiceModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res S3ServiceModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3ServiceInlineCertificate Specifies the certificate that will be used for creating HTTPS connections to the S3 server.
swagger:model s3_service_inline_certificate
*/
type S3ServiceInlineCertificate struct {

	// links
	Links *models.S3ServiceInlineCertificateInlineLinks `json:"_links,omitempty"`

	// Certificate name
	Name *string `json:"name,omitempty"`

	// Certificate UUID
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 service inline certificate
func (o *S3ServiceInlineCertificate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3ServiceInlineCertificate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 service inline certificate based on the context it is used
func (o *S3ServiceInlineCertificate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3ServiceInlineCertificate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3ServiceInlineCertificate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3ServiceInlineCertificate) UnmarshalBinary(b []byte) error {
	var res S3ServiceInlineCertificate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3ServiceInlineCertificateInlineLinks s3 service inline certificate inline links
swagger:model s3_service_inline_certificate_inline__links
*/
type S3ServiceInlineCertificateInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 service inline certificate inline links
func (o *S3ServiceInlineCertificateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3ServiceInlineCertificateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 service inline certificate inline links based on the context it is used
func (o *S3ServiceInlineCertificateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3ServiceInlineCertificateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "certificate" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3ServiceInlineCertificateInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3ServiceInlineCertificateInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3ServiceInlineCertificateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3ServiceInlineMetric Performance numbers, such as IOPS latency and throughput, for SVM protocols.
swagger:model s3_service_inline_metric
*/
type S3ServiceInlineMetric struct {

	// links
	Links *models.S3ServiceInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *models.S3ServiceInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *models.S3ServiceInlineMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *models.S3ServiceInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this s3 service inline metric
func (o *S3ServiceInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3ServiceInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var s3ServiceInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3ServiceInlineMetricTypeDurationPropEnum = append(s3ServiceInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_service_inline_metric
	// S3ServiceInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// S3ServiceInlineMetricDurationPT15S captures enum value "PT15S"
	S3ServiceInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// s3_service_inline_metric
	// S3ServiceInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// S3ServiceInlineMetricDurationPT4M captures enum value "PT4M"
	S3ServiceInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// s3_service_inline_metric
	// S3ServiceInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// S3ServiceInlineMetricDurationPT30M captures enum value "PT30M"
	S3ServiceInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// s3_service_inline_metric
	// S3ServiceInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// S3ServiceInlineMetricDurationPT2H captures enum value "PT2H"
	S3ServiceInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// s3_service_inline_metric
	// S3ServiceInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// S3ServiceInlineMetricDurationP1D captures enum value "P1D"
	S3ServiceInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// s3_service_inline_metric
	// S3ServiceInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// S3ServiceInlineMetricDurationPT5M captures enum value "PT5M"
	S3ServiceInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (o *S3ServiceInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3ServiceInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *S3ServiceInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(o.Duration) { // not required
		return nil
	}

	// value enum
	if err := o.validateDurationEnum("info"+"."+"metric"+"."+"duration", "body", *o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *S3ServiceInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(o.Iops) { // not required
		return nil
	}

	if o.Iops != nil {
		if err := o.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(o.Latency) { // not required
		return nil
	}

	if o.Latency != nil {
		if err := o.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var s3ServiceInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3ServiceInlineMetricTypeStatusPropEnum = append(s3ServiceInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_service_inline_metric
	// S3ServiceInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// S3ServiceInlineMetricStatusOk captures enum value "ok"
	S3ServiceInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// s3_service_inline_metric
	// S3ServiceInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// S3ServiceInlineMetricStatusError captures enum value "error"
	S3ServiceInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// s3_service_inline_metric
	// S3ServiceInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// S3ServiceInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	S3ServiceInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// s3_service_inline_metric
	// S3ServiceInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// S3ServiceInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	S3ServiceInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// s3_service_inline_metric
	// S3ServiceInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// S3ServiceInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	S3ServiceInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// s3_service_inline_metric
	// S3ServiceInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// S3ServiceInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	S3ServiceInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// s3_service_inline_metric
	// S3ServiceInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// S3ServiceInlineMetricStatusNotFound captures enum value "not_found"
	S3ServiceInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// s3_service_inline_metric
	// S3ServiceInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// S3ServiceInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	S3ServiceInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// s3_service_inline_metric
	// S3ServiceInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// S3ServiceInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	S3ServiceInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// s3_service_inline_metric
	// S3ServiceInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// S3ServiceInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	S3ServiceInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// s3_service_inline_metric
	// S3ServiceInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// S3ServiceInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	S3ServiceInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *S3ServiceInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3ServiceInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *S3ServiceInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"metric"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *S3ServiceInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(o.Throughput) { // not required
		return nil
	}

	if o.Throughput != nil {
		if err := o.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"metric"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 service inline metric based on the context it is used
func (o *S3ServiceInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3ServiceInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"duration", "body", o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *S3ServiceInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if o.Iops != nil {
		if err := o.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if o.Latency != nil {
		if err := o.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *S3ServiceInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if o.Throughput != nil {
		if err := o.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3ServiceInlineMetric) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3ServiceInlineMetric) UnmarshalBinary(b []byte) error {
	var res S3ServiceInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3ServiceInlineMetricInlineLinks s3 service inline metric inline links
swagger:model s3_service_inline_metric_inline__links
*/
type S3ServiceInlineMetricInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 service inline metric inline links
func (o *S3ServiceInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3ServiceInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 service inline metric inline links based on the context it is used
func (o *S3ServiceInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3ServiceInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3ServiceInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3ServiceInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3ServiceInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3ServiceInlineMetricInlineIops The rate of I/O operations observed at the storage object.
swagger:model s3_service_inline_metric_inline_iops
*/
type S3ServiceInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this s3 service inline metric inline iops
func (o *S3ServiceInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this s3 service inline metric inline iops based on the context it is used
func (o *S3ServiceInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *S3ServiceInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3ServiceInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res S3ServiceInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3ServiceInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
swagger:model s3_service_inline_metric_inline_latency
*/
type S3ServiceInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this s3 service inline metric inline latency
func (o *S3ServiceInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this s3 service inline metric inline latency based on the context it is used
func (o *S3ServiceInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *S3ServiceInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3ServiceInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res S3ServiceInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3ServiceInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
swagger:model s3_service_inline_metric_inline_throughput
*/
type S3ServiceInlineMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this s3 service inline metric inline throughput
func (o *S3ServiceInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this s3 service inline metric inline throughput based on the context it is used
func (o *S3ServiceInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *S3ServiceInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3ServiceInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res S3ServiceInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3ServiceInlineStatistics These are raw performance numbers, such as IOPS latency and throughput for SVM protocols. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
swagger:model s3_service_inline_statistics
*/
type S3ServiceInlineStatistics struct {

	// iops raw
	IopsRaw *models.S3ServiceInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *models.S3ServiceInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *models.S3ServiceInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this s3 service inline statistics
func (o *S3ServiceInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3ServiceInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.IopsRaw) { // not required
		return nil
	}

	if o.IopsRaw != nil {
		if err := o.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.LatencyRaw) { // not required
		return nil
	}

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var s3ServiceInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3ServiceInlineStatisticsTypeStatusPropEnum = append(s3ServiceInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_service_inline_statistics
	// S3ServiceInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// S3ServiceInlineStatisticsStatusOk captures enum value "ok"
	S3ServiceInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// s3_service_inline_statistics
	// S3ServiceInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// S3ServiceInlineStatisticsStatusError captures enum value "error"
	S3ServiceInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// s3_service_inline_statistics
	// S3ServiceInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// S3ServiceInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	S3ServiceInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// s3_service_inline_statistics
	// S3ServiceInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// S3ServiceInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	S3ServiceInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// s3_service_inline_statistics
	// S3ServiceInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// S3ServiceInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	S3ServiceInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// s3_service_inline_statistics
	// S3ServiceInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// S3ServiceInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	S3ServiceInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// s3_service_inline_statistics
	// S3ServiceInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// S3ServiceInlineStatisticsStatusNotFound captures enum value "not_found"
	S3ServiceInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// s3_service_inline_statistics
	// S3ServiceInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// S3ServiceInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	S3ServiceInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// s3_service_inline_statistics
	// S3ServiceInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// S3ServiceInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	S3ServiceInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// s3_service_inline_statistics
	// S3ServiceInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// S3ServiceInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	S3ServiceInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// s3_service_inline_statistics
	// S3ServiceInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// S3ServiceInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	S3ServiceInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *S3ServiceInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3ServiceInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *S3ServiceInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"statistics"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *S3ServiceInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.ThroughputRaw) { // not required
		return nil
	}

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"statistics"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 service inline statistics based on the context it is used
func (o *S3ServiceInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3ServiceInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.IopsRaw != nil {
		if err := o.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *S3ServiceInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *S3ServiceInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3ServiceInlineStatistics) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3ServiceInlineStatistics) UnmarshalBinary(b []byte) error {
	var res S3ServiceInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3ServiceInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
swagger:model s3_service_inline_statistics_inline_iops_raw
*/
type S3ServiceInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this s3 service inline statistics inline iops raw
func (o *S3ServiceInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this s3 service inline statistics inline iops raw based on the context it is used
func (o *S3ServiceInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *S3ServiceInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3ServiceInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res S3ServiceInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3ServiceInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
swagger:model s3_service_inline_statistics_inline_latency_raw
*/
type S3ServiceInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this s3 service inline statistics inline latency raw
func (o *S3ServiceInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this s3 service inline statistics inline latency raw based on the context it is used
func (o *S3ServiceInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *S3ServiceInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3ServiceInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res S3ServiceInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3ServiceInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
swagger:model s3_service_inline_statistics_inline_throughput_raw
*/
type S3ServiceInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this s3 service inline statistics inline throughput raw
func (o *S3ServiceInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this s3 service inline statistics inline throughput raw based on the context it is used
func (o *S3ServiceInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *S3ServiceInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3ServiceInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res S3ServiceInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3ServiceInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model s3_service_inline_svm
*/
type S3ServiceInlineSvm struct {

	// links
	Links *models.S3ServiceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 service inline svm
func (o *S3ServiceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3ServiceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 service inline svm based on the context it is used
func (o *S3ServiceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3ServiceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3ServiceInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3ServiceInlineSvm) UnmarshalBinary(b []byte) error {
	var res S3ServiceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3ServiceInlineSvmInlineLinks s3 service inline svm inline links
swagger:model s3_service_inline_svm_inline__links
*/
type S3ServiceInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 service inline svm inline links
func (o *S3ServiceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3ServiceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 service inline svm inline links based on the context it is used
func (o *S3ServiceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3ServiceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3ServiceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3ServiceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3ServiceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
