// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewS3ServiceModifyParams creates a new S3ServiceModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3ServiceModifyParams() *S3ServiceModifyParams {
	return &S3ServiceModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3ServiceModifyParamsWithTimeout creates a new S3ServiceModifyParams object
// with the ability to set a timeout on a request.
func NewS3ServiceModifyParamsWithTimeout(timeout time.Duration) *S3ServiceModifyParams {
	return &S3ServiceModifyParams{
		timeout: timeout,
	}
}

// NewS3ServiceModifyParamsWithContext creates a new S3ServiceModifyParams object
// with the ability to set a context for a request.
func NewS3ServiceModifyParamsWithContext(ctx context.Context) *S3ServiceModifyParams {
	return &S3ServiceModifyParams{
		Context: ctx,
	}
}

// NewS3ServiceModifyParamsWithHTTPClient creates a new S3ServiceModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3ServiceModifyParamsWithHTTPClient(client *http.Client) *S3ServiceModifyParams {
	return &S3ServiceModifyParams{
		HTTPClient: client,
	}
}

/*
S3ServiceModifyParams contains all the parameters to send to the API endpoint

	for the s3 service modify operation.

	Typically these are written to a http.Request.
*/
type S3ServiceModifyParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.S3Service

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 service modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3ServiceModifyParams) WithDefaults() *S3ServiceModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 service modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3ServiceModifyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the s3 service modify params
func (o *S3ServiceModifyParams) WithTimeout(timeout time.Duration) *S3ServiceModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 service modify params
func (o *S3ServiceModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 service modify params
func (o *S3ServiceModifyParams) WithContext(ctx context.Context) *S3ServiceModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 service modify params
func (o *S3ServiceModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 service modify params
func (o *S3ServiceModifyParams) WithHTTPClient(client *http.Client) *S3ServiceModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 service modify params
func (o *S3ServiceModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the s3 service modify params
func (o *S3ServiceModifyParams) WithInfo(info *models.S3Service) *S3ServiceModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the s3 service modify params
func (o *S3ServiceModifyParams) SetInfo(info *models.S3Service) {
	o.Info = info
}

// WithSvmUUID adds the svmUUID to the s3 service modify params
func (o *S3ServiceModifyParams) WithSvmUUID(svmUUID string) *S3ServiceModifyParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 service modify params
func (o *S3ServiceModifyParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *S3ServiceModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
