// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3ServiceModifyReader is a Reader for the S3ServiceModify structure.
type S3ServiceModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3ServiceModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3ServiceModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3ServiceModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3ServiceModifyOK creates a S3ServiceModifyOK with default headers values
func NewS3ServiceModifyOK() *S3ServiceModifyOK {
	return &S3ServiceModifyOK{}
}

/*
S3ServiceModifyOK describes a response with status code 200, with default header values.

OK
*/
type S3ServiceModifyOK struct {
}

// IsSuccess returns true when this s3 service modify o k response has a 2xx status code
func (o *S3ServiceModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 service modify o k response has a 3xx status code
func (o *S3ServiceModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 service modify o k response has a 4xx status code
func (o *S3ServiceModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 service modify o k response has a 5xx status code
func (o *S3ServiceModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 service modify o k response a status code equal to that given
func (o *S3ServiceModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 service modify o k response
func (o *S3ServiceModifyOK) Code() int {
	return 200
}

func (o *S3ServiceModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}][%d] s3ServiceModifyOK", 200)
}

func (o *S3ServiceModifyOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}][%d] s3ServiceModifyOK", 200)
}

func (o *S3ServiceModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewS3ServiceModifyDefault creates a S3ServiceModifyDefault with default headers values
func NewS3ServiceModifyDefault(code int) *S3ServiceModifyDefault {
	return &S3ServiceModifyDefault{
		_statusCode: code,
	}
}

/*
	S3ServiceModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 92405789   | The name \\\"{object server name}\\\" is not valid. A valid object server name must be a fully qualified domain name. |
| 92405790   | Object store server name is not valid. Object store server names must have between 3 and 253 characters.  |
| 92405900   | Certificate not found for SVM \\\"{svm.name}\\\".  |
| 92405917   | The specified certificate name and UUID do not refer to the same certificate.   |
| 92406020   | Only certificates of type \\\"server\\\" are supported.  |
| 92406153   | Set the enabled field of the server to "down" before modifying following fields: {field name} |
| 92406231   | One or more object store buckets exist with a default retention period greater than the \\\"max_lock_retention_period\\\" specified. Check the default retention period set for each bucket in the specified SVM and try the operation again.
| 92406237   | One or more object store buckets exist with a default retention period less than the \\\"min_lock_retention_period\\\" specified. Check the default retention period set for each bucket in the specified SVM and try the operation again.
| 92406238   | The value for the \\\"min_lock_retention_period\\\" parameter cannot be greater than the \\\"max_lock_retention_period\\\" parameter for the object store server for SVM \\\"vs1\\\".
*/
type S3ServiceModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 service modify default response has a 2xx status code
func (o *S3ServiceModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 service modify default response has a 3xx status code
func (o *S3ServiceModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 service modify default response has a 4xx status code
func (o *S3ServiceModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 service modify default response has a 5xx status code
func (o *S3ServiceModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 service modify default response a status code equal to that given
func (o *S3ServiceModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 service modify default response
func (o *S3ServiceModifyDefault) Code() int {
	return o._statusCode
}

func (o *S3ServiceModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}][%d] s3_service_modify default %s", o._statusCode, payload)
}

func (o *S3ServiceModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}][%d] s3_service_modify default %s", o._statusCode, payload)
}

func (o *S3ServiceModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3ServiceModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
