// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewS3UserCollectionGetParams creates a new S3UserCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3UserCollectionGetParams() *S3UserCollectionGetParams {
	return &S3UserCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3UserCollectionGetParamsWithTimeout creates a new S3UserCollectionGetParams object
// with the ability to set a timeout on a request.
func NewS3UserCollectionGetParamsWithTimeout(timeout time.Duration) *S3UserCollectionGetParams {
	return &S3UserCollectionGetParams{
		timeout: timeout,
	}
}

// NewS3UserCollectionGetParamsWithContext creates a new S3UserCollectionGetParams object
// with the ability to set a context for a request.
func NewS3UserCollectionGetParamsWithContext(ctx context.Context) *S3UserCollectionGetParams {
	return &S3UserCollectionGetParams{
		Context: ctx,
	}
}

// NewS3UserCollectionGetParamsWithHTTPClient creates a new S3UserCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3UserCollectionGetParamsWithHTTPClient(client *http.Client) *S3UserCollectionGetParams {
	return &S3UserCollectionGetParams{
		HTTPClient: client,
	}
}

/*
S3UserCollectionGetParams contains all the parameters to send to the API endpoint

	for the s3 user collection get operation.

	Typically these are written to a http.Request.
*/
type S3UserCollectionGetParams struct {

	/* AccessKey.

	   Filter by access_key
	*/
	AccessKey *string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* KeyExpiryTime.

	   Filter by key_expiry_time
	*/
	KeyExpiryTime *string

	/* KeyTimeToLive.

	   Filter by key_time_to_live
	*/
	KeyTimeToLive *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 user collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3UserCollectionGetParams) WithDefaults() *S3UserCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 user collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3UserCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := S3UserCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the s3 user collection get params
func (o *S3UserCollectionGetParams) WithTimeout(timeout time.Duration) *S3UserCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 user collection get params
func (o *S3UserCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 user collection get params
func (o *S3UserCollectionGetParams) WithContext(ctx context.Context) *S3UserCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 user collection get params
func (o *S3UserCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 user collection get params
func (o *S3UserCollectionGetParams) WithHTTPClient(client *http.Client) *S3UserCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 user collection get params
func (o *S3UserCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccessKey adds the accessKey to the s3 user collection get params
func (o *S3UserCollectionGetParams) WithAccessKey(accessKey *string) *S3UserCollectionGetParams {
	o.SetAccessKey(accessKey)
	return o
}

// SetAccessKey adds the accessKey to the s3 user collection get params
func (o *S3UserCollectionGetParams) SetAccessKey(accessKey *string) {
	o.AccessKey = accessKey
}

// WithComment adds the comment to the s3 user collection get params
func (o *S3UserCollectionGetParams) WithComment(comment *string) *S3UserCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the s3 user collection get params
func (o *S3UserCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithFields adds the fields to the s3 user collection get params
func (o *S3UserCollectionGetParams) WithFields(fields []string) *S3UserCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the s3 user collection get params
func (o *S3UserCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithKeyExpiryTime adds the keyExpiryTime to the s3 user collection get params
func (o *S3UserCollectionGetParams) WithKeyExpiryTime(keyExpiryTime *string) *S3UserCollectionGetParams {
	o.SetKeyExpiryTime(keyExpiryTime)
	return o
}

// SetKeyExpiryTime adds the keyExpiryTime to the s3 user collection get params
func (o *S3UserCollectionGetParams) SetKeyExpiryTime(keyExpiryTime *string) {
	o.KeyExpiryTime = keyExpiryTime
}

// WithKeyTimeToLive adds the keyTimeToLive to the s3 user collection get params
func (o *S3UserCollectionGetParams) WithKeyTimeToLive(keyTimeToLive *string) *S3UserCollectionGetParams {
	o.SetKeyTimeToLive(keyTimeToLive)
	return o
}

// SetKeyTimeToLive adds the keyTimeToLive to the s3 user collection get params
func (o *S3UserCollectionGetParams) SetKeyTimeToLive(keyTimeToLive *string) {
	o.KeyTimeToLive = keyTimeToLive
}

// WithMaxRecords adds the maxRecords to the s3 user collection get params
func (o *S3UserCollectionGetParams) WithMaxRecords(maxRecords *int64) *S3UserCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the s3 user collection get params
func (o *S3UserCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the s3 user collection get params
func (o *S3UserCollectionGetParams) WithName(name *string) *S3UserCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the s3 user collection get params
func (o *S3UserCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the s3 user collection get params
func (o *S3UserCollectionGetParams) WithOrderBy(orderBy []string) *S3UserCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the s3 user collection get params
func (o *S3UserCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the s3 user collection get params
func (o *S3UserCollectionGetParams) WithReturnRecords(returnRecords *bool) *S3UserCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the s3 user collection get params
func (o *S3UserCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the s3 user collection get params
func (o *S3UserCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *S3UserCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the s3 user collection get params
func (o *S3UserCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the s3 user collection get params
func (o *S3UserCollectionGetParams) WithSvmName(svmName *string) *S3UserCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the s3 user collection get params
func (o *S3UserCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the s3 user collection get params
func (o *S3UserCollectionGetParams) WithSvmUUID(svmUUID string) *S3UserCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 user collection get params
func (o *S3UserCollectionGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *S3UserCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccessKey != nil {

		// query param access_key
		var qrAccessKey string

		if o.AccessKey != nil {
			qrAccessKey = *o.AccessKey
		}
		qAccessKey := qrAccessKey
		if qAccessKey != "" {

			if err := r.SetQueryParam("access_key", qAccessKey); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.KeyExpiryTime != nil {

		// query param key_expiry_time
		var qrKeyExpiryTime string

		if o.KeyExpiryTime != nil {
			qrKeyExpiryTime = *o.KeyExpiryTime
		}
		qKeyExpiryTime := qrKeyExpiryTime
		if qKeyExpiryTime != "" {

			if err := r.SetQueryParam("key_expiry_time", qKeyExpiryTime); err != nil {
				return err
			}
		}
	}

	if o.KeyTimeToLive != nil {

		// query param key_time_to_live
		var qrKeyTimeToLive string

		if o.KeyTimeToLive != nil {
			qrKeyTimeToLive = *o.KeyTimeToLive
		}
		qKeyTimeToLive := qrKeyTimeToLive
		if qKeyTimeToLive != "" {

			if err := r.SetQueryParam("key_time_to_live", qKeyTimeToLive); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamS3UserCollectionGet binds the parameter fields
func (o *S3UserCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamS3UserCollectionGet binds the parameter order_by
func (o *S3UserCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
