// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewS3UserCreateParams creates a new S3UserCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3UserCreateParams() *S3UserCreateParams {
	return &S3UserCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3UserCreateParamsWithTimeout creates a new S3UserCreateParams object
// with the ability to set a timeout on a request.
func NewS3UserCreateParamsWithTimeout(timeout time.Duration) *S3UserCreateParams {
	return &S3UserCreateParams{
		timeout: timeout,
	}
}

// NewS3UserCreateParamsWithContext creates a new S3UserCreateParams object
// with the ability to set a context for a request.
func NewS3UserCreateParamsWithContext(ctx context.Context) *S3UserCreateParams {
	return &S3UserCreateParams{
		Context: ctx,
	}
}

// NewS3UserCreateParamsWithHTTPClient creates a new S3UserCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3UserCreateParamsWithHTTPClient(client *http.Client) *S3UserCreateParams {
	return &S3UserCreateParams{
		HTTPClient: client,
	}
}

/*
S3UserCreateParams contains all the parameters to send to the API endpoint

	for the s3 user create operation.

	Typically these are written to a http.Request.
*/
type S3UserCreateParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.S3User

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 user create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3UserCreateParams) WithDefaults() *S3UserCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 user create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3UserCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := S3UserCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the s3 user create params
func (o *S3UserCreateParams) WithTimeout(timeout time.Duration) *S3UserCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 user create params
func (o *S3UserCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 user create params
func (o *S3UserCreateParams) WithContext(ctx context.Context) *S3UserCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 user create params
func (o *S3UserCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 user create params
func (o *S3UserCreateParams) WithHTTPClient(client *http.Client) *S3UserCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 user create params
func (o *S3UserCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the s3 user create params
func (o *S3UserCreateParams) WithInfo(info *models.S3User) *S3UserCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the s3 user create params
func (o *S3UserCreateParams) SetInfo(info *models.S3User) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the s3 user create params
func (o *S3UserCreateParams) WithReturnRecords(returnRecords *bool) *S3UserCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the s3 user create params
func (o *S3UserCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithSvmUUID adds the svmUUID to the s3 user create params
func (o *S3UserCreateParams) WithSvmUUID(svmUUID string) *S3UserCreateParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 user create params
func (o *S3UserCreateParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *S3UserCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
