// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3UserCreateReader is a Reader for the S3UserCreate structure.
type S3UserCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3UserCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewS3UserCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3UserCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3UserCreateCreated creates a S3UserCreateCreated with default headers values
func NewS3UserCreateCreated() *S3UserCreateCreated {
	return &S3UserCreateCreated{}
}

/*
S3UserCreateCreated describes a response with status code 201, with default header values.

Created
*/
type S3UserCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.S3UserPostPatchResponse
}

// IsSuccess returns true when this s3 user create created response has a 2xx status code
func (o *S3UserCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 user create created response has a 3xx status code
func (o *S3UserCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 user create created response has a 4xx status code
func (o *S3UserCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 user create created response has a 5xx status code
func (o *S3UserCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 user create created response a status code equal to that given
func (o *S3UserCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the s3 user create created response
func (o *S3UserCreateCreated) Code() int {
	return 201
}

func (o *S3UserCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/s3/services/{svm.uuid}/users][%d] s3UserCreateCreated %s", 201, payload)
}

func (o *S3UserCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/s3/services/{svm.uuid}/users][%d] s3UserCreateCreated %s", 201, payload)
}

func (o *S3UserCreateCreated) GetPayload() *models.S3UserPostPatchResponse {
	return o.Payload
}

func (o *S3UserCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.S3UserPostPatchResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3UserCreateDefault creates a S3UserCreateDefault with default headers values
func NewS3UserCreateDefault(code int) *S3UserCreateDefault {
	return &S3UserCreateDefault{
		_statusCode: code,
	}
}

/*
	S3UserCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 92405787   | User name \"User#1\" contains invalid characters. Valid characters for a user name are 0-9, A-Z, a-z, \"_\", \"+\", \"=\", \",\", \".\", \"@\", and \"-\". |
| 92405788   | User name \"User0123456789012345678901234567890123456789012345678901234567890123456789012345\" is not valid. User names must have between 1 and 64 characters. |
| 92405791   | Failed to create access-key and secret-key. |
| 92405817   | SVM \"<non-data SVM name>\" is not a data SVM. Specify a data SVM. |
| 92406083   | The maximum supported value for user key expiry configuration is \"1095\" days. |
| 92406096   | The user does not have permission to access the requested resource \\\"{0}\\\". |
| 92406097   | Internal error. The operation configuration is not correct. |
| 92406196   | The specified value for the \"key_time_to_live\" field cannot be greater than the maximum limit specified for the \"max_key_time_to_live\" field in the object store server. |
| 92406197   | Object store user \"user-2\" must have a non-zero value for the \"key_time_to_live\" field because the maximum limit specified for the \"max_key_time_to_live\" field in the object store server is not zero.
| 92406200   | An object store user with the same access-key already exists. |
| 92406201   | Missing access-key or secret-key. Either provide both of the keys or none. If not provided, keys are generated automatically. |
| 92406205   | The object store user access key contains invalid characters. Valid characters are 0-9 and A-Z. |
*/
type S3UserCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 user create default response has a 2xx status code
func (o *S3UserCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 user create default response has a 3xx status code
func (o *S3UserCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 user create default response has a 4xx status code
func (o *S3UserCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 user create default response has a 5xx status code
func (o *S3UserCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 user create default response a status code equal to that given
func (o *S3UserCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 user create default response
func (o *S3UserCreateDefault) Code() int {
	return o._statusCode
}

func (o *S3UserCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/s3/services/{svm.uuid}/users][%d] s3_user_create default %s", o._statusCode, payload)
}

func (o *S3UserCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/s3/services/{svm.uuid}/users][%d] s3_user_create default %s", o._statusCode, payload)
}

func (o *S3UserCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3UserCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
