// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewS3UserDeleteCollectionParams creates a new S3UserDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3UserDeleteCollectionParams() *S3UserDeleteCollectionParams {
	return &S3UserDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3UserDeleteCollectionParamsWithTimeout creates a new S3UserDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewS3UserDeleteCollectionParamsWithTimeout(timeout time.Duration) *S3UserDeleteCollectionParams {
	return &S3UserDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewS3UserDeleteCollectionParamsWithContext creates a new S3UserDeleteCollectionParams object
// with the ability to set a context for a request.
func NewS3UserDeleteCollectionParamsWithContext(ctx context.Context) *S3UserDeleteCollectionParams {
	return &S3UserDeleteCollectionParams{
		Context: ctx,
	}
}

// NewS3UserDeleteCollectionParamsWithHTTPClient creates a new S3UserDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3UserDeleteCollectionParamsWithHTTPClient(client *http.Client) *S3UserDeleteCollectionParams {
	return &S3UserDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
S3UserDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the s3 user delete collection operation.

	Typically these are written to a http.Request.
*/
type S3UserDeleteCollectionParams struct {

	/* AccessKey.

	   Filter by access_key
	*/
	AccessKey *string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info S3UserDeleteCollectionBody

	/* KeyExpiryTime.

	   Filter by key_expiry_time
	*/
	KeyExpiryTime *string

	/* KeyTimeToLive.

	   Filter by key_time_to_live
	*/
	KeyTimeToLive *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 user delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3UserDeleteCollectionParams) WithDefaults() *S3UserDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 user delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3UserDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := S3UserDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) WithTimeout(timeout time.Duration) *S3UserDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) WithContext(ctx context.Context) *S3UserDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) WithHTTPClient(client *http.Client) *S3UserDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccessKey adds the accessKey to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) WithAccessKey(accessKey *string) *S3UserDeleteCollectionParams {
	o.SetAccessKey(accessKey)
	return o
}

// SetAccessKey adds the accessKey to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) SetAccessKey(accessKey *string) {
	o.AccessKey = accessKey
}

// WithComment adds the comment to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) WithComment(comment *string) *S3UserDeleteCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithContinueOnFailure adds the continueOnFailure to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *S3UserDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) WithInfo(info S3UserDeleteCollectionBody) *S3UserDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) SetInfo(info S3UserDeleteCollectionBody) {
	o.Info = info
}

// WithKeyExpiryTime adds the keyExpiryTime to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) WithKeyExpiryTime(keyExpiryTime *string) *S3UserDeleteCollectionParams {
	o.SetKeyExpiryTime(keyExpiryTime)
	return o
}

// SetKeyExpiryTime adds the keyExpiryTime to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) SetKeyExpiryTime(keyExpiryTime *string) {
	o.KeyExpiryTime = keyExpiryTime
}

// WithKeyTimeToLive adds the keyTimeToLive to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) WithKeyTimeToLive(keyTimeToLive *string) *S3UserDeleteCollectionParams {
	o.SetKeyTimeToLive(keyTimeToLive)
	return o
}

// SetKeyTimeToLive adds the keyTimeToLive to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) SetKeyTimeToLive(keyTimeToLive *string) {
	o.KeyTimeToLive = keyTimeToLive
}

// WithName adds the name to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) WithName(name *string) *S3UserDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithReturnRecords adds the returnRecords to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *S3UserDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *S3UserDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *S3UserDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) WithSvmName(svmName *string) *S3UserDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) WithSvmUUID(svmUUID string) *S3UserDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 user delete collection params
func (o *S3UserDeleteCollectionParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *S3UserDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccessKey != nil {

		// query param access_key
		var qrAccessKey string

		if o.AccessKey != nil {
			qrAccessKey = *o.AccessKey
		}
		qAccessKey := qrAccessKey
		if qAccessKey != "" {

			if err := r.SetQueryParam("access_key", qAccessKey); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.KeyExpiryTime != nil {

		// query param key_expiry_time
		var qrKeyExpiryTime string

		if o.KeyExpiryTime != nil {
			qrKeyExpiryTime = *o.KeyExpiryTime
		}
		qKeyExpiryTime := qrKeyExpiryTime
		if qKeyExpiryTime != "" {

			if err := r.SetQueryParam("key_expiry_time", qKeyExpiryTime); err != nil {
				return err
			}
		}
	}

	if o.KeyTimeToLive != nil {

		// query param key_time_to_live
		var qrKeyTimeToLive string

		if o.KeyTimeToLive != nil {
			qrKeyTimeToLive = *o.KeyTimeToLive
		}
		qKeyTimeToLive := qrKeyTimeToLive
		if qKeyTimeToLive != "" {

			if err := r.SetQueryParam("key_time_to_live", qKeyTimeToLive); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
