// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3UserDeleteReader is a Reader for the S3UserDelete structure.
type S3UserDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3UserDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3UserDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3UserDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3UserDeleteOK creates a S3UserDeleteOK with default headers values
func NewS3UserDeleteOK() *S3UserDeleteOK {
	return &S3UserDeleteOK{}
}

/*
S3UserDeleteOK describes a response with status code 200, with default header values.

OK
*/
type S3UserDeleteOK struct {
}

// IsSuccess returns true when this s3 user delete o k response has a 2xx status code
func (o *S3UserDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 user delete o k response has a 3xx status code
func (o *S3UserDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 user delete o k response has a 4xx status code
func (o *S3UserDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 user delete o k response has a 5xx status code
func (o *S3UserDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 user delete o k response a status code equal to that given
func (o *S3UserDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 user delete o k response
func (o *S3UserDeleteOK) Code() int {
	return 200
}

func (o *S3UserDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/users/{name}][%d] s3UserDeleteOK", 200)
}

func (o *S3UserDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/users/{name}][%d] s3UserDeleteOK", 200)
}

func (o *S3UserDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewS3UserDeleteDefault creates a S3UserDeleteDefault with default headers values
func NewS3UserDeleteDefault(code int) *S3UserDeleteDefault {
	return &S3UserDeleteDefault{
		_statusCode: code,
	}
}

/*
S3UserDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type S3UserDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 user delete default response has a 2xx status code
func (o *S3UserDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 user delete default response has a 3xx status code
func (o *S3UserDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 user delete default response has a 4xx status code
func (o *S3UserDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 user delete default response has a 5xx status code
func (o *S3UserDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 user delete default response a status code equal to that given
func (o *S3UserDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 user delete default response
func (o *S3UserDeleteDefault) Code() int {
	return o._statusCode
}

func (o *S3UserDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/users/{name}][%d] s3_user_delete default %s", o._statusCode, payload)
}

func (o *S3UserDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/users/{name}][%d] s3_user_delete default %s", o._statusCode, payload)
}

func (o *S3UserDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3UserDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
