// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewS3UserGetParams creates a new S3UserGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3UserGetParams() *S3UserGetParams {
	return &S3UserGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3UserGetParamsWithTimeout creates a new S3UserGetParams object
// with the ability to set a timeout on a request.
func NewS3UserGetParamsWithTimeout(timeout time.Duration) *S3UserGetParams {
	return &S3UserGetParams{
		timeout: timeout,
	}
}

// NewS3UserGetParamsWithContext creates a new S3UserGetParams object
// with the ability to set a context for a request.
func NewS3UserGetParamsWithContext(ctx context.Context) *S3UserGetParams {
	return &S3UserGetParams{
		Context: ctx,
	}
}

// NewS3UserGetParamsWithHTTPClient creates a new S3UserGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3UserGetParamsWithHTTPClient(client *http.Client) *S3UserGetParams {
	return &S3UserGetParams{
		HTTPClient: client,
	}
}

/*
S3UserGetParams contains all the parameters to send to the API endpoint

	for the s3 user get operation.

	Typically these are written to a http.Request.
*/
type S3UserGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Name.

	   User name
	*/
	Name string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 user get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3UserGetParams) WithDefaults() *S3UserGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 user get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3UserGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the s3 user get params
func (o *S3UserGetParams) WithTimeout(timeout time.Duration) *S3UserGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 user get params
func (o *S3UserGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 user get params
func (o *S3UserGetParams) WithContext(ctx context.Context) *S3UserGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 user get params
func (o *S3UserGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 user get params
func (o *S3UserGetParams) WithHTTPClient(client *http.Client) *S3UserGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 user get params
func (o *S3UserGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the s3 user get params
func (o *S3UserGetParams) WithFields(fields []string) *S3UserGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the s3 user get params
func (o *S3UserGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithName adds the name to the s3 user get params
func (o *S3UserGetParams) WithName(name string) *S3UserGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the s3 user get params
func (o *S3UserGetParams) SetName(name string) {
	o.Name = name
}

// WithSvmUUID adds the svmUUID to the s3 user get params
func (o *S3UserGetParams) WithSvmUUID(svmUUID string) *S3UserGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 user get params
func (o *S3UserGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *S3UserGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamS3UserGet binds the parameter fields
func (o *S3UserGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
