// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewS3UserModifyCollectionParams creates a new S3UserModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3UserModifyCollectionParams() *S3UserModifyCollectionParams {
	return &S3UserModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3UserModifyCollectionParamsWithTimeout creates a new S3UserModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewS3UserModifyCollectionParamsWithTimeout(timeout time.Duration) *S3UserModifyCollectionParams {
	return &S3UserModifyCollectionParams{
		timeout: timeout,
	}
}

// NewS3UserModifyCollectionParamsWithContext creates a new S3UserModifyCollectionParams object
// with the ability to set a context for a request.
func NewS3UserModifyCollectionParamsWithContext(ctx context.Context) *S3UserModifyCollectionParams {
	return &S3UserModifyCollectionParams{
		Context: ctx,
	}
}

// NewS3UserModifyCollectionParamsWithHTTPClient creates a new S3UserModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3UserModifyCollectionParamsWithHTTPClient(client *http.Client) *S3UserModifyCollectionParams {
	return &S3UserModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
S3UserModifyCollectionParams contains all the parameters to send to the API endpoint

	for the s3 user modify collection operation.

	Typically these are written to a http.Request.
*/
type S3UserModifyCollectionParams struct {

	/* AccessKey.

	   Filter by access_key
	*/
	AccessKey *string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* DeleteKeys.

	   Specifies whether or not to delete the user keys.

	*/
	DeleteKeys *bool

	/* Info.

	   Info specification
	*/
	Info S3UserModifyCollectionBody

	/* KeyExpiryTime.

	   Filter by key_expiry_time
	*/
	KeyExpiryTime *string

	/* KeyTimeToLive.

	   Filter by key_time_to_live
	*/
	KeyTimeToLive *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* RegenerateKeys.

	   Specifies whether or not to regenerate the user keys.

	*/
	RegenerateKeys *bool

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 user modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3UserModifyCollectionParams) WithDefaults() *S3UserModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 user modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3UserModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		deleteKeysDefault = bool(false)

		regenerateKeysDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := S3UserModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		DeleteKeys:        &deleteKeysDefault,
		RegenerateKeys:    &regenerateKeysDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) WithTimeout(timeout time.Duration) *S3UserModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) WithContext(ctx context.Context) *S3UserModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) WithHTTPClient(client *http.Client) *S3UserModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccessKey adds the accessKey to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) WithAccessKey(accessKey *string) *S3UserModifyCollectionParams {
	o.SetAccessKey(accessKey)
	return o
}

// SetAccessKey adds the accessKey to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) SetAccessKey(accessKey *string) {
	o.AccessKey = accessKey
}

// WithComment adds the comment to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) WithComment(comment *string) *S3UserModifyCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithContinueOnFailure adds the continueOnFailure to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *S3UserModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDeleteKeys adds the deleteKeys to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) WithDeleteKeys(deleteKeys *bool) *S3UserModifyCollectionParams {
	o.SetDeleteKeys(deleteKeys)
	return o
}

// SetDeleteKeys adds the deleteKeys to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) SetDeleteKeys(deleteKeys *bool) {
	o.DeleteKeys = deleteKeys
}

// WithInfo adds the info to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) WithInfo(info S3UserModifyCollectionBody) *S3UserModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) SetInfo(info S3UserModifyCollectionBody) {
	o.Info = info
}

// WithKeyExpiryTime adds the keyExpiryTime to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) WithKeyExpiryTime(keyExpiryTime *string) *S3UserModifyCollectionParams {
	o.SetKeyExpiryTime(keyExpiryTime)
	return o
}

// SetKeyExpiryTime adds the keyExpiryTime to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) SetKeyExpiryTime(keyExpiryTime *string) {
	o.KeyExpiryTime = keyExpiryTime
}

// WithKeyTimeToLive adds the keyTimeToLive to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) WithKeyTimeToLive(keyTimeToLive *string) *S3UserModifyCollectionParams {
	o.SetKeyTimeToLive(keyTimeToLive)
	return o
}

// SetKeyTimeToLive adds the keyTimeToLive to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) SetKeyTimeToLive(keyTimeToLive *string) {
	o.KeyTimeToLive = keyTimeToLive
}

// WithName adds the name to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) WithName(name *string) *S3UserModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithRegenerateKeys adds the regenerateKeys to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) WithRegenerateKeys(regenerateKeys *bool) *S3UserModifyCollectionParams {
	o.SetRegenerateKeys(regenerateKeys)
	return o
}

// SetRegenerateKeys adds the regenerateKeys to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) SetRegenerateKeys(regenerateKeys *bool) {
	o.RegenerateKeys = regenerateKeys
}

// WithReturnRecords adds the returnRecords to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) WithReturnRecords(returnRecords *bool) *S3UserModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *S3UserModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) WithSerialRecords(serialRecords *bool) *S3UserModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) WithSvmName(svmName *string) *S3UserModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) WithSvmUUID(svmUUID string) *S3UserModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 user modify collection params
func (o *S3UserModifyCollectionParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *S3UserModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccessKey != nil {

		// query param access_key
		var qrAccessKey string

		if o.AccessKey != nil {
			qrAccessKey = *o.AccessKey
		}
		qAccessKey := qrAccessKey
		if qAccessKey != "" {

			if err := r.SetQueryParam("access_key", qAccessKey); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.DeleteKeys != nil {

		// query param delete_keys
		var qrDeleteKeys bool

		if o.DeleteKeys != nil {
			qrDeleteKeys = *o.DeleteKeys
		}
		qDeleteKeys := swag.FormatBool(qrDeleteKeys)
		if qDeleteKeys != "" {

			if err := r.SetQueryParam("delete_keys", qDeleteKeys); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.KeyExpiryTime != nil {

		// query param key_expiry_time
		var qrKeyExpiryTime string

		if o.KeyExpiryTime != nil {
			qrKeyExpiryTime = *o.KeyExpiryTime
		}
		qKeyExpiryTime := qrKeyExpiryTime
		if qKeyExpiryTime != "" {

			if err := r.SetQueryParam("key_expiry_time", qKeyExpiryTime); err != nil {
				return err
			}
		}
	}

	if o.KeyTimeToLive != nil {

		// query param key_time_to_live
		var qrKeyTimeToLive string

		if o.KeyTimeToLive != nil {
			qrKeyTimeToLive = *o.KeyTimeToLive
		}
		qKeyTimeToLive := qrKeyTimeToLive
		if qKeyTimeToLive != "" {

			if err := r.SetQueryParam("key_time_to_live", qKeyTimeToLive); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.RegenerateKeys != nil {

		// query param regenerate_keys
		var qrRegenerateKeys bool

		if o.RegenerateKeys != nil {
			qrRegenerateKeys = *o.RegenerateKeys
		}
		qRegenerateKeys := swag.FormatBool(qrRegenerateKeys)
		if qRegenerateKeys != "" {

			if err := r.SetQueryParam("regenerate_keys", qRegenerateKeys); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
