// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3UserModifyCollectionReader is a Reader for the S3UserModifyCollection structure.
type S3UserModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3UserModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3UserModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3UserModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3UserModifyCollectionOK creates a S3UserModifyCollectionOK with default headers values
func NewS3UserModifyCollectionOK() *S3UserModifyCollectionOK {
	return &S3UserModifyCollectionOK{}
}

/*
S3UserModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type S3UserModifyCollectionOK struct {
	Payload *models.S3UserPostPatchResponse
}

// IsSuccess returns true when this s3 user modify collection o k response has a 2xx status code
func (o *S3UserModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 user modify collection o k response has a 3xx status code
func (o *S3UserModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 user modify collection o k response has a 4xx status code
func (o *S3UserModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 user modify collection o k response has a 5xx status code
func (o *S3UserModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 user modify collection o k response a status code equal to that given
func (o *S3UserModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 user modify collection o k response
func (o *S3UserModifyCollectionOK) Code() int {
	return 200
}

func (o *S3UserModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/users][%d] s3UserModifyCollectionOK %s", 200, payload)
}

func (o *S3UserModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/users][%d] s3UserModifyCollectionOK %s", 200, payload)
}

func (o *S3UserModifyCollectionOK) GetPayload() *models.S3UserPostPatchResponse {
	return o.Payload
}

func (o *S3UserModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3UserPostPatchResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3UserModifyCollectionDefault creates a S3UserModifyCollectionDefault with default headers values
func NewS3UserModifyCollectionDefault(code int) *S3UserModifyCollectionDefault {
	return &S3UserModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	S3UserModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 92405792   | Failed to regenerate access-key and secret-key for user. |
| 92406082   | Cannot perform \"regenerate_keys\" and \"delete_keys\" operations simultaneously on an S3 user. |
| 92406081   | The \"regenerate_keys\" operation on S3 User \"user-2\" in SVM \"vs1\" succeeded. However, modifying all of the other S3 user properties failed. Reason: resource limit exceeded. Retry the operation again without specifying the \"regenerate_keys\" parameter. |
| 92406080   | Cannot delete root user keys because there exists at least one S3 SnapMirror relationship that is using these keys. |
| 92406083   | The maximum supported value for user key expiry configuration is \"1095\" days. |
| 92406088   | The \"key_time_to_live\" parameter can only be used when the \"regenerate_keys\" operation is performed. |
| 92406096   | The user does not have permission to access the requested resource \\\"{0}\\\". |
| 92406097   | Internal error. The operation configuration is not correct. |

| 92406196   | The specified value for the \"key_time_to_live\" field cannot be greater than the maximum limit specified for the \"max_key_time_to_live\" field in the object store server. |
| 92406197   | Object store user \"user-2\" must have a non-zero value for the \"key_time_to_live\" field because the maximum limit specified for the \"max_key_time_to_live\" field in the object store server is not zero.
| 92406200   | An object store user with the same access-key already exists. |
| 92406201   | Missing access-key or secret-key. Either provide both of the keys or none. If not provided, keys are generated automatically. |
| 92406202   | The \"delete_keys\" operation must be performed without specifying the user keys. |
| 92406205   | The object store user access key contains invalid characters. Valid characters are 0-9 and A-Z. |
| 92406308   | Cannot disable user \"user1\" in SVM \"vs1\" because the user belongs to at least one object store group. Remove the user from all groups before disabling the user. |
*/
type S3UserModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 user modify collection default response has a 2xx status code
func (o *S3UserModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 user modify collection default response has a 3xx status code
func (o *S3UserModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 user modify collection default response has a 4xx status code
func (o *S3UserModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 user modify collection default response has a 5xx status code
func (o *S3UserModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 user modify collection default response a status code equal to that given
func (o *S3UserModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 user modify collection default response
func (o *S3UserModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *S3UserModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/users][%d] s3_user_modify_collection default %s", o._statusCode, payload)
}

func (o *S3UserModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/users][%d] s3_user_modify_collection default %s", o._statusCode, payload)
}

func (o *S3UserModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3UserModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
S3UserModifyCollectionBody s3 user modify collection body
swagger:model S3UserModifyCollectionBody
*/
type S3UserModifyCollectionBody struct {

	// Specifies the access key for the user.
	// Example: HJAKU28M3SXTE2UXUACV
	AccessKey *string `json:"access_key,omitempty"`

	// Can contain any additional information about the user being created or modified.
	// Example: S3 user
	// Max Length: 256
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Specifies the date and time after which keys expire and are no longer valid.
	// Example: 2024-01-01 00:00:00+00:00
	// Read Only: true
	// Format: date-time
	KeyExpiryTime *strfmt.DateTime `json:"key_expiry_time,omitempty"`

	// Indicates the time period from when this parameter is specified:
	// * when creating or modifying a user or
	// * when the user keys were last regenerated, after which the user keys expire and are no longer valid.
	// * Valid format is: 'PnDTnHnMnS|PnW'. For example, P2DT6H3M10S specifies a time period of 2 days, 6 hours, 3 minutes, and 10 seconds.
	// * If the value specified is '0' seconds, then the keys won't expire.
	//
	// Example: PT6H3M
	KeyTimeToLive *string `json:"key_time_to_live,omitempty"`

	// Specifies the name of the user. A user name length can range from 1 to 64 characters and can only contain the following combination of characters 0-9, A-Z, a-z, "_", "+", "=", ",", ".","@", and "-".
	// Example: user-1
	// Max Length: 64
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// s3 user response inline records
	S3UserResponseInlineRecords []*models.S3User `json:"records,omitempty"`

	// Specifies the secret key for the user.
	// Example: dummy_secret_key_1234_abcd_ldjf
	SecretKey *string `json:"secret_key,omitempty"`

	// svm
	Svm *models.S3UserInlineSvm `json:"svm,omitempty"`
}

// Validate validates this s3 user modify collection body
func (o *S3UserModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateKeyExpiryTime(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateS3UserResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3UserModifyCollectionBody) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"comment", "body", *o.Comment, 256); err != nil {
		return err
	}

	return nil
}

func (o *S3UserModifyCollectionBody) validateKeyExpiryTime(formats strfmt.Registry) error {
	if swag.IsZero(o.KeyExpiryTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"key_expiry_time", "body", "date-time", o.KeyExpiryTime.String(), formats); err != nil {
		return err
	}

	return nil
}

func (o *S3UserModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 64); err != nil {
		return err
	}

	return nil
}

func (o *S3UserModifyCollectionBody) validateS3UserResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.S3UserResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.S3UserResponseInlineRecords); i++ {
		if swag.IsZero(o.S3UserResponseInlineRecords[i]) { // not required
			continue
		}

		if o.S3UserResponseInlineRecords[i] != nil {
			if err := o.S3UserResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3UserModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 user modify collection body based on the context it is used
func (o *S3UserModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateKeyExpiryTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateS3UserResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3UserModifyCollectionBody) contextValidateKeyExpiryTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"key_expiry_time", "body", o.KeyExpiryTime); err != nil {
		return err
	}

	return nil
}

func (o *S3UserModifyCollectionBody) contextValidateS3UserResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3UserResponseInlineRecords); i++ {

		if o.S3UserResponseInlineRecords[i] != nil {
			if err := o.S3UserResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3UserModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3UserModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3UserModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res S3UserModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3UserInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model s3_user_inline_svm
*/
type S3UserInlineSvm struct {

	// links
	Links *models.S3UserInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 user inline svm
func (o *S3UserInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3UserInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 user inline svm based on the context it is used
func (o *S3UserInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3UserInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3UserInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3UserInlineSvm) UnmarshalBinary(b []byte) error {
	var res S3UserInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3UserInlineSvmInlineLinks s3 user inline svm inline links
swagger:model s3_user_inline_svm_inline__links
*/
type S3UserInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 user inline svm inline links
func (o *S3UserInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3UserInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 user inline svm inline links based on the context it is used
func (o *S3UserInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3UserInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3UserInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3UserInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3UserInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
