// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewS3UserModifyParams creates a new S3UserModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3UserModifyParams() *S3UserModifyParams {
	return &S3UserModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3UserModifyParamsWithTimeout creates a new S3UserModifyParams object
// with the ability to set a timeout on a request.
func NewS3UserModifyParamsWithTimeout(timeout time.Duration) *S3UserModifyParams {
	return &S3UserModifyParams{
		timeout: timeout,
	}
}

// NewS3UserModifyParamsWithContext creates a new S3UserModifyParams object
// with the ability to set a context for a request.
func NewS3UserModifyParamsWithContext(ctx context.Context) *S3UserModifyParams {
	return &S3UserModifyParams{
		Context: ctx,
	}
}

// NewS3UserModifyParamsWithHTTPClient creates a new S3UserModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3UserModifyParamsWithHTTPClient(client *http.Client) *S3UserModifyParams {
	return &S3UserModifyParams{
		HTTPClient: client,
	}
}

/*
S3UserModifyParams contains all the parameters to send to the API endpoint

	for the s3 user modify operation.

	Typically these are written to a http.Request.
*/
type S3UserModifyParams struct {

	/* DeleteKeys.

	   Specifies whether or not to delete the user keys.

	*/
	DeleteKeys *bool

	/* Info.

	   Info specification
	*/
	Info *models.S3User

	/* Name.

	   User name
	*/
	Name string

	/* RegenerateKeys.

	   Specifies whether or not to regenerate the user keys.

	*/
	RegenerateKeys *bool

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 user modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3UserModifyParams) WithDefaults() *S3UserModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 user modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3UserModifyParams) SetDefaults() {
	var (
		deleteKeysDefault = bool(false)

		regenerateKeysDefault = bool(false)
	)

	val := S3UserModifyParams{
		DeleteKeys:     &deleteKeysDefault,
		RegenerateKeys: &regenerateKeysDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the s3 user modify params
func (o *S3UserModifyParams) WithTimeout(timeout time.Duration) *S3UserModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 user modify params
func (o *S3UserModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 user modify params
func (o *S3UserModifyParams) WithContext(ctx context.Context) *S3UserModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 user modify params
func (o *S3UserModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 user modify params
func (o *S3UserModifyParams) WithHTTPClient(client *http.Client) *S3UserModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 user modify params
func (o *S3UserModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDeleteKeys adds the deleteKeys to the s3 user modify params
func (o *S3UserModifyParams) WithDeleteKeys(deleteKeys *bool) *S3UserModifyParams {
	o.SetDeleteKeys(deleteKeys)
	return o
}

// SetDeleteKeys adds the deleteKeys to the s3 user modify params
func (o *S3UserModifyParams) SetDeleteKeys(deleteKeys *bool) {
	o.DeleteKeys = deleteKeys
}

// WithInfo adds the info to the s3 user modify params
func (o *S3UserModifyParams) WithInfo(info *models.S3User) *S3UserModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the s3 user modify params
func (o *S3UserModifyParams) SetInfo(info *models.S3User) {
	o.Info = info
}

// WithName adds the name to the s3 user modify params
func (o *S3UserModifyParams) WithName(name string) *S3UserModifyParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the s3 user modify params
func (o *S3UserModifyParams) SetName(name string) {
	o.Name = name
}

// WithRegenerateKeys adds the regenerateKeys to the s3 user modify params
func (o *S3UserModifyParams) WithRegenerateKeys(regenerateKeys *bool) *S3UserModifyParams {
	o.SetRegenerateKeys(regenerateKeys)
	return o
}

// SetRegenerateKeys adds the regenerateKeys to the s3 user modify params
func (o *S3UserModifyParams) SetRegenerateKeys(regenerateKeys *bool) {
	o.RegenerateKeys = regenerateKeys
}

// WithSvmUUID adds the svmUUID to the s3 user modify params
func (o *S3UserModifyParams) WithSvmUUID(svmUUID string) *S3UserModifyParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 user modify params
func (o *S3UserModifyParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *S3UserModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DeleteKeys != nil {

		// query param delete_keys
		var qrDeleteKeys bool

		if o.DeleteKeys != nil {
			qrDeleteKeys = *o.DeleteKeys
		}
		qDeleteKeys := swag.FormatBool(qrDeleteKeys)
		if qDeleteKeys != "" {

			if err := r.SetQueryParam("delete_keys", qDeleteKeys); err != nil {
				return err
			}
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if o.RegenerateKeys != nil {

		// query param regenerate_keys
		var qrRegenerateKeys bool

		if o.RegenerateKeys != nil {
			qrRegenerateKeys = *o.RegenerateKeys
		}
		qRegenerateKeys := swag.FormatBool(qrRegenerateKeys)
		if qRegenerateKeys != "" {

			if err := r.SetQueryParam("regenerate_keys", qRegenerateKeys); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
