// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFcLoginCollectionGetParams creates a new FcLoginCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFcLoginCollectionGetParams() *FcLoginCollectionGetParams {
	return &FcLoginCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFcLoginCollectionGetParamsWithTimeout creates a new FcLoginCollectionGetParams object
// with the ability to set a timeout on a request.
func NewFcLoginCollectionGetParamsWithTimeout(timeout time.Duration) *FcLoginCollectionGetParams {
	return &FcLoginCollectionGetParams{
		timeout: timeout,
	}
}

// NewFcLoginCollectionGetParamsWithContext creates a new FcLoginCollectionGetParams object
// with the ability to set a context for a request.
func NewFcLoginCollectionGetParamsWithContext(ctx context.Context) *FcLoginCollectionGetParams {
	return &FcLoginCollectionGetParams{
		Context: ctx,
	}
}

// NewFcLoginCollectionGetParamsWithHTTPClient creates a new FcLoginCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewFcLoginCollectionGetParamsWithHTTPClient(client *http.Client) *FcLoginCollectionGetParams {
	return &FcLoginCollectionGetParams{
		HTTPClient: client,
	}
}

/*
FcLoginCollectionGetParams contains all the parameters to send to the API endpoint

	for the fc login collection get operation.

	Typically these are written to a http.Request.
*/
type FcLoginCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IgroupsName.

	   Filter by igroups.name
	*/
	IgroupsName *string

	/* IgroupsUUID.

	   Filter by igroups.uuid
	*/
	IgroupsUUID *string

	/* InitiatorAliases.

	   Filter by initiator.aliases
	*/
	InitiatorAliases *string

	/* InitiatorComment.

	   Filter by initiator.comment
	*/
	InitiatorComment *string

	/* InitiatorPortAddress.

	   Filter by initiator.port_address
	*/
	InitiatorPortAddress *string

	/* InitiatorWwnn.

	   Filter by initiator.wwnn
	*/
	InitiatorWwnn *string

	/* InitiatorWwpn.

	   Filter by initiator.wwpn
	*/
	InitiatorWwpn *string

	/* InterfaceName.

	   Filter by interface.name
	*/
	InterfaceName *string

	/* InterfaceUUID.

	   Filter by interface.uuid
	*/
	InterfaceUUID *string

	/* InterfaceWwpn.

	   Filter by interface.wwpn
	*/
	InterfaceWwpn *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Protocol.

	   Filter by protocol
	*/
	Protocol *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the fc login collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FcLoginCollectionGetParams) WithDefaults() *FcLoginCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the fc login collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FcLoginCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := FcLoginCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithTimeout(timeout time.Duration) *FcLoginCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithContext(ctx context.Context) *FcLoginCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithHTTPClient(client *http.Client) *FcLoginCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithFields(fields []string) *FcLoginCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIgroupsName adds the igroupsName to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithIgroupsName(igroupsName *string) *FcLoginCollectionGetParams {
	o.SetIgroupsName(igroupsName)
	return o
}

// SetIgroupsName adds the igroupsName to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetIgroupsName(igroupsName *string) {
	o.IgroupsName = igroupsName
}

// WithIgroupsUUID adds the igroupsUUID to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithIgroupsUUID(igroupsUUID *string) *FcLoginCollectionGetParams {
	o.SetIgroupsUUID(igroupsUUID)
	return o
}

// SetIgroupsUUID adds the igroupsUuid to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetIgroupsUUID(igroupsUUID *string) {
	o.IgroupsUUID = igroupsUUID
}

// WithInitiatorAliases adds the initiatorAliases to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithInitiatorAliases(initiatorAliases *string) *FcLoginCollectionGetParams {
	o.SetInitiatorAliases(initiatorAliases)
	return o
}

// SetInitiatorAliases adds the initiatorAliases to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetInitiatorAliases(initiatorAliases *string) {
	o.InitiatorAliases = initiatorAliases
}

// WithInitiatorComment adds the initiatorComment to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithInitiatorComment(initiatorComment *string) *FcLoginCollectionGetParams {
	o.SetInitiatorComment(initiatorComment)
	return o
}

// SetInitiatorComment adds the initiatorComment to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetInitiatorComment(initiatorComment *string) {
	o.InitiatorComment = initiatorComment
}

// WithInitiatorPortAddress adds the initiatorPortAddress to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithInitiatorPortAddress(initiatorPortAddress *string) *FcLoginCollectionGetParams {
	o.SetInitiatorPortAddress(initiatorPortAddress)
	return o
}

// SetInitiatorPortAddress adds the initiatorPortAddress to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetInitiatorPortAddress(initiatorPortAddress *string) {
	o.InitiatorPortAddress = initiatorPortAddress
}

// WithInitiatorWwnn adds the initiatorWwnn to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithInitiatorWwnn(initiatorWwnn *string) *FcLoginCollectionGetParams {
	o.SetInitiatorWwnn(initiatorWwnn)
	return o
}

// SetInitiatorWwnn adds the initiatorWwnn to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetInitiatorWwnn(initiatorWwnn *string) {
	o.InitiatorWwnn = initiatorWwnn
}

// WithInitiatorWwpn adds the initiatorWwpn to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithInitiatorWwpn(initiatorWwpn *string) *FcLoginCollectionGetParams {
	o.SetInitiatorWwpn(initiatorWwpn)
	return o
}

// SetInitiatorWwpn adds the initiatorWwpn to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetInitiatorWwpn(initiatorWwpn *string) {
	o.InitiatorWwpn = initiatorWwpn
}

// WithInterfaceName adds the interfaceName to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithInterfaceName(interfaceName *string) *FcLoginCollectionGetParams {
	o.SetInterfaceName(interfaceName)
	return o
}

// SetInterfaceName adds the interfaceName to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetInterfaceName(interfaceName *string) {
	o.InterfaceName = interfaceName
}

// WithInterfaceUUID adds the interfaceUUID to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithInterfaceUUID(interfaceUUID *string) *FcLoginCollectionGetParams {
	o.SetInterfaceUUID(interfaceUUID)
	return o
}

// SetInterfaceUUID adds the interfaceUuid to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetInterfaceUUID(interfaceUUID *string) {
	o.InterfaceUUID = interfaceUUID
}

// WithInterfaceWwpn adds the interfaceWwpn to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithInterfaceWwpn(interfaceWwpn *string) *FcLoginCollectionGetParams {
	o.SetInterfaceWwpn(interfaceWwpn)
	return o
}

// SetInterfaceWwpn adds the interfaceWwpn to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetInterfaceWwpn(interfaceWwpn *string) {
	o.InterfaceWwpn = interfaceWwpn
}

// WithMaxRecords adds the maxRecords to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithMaxRecords(maxRecords *int64) *FcLoginCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithOrderBy(orderBy []string) *FcLoginCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithProtocol adds the protocol to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithProtocol(protocol *string) *FcLoginCollectionGetParams {
	o.SetProtocol(protocol)
	return o
}

// SetProtocol adds the protocol to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetProtocol(protocol *string) {
	o.Protocol = protocol
}

// WithReturnRecords adds the returnRecords to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithReturnRecords(returnRecords *bool) *FcLoginCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *FcLoginCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithSvmName(svmName *string) *FcLoginCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the fc login collection get params
func (o *FcLoginCollectionGetParams) WithSvmUUID(svmUUID *string) *FcLoginCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the fc login collection get params
func (o *FcLoginCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *FcLoginCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.IgroupsName != nil {

		// query param igroups.name
		var qrIgroupsName string

		if o.IgroupsName != nil {
			qrIgroupsName = *o.IgroupsName
		}
		qIgroupsName := qrIgroupsName
		if qIgroupsName != "" {

			if err := r.SetQueryParam("igroups.name", qIgroupsName); err != nil {
				return err
			}
		}
	}

	if o.IgroupsUUID != nil {

		// query param igroups.uuid
		var qrIgroupsUUID string

		if o.IgroupsUUID != nil {
			qrIgroupsUUID = *o.IgroupsUUID
		}
		qIgroupsUUID := qrIgroupsUUID
		if qIgroupsUUID != "" {

			if err := r.SetQueryParam("igroups.uuid", qIgroupsUUID); err != nil {
				return err
			}
		}
	}

	if o.InitiatorAliases != nil {

		// query param initiator.aliases
		var qrInitiatorAliases string

		if o.InitiatorAliases != nil {
			qrInitiatorAliases = *o.InitiatorAliases
		}
		qInitiatorAliases := qrInitiatorAliases
		if qInitiatorAliases != "" {

			if err := r.SetQueryParam("initiator.aliases", qInitiatorAliases); err != nil {
				return err
			}
		}
	}

	if o.InitiatorComment != nil {

		// query param initiator.comment
		var qrInitiatorComment string

		if o.InitiatorComment != nil {
			qrInitiatorComment = *o.InitiatorComment
		}
		qInitiatorComment := qrInitiatorComment
		if qInitiatorComment != "" {

			if err := r.SetQueryParam("initiator.comment", qInitiatorComment); err != nil {
				return err
			}
		}
	}

	if o.InitiatorPortAddress != nil {

		// query param initiator.port_address
		var qrInitiatorPortAddress string

		if o.InitiatorPortAddress != nil {
			qrInitiatorPortAddress = *o.InitiatorPortAddress
		}
		qInitiatorPortAddress := qrInitiatorPortAddress
		if qInitiatorPortAddress != "" {

			if err := r.SetQueryParam("initiator.port_address", qInitiatorPortAddress); err != nil {
				return err
			}
		}
	}

	if o.InitiatorWwnn != nil {

		// query param initiator.wwnn
		var qrInitiatorWwnn string

		if o.InitiatorWwnn != nil {
			qrInitiatorWwnn = *o.InitiatorWwnn
		}
		qInitiatorWwnn := qrInitiatorWwnn
		if qInitiatorWwnn != "" {

			if err := r.SetQueryParam("initiator.wwnn", qInitiatorWwnn); err != nil {
				return err
			}
		}
	}

	if o.InitiatorWwpn != nil {

		// query param initiator.wwpn
		var qrInitiatorWwpn string

		if o.InitiatorWwpn != nil {
			qrInitiatorWwpn = *o.InitiatorWwpn
		}
		qInitiatorWwpn := qrInitiatorWwpn
		if qInitiatorWwpn != "" {

			if err := r.SetQueryParam("initiator.wwpn", qInitiatorWwpn); err != nil {
				return err
			}
		}
	}

	if o.InterfaceName != nil {

		// query param interface.name
		var qrInterfaceName string

		if o.InterfaceName != nil {
			qrInterfaceName = *o.InterfaceName
		}
		qInterfaceName := qrInterfaceName
		if qInterfaceName != "" {

			if err := r.SetQueryParam("interface.name", qInterfaceName); err != nil {
				return err
			}
		}
	}

	if o.InterfaceUUID != nil {

		// query param interface.uuid
		var qrInterfaceUUID string

		if o.InterfaceUUID != nil {
			qrInterfaceUUID = *o.InterfaceUUID
		}
		qInterfaceUUID := qrInterfaceUUID
		if qInterfaceUUID != "" {

			if err := r.SetQueryParam("interface.uuid", qInterfaceUUID); err != nil {
				return err
			}
		}
	}

	if o.InterfaceWwpn != nil {

		// query param interface.wwpn
		var qrInterfaceWwpn string

		if o.InterfaceWwpn != nil {
			qrInterfaceWwpn = *o.InterfaceWwpn
		}
		qInterfaceWwpn := qrInterfaceWwpn
		if qInterfaceWwpn != "" {

			if err := r.SetQueryParam("interface.wwpn", qInterfaceWwpn); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Protocol != nil {

		// query param protocol
		var qrProtocol string

		if o.Protocol != nil {
			qrProtocol = *o.Protocol
		}
		qProtocol := qrProtocol
		if qProtocol != "" {

			if err := r.SetQueryParam("protocol", qProtocol); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamFcLoginCollectionGet binds the parameter fields
func (o *FcLoginCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamFcLoginCollectionGet binds the parameter order_by
func (o *FcLoginCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
