// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFcLoginGetParams creates a new FcLoginGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFcLoginGetParams() *FcLoginGetParams {
	return &FcLoginGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFcLoginGetParamsWithTimeout creates a new FcLoginGetParams object
// with the ability to set a timeout on a request.
func NewFcLoginGetParamsWithTimeout(timeout time.Duration) *FcLoginGetParams {
	return &FcLoginGetParams{
		timeout: timeout,
	}
}

// NewFcLoginGetParamsWithContext creates a new FcLoginGetParams object
// with the ability to set a context for a request.
func NewFcLoginGetParamsWithContext(ctx context.Context) *FcLoginGetParams {
	return &FcLoginGetParams{
		Context: ctx,
	}
}

// NewFcLoginGetParamsWithHTTPClient creates a new FcLoginGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewFcLoginGetParamsWithHTTPClient(client *http.Client) *FcLoginGetParams {
	return &FcLoginGetParams{
		HTTPClient: client,
	}
}

/*
FcLoginGetParams contains all the parameters to send to the API endpoint

	for the fc login get operation.

	Typically these are written to a http.Request.
*/
type FcLoginGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* InitiatorWwpn.

	   The world wide port name (WWPN) of the initiator.

	*/
	InitiatorWwpn string

	/* InterfaceUUID.

	   The unique identifier of the FC interface through which the initiator logged in.

	*/
	InterfaceUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the fc login get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FcLoginGetParams) WithDefaults() *FcLoginGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the fc login get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FcLoginGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the fc login get params
func (o *FcLoginGetParams) WithTimeout(timeout time.Duration) *FcLoginGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the fc login get params
func (o *FcLoginGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the fc login get params
func (o *FcLoginGetParams) WithContext(ctx context.Context) *FcLoginGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the fc login get params
func (o *FcLoginGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the fc login get params
func (o *FcLoginGetParams) WithHTTPClient(client *http.Client) *FcLoginGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the fc login get params
func (o *FcLoginGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the fc login get params
func (o *FcLoginGetParams) WithFields(fields []string) *FcLoginGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the fc login get params
func (o *FcLoginGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithInitiatorWwpn adds the initiatorWwpn to the fc login get params
func (o *FcLoginGetParams) WithInitiatorWwpn(initiatorWwpn string) *FcLoginGetParams {
	o.SetInitiatorWwpn(initiatorWwpn)
	return o
}

// SetInitiatorWwpn adds the initiatorWwpn to the fc login get params
func (o *FcLoginGetParams) SetInitiatorWwpn(initiatorWwpn string) {
	o.InitiatorWwpn = initiatorWwpn
}

// WithInterfaceUUID adds the interfaceUUID to the fc login get params
func (o *FcLoginGetParams) WithInterfaceUUID(interfaceUUID string) *FcLoginGetParams {
	o.SetInterfaceUUID(interfaceUUID)
	return o
}

// SetInterfaceUUID adds the interfaceUuid to the fc login get params
func (o *FcLoginGetParams) SetInterfaceUUID(interfaceUUID string) {
	o.InterfaceUUID = interfaceUUID
}

// WriteToRequest writes these params to a swagger request
func (o *FcLoginGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param initiator.wwpn
	if err := r.SetPathParam("initiator.wwpn", o.InitiatorWwpn); err != nil {
		return err
	}

	// path param interface.uuid
	if err := r.SetPathParam("interface.uuid", o.InterfaceUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamFcLoginGet binds the parameter fields
func (o *FcLoginGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
