// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FcpServiceModifyCollectionReader is a Reader for the FcpServiceModifyCollection structure.
type FcpServiceModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FcpServiceModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFcpServiceModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFcpServiceModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFcpServiceModifyCollectionOK creates a FcpServiceModifyCollectionOK with default headers values
func NewFcpServiceModifyCollectionOK() *FcpServiceModifyCollectionOK {
	return &FcpServiceModifyCollectionOK{}
}

/*
FcpServiceModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type FcpServiceModifyCollectionOK struct {
}

// IsSuccess returns true when this fcp service modify collection o k response has a 2xx status code
func (o *FcpServiceModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fcp service modify collection o k response has a 3xx status code
func (o *FcpServiceModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fcp service modify collection o k response has a 4xx status code
func (o *FcpServiceModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fcp service modify collection o k response has a 5xx status code
func (o *FcpServiceModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fcp service modify collection o k response a status code equal to that given
func (o *FcpServiceModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fcp service modify collection o k response
func (o *FcpServiceModifyCollectionOK) Code() int {
	return 200
}

func (o *FcpServiceModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/san/fcp/services][%d] fcpServiceModifyCollectionOK", 200)
}

func (o *FcpServiceModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/san/fcp/services][%d] fcpServiceModifyCollectionOK", 200)
}

func (o *FcpServiceModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewFcpServiceModifyCollectionDefault creates a FcpServiceModifyCollectionDefault with default headers values
func NewFcpServiceModifyCollectionDefault(code int) *FcpServiceModifyCollectionDefault {
	return &FcpServiceModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	FcpServiceModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2621462 | An SVM with the specified UUID does not exist. |
| 5374083 | There is no Fibre Channel Protocol service for the specified SVM. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type FcpServiceModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fcp service modify collection default response has a 2xx status code
func (o *FcpServiceModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fcp service modify collection default response has a 3xx status code
func (o *FcpServiceModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fcp service modify collection default response has a 4xx status code
func (o *FcpServiceModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fcp service modify collection default response has a 5xx status code
func (o *FcpServiceModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fcp service modify collection default response a status code equal to that given
func (o *FcpServiceModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fcp service modify collection default response
func (o *FcpServiceModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *FcpServiceModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/san/fcp/services][%d] fcp_service_modify_collection default %s", o._statusCode, payload)
}

func (o *FcpServiceModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/san/fcp/services][%d] fcp_service_modify_collection default %s", o._statusCode, payload)
}

func (o *FcpServiceModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FcpServiceModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
FcpServiceModifyCollectionBody fcp service modify collection body
swagger:model FcpServiceModifyCollectionBody
*/
type FcpServiceModifyCollectionBody struct {

	// links
	Links *models.FcpServiceInlineLinks `json:"_links,omitempty"`

	// The administrative state of the FC Protocol service. The FC Protocol service can be disabled to block all FC Protocol connectivity to the SVM.<br/>
	// This is optional in POST and PATCH. The default setting is _true_ (enabled) in POST.
	//
	Enabled *bool `json:"enabled,omitempty"`

	// fcp service response inline records
	FcpServiceResponseInlineRecords []*models.FcpService `json:"records,omitempty"`

	// metric
	Metric *models.FcpServiceInlineMetric `json:"metric,omitempty"`

	// statistics
	Statistics *models.FcpServiceInlineStatistics `json:"statistics,omitempty"`

	// svm
	Svm *models.FcpServiceInlineSvm `json:"svm,omitempty"`

	// target
	Target *models.FcpServiceInlineTarget `json:"target,omitempty"`
}

// Validate validates this fcp service modify collection body
func (o *FcpServiceModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFcpServiceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTarget(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcpServiceModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceModifyCollectionBody) validateFcpServiceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.FcpServiceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.FcpServiceResponseInlineRecords); i++ {
		if swag.IsZero(o.FcpServiceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.FcpServiceResponseInlineRecords[i] != nil {
			if err := o.FcpServiceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FcpServiceModifyCollectionBody) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(o.Metric) { // not required
		return nil
	}

	if o.Metric != nil {
		if err := o.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceModifyCollectionBody) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(o.Statistics) { // not required
		return nil
	}

	if o.Statistics != nil {
		if err := o.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceModifyCollectionBody) validateTarget(formats strfmt.Registry) error {
	if swag.IsZero(o.Target) { // not required
		return nil
	}

	if o.Target != nil {
		if err := o.Target.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "target")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fcp service modify collection body based on the context it is used
func (o *FcpServiceModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFcpServiceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTarget(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcpServiceModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceModifyCollectionBody) contextValidateFcpServiceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.FcpServiceResponseInlineRecords); i++ {

		if o.FcpServiceResponseInlineRecords[i] != nil {
			if err := o.FcpServiceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FcpServiceModifyCollectionBody) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if o.Metric != nil {
		if err := o.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceModifyCollectionBody) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if o.Statistics != nil {
		if err := o.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceModifyCollectionBody) contextValidateTarget(ctx context.Context, formats strfmt.Registry) error {

	if o.Target != nil {
		if err := o.Target.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "target")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcpServiceModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcpServiceModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res FcpServiceModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcpServiceInlineLinks fcp service inline links
swagger:model fcp_service_inline__links
*/
type FcpServiceInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this fcp service inline links
func (o *FcpServiceInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcpServiceInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fcp service inline links based on the context it is used
func (o *FcpServiceInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcpServiceInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcpServiceInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcpServiceInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcpServiceInlineMetric Performance numbers, such as IOPS latency and throughput, for SVM protocols.
swagger:model fcp_service_inline_metric
*/
type FcpServiceInlineMetric struct {

	// links
	Links *models.FcpServiceInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *models.FcpServiceInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *models.FcpServiceInlineMetricInlineLatency `json:"latency,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *models.FcpServiceInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this fcp service inline metric
func (o *FcpServiceInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcpServiceInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var fcpServiceInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcpServiceInlineMetricTypeDurationPropEnum = append(fcpServiceInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// FcpServiceInlineMetricDurationPT15S captures enum value "PT15S"
	FcpServiceInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// FcpServiceInlineMetricDurationPT4M captures enum value "PT4M"
	FcpServiceInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// FcpServiceInlineMetricDurationPT30M captures enum value "PT30M"
	FcpServiceInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// FcpServiceInlineMetricDurationPT2H captures enum value "PT2H"
	FcpServiceInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// FcpServiceInlineMetricDurationP1D captures enum value "P1D"
	FcpServiceInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// FcpServiceInlineMetricDurationPT5M captures enum value "PT5M"
	FcpServiceInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (o *FcpServiceInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcpServiceInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FcpServiceInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(o.Duration) { // not required
		return nil
	}

	// value enum
	if err := o.validateDurationEnum("info"+"."+"metric"+"."+"duration", "body", *o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *FcpServiceInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(o.Iops) { // not required
		return nil
	}

	if o.Iops != nil {
		if err := o.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(o.Latency) { // not required
		return nil
	}

	if o.Latency != nil {
		if err := o.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var fcpServiceInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcpServiceInlineMetricTypeStatusPropEnum = append(fcpServiceInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// FcpServiceInlineMetricStatusOk captures enum value "ok"
	FcpServiceInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// FcpServiceInlineMetricStatusError captures enum value "error"
	FcpServiceInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// FcpServiceInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	FcpServiceInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// FcpServiceInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	FcpServiceInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// FcpServiceInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	FcpServiceInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// FcpServiceInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	FcpServiceInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// FcpServiceInlineMetricStatusNotFound captures enum value "not_found"
	FcpServiceInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// FcpServiceInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	FcpServiceInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// FcpServiceInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	FcpServiceInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// FcpServiceInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	FcpServiceInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// fcp_service_inline_metric
	// FcpServiceInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// FcpServiceInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	FcpServiceInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *FcpServiceInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcpServiceInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FcpServiceInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"metric"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *FcpServiceInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(o.Throughput) { // not required
		return nil
	}

	if o.Throughput != nil {
		if err := o.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"metric"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fcp service inline metric based on the context it is used
func (o *FcpServiceInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcpServiceInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"duration", "body", o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *FcpServiceInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if o.Iops != nil {
		if err := o.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if o.Latency != nil {
		if err := o.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *FcpServiceInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if o.Throughput != nil {
		if err := o.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcpServiceInlineMetric) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcpServiceInlineMetric) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcpServiceInlineMetricInlineLinks fcp service inline metric inline links
swagger:model fcp_service_inline_metric_inline__links
*/
type FcpServiceInlineMetricInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this fcp service inline metric inline links
func (o *FcpServiceInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcpServiceInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fcp service inline metric inline links based on the context it is used
func (o *FcpServiceInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcpServiceInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcpServiceInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcpServiceInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcpServiceInlineMetricInlineIops The rate of I/O operations observed at the storage object.
swagger:model fcp_service_inline_metric_inline_iops
*/
type FcpServiceInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fcp service inline metric inline iops
func (o *FcpServiceInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fcp service inline metric inline iops based on the context it is used
func (o *FcpServiceInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FcpServiceInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcpServiceInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcpServiceInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
swagger:model fcp_service_inline_metric_inline_latency
*/
type FcpServiceInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fcp service inline metric inline latency
func (o *FcpServiceInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fcp service inline metric inline latency based on the context it is used
func (o *FcpServiceInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FcpServiceInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcpServiceInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcpServiceInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
swagger:model fcp_service_inline_metric_inline_throughput
*/
type FcpServiceInlineMetricInlineThroughput struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fcp service inline metric inline throughput
func (o *FcpServiceInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fcp service inline metric inline throughput based on the context it is used
func (o *FcpServiceInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FcpServiceInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcpServiceInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcpServiceInlineStatistics These are raw performance numbers, such as IOPS latency and throughput for SVM protocols. These numbers are aggregated across all nodes in the cluster and increase with the uptime of the cluster.
swagger:model fcp_service_inline_statistics
*/
type FcpServiceInlineStatistics struct {

	// iops raw
	IopsRaw *models.FcpServiceInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *models.FcpServiceInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Any errors associated with the sample. For example, if the aggregation of data over multiple nodes fails then any of the partial errors might be returned, "ok" on success, or "error" on any internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *models.FcpServiceInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this fcp service inline statistics
func (o *FcpServiceInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcpServiceInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.IopsRaw) { // not required
		return nil
	}

	if o.IopsRaw != nil {
		if err := o.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.LatencyRaw) { // not required
		return nil
	}

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var fcpServiceInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		fcpServiceInlineStatisticsTypeStatusPropEnum = append(fcpServiceInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusOk captures enum value "ok"
	FcpServiceInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusError captures enum value "error"
	FcpServiceInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	FcpServiceInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	FcpServiceInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	FcpServiceInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	FcpServiceInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusNotFound captures enum value "not_found"
	FcpServiceInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	FcpServiceInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	FcpServiceInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	FcpServiceInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// fcp_service_inline_statistics
	// FcpServiceInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// FcpServiceInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	FcpServiceInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *FcpServiceInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, fcpServiceInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FcpServiceInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"statistics"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *FcpServiceInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.ThroughputRaw) { // not required
		return nil
	}

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"statistics"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fcp service inline statistics based on the context it is used
func (o *FcpServiceInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcpServiceInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.IopsRaw != nil {
		if err := o.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *FcpServiceInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *FcpServiceInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcpServiceInlineStatistics) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcpServiceInlineStatistics) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcpServiceInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This should be used along with delta time to calculate the rate of I/O operations per unit of time.
swagger:model fcp_service_inline_statistics_inline_iops_raw
*/
type FcpServiceInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fcp service inline statistics inline iops raw
func (o *FcpServiceInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fcp service inline statistics inline iops raw based on the context it is used
func (o *FcpServiceInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FcpServiceInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcpServiceInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcpServiceInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This should be divided by the raw IOPS value to calculate the average latency per I/O operation.
swagger:model fcp_service_inline_statistics_inline_latency_raw
*/
type FcpServiceInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fcp service inline statistics inline latency raw
func (o *FcpServiceInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fcp service inline statistics inline latency raw based on the context it is used
func (o *FcpServiceInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FcpServiceInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcpServiceInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcpServiceInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This should be used along with delta time to calculate the rate of throughput bytes per unit of time.
swagger:model fcp_service_inline_statistics_inline_throughput_raw
*/
type FcpServiceInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this fcp service inline statistics inline throughput raw
func (o *FcpServiceInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this fcp service inline statistics inline throughput raw based on the context it is used
func (o *FcpServiceInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *FcpServiceInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcpServiceInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcpServiceInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model fcp_service_inline_svm
*/
type FcpServiceInlineSvm struct {

	// links
	Links *models.FcpServiceInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this fcp service inline svm
func (o *FcpServiceInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcpServiceInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fcp service inline svm based on the context it is used
func (o *FcpServiceInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcpServiceInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcpServiceInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcpServiceInlineSvm) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcpServiceInlineSvmInlineLinks fcp service inline svm inline links
swagger:model fcp_service_inline_svm_inline__links
*/
type FcpServiceInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this fcp service inline svm inline links
func (o *FcpServiceInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcpServiceInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this fcp service inline svm inline links based on the context it is used
func (o *FcpServiceInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcpServiceInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcpServiceInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcpServiceInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FcpServiceInlineTarget fcp service inline target
swagger:model fcp_service_inline_target
*/
type FcpServiceInlineTarget struct {

	// The target name of the FC Protocol service. This is generated for the SVM during POST.<br/>
	// The FC Protocol target name is a world wide node name (WWNN).<br/>
	// If required, the target name can be modified using the ONTAP command line.
	//
	// Example: 20:00:00:50:56:bb:b2:4b
	// Read Only: true
	// Max Length: 128
	// Min Length: 1
	Name *string `json:"name,omitempty"`
}

// Validate validates this fcp service inline target
func (o *FcpServiceInlineTarget) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcpServiceInlineTarget) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"target"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"target"+"."+"name", "body", *o.Name, 128); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this fcp service inline target based on the context it is used
func (o *FcpServiceInlineTarget) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FcpServiceInlineTarget) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"target"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FcpServiceInlineTarget) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FcpServiceInlineTarget) UnmarshalBinary(b []byte) error {
	var res FcpServiceInlineTarget
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
