// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FcpServiceModifyReader is a Reader for the FcpServiceModify structure.
type FcpServiceModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FcpServiceModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFcpServiceModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFcpServiceModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFcpServiceModifyOK creates a FcpServiceModifyOK with default headers values
func NewFcpServiceModifyOK() *FcpServiceModifyOK {
	return &FcpServiceModifyOK{}
}

/*
FcpServiceModifyOK describes a response with status code 200, with default header values.

OK
*/
type FcpServiceModifyOK struct {
}

// IsSuccess returns true when this fcp service modify o k response has a 2xx status code
func (o *FcpServiceModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this fcp service modify o k response has a 3xx status code
func (o *FcpServiceModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this fcp service modify o k response has a 4xx status code
func (o *FcpServiceModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this fcp service modify o k response has a 5xx status code
func (o *FcpServiceModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this fcp service modify o k response a status code equal to that given
func (o *FcpServiceModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the fcp service modify o k response
func (o *FcpServiceModifyOK) Code() int {
	return 200
}

func (o *FcpServiceModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/san/fcp/services/{svm.uuid}][%d] fcpServiceModifyOK", 200)
}

func (o *FcpServiceModifyOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/san/fcp/services/{svm.uuid}][%d] fcpServiceModifyOK", 200)
}

func (o *FcpServiceModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewFcpServiceModifyDefault creates a FcpServiceModifyDefault with default headers values
func NewFcpServiceModifyDefault(code int) *FcpServiceModifyDefault {
	return &FcpServiceModifyDefault{
		_statusCode: code,
	}
}

/*
	FcpServiceModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2621462 | An SVM with the specified UUID does not exist. |
| 5374083 | There is no Fibre Channel Protocol service for the specified SVM. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type FcpServiceModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this fcp service modify default response has a 2xx status code
func (o *FcpServiceModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this fcp service modify default response has a 3xx status code
func (o *FcpServiceModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this fcp service modify default response has a 4xx status code
func (o *FcpServiceModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this fcp service modify default response has a 5xx status code
func (o *FcpServiceModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this fcp service modify default response a status code equal to that given
func (o *FcpServiceModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the fcp service modify default response
func (o *FcpServiceModifyDefault) Code() int {
	return o._statusCode
}

func (o *FcpServiceModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/san/fcp/services/{svm.uuid}][%d] fcp_service_modify default %s", o._statusCode, payload)
}

func (o *FcpServiceModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/san/fcp/services/{svm.uuid}][%d] fcp_service_modify default %s", o._statusCode, payload)
}

func (o *FcpServiceModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FcpServiceModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
