// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewIgroupCollectionGetParams creates a new IgroupCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIgroupCollectionGetParams() *IgroupCollectionGetParams {
	return &IgroupCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIgroupCollectionGetParamsWithTimeout creates a new IgroupCollectionGetParams object
// with the ability to set a timeout on a request.
func NewIgroupCollectionGetParamsWithTimeout(timeout time.Duration) *IgroupCollectionGetParams {
	return &IgroupCollectionGetParams{
		timeout: timeout,
	}
}

// NewIgroupCollectionGetParamsWithContext creates a new IgroupCollectionGetParams object
// with the ability to set a context for a request.
func NewIgroupCollectionGetParamsWithContext(ctx context.Context) *IgroupCollectionGetParams {
	return &IgroupCollectionGetParams{
		Context: ctx,
	}
}

// NewIgroupCollectionGetParamsWithHTTPClient creates a new IgroupCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewIgroupCollectionGetParamsWithHTTPClient(client *http.Client) *IgroupCollectionGetParams {
	return &IgroupCollectionGetParams{
		HTTPClient: client,
	}
}

/*
IgroupCollectionGetParams contains all the parameters to send to the API endpoint

	for the igroup collection get operation.

	Typically these are written to a http.Request.
*/
type IgroupCollectionGetParams struct {

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ConnectivityTrackingAlertsSummaryArgumentsCode.

	   Filter by connectivity_tracking.alerts.summary.arguments.code
	*/
	ConnectivityTrackingAlertsSummaryArgumentsCode *string

	/* ConnectivityTrackingAlertsSummaryArgumentsMessage.

	   Filter by connectivity_tracking.alerts.summary.arguments.message
	*/
	ConnectivityTrackingAlertsSummaryArgumentsMessage *string

	/* ConnectivityTrackingAlertsSummaryCode.

	   Filter by connectivity_tracking.alerts.summary.code
	*/
	ConnectivityTrackingAlertsSummaryCode *string

	/* ConnectivityTrackingAlertsSummaryMessage.

	   Filter by connectivity_tracking.alerts.summary.message
	*/
	ConnectivityTrackingAlertsSummaryMessage *string

	/* ConnectivityTrackingConnectionState.

	   Filter by connectivity_tracking.connection_state
	*/
	ConnectivityTrackingConnectionState *string

	/* ConnectivityTrackingRequiredNodesName.

	   Filter by connectivity_tracking.required_nodes.name
	*/
	ConnectivityTrackingRequiredNodesName *string

	/* ConnectivityTrackingRequiredNodesUUID.

	   Filter by connectivity_tracking.required_nodes.uuid
	*/
	ConnectivityTrackingRequiredNodesUUID *string

	/* DeleteOnUnmap.

	   Filter by delete_on_unmap
	*/
	DeleteOnUnmap *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IgroupsComment.

	   Filter by igroups.comment
	*/
	IgroupsComment *string

	/* IgroupsName.

	   Filter by igroups.name
	*/
	IgroupsName *string

	/* IgroupsUUID.

	   Filter by igroups.uuid
	*/
	IgroupsUUID *string

	/* InitiatorsComment.

	   Filter by initiators.comment
	*/
	InitiatorsComment *string

	/* InitiatorsConnectivityTrackingConnectionState.

	   Filter by initiators.connectivity_tracking.connection_state
	*/
	InitiatorsConnectivityTrackingConnectionState *string

	/* InitiatorsIgroupName.

	   Filter by initiators.igroup.name
	*/
	InitiatorsIgroupName *string

	/* InitiatorsIgroupUUID.

	   Filter by initiators.igroup.uuid
	*/
	InitiatorsIgroupUUID *string

	/* InitiatorsName.

	   Filter by initiators.name
	*/
	InitiatorsName *string

	/* InitiatorsProximityLocalSvm.

	   Filter by initiators.proximity.local_svm
	*/
	InitiatorsProximityLocalSvm *bool

	/* InitiatorsProximityPeerSvmsName.

	   Filter by initiators.proximity.peer_svms.name
	*/
	InitiatorsProximityPeerSvmsName *string

	/* InitiatorsProximityPeerSvmsUUID.

	   Filter by initiators.proximity.peer_svms.uuid
	*/
	InitiatorsProximityPeerSvmsUUID *string

	/* LunMapsLogicalUnitNumber.

	   Filter by lun_maps.logical_unit_number
	*/
	LunMapsLogicalUnitNumber *int64

	/* LunMapsLunName.

	   Filter by lun_maps.lun.name
	*/
	LunMapsLunName *string

	/* LunMapsLunNodeName.

	   Filter by lun_maps.lun.node.name
	*/
	LunMapsLunNodeName *string

	/* LunMapsLunNodeUUID.

	   Filter by lun_maps.lun.node.uuid
	*/
	LunMapsLunNodeUUID *string

	/* LunMapsLunUUID.

	   Filter by lun_maps.lun.uuid
	*/
	LunMapsLunUUID *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* OsType.

	   Filter by os_type
	*/
	OsType *string

	/* ParentIgroupsComment.

	   Filter by parent_igroups.comment
	*/
	ParentIgroupsComment *string

	/* ParentIgroupsName.

	   Filter by parent_igroups.name
	*/
	ParentIgroupsName *string

	/* ParentIgroupsUUID.

	   Filter by parent_igroups.uuid
	*/
	ParentIgroupsUUID *string

	/* PortsetName.

	   Filter by portset.name
	*/
	PortsetName *string

	/* PortsetUUID.

	   Filter by portset.uuid
	*/
	PortsetUUID *string

	/* Protocol.

	   Filter by protocol
	*/
	Protocol *string

	/* ReplicationErrorIgroupLocalSvm.

	   Filter by replication.error.igroup.local_svm
	*/
	ReplicationErrorIgroupLocalSvm *bool

	/* ReplicationErrorIgroupName.

	   Filter by replication.error.igroup.name
	*/
	ReplicationErrorIgroupName *string

	/* ReplicationErrorIgroupUUID.

	   Filter by replication.error.igroup.uuid
	*/
	ReplicationErrorIgroupUUID *string

	/* ReplicationErrorSummaryArgumentsCode.

	   Filter by replication.error.summary.arguments.code
	*/
	ReplicationErrorSummaryArgumentsCode *string

	/* ReplicationErrorSummaryArgumentsMessage.

	   Filter by replication.error.summary.arguments.message
	*/
	ReplicationErrorSummaryArgumentsMessage *string

	/* ReplicationErrorSummaryCode.

	   Filter by replication.error.summary.code
	*/
	ReplicationErrorSummaryCode *string

	/* ReplicationErrorSummaryMessage.

	   Filter by replication.error.summary.message
	*/
	ReplicationErrorSummaryMessage *string

	/* ReplicationPeerSvmName.

	   Filter by replication.peer_svm.name
	*/
	ReplicationPeerSvmName *string

	/* ReplicationPeerSvmUUID.

	   Filter by replication.peer_svm.uuid
	*/
	ReplicationPeerSvmUUID *string

	/* ReplicationState.

	   Filter by replication.state
	*/
	ReplicationState *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SupportsIgroups.

	   Filter by supports_igroups
	*/
	SupportsIgroups *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TargetFirmwareRevision.

	   Filter by target.firmware_revision
	*/
	TargetFirmwareRevision *string

	/* TargetProductID.

	   Filter by target.product_id
	*/
	TargetProductID *string

	/* TargetVendorID.

	   Filter by target.vendor_id
	*/
	TargetVendorID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the igroup collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IgroupCollectionGetParams) WithDefaults() *IgroupCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the igroup collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IgroupCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := IgroupCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the igroup collection get params
func (o *IgroupCollectionGetParams) WithTimeout(timeout time.Duration) *IgroupCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the igroup collection get params
func (o *IgroupCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the igroup collection get params
func (o *IgroupCollectionGetParams) WithContext(ctx context.Context) *IgroupCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the igroup collection get params
func (o *IgroupCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the igroup collection get params
func (o *IgroupCollectionGetParams) WithHTTPClient(client *http.Client) *IgroupCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the igroup collection get params
func (o *IgroupCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the igroup collection get params
func (o *IgroupCollectionGetParams) WithComment(comment *string) *IgroupCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the igroup collection get params
func (o *IgroupCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithConnectivityTrackingAlertsSummaryArgumentsCode adds the connectivityTrackingAlertsSummaryArgumentsCode to the igroup collection get params
func (o *IgroupCollectionGetParams) WithConnectivityTrackingAlertsSummaryArgumentsCode(connectivityTrackingAlertsSummaryArgumentsCode *string) *IgroupCollectionGetParams {
	o.SetConnectivityTrackingAlertsSummaryArgumentsCode(connectivityTrackingAlertsSummaryArgumentsCode)
	return o
}

// SetConnectivityTrackingAlertsSummaryArgumentsCode adds the connectivityTrackingAlertsSummaryArgumentsCode to the igroup collection get params
func (o *IgroupCollectionGetParams) SetConnectivityTrackingAlertsSummaryArgumentsCode(connectivityTrackingAlertsSummaryArgumentsCode *string) {
	o.ConnectivityTrackingAlertsSummaryArgumentsCode = connectivityTrackingAlertsSummaryArgumentsCode
}

// WithConnectivityTrackingAlertsSummaryArgumentsMessage adds the connectivityTrackingAlertsSummaryArgumentsMessage to the igroup collection get params
func (o *IgroupCollectionGetParams) WithConnectivityTrackingAlertsSummaryArgumentsMessage(connectivityTrackingAlertsSummaryArgumentsMessage *string) *IgroupCollectionGetParams {
	o.SetConnectivityTrackingAlertsSummaryArgumentsMessage(connectivityTrackingAlertsSummaryArgumentsMessage)
	return o
}

// SetConnectivityTrackingAlertsSummaryArgumentsMessage adds the connectivityTrackingAlertsSummaryArgumentsMessage to the igroup collection get params
func (o *IgroupCollectionGetParams) SetConnectivityTrackingAlertsSummaryArgumentsMessage(connectivityTrackingAlertsSummaryArgumentsMessage *string) {
	o.ConnectivityTrackingAlertsSummaryArgumentsMessage = connectivityTrackingAlertsSummaryArgumentsMessage
}

// WithConnectivityTrackingAlertsSummaryCode adds the connectivityTrackingAlertsSummaryCode to the igroup collection get params
func (o *IgroupCollectionGetParams) WithConnectivityTrackingAlertsSummaryCode(connectivityTrackingAlertsSummaryCode *string) *IgroupCollectionGetParams {
	o.SetConnectivityTrackingAlertsSummaryCode(connectivityTrackingAlertsSummaryCode)
	return o
}

// SetConnectivityTrackingAlertsSummaryCode adds the connectivityTrackingAlertsSummaryCode to the igroup collection get params
func (o *IgroupCollectionGetParams) SetConnectivityTrackingAlertsSummaryCode(connectivityTrackingAlertsSummaryCode *string) {
	o.ConnectivityTrackingAlertsSummaryCode = connectivityTrackingAlertsSummaryCode
}

// WithConnectivityTrackingAlertsSummaryMessage adds the connectivityTrackingAlertsSummaryMessage to the igroup collection get params
func (o *IgroupCollectionGetParams) WithConnectivityTrackingAlertsSummaryMessage(connectivityTrackingAlertsSummaryMessage *string) *IgroupCollectionGetParams {
	o.SetConnectivityTrackingAlertsSummaryMessage(connectivityTrackingAlertsSummaryMessage)
	return o
}

// SetConnectivityTrackingAlertsSummaryMessage adds the connectivityTrackingAlertsSummaryMessage to the igroup collection get params
func (o *IgroupCollectionGetParams) SetConnectivityTrackingAlertsSummaryMessage(connectivityTrackingAlertsSummaryMessage *string) {
	o.ConnectivityTrackingAlertsSummaryMessage = connectivityTrackingAlertsSummaryMessage
}

// WithConnectivityTrackingConnectionState adds the connectivityTrackingConnectionState to the igroup collection get params
func (o *IgroupCollectionGetParams) WithConnectivityTrackingConnectionState(connectivityTrackingConnectionState *string) *IgroupCollectionGetParams {
	o.SetConnectivityTrackingConnectionState(connectivityTrackingConnectionState)
	return o
}

// SetConnectivityTrackingConnectionState adds the connectivityTrackingConnectionState to the igroup collection get params
func (o *IgroupCollectionGetParams) SetConnectivityTrackingConnectionState(connectivityTrackingConnectionState *string) {
	o.ConnectivityTrackingConnectionState = connectivityTrackingConnectionState
}

// WithConnectivityTrackingRequiredNodesName adds the connectivityTrackingRequiredNodesName to the igroup collection get params
func (o *IgroupCollectionGetParams) WithConnectivityTrackingRequiredNodesName(connectivityTrackingRequiredNodesName *string) *IgroupCollectionGetParams {
	o.SetConnectivityTrackingRequiredNodesName(connectivityTrackingRequiredNodesName)
	return o
}

// SetConnectivityTrackingRequiredNodesName adds the connectivityTrackingRequiredNodesName to the igroup collection get params
func (o *IgroupCollectionGetParams) SetConnectivityTrackingRequiredNodesName(connectivityTrackingRequiredNodesName *string) {
	o.ConnectivityTrackingRequiredNodesName = connectivityTrackingRequiredNodesName
}

// WithConnectivityTrackingRequiredNodesUUID adds the connectivityTrackingRequiredNodesUUID to the igroup collection get params
func (o *IgroupCollectionGetParams) WithConnectivityTrackingRequiredNodesUUID(connectivityTrackingRequiredNodesUUID *string) *IgroupCollectionGetParams {
	o.SetConnectivityTrackingRequiredNodesUUID(connectivityTrackingRequiredNodesUUID)
	return o
}

// SetConnectivityTrackingRequiredNodesUUID adds the connectivityTrackingRequiredNodesUuid to the igroup collection get params
func (o *IgroupCollectionGetParams) SetConnectivityTrackingRequiredNodesUUID(connectivityTrackingRequiredNodesUUID *string) {
	o.ConnectivityTrackingRequiredNodesUUID = connectivityTrackingRequiredNodesUUID
}

// WithDeleteOnUnmap adds the deleteOnUnmap to the igroup collection get params
func (o *IgroupCollectionGetParams) WithDeleteOnUnmap(deleteOnUnmap *bool) *IgroupCollectionGetParams {
	o.SetDeleteOnUnmap(deleteOnUnmap)
	return o
}

// SetDeleteOnUnmap adds the deleteOnUnmap to the igroup collection get params
func (o *IgroupCollectionGetParams) SetDeleteOnUnmap(deleteOnUnmap *bool) {
	o.DeleteOnUnmap = deleteOnUnmap
}

// WithFields adds the fields to the igroup collection get params
func (o *IgroupCollectionGetParams) WithFields(fields []string) *IgroupCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the igroup collection get params
func (o *IgroupCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIgroupsComment adds the igroupsComment to the igroup collection get params
func (o *IgroupCollectionGetParams) WithIgroupsComment(igroupsComment *string) *IgroupCollectionGetParams {
	o.SetIgroupsComment(igroupsComment)
	return o
}

// SetIgroupsComment adds the igroupsComment to the igroup collection get params
func (o *IgroupCollectionGetParams) SetIgroupsComment(igroupsComment *string) {
	o.IgroupsComment = igroupsComment
}

// WithIgroupsName adds the igroupsName to the igroup collection get params
func (o *IgroupCollectionGetParams) WithIgroupsName(igroupsName *string) *IgroupCollectionGetParams {
	o.SetIgroupsName(igroupsName)
	return o
}

// SetIgroupsName adds the igroupsName to the igroup collection get params
func (o *IgroupCollectionGetParams) SetIgroupsName(igroupsName *string) {
	o.IgroupsName = igroupsName
}

// WithIgroupsUUID adds the igroupsUUID to the igroup collection get params
func (o *IgroupCollectionGetParams) WithIgroupsUUID(igroupsUUID *string) *IgroupCollectionGetParams {
	o.SetIgroupsUUID(igroupsUUID)
	return o
}

// SetIgroupsUUID adds the igroupsUuid to the igroup collection get params
func (o *IgroupCollectionGetParams) SetIgroupsUUID(igroupsUUID *string) {
	o.IgroupsUUID = igroupsUUID
}

// WithInitiatorsComment adds the initiatorsComment to the igroup collection get params
func (o *IgroupCollectionGetParams) WithInitiatorsComment(initiatorsComment *string) *IgroupCollectionGetParams {
	o.SetInitiatorsComment(initiatorsComment)
	return o
}

// SetInitiatorsComment adds the initiatorsComment to the igroup collection get params
func (o *IgroupCollectionGetParams) SetInitiatorsComment(initiatorsComment *string) {
	o.InitiatorsComment = initiatorsComment
}

// WithInitiatorsConnectivityTrackingConnectionState adds the initiatorsConnectivityTrackingConnectionState to the igroup collection get params
func (o *IgroupCollectionGetParams) WithInitiatorsConnectivityTrackingConnectionState(initiatorsConnectivityTrackingConnectionState *string) *IgroupCollectionGetParams {
	o.SetInitiatorsConnectivityTrackingConnectionState(initiatorsConnectivityTrackingConnectionState)
	return o
}

// SetInitiatorsConnectivityTrackingConnectionState adds the initiatorsConnectivityTrackingConnectionState to the igroup collection get params
func (o *IgroupCollectionGetParams) SetInitiatorsConnectivityTrackingConnectionState(initiatorsConnectivityTrackingConnectionState *string) {
	o.InitiatorsConnectivityTrackingConnectionState = initiatorsConnectivityTrackingConnectionState
}

// WithInitiatorsIgroupName adds the initiatorsIgroupName to the igroup collection get params
func (o *IgroupCollectionGetParams) WithInitiatorsIgroupName(initiatorsIgroupName *string) *IgroupCollectionGetParams {
	o.SetInitiatorsIgroupName(initiatorsIgroupName)
	return o
}

// SetInitiatorsIgroupName adds the initiatorsIgroupName to the igroup collection get params
func (o *IgroupCollectionGetParams) SetInitiatorsIgroupName(initiatorsIgroupName *string) {
	o.InitiatorsIgroupName = initiatorsIgroupName
}

// WithInitiatorsIgroupUUID adds the initiatorsIgroupUUID to the igroup collection get params
func (o *IgroupCollectionGetParams) WithInitiatorsIgroupUUID(initiatorsIgroupUUID *string) *IgroupCollectionGetParams {
	o.SetInitiatorsIgroupUUID(initiatorsIgroupUUID)
	return o
}

// SetInitiatorsIgroupUUID adds the initiatorsIgroupUuid to the igroup collection get params
func (o *IgroupCollectionGetParams) SetInitiatorsIgroupUUID(initiatorsIgroupUUID *string) {
	o.InitiatorsIgroupUUID = initiatorsIgroupUUID
}

// WithInitiatorsName adds the initiatorsName to the igroup collection get params
func (o *IgroupCollectionGetParams) WithInitiatorsName(initiatorsName *string) *IgroupCollectionGetParams {
	o.SetInitiatorsName(initiatorsName)
	return o
}

// SetInitiatorsName adds the initiatorsName to the igroup collection get params
func (o *IgroupCollectionGetParams) SetInitiatorsName(initiatorsName *string) {
	o.InitiatorsName = initiatorsName
}

// WithInitiatorsProximityLocalSvm adds the initiatorsProximityLocalSvm to the igroup collection get params
func (o *IgroupCollectionGetParams) WithInitiatorsProximityLocalSvm(initiatorsProximityLocalSvm *bool) *IgroupCollectionGetParams {
	o.SetInitiatorsProximityLocalSvm(initiatorsProximityLocalSvm)
	return o
}

// SetInitiatorsProximityLocalSvm adds the initiatorsProximityLocalSvm to the igroup collection get params
func (o *IgroupCollectionGetParams) SetInitiatorsProximityLocalSvm(initiatorsProximityLocalSvm *bool) {
	o.InitiatorsProximityLocalSvm = initiatorsProximityLocalSvm
}

// WithInitiatorsProximityPeerSvmsName adds the initiatorsProximityPeerSvmsName to the igroup collection get params
func (o *IgroupCollectionGetParams) WithInitiatorsProximityPeerSvmsName(initiatorsProximityPeerSvmsName *string) *IgroupCollectionGetParams {
	o.SetInitiatorsProximityPeerSvmsName(initiatorsProximityPeerSvmsName)
	return o
}

// SetInitiatorsProximityPeerSvmsName adds the initiatorsProximityPeerSvmsName to the igroup collection get params
func (o *IgroupCollectionGetParams) SetInitiatorsProximityPeerSvmsName(initiatorsProximityPeerSvmsName *string) {
	o.InitiatorsProximityPeerSvmsName = initiatorsProximityPeerSvmsName
}

// WithInitiatorsProximityPeerSvmsUUID adds the initiatorsProximityPeerSvmsUUID to the igroup collection get params
func (o *IgroupCollectionGetParams) WithInitiatorsProximityPeerSvmsUUID(initiatorsProximityPeerSvmsUUID *string) *IgroupCollectionGetParams {
	o.SetInitiatorsProximityPeerSvmsUUID(initiatorsProximityPeerSvmsUUID)
	return o
}

// SetInitiatorsProximityPeerSvmsUUID adds the initiatorsProximityPeerSvmsUuid to the igroup collection get params
func (o *IgroupCollectionGetParams) SetInitiatorsProximityPeerSvmsUUID(initiatorsProximityPeerSvmsUUID *string) {
	o.InitiatorsProximityPeerSvmsUUID = initiatorsProximityPeerSvmsUUID
}

// WithLunMapsLogicalUnitNumber adds the lunMapsLogicalUnitNumber to the igroup collection get params
func (o *IgroupCollectionGetParams) WithLunMapsLogicalUnitNumber(lunMapsLogicalUnitNumber *int64) *IgroupCollectionGetParams {
	o.SetLunMapsLogicalUnitNumber(lunMapsLogicalUnitNumber)
	return o
}

// SetLunMapsLogicalUnitNumber adds the lunMapsLogicalUnitNumber to the igroup collection get params
func (o *IgroupCollectionGetParams) SetLunMapsLogicalUnitNumber(lunMapsLogicalUnitNumber *int64) {
	o.LunMapsLogicalUnitNumber = lunMapsLogicalUnitNumber
}

// WithLunMapsLunName adds the lunMapsLunName to the igroup collection get params
func (o *IgroupCollectionGetParams) WithLunMapsLunName(lunMapsLunName *string) *IgroupCollectionGetParams {
	o.SetLunMapsLunName(lunMapsLunName)
	return o
}

// SetLunMapsLunName adds the lunMapsLunName to the igroup collection get params
func (o *IgroupCollectionGetParams) SetLunMapsLunName(lunMapsLunName *string) {
	o.LunMapsLunName = lunMapsLunName
}

// WithLunMapsLunNodeName adds the lunMapsLunNodeName to the igroup collection get params
func (o *IgroupCollectionGetParams) WithLunMapsLunNodeName(lunMapsLunNodeName *string) *IgroupCollectionGetParams {
	o.SetLunMapsLunNodeName(lunMapsLunNodeName)
	return o
}

// SetLunMapsLunNodeName adds the lunMapsLunNodeName to the igroup collection get params
func (o *IgroupCollectionGetParams) SetLunMapsLunNodeName(lunMapsLunNodeName *string) {
	o.LunMapsLunNodeName = lunMapsLunNodeName
}

// WithLunMapsLunNodeUUID adds the lunMapsLunNodeUUID to the igroup collection get params
func (o *IgroupCollectionGetParams) WithLunMapsLunNodeUUID(lunMapsLunNodeUUID *string) *IgroupCollectionGetParams {
	o.SetLunMapsLunNodeUUID(lunMapsLunNodeUUID)
	return o
}

// SetLunMapsLunNodeUUID adds the lunMapsLunNodeUuid to the igroup collection get params
func (o *IgroupCollectionGetParams) SetLunMapsLunNodeUUID(lunMapsLunNodeUUID *string) {
	o.LunMapsLunNodeUUID = lunMapsLunNodeUUID
}

// WithLunMapsLunUUID adds the lunMapsLunUUID to the igroup collection get params
func (o *IgroupCollectionGetParams) WithLunMapsLunUUID(lunMapsLunUUID *string) *IgroupCollectionGetParams {
	o.SetLunMapsLunUUID(lunMapsLunUUID)
	return o
}

// SetLunMapsLunUUID adds the lunMapsLunUuid to the igroup collection get params
func (o *IgroupCollectionGetParams) SetLunMapsLunUUID(lunMapsLunUUID *string) {
	o.LunMapsLunUUID = lunMapsLunUUID
}

// WithMaxRecords adds the maxRecords to the igroup collection get params
func (o *IgroupCollectionGetParams) WithMaxRecords(maxRecords *int64) *IgroupCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the igroup collection get params
func (o *IgroupCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the igroup collection get params
func (o *IgroupCollectionGetParams) WithName(name *string) *IgroupCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the igroup collection get params
func (o *IgroupCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the igroup collection get params
func (o *IgroupCollectionGetParams) WithOrderBy(orderBy []string) *IgroupCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the igroup collection get params
func (o *IgroupCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithOsType adds the osType to the igroup collection get params
func (o *IgroupCollectionGetParams) WithOsType(osType *string) *IgroupCollectionGetParams {
	o.SetOsType(osType)
	return o
}

// SetOsType adds the osType to the igroup collection get params
func (o *IgroupCollectionGetParams) SetOsType(osType *string) {
	o.OsType = osType
}

// WithParentIgroupsComment adds the parentIgroupsComment to the igroup collection get params
func (o *IgroupCollectionGetParams) WithParentIgroupsComment(parentIgroupsComment *string) *IgroupCollectionGetParams {
	o.SetParentIgroupsComment(parentIgroupsComment)
	return o
}

// SetParentIgroupsComment adds the parentIgroupsComment to the igroup collection get params
func (o *IgroupCollectionGetParams) SetParentIgroupsComment(parentIgroupsComment *string) {
	o.ParentIgroupsComment = parentIgroupsComment
}

// WithParentIgroupsName adds the parentIgroupsName to the igroup collection get params
func (o *IgroupCollectionGetParams) WithParentIgroupsName(parentIgroupsName *string) *IgroupCollectionGetParams {
	o.SetParentIgroupsName(parentIgroupsName)
	return o
}

// SetParentIgroupsName adds the parentIgroupsName to the igroup collection get params
func (o *IgroupCollectionGetParams) SetParentIgroupsName(parentIgroupsName *string) {
	o.ParentIgroupsName = parentIgroupsName
}

// WithParentIgroupsUUID adds the parentIgroupsUUID to the igroup collection get params
func (o *IgroupCollectionGetParams) WithParentIgroupsUUID(parentIgroupsUUID *string) *IgroupCollectionGetParams {
	o.SetParentIgroupsUUID(parentIgroupsUUID)
	return o
}

// SetParentIgroupsUUID adds the parentIgroupsUuid to the igroup collection get params
func (o *IgroupCollectionGetParams) SetParentIgroupsUUID(parentIgroupsUUID *string) {
	o.ParentIgroupsUUID = parentIgroupsUUID
}

// WithPortsetName adds the portsetName to the igroup collection get params
func (o *IgroupCollectionGetParams) WithPortsetName(portsetName *string) *IgroupCollectionGetParams {
	o.SetPortsetName(portsetName)
	return o
}

// SetPortsetName adds the portsetName to the igroup collection get params
func (o *IgroupCollectionGetParams) SetPortsetName(portsetName *string) {
	o.PortsetName = portsetName
}

// WithPortsetUUID adds the portsetUUID to the igroup collection get params
func (o *IgroupCollectionGetParams) WithPortsetUUID(portsetUUID *string) *IgroupCollectionGetParams {
	o.SetPortsetUUID(portsetUUID)
	return o
}

// SetPortsetUUID adds the portsetUuid to the igroup collection get params
func (o *IgroupCollectionGetParams) SetPortsetUUID(portsetUUID *string) {
	o.PortsetUUID = portsetUUID
}

// WithProtocol adds the protocol to the igroup collection get params
func (o *IgroupCollectionGetParams) WithProtocol(protocol *string) *IgroupCollectionGetParams {
	o.SetProtocol(protocol)
	return o
}

// SetProtocol adds the protocol to the igroup collection get params
func (o *IgroupCollectionGetParams) SetProtocol(protocol *string) {
	o.Protocol = protocol
}

// WithReplicationErrorIgroupLocalSvm adds the replicationErrorIgroupLocalSvm to the igroup collection get params
func (o *IgroupCollectionGetParams) WithReplicationErrorIgroupLocalSvm(replicationErrorIgroupLocalSvm *bool) *IgroupCollectionGetParams {
	o.SetReplicationErrorIgroupLocalSvm(replicationErrorIgroupLocalSvm)
	return o
}

// SetReplicationErrorIgroupLocalSvm adds the replicationErrorIgroupLocalSvm to the igroup collection get params
func (o *IgroupCollectionGetParams) SetReplicationErrorIgroupLocalSvm(replicationErrorIgroupLocalSvm *bool) {
	o.ReplicationErrorIgroupLocalSvm = replicationErrorIgroupLocalSvm
}

// WithReplicationErrorIgroupName adds the replicationErrorIgroupName to the igroup collection get params
func (o *IgroupCollectionGetParams) WithReplicationErrorIgroupName(replicationErrorIgroupName *string) *IgroupCollectionGetParams {
	o.SetReplicationErrorIgroupName(replicationErrorIgroupName)
	return o
}

// SetReplicationErrorIgroupName adds the replicationErrorIgroupName to the igroup collection get params
func (o *IgroupCollectionGetParams) SetReplicationErrorIgroupName(replicationErrorIgroupName *string) {
	o.ReplicationErrorIgroupName = replicationErrorIgroupName
}

// WithReplicationErrorIgroupUUID adds the replicationErrorIgroupUUID to the igroup collection get params
func (o *IgroupCollectionGetParams) WithReplicationErrorIgroupUUID(replicationErrorIgroupUUID *string) *IgroupCollectionGetParams {
	o.SetReplicationErrorIgroupUUID(replicationErrorIgroupUUID)
	return o
}

// SetReplicationErrorIgroupUUID adds the replicationErrorIgroupUuid to the igroup collection get params
func (o *IgroupCollectionGetParams) SetReplicationErrorIgroupUUID(replicationErrorIgroupUUID *string) {
	o.ReplicationErrorIgroupUUID = replicationErrorIgroupUUID
}

// WithReplicationErrorSummaryArgumentsCode adds the replicationErrorSummaryArgumentsCode to the igroup collection get params
func (o *IgroupCollectionGetParams) WithReplicationErrorSummaryArgumentsCode(replicationErrorSummaryArgumentsCode *string) *IgroupCollectionGetParams {
	o.SetReplicationErrorSummaryArgumentsCode(replicationErrorSummaryArgumentsCode)
	return o
}

// SetReplicationErrorSummaryArgumentsCode adds the replicationErrorSummaryArgumentsCode to the igroup collection get params
func (o *IgroupCollectionGetParams) SetReplicationErrorSummaryArgumentsCode(replicationErrorSummaryArgumentsCode *string) {
	o.ReplicationErrorSummaryArgumentsCode = replicationErrorSummaryArgumentsCode
}

// WithReplicationErrorSummaryArgumentsMessage adds the replicationErrorSummaryArgumentsMessage to the igroup collection get params
func (o *IgroupCollectionGetParams) WithReplicationErrorSummaryArgumentsMessage(replicationErrorSummaryArgumentsMessage *string) *IgroupCollectionGetParams {
	o.SetReplicationErrorSummaryArgumentsMessage(replicationErrorSummaryArgumentsMessage)
	return o
}

// SetReplicationErrorSummaryArgumentsMessage adds the replicationErrorSummaryArgumentsMessage to the igroup collection get params
func (o *IgroupCollectionGetParams) SetReplicationErrorSummaryArgumentsMessage(replicationErrorSummaryArgumentsMessage *string) {
	o.ReplicationErrorSummaryArgumentsMessage = replicationErrorSummaryArgumentsMessage
}

// WithReplicationErrorSummaryCode adds the replicationErrorSummaryCode to the igroup collection get params
func (o *IgroupCollectionGetParams) WithReplicationErrorSummaryCode(replicationErrorSummaryCode *string) *IgroupCollectionGetParams {
	o.SetReplicationErrorSummaryCode(replicationErrorSummaryCode)
	return o
}

// SetReplicationErrorSummaryCode adds the replicationErrorSummaryCode to the igroup collection get params
func (o *IgroupCollectionGetParams) SetReplicationErrorSummaryCode(replicationErrorSummaryCode *string) {
	o.ReplicationErrorSummaryCode = replicationErrorSummaryCode
}

// WithReplicationErrorSummaryMessage adds the replicationErrorSummaryMessage to the igroup collection get params
func (o *IgroupCollectionGetParams) WithReplicationErrorSummaryMessage(replicationErrorSummaryMessage *string) *IgroupCollectionGetParams {
	o.SetReplicationErrorSummaryMessage(replicationErrorSummaryMessage)
	return o
}

// SetReplicationErrorSummaryMessage adds the replicationErrorSummaryMessage to the igroup collection get params
func (o *IgroupCollectionGetParams) SetReplicationErrorSummaryMessage(replicationErrorSummaryMessage *string) {
	o.ReplicationErrorSummaryMessage = replicationErrorSummaryMessage
}

// WithReplicationPeerSvmName adds the replicationPeerSvmName to the igroup collection get params
func (o *IgroupCollectionGetParams) WithReplicationPeerSvmName(replicationPeerSvmName *string) *IgroupCollectionGetParams {
	o.SetReplicationPeerSvmName(replicationPeerSvmName)
	return o
}

// SetReplicationPeerSvmName adds the replicationPeerSvmName to the igroup collection get params
func (o *IgroupCollectionGetParams) SetReplicationPeerSvmName(replicationPeerSvmName *string) {
	o.ReplicationPeerSvmName = replicationPeerSvmName
}

// WithReplicationPeerSvmUUID adds the replicationPeerSvmUUID to the igroup collection get params
func (o *IgroupCollectionGetParams) WithReplicationPeerSvmUUID(replicationPeerSvmUUID *string) *IgroupCollectionGetParams {
	o.SetReplicationPeerSvmUUID(replicationPeerSvmUUID)
	return o
}

// SetReplicationPeerSvmUUID adds the replicationPeerSvmUuid to the igroup collection get params
func (o *IgroupCollectionGetParams) SetReplicationPeerSvmUUID(replicationPeerSvmUUID *string) {
	o.ReplicationPeerSvmUUID = replicationPeerSvmUUID
}

// WithReplicationState adds the replicationState to the igroup collection get params
func (o *IgroupCollectionGetParams) WithReplicationState(replicationState *string) *IgroupCollectionGetParams {
	o.SetReplicationState(replicationState)
	return o
}

// SetReplicationState adds the replicationState to the igroup collection get params
func (o *IgroupCollectionGetParams) SetReplicationState(replicationState *string) {
	o.ReplicationState = replicationState
}

// WithReturnRecords adds the returnRecords to the igroup collection get params
func (o *IgroupCollectionGetParams) WithReturnRecords(returnRecords *bool) *IgroupCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the igroup collection get params
func (o *IgroupCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the igroup collection get params
func (o *IgroupCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *IgroupCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the igroup collection get params
func (o *IgroupCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSupportsIgroups adds the supportsIgroups to the igroup collection get params
func (o *IgroupCollectionGetParams) WithSupportsIgroups(supportsIgroups *bool) *IgroupCollectionGetParams {
	o.SetSupportsIgroups(supportsIgroups)
	return o
}

// SetSupportsIgroups adds the supportsIgroups to the igroup collection get params
func (o *IgroupCollectionGetParams) SetSupportsIgroups(supportsIgroups *bool) {
	o.SupportsIgroups = supportsIgroups
}

// WithSvmName adds the svmName to the igroup collection get params
func (o *IgroupCollectionGetParams) WithSvmName(svmName *string) *IgroupCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the igroup collection get params
func (o *IgroupCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the igroup collection get params
func (o *IgroupCollectionGetParams) WithSvmUUID(svmUUID *string) *IgroupCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the igroup collection get params
func (o *IgroupCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTargetFirmwareRevision adds the targetFirmwareRevision to the igroup collection get params
func (o *IgroupCollectionGetParams) WithTargetFirmwareRevision(targetFirmwareRevision *string) *IgroupCollectionGetParams {
	o.SetTargetFirmwareRevision(targetFirmwareRevision)
	return o
}

// SetTargetFirmwareRevision adds the targetFirmwareRevision to the igroup collection get params
func (o *IgroupCollectionGetParams) SetTargetFirmwareRevision(targetFirmwareRevision *string) {
	o.TargetFirmwareRevision = targetFirmwareRevision
}

// WithTargetProductID adds the targetProductID to the igroup collection get params
func (o *IgroupCollectionGetParams) WithTargetProductID(targetProductID *string) *IgroupCollectionGetParams {
	o.SetTargetProductID(targetProductID)
	return o
}

// SetTargetProductID adds the targetProductId to the igroup collection get params
func (o *IgroupCollectionGetParams) SetTargetProductID(targetProductID *string) {
	o.TargetProductID = targetProductID
}

// WithTargetVendorID adds the targetVendorID to the igroup collection get params
func (o *IgroupCollectionGetParams) WithTargetVendorID(targetVendorID *string) *IgroupCollectionGetParams {
	o.SetTargetVendorID(targetVendorID)
	return o
}

// SetTargetVendorID adds the targetVendorId to the igroup collection get params
func (o *IgroupCollectionGetParams) SetTargetVendorID(targetVendorID *string) {
	o.TargetVendorID = targetVendorID
}

// WithUUID adds the uuid to the igroup collection get params
func (o *IgroupCollectionGetParams) WithUUID(uuid *string) *IgroupCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the igroup collection get params
func (o *IgroupCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *IgroupCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityTrackingAlertsSummaryArgumentsCode != nil {

		// query param connectivity_tracking.alerts.summary.arguments.code
		var qrConnectivityTrackingAlertsSummaryArgumentsCode string

		if o.ConnectivityTrackingAlertsSummaryArgumentsCode != nil {
			qrConnectivityTrackingAlertsSummaryArgumentsCode = *o.ConnectivityTrackingAlertsSummaryArgumentsCode
		}
		qConnectivityTrackingAlertsSummaryArgumentsCode := qrConnectivityTrackingAlertsSummaryArgumentsCode
		if qConnectivityTrackingAlertsSummaryArgumentsCode != "" {

			if err := r.SetQueryParam("connectivity_tracking.alerts.summary.arguments.code", qConnectivityTrackingAlertsSummaryArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityTrackingAlertsSummaryArgumentsMessage != nil {

		// query param connectivity_tracking.alerts.summary.arguments.message
		var qrConnectivityTrackingAlertsSummaryArgumentsMessage string

		if o.ConnectivityTrackingAlertsSummaryArgumentsMessage != nil {
			qrConnectivityTrackingAlertsSummaryArgumentsMessage = *o.ConnectivityTrackingAlertsSummaryArgumentsMessage
		}
		qConnectivityTrackingAlertsSummaryArgumentsMessage := qrConnectivityTrackingAlertsSummaryArgumentsMessage
		if qConnectivityTrackingAlertsSummaryArgumentsMessage != "" {

			if err := r.SetQueryParam("connectivity_tracking.alerts.summary.arguments.message", qConnectivityTrackingAlertsSummaryArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityTrackingAlertsSummaryCode != nil {

		// query param connectivity_tracking.alerts.summary.code
		var qrConnectivityTrackingAlertsSummaryCode string

		if o.ConnectivityTrackingAlertsSummaryCode != nil {
			qrConnectivityTrackingAlertsSummaryCode = *o.ConnectivityTrackingAlertsSummaryCode
		}
		qConnectivityTrackingAlertsSummaryCode := qrConnectivityTrackingAlertsSummaryCode
		if qConnectivityTrackingAlertsSummaryCode != "" {

			if err := r.SetQueryParam("connectivity_tracking.alerts.summary.code", qConnectivityTrackingAlertsSummaryCode); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityTrackingAlertsSummaryMessage != nil {

		// query param connectivity_tracking.alerts.summary.message
		var qrConnectivityTrackingAlertsSummaryMessage string

		if o.ConnectivityTrackingAlertsSummaryMessage != nil {
			qrConnectivityTrackingAlertsSummaryMessage = *o.ConnectivityTrackingAlertsSummaryMessage
		}
		qConnectivityTrackingAlertsSummaryMessage := qrConnectivityTrackingAlertsSummaryMessage
		if qConnectivityTrackingAlertsSummaryMessage != "" {

			if err := r.SetQueryParam("connectivity_tracking.alerts.summary.message", qConnectivityTrackingAlertsSummaryMessage); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityTrackingConnectionState != nil {

		// query param connectivity_tracking.connection_state
		var qrConnectivityTrackingConnectionState string

		if o.ConnectivityTrackingConnectionState != nil {
			qrConnectivityTrackingConnectionState = *o.ConnectivityTrackingConnectionState
		}
		qConnectivityTrackingConnectionState := qrConnectivityTrackingConnectionState
		if qConnectivityTrackingConnectionState != "" {

			if err := r.SetQueryParam("connectivity_tracking.connection_state", qConnectivityTrackingConnectionState); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityTrackingRequiredNodesName != nil {

		// query param connectivity_tracking.required_nodes.name
		var qrConnectivityTrackingRequiredNodesName string

		if o.ConnectivityTrackingRequiredNodesName != nil {
			qrConnectivityTrackingRequiredNodesName = *o.ConnectivityTrackingRequiredNodesName
		}
		qConnectivityTrackingRequiredNodesName := qrConnectivityTrackingRequiredNodesName
		if qConnectivityTrackingRequiredNodesName != "" {

			if err := r.SetQueryParam("connectivity_tracking.required_nodes.name", qConnectivityTrackingRequiredNodesName); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityTrackingRequiredNodesUUID != nil {

		// query param connectivity_tracking.required_nodes.uuid
		var qrConnectivityTrackingRequiredNodesUUID string

		if o.ConnectivityTrackingRequiredNodesUUID != nil {
			qrConnectivityTrackingRequiredNodesUUID = *o.ConnectivityTrackingRequiredNodesUUID
		}
		qConnectivityTrackingRequiredNodesUUID := qrConnectivityTrackingRequiredNodesUUID
		if qConnectivityTrackingRequiredNodesUUID != "" {

			if err := r.SetQueryParam("connectivity_tracking.required_nodes.uuid", qConnectivityTrackingRequiredNodesUUID); err != nil {
				return err
			}
		}
	}

	if o.DeleteOnUnmap != nil {

		// query param delete_on_unmap
		var qrDeleteOnUnmap bool

		if o.DeleteOnUnmap != nil {
			qrDeleteOnUnmap = *o.DeleteOnUnmap
		}
		qDeleteOnUnmap := swag.FormatBool(qrDeleteOnUnmap)
		if qDeleteOnUnmap != "" {

			if err := r.SetQueryParam("delete_on_unmap", qDeleteOnUnmap); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.IgroupsComment != nil {

		// query param igroups.comment
		var qrIgroupsComment string

		if o.IgroupsComment != nil {
			qrIgroupsComment = *o.IgroupsComment
		}
		qIgroupsComment := qrIgroupsComment
		if qIgroupsComment != "" {

			if err := r.SetQueryParam("igroups.comment", qIgroupsComment); err != nil {
				return err
			}
		}
	}

	if o.IgroupsName != nil {

		// query param igroups.name
		var qrIgroupsName string

		if o.IgroupsName != nil {
			qrIgroupsName = *o.IgroupsName
		}
		qIgroupsName := qrIgroupsName
		if qIgroupsName != "" {

			if err := r.SetQueryParam("igroups.name", qIgroupsName); err != nil {
				return err
			}
		}
	}

	if o.IgroupsUUID != nil {

		// query param igroups.uuid
		var qrIgroupsUUID string

		if o.IgroupsUUID != nil {
			qrIgroupsUUID = *o.IgroupsUUID
		}
		qIgroupsUUID := qrIgroupsUUID
		if qIgroupsUUID != "" {

			if err := r.SetQueryParam("igroups.uuid", qIgroupsUUID); err != nil {
				return err
			}
		}
	}

	if o.InitiatorsComment != nil {

		// query param initiators.comment
		var qrInitiatorsComment string

		if o.InitiatorsComment != nil {
			qrInitiatorsComment = *o.InitiatorsComment
		}
		qInitiatorsComment := qrInitiatorsComment
		if qInitiatorsComment != "" {

			if err := r.SetQueryParam("initiators.comment", qInitiatorsComment); err != nil {
				return err
			}
		}
	}

	if o.InitiatorsConnectivityTrackingConnectionState != nil {

		// query param initiators.connectivity_tracking.connection_state
		var qrInitiatorsConnectivityTrackingConnectionState string

		if o.InitiatorsConnectivityTrackingConnectionState != nil {
			qrInitiatorsConnectivityTrackingConnectionState = *o.InitiatorsConnectivityTrackingConnectionState
		}
		qInitiatorsConnectivityTrackingConnectionState := qrInitiatorsConnectivityTrackingConnectionState
		if qInitiatorsConnectivityTrackingConnectionState != "" {

			if err := r.SetQueryParam("initiators.connectivity_tracking.connection_state", qInitiatorsConnectivityTrackingConnectionState); err != nil {
				return err
			}
		}
	}

	if o.InitiatorsIgroupName != nil {

		// query param initiators.igroup.name
		var qrInitiatorsIgroupName string

		if o.InitiatorsIgroupName != nil {
			qrInitiatorsIgroupName = *o.InitiatorsIgroupName
		}
		qInitiatorsIgroupName := qrInitiatorsIgroupName
		if qInitiatorsIgroupName != "" {

			if err := r.SetQueryParam("initiators.igroup.name", qInitiatorsIgroupName); err != nil {
				return err
			}
		}
	}

	if o.InitiatorsIgroupUUID != nil {

		// query param initiators.igroup.uuid
		var qrInitiatorsIgroupUUID string

		if o.InitiatorsIgroupUUID != nil {
			qrInitiatorsIgroupUUID = *o.InitiatorsIgroupUUID
		}
		qInitiatorsIgroupUUID := qrInitiatorsIgroupUUID
		if qInitiatorsIgroupUUID != "" {

			if err := r.SetQueryParam("initiators.igroup.uuid", qInitiatorsIgroupUUID); err != nil {
				return err
			}
		}
	}

	if o.InitiatorsName != nil {

		// query param initiators.name
		var qrInitiatorsName string

		if o.InitiatorsName != nil {
			qrInitiatorsName = *o.InitiatorsName
		}
		qInitiatorsName := qrInitiatorsName
		if qInitiatorsName != "" {

			if err := r.SetQueryParam("initiators.name", qInitiatorsName); err != nil {
				return err
			}
		}
	}

	if o.InitiatorsProximityLocalSvm != nil {

		// query param initiators.proximity.local_svm
		var qrInitiatorsProximityLocalSvm bool

		if o.InitiatorsProximityLocalSvm != nil {
			qrInitiatorsProximityLocalSvm = *o.InitiatorsProximityLocalSvm
		}
		qInitiatorsProximityLocalSvm := swag.FormatBool(qrInitiatorsProximityLocalSvm)
		if qInitiatorsProximityLocalSvm != "" {

			if err := r.SetQueryParam("initiators.proximity.local_svm", qInitiatorsProximityLocalSvm); err != nil {
				return err
			}
		}
	}

	if o.InitiatorsProximityPeerSvmsName != nil {

		// query param initiators.proximity.peer_svms.name
		var qrInitiatorsProximityPeerSvmsName string

		if o.InitiatorsProximityPeerSvmsName != nil {
			qrInitiatorsProximityPeerSvmsName = *o.InitiatorsProximityPeerSvmsName
		}
		qInitiatorsProximityPeerSvmsName := qrInitiatorsProximityPeerSvmsName
		if qInitiatorsProximityPeerSvmsName != "" {

			if err := r.SetQueryParam("initiators.proximity.peer_svms.name", qInitiatorsProximityPeerSvmsName); err != nil {
				return err
			}
		}
	}

	if o.InitiatorsProximityPeerSvmsUUID != nil {

		// query param initiators.proximity.peer_svms.uuid
		var qrInitiatorsProximityPeerSvmsUUID string

		if o.InitiatorsProximityPeerSvmsUUID != nil {
			qrInitiatorsProximityPeerSvmsUUID = *o.InitiatorsProximityPeerSvmsUUID
		}
		qInitiatorsProximityPeerSvmsUUID := qrInitiatorsProximityPeerSvmsUUID
		if qInitiatorsProximityPeerSvmsUUID != "" {

			if err := r.SetQueryParam("initiators.proximity.peer_svms.uuid", qInitiatorsProximityPeerSvmsUUID); err != nil {
				return err
			}
		}
	}

	if o.LunMapsLogicalUnitNumber != nil {

		// query param lun_maps.logical_unit_number
		var qrLunMapsLogicalUnitNumber int64

		if o.LunMapsLogicalUnitNumber != nil {
			qrLunMapsLogicalUnitNumber = *o.LunMapsLogicalUnitNumber
		}
		qLunMapsLogicalUnitNumber := swag.FormatInt64(qrLunMapsLogicalUnitNumber)
		if qLunMapsLogicalUnitNumber != "" {

			if err := r.SetQueryParam("lun_maps.logical_unit_number", qLunMapsLogicalUnitNumber); err != nil {
				return err
			}
		}
	}

	if o.LunMapsLunName != nil {

		// query param lun_maps.lun.name
		var qrLunMapsLunName string

		if o.LunMapsLunName != nil {
			qrLunMapsLunName = *o.LunMapsLunName
		}
		qLunMapsLunName := qrLunMapsLunName
		if qLunMapsLunName != "" {

			if err := r.SetQueryParam("lun_maps.lun.name", qLunMapsLunName); err != nil {
				return err
			}
		}
	}

	if o.LunMapsLunNodeName != nil {

		// query param lun_maps.lun.node.name
		var qrLunMapsLunNodeName string

		if o.LunMapsLunNodeName != nil {
			qrLunMapsLunNodeName = *o.LunMapsLunNodeName
		}
		qLunMapsLunNodeName := qrLunMapsLunNodeName
		if qLunMapsLunNodeName != "" {

			if err := r.SetQueryParam("lun_maps.lun.node.name", qLunMapsLunNodeName); err != nil {
				return err
			}
		}
	}

	if o.LunMapsLunNodeUUID != nil {

		// query param lun_maps.lun.node.uuid
		var qrLunMapsLunNodeUUID string

		if o.LunMapsLunNodeUUID != nil {
			qrLunMapsLunNodeUUID = *o.LunMapsLunNodeUUID
		}
		qLunMapsLunNodeUUID := qrLunMapsLunNodeUUID
		if qLunMapsLunNodeUUID != "" {

			if err := r.SetQueryParam("lun_maps.lun.node.uuid", qLunMapsLunNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.LunMapsLunUUID != nil {

		// query param lun_maps.lun.uuid
		var qrLunMapsLunUUID string

		if o.LunMapsLunUUID != nil {
			qrLunMapsLunUUID = *o.LunMapsLunUUID
		}
		qLunMapsLunUUID := qrLunMapsLunUUID
		if qLunMapsLunUUID != "" {

			if err := r.SetQueryParam("lun_maps.lun.uuid", qLunMapsLunUUID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.OsType != nil {

		// query param os_type
		var qrOsType string

		if o.OsType != nil {
			qrOsType = *o.OsType
		}
		qOsType := qrOsType
		if qOsType != "" {

			if err := r.SetQueryParam("os_type", qOsType); err != nil {
				return err
			}
		}
	}

	if o.ParentIgroupsComment != nil {

		// query param parent_igroups.comment
		var qrParentIgroupsComment string

		if o.ParentIgroupsComment != nil {
			qrParentIgroupsComment = *o.ParentIgroupsComment
		}
		qParentIgroupsComment := qrParentIgroupsComment
		if qParentIgroupsComment != "" {

			if err := r.SetQueryParam("parent_igroups.comment", qParentIgroupsComment); err != nil {
				return err
			}
		}
	}

	if o.ParentIgroupsName != nil {

		// query param parent_igroups.name
		var qrParentIgroupsName string

		if o.ParentIgroupsName != nil {
			qrParentIgroupsName = *o.ParentIgroupsName
		}
		qParentIgroupsName := qrParentIgroupsName
		if qParentIgroupsName != "" {

			if err := r.SetQueryParam("parent_igroups.name", qParentIgroupsName); err != nil {
				return err
			}
		}
	}

	if o.ParentIgroupsUUID != nil {

		// query param parent_igroups.uuid
		var qrParentIgroupsUUID string

		if o.ParentIgroupsUUID != nil {
			qrParentIgroupsUUID = *o.ParentIgroupsUUID
		}
		qParentIgroupsUUID := qrParentIgroupsUUID
		if qParentIgroupsUUID != "" {

			if err := r.SetQueryParam("parent_igroups.uuid", qParentIgroupsUUID); err != nil {
				return err
			}
		}
	}

	if o.PortsetName != nil {

		// query param portset.name
		var qrPortsetName string

		if o.PortsetName != nil {
			qrPortsetName = *o.PortsetName
		}
		qPortsetName := qrPortsetName
		if qPortsetName != "" {

			if err := r.SetQueryParam("portset.name", qPortsetName); err != nil {
				return err
			}
		}
	}

	if o.PortsetUUID != nil {

		// query param portset.uuid
		var qrPortsetUUID string

		if o.PortsetUUID != nil {
			qrPortsetUUID = *o.PortsetUUID
		}
		qPortsetUUID := qrPortsetUUID
		if qPortsetUUID != "" {

			if err := r.SetQueryParam("portset.uuid", qPortsetUUID); err != nil {
				return err
			}
		}
	}

	if o.Protocol != nil {

		// query param protocol
		var qrProtocol string

		if o.Protocol != nil {
			qrProtocol = *o.Protocol
		}
		qProtocol := qrProtocol
		if qProtocol != "" {

			if err := r.SetQueryParam("protocol", qProtocol); err != nil {
				return err
			}
		}
	}

	if o.ReplicationErrorIgroupLocalSvm != nil {

		// query param replication.error.igroup.local_svm
		var qrReplicationErrorIgroupLocalSvm bool

		if o.ReplicationErrorIgroupLocalSvm != nil {
			qrReplicationErrorIgroupLocalSvm = *o.ReplicationErrorIgroupLocalSvm
		}
		qReplicationErrorIgroupLocalSvm := swag.FormatBool(qrReplicationErrorIgroupLocalSvm)
		if qReplicationErrorIgroupLocalSvm != "" {

			if err := r.SetQueryParam("replication.error.igroup.local_svm", qReplicationErrorIgroupLocalSvm); err != nil {
				return err
			}
		}
	}

	if o.ReplicationErrorIgroupName != nil {

		// query param replication.error.igroup.name
		var qrReplicationErrorIgroupName string

		if o.ReplicationErrorIgroupName != nil {
			qrReplicationErrorIgroupName = *o.ReplicationErrorIgroupName
		}
		qReplicationErrorIgroupName := qrReplicationErrorIgroupName
		if qReplicationErrorIgroupName != "" {

			if err := r.SetQueryParam("replication.error.igroup.name", qReplicationErrorIgroupName); err != nil {
				return err
			}
		}
	}

	if o.ReplicationErrorIgroupUUID != nil {

		// query param replication.error.igroup.uuid
		var qrReplicationErrorIgroupUUID string

		if o.ReplicationErrorIgroupUUID != nil {
			qrReplicationErrorIgroupUUID = *o.ReplicationErrorIgroupUUID
		}
		qReplicationErrorIgroupUUID := qrReplicationErrorIgroupUUID
		if qReplicationErrorIgroupUUID != "" {

			if err := r.SetQueryParam("replication.error.igroup.uuid", qReplicationErrorIgroupUUID); err != nil {
				return err
			}
		}
	}

	if o.ReplicationErrorSummaryArgumentsCode != nil {

		// query param replication.error.summary.arguments.code
		var qrReplicationErrorSummaryArgumentsCode string

		if o.ReplicationErrorSummaryArgumentsCode != nil {
			qrReplicationErrorSummaryArgumentsCode = *o.ReplicationErrorSummaryArgumentsCode
		}
		qReplicationErrorSummaryArgumentsCode := qrReplicationErrorSummaryArgumentsCode
		if qReplicationErrorSummaryArgumentsCode != "" {

			if err := r.SetQueryParam("replication.error.summary.arguments.code", qReplicationErrorSummaryArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.ReplicationErrorSummaryArgumentsMessage != nil {

		// query param replication.error.summary.arguments.message
		var qrReplicationErrorSummaryArgumentsMessage string

		if o.ReplicationErrorSummaryArgumentsMessage != nil {
			qrReplicationErrorSummaryArgumentsMessage = *o.ReplicationErrorSummaryArgumentsMessage
		}
		qReplicationErrorSummaryArgumentsMessage := qrReplicationErrorSummaryArgumentsMessage
		if qReplicationErrorSummaryArgumentsMessage != "" {

			if err := r.SetQueryParam("replication.error.summary.arguments.message", qReplicationErrorSummaryArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.ReplicationErrorSummaryCode != nil {

		// query param replication.error.summary.code
		var qrReplicationErrorSummaryCode string

		if o.ReplicationErrorSummaryCode != nil {
			qrReplicationErrorSummaryCode = *o.ReplicationErrorSummaryCode
		}
		qReplicationErrorSummaryCode := qrReplicationErrorSummaryCode
		if qReplicationErrorSummaryCode != "" {

			if err := r.SetQueryParam("replication.error.summary.code", qReplicationErrorSummaryCode); err != nil {
				return err
			}
		}
	}

	if o.ReplicationErrorSummaryMessage != nil {

		// query param replication.error.summary.message
		var qrReplicationErrorSummaryMessage string

		if o.ReplicationErrorSummaryMessage != nil {
			qrReplicationErrorSummaryMessage = *o.ReplicationErrorSummaryMessage
		}
		qReplicationErrorSummaryMessage := qrReplicationErrorSummaryMessage
		if qReplicationErrorSummaryMessage != "" {

			if err := r.SetQueryParam("replication.error.summary.message", qReplicationErrorSummaryMessage); err != nil {
				return err
			}
		}
	}

	if o.ReplicationPeerSvmName != nil {

		// query param replication.peer_svm.name
		var qrReplicationPeerSvmName string

		if o.ReplicationPeerSvmName != nil {
			qrReplicationPeerSvmName = *o.ReplicationPeerSvmName
		}
		qReplicationPeerSvmName := qrReplicationPeerSvmName
		if qReplicationPeerSvmName != "" {

			if err := r.SetQueryParam("replication.peer_svm.name", qReplicationPeerSvmName); err != nil {
				return err
			}
		}
	}

	if o.ReplicationPeerSvmUUID != nil {

		// query param replication.peer_svm.uuid
		var qrReplicationPeerSvmUUID string

		if o.ReplicationPeerSvmUUID != nil {
			qrReplicationPeerSvmUUID = *o.ReplicationPeerSvmUUID
		}
		qReplicationPeerSvmUUID := qrReplicationPeerSvmUUID
		if qReplicationPeerSvmUUID != "" {

			if err := r.SetQueryParam("replication.peer_svm.uuid", qReplicationPeerSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.ReplicationState != nil {

		// query param replication.state
		var qrReplicationState string

		if o.ReplicationState != nil {
			qrReplicationState = *o.ReplicationState
		}
		qReplicationState := qrReplicationState
		if qReplicationState != "" {

			if err := r.SetQueryParam("replication.state", qReplicationState); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SupportsIgroups != nil {

		// query param supports_igroups
		var qrSupportsIgroups bool

		if o.SupportsIgroups != nil {
			qrSupportsIgroups = *o.SupportsIgroups
		}
		qSupportsIgroups := swag.FormatBool(qrSupportsIgroups)
		if qSupportsIgroups != "" {

			if err := r.SetQueryParam("supports_igroups", qSupportsIgroups); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TargetFirmwareRevision != nil {

		// query param target.firmware_revision
		var qrTargetFirmwareRevision string

		if o.TargetFirmwareRevision != nil {
			qrTargetFirmwareRevision = *o.TargetFirmwareRevision
		}
		qTargetFirmwareRevision := qrTargetFirmwareRevision
		if qTargetFirmwareRevision != "" {

			if err := r.SetQueryParam("target.firmware_revision", qTargetFirmwareRevision); err != nil {
				return err
			}
		}
	}

	if o.TargetProductID != nil {

		// query param target.product_id
		var qrTargetProductID string

		if o.TargetProductID != nil {
			qrTargetProductID = *o.TargetProductID
		}
		qTargetProductID := qrTargetProductID
		if qTargetProductID != "" {

			if err := r.SetQueryParam("target.product_id", qTargetProductID); err != nil {
				return err
			}
		}
	}

	if o.TargetVendorID != nil {

		// query param target.vendor_id
		var qrTargetVendorID string

		if o.TargetVendorID != nil {
			qrTargetVendorID = *o.TargetVendorID
		}
		qTargetVendorID := qrTargetVendorID
		if qTargetVendorID != "" {

			if err := r.SetQueryParam("target.vendor_id", qTargetVendorID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamIgroupCollectionGet binds the parameter fields
func (o *IgroupCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamIgroupCollectionGet binds the parameter order_by
func (o *IgroupCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
