// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewIgroupCreateParams creates a new IgroupCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIgroupCreateParams() *IgroupCreateParams {
	return &IgroupCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIgroupCreateParamsWithTimeout creates a new IgroupCreateParams object
// with the ability to set a timeout on a request.
func NewIgroupCreateParamsWithTimeout(timeout time.Duration) *IgroupCreateParams {
	return &IgroupCreateParams{
		timeout: timeout,
	}
}

// NewIgroupCreateParamsWithContext creates a new IgroupCreateParams object
// with the ability to set a context for a request.
func NewIgroupCreateParamsWithContext(ctx context.Context) *IgroupCreateParams {
	return &IgroupCreateParams{
		Context: ctx,
	}
}

// NewIgroupCreateParamsWithHTTPClient creates a new IgroupCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewIgroupCreateParamsWithHTTPClient(client *http.Client) *IgroupCreateParams {
	return &IgroupCreateParams{
		HTTPClient: client,
	}
}

/*
IgroupCreateParams contains all the parameters to send to the API endpoint

	for the igroup create operation.

	Typically these are written to a http.Request.
*/
type IgroupCreateParams struct {

	/* Info.

	   The property values for the new initiator group.

	*/
	Info *models.Igroup

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the igroup create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IgroupCreateParams) WithDefaults() *IgroupCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the igroup create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IgroupCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := IgroupCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the igroup create params
func (o *IgroupCreateParams) WithTimeout(timeout time.Duration) *IgroupCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the igroup create params
func (o *IgroupCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the igroup create params
func (o *IgroupCreateParams) WithContext(ctx context.Context) *IgroupCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the igroup create params
func (o *IgroupCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the igroup create params
func (o *IgroupCreateParams) WithHTTPClient(client *http.Client) *IgroupCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the igroup create params
func (o *IgroupCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the igroup create params
func (o *IgroupCreateParams) WithInfo(info *models.Igroup) *IgroupCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the igroup create params
func (o *IgroupCreateParams) SetInfo(info *models.Igroup) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the igroup create params
func (o *IgroupCreateParams) WithReturnRecords(returnRecords *bool) *IgroupCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the igroup create params
func (o *IgroupCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *IgroupCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
