// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IgroupInitiatorCollectionGetReader is a Reader for the IgroupInitiatorCollectionGet structure.
type IgroupInitiatorCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IgroupInitiatorCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIgroupInitiatorCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIgroupInitiatorCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIgroupInitiatorCollectionGetOK creates a IgroupInitiatorCollectionGetOK with default headers values
func NewIgroupInitiatorCollectionGetOK() *IgroupInitiatorCollectionGetOK {
	return &IgroupInitiatorCollectionGetOK{}
}

/*
IgroupInitiatorCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type IgroupInitiatorCollectionGetOK struct {
	Payload *models.IgroupInitiatorResponse
}

// IsSuccess returns true when this igroup initiator collection get o k response has a 2xx status code
func (o *IgroupInitiatorCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this igroup initiator collection get o k response has a 3xx status code
func (o *IgroupInitiatorCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this igroup initiator collection get o k response has a 4xx status code
func (o *IgroupInitiatorCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this igroup initiator collection get o k response has a 5xx status code
func (o *IgroupInitiatorCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this igroup initiator collection get o k response a status code equal to that given
func (o *IgroupInitiatorCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the igroup initiator collection get o k response
func (o *IgroupInitiatorCollectionGetOK) Code() int {
	return 200
}

func (o *IgroupInitiatorCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/igroups/{igroup.uuid}/initiators][%d] igroupInitiatorCollectionGetOK %s", 200, payload)
}

func (o *IgroupInitiatorCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/igroups/{igroup.uuid}/initiators][%d] igroupInitiatorCollectionGetOK %s", 200, payload)
}

func (o *IgroupInitiatorCollectionGetOK) GetPayload() *models.IgroupInitiatorResponse {
	return o.Payload
}

func (o *IgroupInitiatorCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.IgroupInitiatorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewIgroupInitiatorCollectionGetDefault creates a IgroupInitiatorCollectionGetDefault with default headers values
func NewIgroupInitiatorCollectionGetDefault(code int) *IgroupInitiatorCollectionGetDefault {
	return &IgroupInitiatorCollectionGetDefault{
		_statusCode: code,
	}
}

/*
	IgroupInitiatorCollectionGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5374852 | The initiator group specified in the URI does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IgroupInitiatorCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this igroup initiator collection get default response has a 2xx status code
func (o *IgroupInitiatorCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this igroup initiator collection get default response has a 3xx status code
func (o *IgroupInitiatorCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this igroup initiator collection get default response has a 4xx status code
func (o *IgroupInitiatorCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this igroup initiator collection get default response has a 5xx status code
func (o *IgroupInitiatorCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this igroup initiator collection get default response a status code equal to that given
func (o *IgroupInitiatorCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the igroup initiator collection get default response
func (o *IgroupInitiatorCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *IgroupInitiatorCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/igroups/{igroup.uuid}/initiators][%d] igroup_initiator_collection_get default %s", o._statusCode, payload)
}

func (o *IgroupInitiatorCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/igroups/{igroup.uuid}/initiators][%d] igroup_initiator_collection_get default %s", o._statusCode, payload)
}

func (o *IgroupInitiatorCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IgroupInitiatorCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
