// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewIgroupInitiatorCreateParams creates a new IgroupInitiatorCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIgroupInitiatorCreateParams() *IgroupInitiatorCreateParams {
	return &IgroupInitiatorCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIgroupInitiatorCreateParamsWithTimeout creates a new IgroupInitiatorCreateParams object
// with the ability to set a timeout on a request.
func NewIgroupInitiatorCreateParamsWithTimeout(timeout time.Duration) *IgroupInitiatorCreateParams {
	return &IgroupInitiatorCreateParams{
		timeout: timeout,
	}
}

// NewIgroupInitiatorCreateParamsWithContext creates a new IgroupInitiatorCreateParams object
// with the ability to set a context for a request.
func NewIgroupInitiatorCreateParamsWithContext(ctx context.Context) *IgroupInitiatorCreateParams {
	return &IgroupInitiatorCreateParams{
		Context: ctx,
	}
}

// NewIgroupInitiatorCreateParamsWithHTTPClient creates a new IgroupInitiatorCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewIgroupInitiatorCreateParamsWithHTTPClient(client *http.Client) *IgroupInitiatorCreateParams {
	return &IgroupInitiatorCreateParams{
		HTTPClient: client,
	}
}

/*
IgroupInitiatorCreateParams contains all the parameters to send to the API endpoint

	for the igroup initiator create operation.

	Typically these are written to a http.Request.
*/
type IgroupInitiatorCreateParams struct {

	/* IgroupUUID.

	   The unique identifier of the initiator group.

	*/
	IgroupUUID string

	/* Info.

	   The properties of the initiator to add to the initiator group.

	*/
	Info *models.IgroupInitiator

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the igroup initiator create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IgroupInitiatorCreateParams) WithDefaults() *IgroupInitiatorCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the igroup initiator create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IgroupInitiatorCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := IgroupInitiatorCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the igroup initiator create params
func (o *IgroupInitiatorCreateParams) WithTimeout(timeout time.Duration) *IgroupInitiatorCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the igroup initiator create params
func (o *IgroupInitiatorCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the igroup initiator create params
func (o *IgroupInitiatorCreateParams) WithContext(ctx context.Context) *IgroupInitiatorCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the igroup initiator create params
func (o *IgroupInitiatorCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the igroup initiator create params
func (o *IgroupInitiatorCreateParams) WithHTTPClient(client *http.Client) *IgroupInitiatorCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the igroup initiator create params
func (o *IgroupInitiatorCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithIgroupUUID adds the igroupUUID to the igroup initiator create params
func (o *IgroupInitiatorCreateParams) WithIgroupUUID(igroupUUID string) *IgroupInitiatorCreateParams {
	o.SetIgroupUUID(igroupUUID)
	return o
}

// SetIgroupUUID adds the igroupUuid to the igroup initiator create params
func (o *IgroupInitiatorCreateParams) SetIgroupUUID(igroupUUID string) {
	o.IgroupUUID = igroupUUID
}

// WithInfo adds the info to the igroup initiator create params
func (o *IgroupInitiatorCreateParams) WithInfo(info *models.IgroupInitiator) *IgroupInitiatorCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the igroup initiator create params
func (o *IgroupInitiatorCreateParams) SetInfo(info *models.IgroupInitiator) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the igroup initiator create params
func (o *IgroupInitiatorCreateParams) WithReturnRecords(returnRecords *bool) *IgroupInitiatorCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the igroup initiator create params
func (o *IgroupInitiatorCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *IgroupInitiatorCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param igroup.uuid
	if err := r.SetPathParam("igroup.uuid", o.IgroupUUID); err != nil {
		return err
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
