// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IgroupInitiatorCreateReader is a Reader for the IgroupInitiatorCreate structure.
type IgroupInitiatorCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IgroupInitiatorCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewIgroupInitiatorCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIgroupInitiatorCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIgroupInitiatorCreateCreated creates a IgroupInitiatorCreateCreated with default headers values
func NewIgroupInitiatorCreateCreated() *IgroupInitiatorCreateCreated {
	return &IgroupInitiatorCreateCreated{}
}

/*
IgroupInitiatorCreateCreated describes a response with status code 201, with default header values.

Created
*/
type IgroupInitiatorCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.IgroupInitiatorResponse
}

// IsSuccess returns true when this igroup initiator create created response has a 2xx status code
func (o *IgroupInitiatorCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this igroup initiator create created response has a 3xx status code
func (o *IgroupInitiatorCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this igroup initiator create created response has a 4xx status code
func (o *IgroupInitiatorCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this igroup initiator create created response has a 5xx status code
func (o *IgroupInitiatorCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this igroup initiator create created response a status code equal to that given
func (o *IgroupInitiatorCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the igroup initiator create created response
func (o *IgroupInitiatorCreateCreated) Code() int {
	return 201
}

func (o *IgroupInitiatorCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/igroups/{igroup.uuid}/initiators][%d] igroupInitiatorCreateCreated %s", 201, payload)
}

func (o *IgroupInitiatorCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/igroups/{igroup.uuid}/initiators][%d] igroupInitiatorCreateCreated %s", 201, payload)
}

func (o *IgroupInitiatorCreateCreated) GetPayload() *models.IgroupInitiatorResponse {
	return o.Payload
}

func (o *IgroupInitiatorCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.IgroupInitiatorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewIgroupInitiatorCreateDefault creates a IgroupInitiatorCreateDefault with default headers values
func NewIgroupInitiatorCreateDefault(code int) *IgroupInitiatorCreateDefault {
	return &IgroupInitiatorCreateDefault{
		_statusCode: code,
	}
}

/*
	IgroupInitiatorCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1254193 | Adding an initiator would cause the initiator to be mapped to the same LUN more than once. |
| 1254324 | Adding an initiator would cause the initiator to have the same logical unit identifier for multiple LUN maps. |
| 5373969 | A supplied initiator name looks like an iSCSI IQN initiator, but the portions after the prefix are missing. |
| 5373971 | A supplied initiator name looks like an iSCSI IQN initiator, but the date portion is invalid. |
| 5373972 | A supplied initiator name looks like an iSCSI IQN initiator, but the naming authority portion is invalid. |
| 5373977 | A supplied initiator name looks like an iSCSI EUI initiator, but the length is invalid. |
| 5373978 | A supplied initiator name looks like an iSCSI EUI initiator, but the format is invalid. |
| 5373982 | An invalid WWN was specified. The length is incorrect. |
| 5373983 | An invalid WWN was specified. The format is incorrect. |
| 5373992 | A supplied initiator name was too long to be valid. |
| 5373993 | A supplied initiator name did not match any valid format. |
| 5374033 | Initiators must be supplied. |
| 5374035 | A supplied initiator is already in the initiator group. |
| 5374038 | An invalid Fibre Channel WWPN was supplied. |
| 5374039 | An invalid iSCSI initiator name was supplied. |
| 5374734 | An initiator is already in another initiator group with a conflicting operating system type. |
| 5374761 | An error was reported by the peer cluster while adding an initiator to a replicated initiator group. The specific error will be included as a nested error. |
| 5374852 | The initiator group specified in the URI does not exist. |
| 5374917 | Duplicated initiators have conflicting property values. |
| 5375055 | The `local_svm` property of an initiator proximity was not specified. |
| 5375056 | An SVM peering relationship that does not have the initiator group's SVM as the local SVM was specified. |
| 5375261 | Setting initiator proximity is not supported for the SVM type. |
| 5376057 | Setting initiator proximity is not supported for the ONTAP version. |
| 5376059 | Setting initiator proximity to a peer that is either the destination of an SVM DR relationship or in a Metrocluster configuration is not supported. |
| 26345672 | The specified SVM peering relationship was not found. |
| 26345673 | An SVM peering relationship between the initiator group's SVM and specified peer SVM was not found. |
| 26345675 | An SVM peering relationship UUID and name were specified and they do not refer to the same SVM peering relationship. |
| 26345680 | Supplied SVM peer is on the local cluster. The operation requires a peer on a remote cluster. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IgroupInitiatorCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this igroup initiator create default response has a 2xx status code
func (o *IgroupInitiatorCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this igroup initiator create default response has a 3xx status code
func (o *IgroupInitiatorCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this igroup initiator create default response has a 4xx status code
func (o *IgroupInitiatorCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this igroup initiator create default response has a 5xx status code
func (o *IgroupInitiatorCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this igroup initiator create default response a status code equal to that given
func (o *IgroupInitiatorCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the igroup initiator create default response
func (o *IgroupInitiatorCreateDefault) Code() int {
	return o._statusCode
}

func (o *IgroupInitiatorCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/igroups/{igroup.uuid}/initiators][%d] igroup_initiator_create default %s", o._statusCode, payload)
}

func (o *IgroupInitiatorCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/igroups/{igroup.uuid}/initiators][%d] igroup_initiator_create default %s", o._statusCode, payload)
}

func (o *IgroupInitiatorCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IgroupInitiatorCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
