// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IgroupInitiatorDeleteCollectionReader is a Reader for the IgroupInitiatorDeleteCollection structure.
type IgroupInitiatorDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IgroupInitiatorDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIgroupInitiatorDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIgroupInitiatorDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIgroupInitiatorDeleteCollectionOK creates a IgroupInitiatorDeleteCollectionOK with default headers values
func NewIgroupInitiatorDeleteCollectionOK() *IgroupInitiatorDeleteCollectionOK {
	return &IgroupInitiatorDeleteCollectionOK{}
}

/*
IgroupInitiatorDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type IgroupInitiatorDeleteCollectionOK struct {
}

// IsSuccess returns true when this igroup initiator delete collection o k response has a 2xx status code
func (o *IgroupInitiatorDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this igroup initiator delete collection o k response has a 3xx status code
func (o *IgroupInitiatorDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this igroup initiator delete collection o k response has a 4xx status code
func (o *IgroupInitiatorDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this igroup initiator delete collection o k response has a 5xx status code
func (o *IgroupInitiatorDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this igroup initiator delete collection o k response a status code equal to that given
func (o *IgroupInitiatorDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the igroup initiator delete collection o k response
func (o *IgroupInitiatorDeleteCollectionOK) Code() int {
	return 200
}

func (o *IgroupInitiatorDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/san/igroups/{igroup.uuid}/initiators][%d] igroupInitiatorDeleteCollectionOK", 200)
}

func (o *IgroupInitiatorDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/san/igroups/{igroup.uuid}/initiators][%d] igroupInitiatorDeleteCollectionOK", 200)
}

func (o *IgroupInitiatorDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewIgroupInitiatorDeleteCollectionDefault creates a IgroupInitiatorDeleteCollectionDefault with default headers values
func NewIgroupInitiatorDeleteCollectionDefault(code int) *IgroupInitiatorDeleteCollectionDefault {
	return &IgroupInitiatorDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	IgroupInitiatorDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1254213 | The initiator group is mapped to one or more LUNs and `allow_delete_while_mapped` has not been specified. |
| 5374034 | An initiator is not a member of the initiator group. |
| 5374041 | The initiator is not owned by the supplied initiator group. |
| 5374762 | An error was reported by the peer cluster while removing an initiator from a replicated initiator group. The specific error will be included as a nested error. |
| 5374852 | The initiator group specified in the URI does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IgroupInitiatorDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this igroup initiator delete collection default response has a 2xx status code
func (o *IgroupInitiatorDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this igroup initiator delete collection default response has a 3xx status code
func (o *IgroupInitiatorDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this igroup initiator delete collection default response has a 4xx status code
func (o *IgroupInitiatorDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this igroup initiator delete collection default response has a 5xx status code
func (o *IgroupInitiatorDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this igroup initiator delete collection default response a status code equal to that given
func (o *IgroupInitiatorDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the igroup initiator delete collection default response
func (o *IgroupInitiatorDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *IgroupInitiatorDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/san/igroups/{igroup.uuid}/initiators][%d] igroup_initiator_delete_collection default %s", o._statusCode, payload)
}

func (o *IgroupInitiatorDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/san/igroups/{igroup.uuid}/initiators][%d] igroup_initiator_delete_collection default %s", o._statusCode, payload)
}

func (o *IgroupInitiatorDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IgroupInitiatorDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
IgroupInitiatorDeleteCollectionBody igroup initiator delete collection body
swagger:model IgroupInitiatorDeleteCollectionBody
*/
type IgroupInitiatorDeleteCollectionBody struct {

	// igroup initiator response inline records
	IgroupInitiatorResponseInlineRecords []*models.IgroupInitiator `json:"records,omitempty"`
}

// Validate validates this igroup initiator delete collection body
func (o *IgroupInitiatorDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIgroupInitiatorResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorDeleteCollectionBody) validateIgroupInitiatorResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.IgroupInitiatorResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.IgroupInitiatorResponseInlineRecords); i++ {
		if swag.IsZero(o.IgroupInitiatorResponseInlineRecords[i]) { // not required
			continue
		}

		if o.IgroupInitiatorResponseInlineRecords[i] != nil {
			if err := o.IgroupInitiatorResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this igroup initiator delete collection body based on the context it is used
func (o *IgroupInitiatorDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIgroupInitiatorResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorDeleteCollectionBody) contextValidateIgroupInitiatorResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.IgroupInitiatorResponseInlineRecords); i++ {

		if o.IgroupInitiatorResponseInlineRecords[i] != nil {
			if err := o.IgroupInitiatorResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
