// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IgroupInitiatorDeleteReader is a Reader for the IgroupInitiatorDelete structure.
type IgroupInitiatorDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IgroupInitiatorDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIgroupInitiatorDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIgroupInitiatorDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIgroupInitiatorDeleteOK creates a IgroupInitiatorDeleteOK with default headers values
func NewIgroupInitiatorDeleteOK() *IgroupInitiatorDeleteOK {
	return &IgroupInitiatorDeleteOK{}
}

/*
IgroupInitiatorDeleteOK describes a response with status code 200, with default header values.

OK
*/
type IgroupInitiatorDeleteOK struct {
}

// IsSuccess returns true when this igroup initiator delete o k response has a 2xx status code
func (o *IgroupInitiatorDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this igroup initiator delete o k response has a 3xx status code
func (o *IgroupInitiatorDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this igroup initiator delete o k response has a 4xx status code
func (o *IgroupInitiatorDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this igroup initiator delete o k response has a 5xx status code
func (o *IgroupInitiatorDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this igroup initiator delete o k response a status code equal to that given
func (o *IgroupInitiatorDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the igroup initiator delete o k response
func (o *IgroupInitiatorDeleteOK) Code() int {
	return 200
}

func (o *IgroupInitiatorDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/san/igroups/{igroup.uuid}/initiators/{name}][%d] igroupInitiatorDeleteOK", 200)
}

func (o *IgroupInitiatorDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/san/igroups/{igroup.uuid}/initiators/{name}][%d] igroupInitiatorDeleteOK", 200)
}

func (o *IgroupInitiatorDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewIgroupInitiatorDeleteDefault creates a IgroupInitiatorDeleteDefault with default headers values
func NewIgroupInitiatorDeleteDefault(code int) *IgroupInitiatorDeleteDefault {
	return &IgroupInitiatorDeleteDefault{
		_statusCode: code,
	}
}

/*
	IgroupInitiatorDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1254213 | The initiator group is mapped to one or more LUNs and `allow_delete_while_mapped` has not been specified. |
| 5374034 | An initiator is not a member of the initiator group. |
| 5374041 | The initiator is not owned by the supplied initiator group. |
| 5374762 | An error was reported by the peer cluster while removing an initiator from a replicated initiator group. The specific error will be included as a nested error. |
| 5374852 | The initiator group specified in the URI does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IgroupInitiatorDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this igroup initiator delete default response has a 2xx status code
func (o *IgroupInitiatorDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this igroup initiator delete default response has a 3xx status code
func (o *IgroupInitiatorDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this igroup initiator delete default response has a 4xx status code
func (o *IgroupInitiatorDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this igroup initiator delete default response has a 5xx status code
func (o *IgroupInitiatorDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this igroup initiator delete default response a status code equal to that given
func (o *IgroupInitiatorDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the igroup initiator delete default response
func (o *IgroupInitiatorDeleteDefault) Code() int {
	return o._statusCode
}

func (o *IgroupInitiatorDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/san/igroups/{igroup.uuid}/initiators/{name}][%d] igroup_initiator_delete default %s", o._statusCode, payload)
}

func (o *IgroupInitiatorDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/san/igroups/{igroup.uuid}/initiators/{name}][%d] igroup_initiator_delete default %s", o._statusCode, payload)
}

func (o *IgroupInitiatorDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IgroupInitiatorDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
