// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IgroupInitiatorGetReader is a Reader for the IgroupInitiatorGet structure.
type IgroupInitiatorGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IgroupInitiatorGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIgroupInitiatorGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIgroupInitiatorGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIgroupInitiatorGetOK creates a IgroupInitiatorGetOK with default headers values
func NewIgroupInitiatorGetOK() *IgroupInitiatorGetOK {
	return &IgroupInitiatorGetOK{}
}

/*
IgroupInitiatorGetOK describes a response with status code 200, with default header values.

OK
*/
type IgroupInitiatorGetOK struct {
	Payload *models.IgroupInitiator
}

// IsSuccess returns true when this igroup initiator get o k response has a 2xx status code
func (o *IgroupInitiatorGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this igroup initiator get o k response has a 3xx status code
func (o *IgroupInitiatorGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this igroup initiator get o k response has a 4xx status code
func (o *IgroupInitiatorGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this igroup initiator get o k response has a 5xx status code
func (o *IgroupInitiatorGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this igroup initiator get o k response a status code equal to that given
func (o *IgroupInitiatorGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the igroup initiator get o k response
func (o *IgroupInitiatorGetOK) Code() int {
	return 200
}

func (o *IgroupInitiatorGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/igroups/{igroup.uuid}/initiators/{name}][%d] igroupInitiatorGetOK %s", 200, payload)
}

func (o *IgroupInitiatorGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/igroups/{igroup.uuid}/initiators/{name}][%d] igroupInitiatorGetOK %s", 200, payload)
}

func (o *IgroupInitiatorGetOK) GetPayload() *models.IgroupInitiator {
	return o.Payload
}

func (o *IgroupInitiatorGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.IgroupInitiator)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewIgroupInitiatorGetDefault creates a IgroupInitiatorGetDefault with default headers values
func NewIgroupInitiatorGetDefault(code int) *IgroupInitiatorGetDefault {
	return &IgroupInitiatorGetDefault{
		_statusCode: code,
	}
}

/*
	IgroupInitiatorGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 4 | The initiator is not a member of the initiator group. |
| 5374852 | The initiator group specified in the URI does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IgroupInitiatorGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this igroup initiator get default response has a 2xx status code
func (o *IgroupInitiatorGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this igroup initiator get default response has a 3xx status code
func (o *IgroupInitiatorGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this igroup initiator get default response has a 4xx status code
func (o *IgroupInitiatorGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this igroup initiator get default response has a 5xx status code
func (o *IgroupInitiatorGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this igroup initiator get default response a status code equal to that given
func (o *IgroupInitiatorGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the igroup initiator get default response
func (o *IgroupInitiatorGetDefault) Code() int {
	return o._statusCode
}

func (o *IgroupInitiatorGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/igroups/{igroup.uuid}/initiators/{name}][%d] igroup_initiator_get default %s", o._statusCode, payload)
}

func (o *IgroupInitiatorGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/igroups/{igroup.uuid}/initiators/{name}][%d] igroup_initiator_get default %s", o._statusCode, payload)
}

func (o *IgroupInitiatorGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IgroupInitiatorGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
