// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IgroupInitiatorModifyCollectionReader is a Reader for the IgroupInitiatorModifyCollection structure.
type IgroupInitiatorModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IgroupInitiatorModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIgroupInitiatorModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIgroupInitiatorModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIgroupInitiatorModifyCollectionOK creates a IgroupInitiatorModifyCollectionOK with default headers values
func NewIgroupInitiatorModifyCollectionOK() *IgroupInitiatorModifyCollectionOK {
	return &IgroupInitiatorModifyCollectionOK{}
}

/*
IgroupInitiatorModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type IgroupInitiatorModifyCollectionOK struct {
}

// IsSuccess returns true when this igroup initiator modify collection o k response has a 2xx status code
func (o *IgroupInitiatorModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this igroup initiator modify collection o k response has a 3xx status code
func (o *IgroupInitiatorModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this igroup initiator modify collection o k response has a 4xx status code
func (o *IgroupInitiatorModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this igroup initiator modify collection o k response has a 5xx status code
func (o *IgroupInitiatorModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this igroup initiator modify collection o k response a status code equal to that given
func (o *IgroupInitiatorModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the igroup initiator modify collection o k response
func (o *IgroupInitiatorModifyCollectionOK) Code() int {
	return 200
}

func (o *IgroupInitiatorModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/san/igroups/{igroup.uuid}/initiators][%d] igroupInitiatorModifyCollectionOK", 200)
}

func (o *IgroupInitiatorModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/san/igroups/{igroup.uuid}/initiators][%d] igroupInitiatorModifyCollectionOK", 200)
}

func (o *IgroupInitiatorModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewIgroupInitiatorModifyCollectionDefault creates a IgroupInitiatorModifyCollectionDefault with default headers values
func NewIgroupInitiatorModifyCollectionDefault(code int) *IgroupInitiatorModifyCollectionDefault {
	return &IgroupInitiatorModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	IgroupInitiatorModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5374034 | An initiator is not a member of the initiator group. |
| 5374744 | The cluster is currently running in a mixed version and the initiators cannot be modified until the effective cluster version reaches 9.9.1. |
| 5374852 | The initiator group does not exist. |
| 5374918 | A subset of the provided list of initiators were modified before a failure occurred. |
| 5375055 | The `local_svm` property of an initiator proximity was not specified. |
| 5375056 | An SVM peering relationship that does not have the initiator group's SVM as the local SVM was specified. |
| 5375261 | Setting initiator proximity is not supported for the SVM type. |
| 5376057 | Setting initiator proximity is not supported for the ONTAP version. |
| 5376059 | Setting initiator proximity to a peer that is either the destination of an SVM DR relationship or in a Metrocluster configuration is not supported. |
| 26345672 | The specified SVM peering relationship was not found. |
| 26345673 | An SVM peering relationship between the initiator group's SVM and specified peer SVM was not found. |
| 26345675 | An SVM peering relationship UUID and name were specified and they do not refer to the same SVM peering relationship. |
| 26345680 | Supplied SVM peer is on the local cluster. The operation requires a peer on a remote cluster. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IgroupInitiatorModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this igroup initiator modify collection default response has a 2xx status code
func (o *IgroupInitiatorModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this igroup initiator modify collection default response has a 3xx status code
func (o *IgroupInitiatorModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this igroup initiator modify collection default response has a 4xx status code
func (o *IgroupInitiatorModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this igroup initiator modify collection default response has a 5xx status code
func (o *IgroupInitiatorModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this igroup initiator modify collection default response a status code equal to that given
func (o *IgroupInitiatorModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the igroup initiator modify collection default response
func (o *IgroupInitiatorModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *IgroupInitiatorModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/san/igroups/{igroup.uuid}/initiators][%d] igroup_initiator_modify_collection default %s", o._statusCode, payload)
}

func (o *IgroupInitiatorModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/san/igroups/{igroup.uuid}/initiators][%d] igroup_initiator_modify_collection default %s", o._statusCode, payload)
}

func (o *IgroupInitiatorModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IgroupInitiatorModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
IgroupInitiatorModifyCollectionBody igroup initiator modify collection body
swagger:model IgroupInitiatorModifyCollectionBody
*/
type IgroupInitiatorModifyCollectionBody struct {

	// links
	Links *models.IgroupInitiatorInlineLinks `json:"_links,omitempty"`

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// connectivity tracking
	ConnectivityTracking *models.IgroupInitiatorInlineConnectivityTracking `json:"connectivity_tracking,omitempty"`

	// igroup
	Igroup *models.IgroupInitiatorInlineIgroup `json:"igroup,omitempty"`

	// An array of initiators specified to add multiple initiators to an initiator group in a single API call. Not allowed when the `name` property is used.
	//
	IgroupInitiatorInlineRecords []*models.IgroupInitiatorInlineRecordsInlineArrayItem `json:"records,omitempty"`

	// The FC WWPN, iSCSI IQN, or iSCSI EUI that identifies the host initiator. Valid in POST only and not allowed when the `records` property is used.<br/>
	// An FC WWPN consists of 16 hexadecimal digits grouped as 8 pairs separated by colons. The format for an iSCSI IQN is _iqn.yyyy-mm.reverse_domain_name:any_. The iSCSI EUI format consists of the _eui._ prefix followed by 16 hexadecimal characters.
	//
	// Example: iqn.1998-01.com.corp.iscsi:name1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// proximity
	Proximity *models.IgroupInitiatorInlineProximity `json:"proximity,omitempty"`
}

// Validate validates this igroup initiator modify collection body
func (o *IgroupInitiatorModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConnectivityTracking(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIgroupInitiatorInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProximity(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionBody) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionBody) validateConnectivityTracking(formats strfmt.Registry) error {
	if swag.IsZero(o.ConnectivityTracking) { // not required
		return nil
	}

	if o.ConnectivityTracking != nil {
		if err := o.ConnectivityTracking.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "connectivity_tracking")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionBody) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(o.Igroup) { // not required
		return nil
	}

	if o.Igroup != nil {
		if err := o.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "igroup")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionBody) validateIgroupInitiatorInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.IgroupInitiatorInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.IgroupInitiatorInlineRecords); i++ {
		if swag.IsZero(o.IgroupInitiatorInlineRecords[i]) { // not required
			continue
		}

		if o.IgroupInitiatorInlineRecords[i] != nil {
			if err := o.IgroupInitiatorInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionBody) validateProximity(formats strfmt.Registry) error {
	if swag.IsZero(o.Proximity) { // not required
		return nil
	}

	if o.Proximity != nil {
		if err := o.Proximity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "proximity")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator modify collection body based on the context it is used
func (o *IgroupInitiatorModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConnectivityTracking(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIgroupInitiatorInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProximity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionBody) contextValidateConnectivityTracking(ctx context.Context, formats strfmt.Registry) error {

	if o.ConnectivityTracking != nil {
		if err := o.ConnectivityTracking.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "connectivity_tracking")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionBody) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if o.Igroup != nil {
		if err := o.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "igroup")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionBody) contextValidateIgroupInitiatorInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.IgroupInitiatorInlineRecords); i++ {

		if o.IgroupInitiatorInlineRecords[i] != nil {
			if err := o.IgroupInitiatorInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionBody) contextValidateProximity(ctx context.Context, formats strfmt.Registry) error {

	if o.Proximity != nil {
		if err := o.Proximity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "proximity")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0 igroup initiator modify collection params body connectivity tracking alerts items0
swagger:model IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0
*/
type IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0 struct {

	// summary
	Summary *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary `json:"summary,omitempty"`
}

// Validate validates this igroup initiator modify collection params body connectivity tracking alerts items0
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSummary(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0) validateSummary(formats strfmt.Registry) error {
	if swag.IsZero(o.Summary) { // not required
		return nil
	}

	if o.Summary != nil {
		if err := o.Summary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("summary")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator modify collection params body connectivity tracking alerts items0 based on the context it is used
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSummary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0) contextValidateSummary(ctx context.Context, formats strfmt.Registry) error {

	if o.Summary != nil {
		if err := o.Summary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("summary")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary A user friendly message describing the connection state.
//
swagger:model IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary
*/
type IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary struct {

	// Message arguments
	// Read Only: true
	Arguments []*models.ErrorArguments `json:"arguments"`

	// Error code
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Error message
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this igroup initiator modify collection params body connectivity tracking alerts items0 summary
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(o.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(o.Arguments); i++ {
		if swag.IsZero(o.Arguments[i]) { // not required
			continue
		}

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("summary" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this igroup initiator modify collection params body connectivity tracking alerts items0 summary based on the context it is used
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "summary"+"."+"arguments", "body", []*models.ErrorArguments(o.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(o.Arguments); i++ {

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("summary" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "summary"+"."+"code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "summary"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0 igroup initiator modify collection params body connectivity tracking connections items0
swagger:model IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0
*/
type IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0 struct {

	// logins
	Logins []*IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0 `json:"logins"`

	// node
	Node *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0Node `json:"node,omitempty"`
}

// Validate validates this igroup initiator modify collection params body connectivity tracking connections items0
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLogins(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0) validateLogins(formats strfmt.Registry) error {
	if swag.IsZero(o.Logins) { // not required
		return nil
	}

	for i := 0; i < len(o.Logins); i++ {
		if swag.IsZero(o.Logins[i]) { // not required
			continue
		}

		if o.Logins[i] != nil {
			if err := o.Logins[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("logins" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator modify collection params body connectivity tracking connections items0 based on the context it is used
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLogins(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0) contextValidateLogins(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Logins); i++ {

		if o.Logins[i] != nil {
			if err := o.Logins[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("logins" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0 igroup initiator modify collection params body connectivity tracking connections items0 logins items0
swagger:model IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0
*/
type IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0 struct {

	// True if the initiator is currently logged in to this connection's interface.
	//
	// Read Only: true
	Connected *bool `json:"connected,omitempty"`

	// interface
	Interface *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0Interface `json:"interface,omitempty"`

	// The last time this initiator logged in. Logins not seen for 48 hours are cleared and not reported.
	//
	// Example: 2021-03-14 05:19:00+00:00
	// Read Only: true
	// Format: date-time
	LastSeenTime *strfmt.DateTime `json:"last_seen_time,omitempty"`
}

// Validate validates this igroup initiator modify collection params body connectivity tracking connections items0 logins items0
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateInterface(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLastSeenTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0) validateInterface(formats strfmt.Registry) error {
	if swag.IsZero(o.Interface) { // not required
		return nil
	}

	if o.Interface != nil {
		if err := o.Interface.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0) validateLastSeenTime(formats strfmt.Registry) error {
	if swag.IsZero(o.LastSeenTime) { // not required
		return nil
	}

	if err := validate.FormatOf("last_seen_time", "body", "date-time", o.LastSeenTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this igroup initiator modify collection params body connectivity tracking connections items0 logins items0 based on the context it is used
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateConnected(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInterface(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLastSeenTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0) contextValidateConnected(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connected", "body", o.Connected); err != nil {
		return err
	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0) contextValidateInterface(ctx context.Context, formats strfmt.Registry) error {

	if o.Interface != nil {
		if err := o.Interface.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0) contextValidateLastSeenTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "last_seen_time", "body", o.LastSeenTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0Interface igroup initiator modify collection params body connectivity tracking connections items0 logins items0 interface
swagger:model IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0Interface
*/
type IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0Interface struct {

	// fc
	Fc *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc `json:"fc,omitempty"`

	// ip
	IP *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP `json:"ip,omitempty"`
}

// Validate validates this igroup initiator modify collection params body connectivity tracking connections items0 logins items0 interface
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0Interface) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateFc(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0Interface) validateFc(formats strfmt.Registry) error {
	if swag.IsZero(o.Fc) { // not required
		return nil
	}

	if o.Fc != nil {
		if err := o.Fc.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "fc")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0Interface) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(o.IP) { // not required
		return nil
	}

	if o.IP != nil {
		if err := o.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator modify collection params body connectivity tracking connections items0 logins items0 interface based on the context it is used
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0Interface) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateFc(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0Interface) contextValidateFc(ctx context.Context, formats strfmt.Registry) error {

	if o.Fc != nil {
		if err := o.Fc.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "fc")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0Interface) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if o.IP != nil {
		if err := o.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0Interface) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0Interface) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0Interface
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc An FC interface.
//
swagger:model IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc
*/
type IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc struct {

	// links
	Links *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks `json:"_links,omitempty"`

	// The name of the FC interface.
	//
	// Example: fc_lif1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the FC interface.
	//
	// Example: 3a09ab42-4da1-32cf-9d35-3385a6101a0b
	UUID *string `json:"uuid,omitempty"`

	// The WWPN of the FC interface.
	//
	// Example: 20:00:00:50:56:b4:13:a8
	// Read Only: true
	Wwpn *string `json:"wwpn,omitempty"`
}

// Validate validates this igroup initiator modify collection params body connectivity tracking connections items0 logins items0 interface fc
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "fc" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator modify collection params body connectivity tracking connections items0 logins items0 interface fc based on the context it is used
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWwpn(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "fc" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc) contextValidateWwpn(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "interface"+"."+"fc"+"."+"wwpn", "body", o.Wwpn); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFc
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks igroup initiator modify collection params body connectivity tracking connections items0 logins items0 interface fc links
swagger:model IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks
*/
type IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this igroup initiator modify collection params body connectivity tracking connections items0 logins items0 interface fc links
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "fc" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator modify collection params body connectivity tracking connections items0 logins items0 interface fc links based on the context it is used
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "fc" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceFcLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP A network interface. Either UUID or name may be supplied on input.
swagger:model IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP
*/
type IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP struct {

	// links
	Links *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks `json:"_links,omitempty"`

	// ip
	IP *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP `json:"ip,omitempty"`

	// The name of the interface. If only the name is provided, the SVM scope
	// must be provided by the object this object is embedded in.
	//
	// Example: lif1
	Name *string `json:"name,omitempty"`

	// The UUID that uniquely identifies the interface.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup initiator modify collection params body connectivity tracking connections items0 logins items0 interface IP
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIP(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP) validateIP(formats strfmt.Registry) error {
	if swag.IsZero(o.IP) { // not required
		return nil
	}

	if o.IP != nil {
		if err := o.IP.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator modify collection params body connectivity tracking connections items0 logins items0 interface IP based on the context it is used
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIP(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP) contextValidateIP(ctx context.Context, formats strfmt.Registry) error {

	if o.IP != nil {
		if err := o.IP.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "ip")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP IP information
swagger:model IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP
*/
type IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP struct {

	// address
	Address *models.IPAddressReadonly `json:"address,omitempty"`
}

// Validate validates this igroup initiator modify collection params body connectivity tracking connections items0 logins items0 interface IP IP
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAddress(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP) validateAddress(formats strfmt.Registry) error {
	if swag.IsZero(o.Address) { // not required
		return nil
	}

	if o.Address != nil {
		if err := o.Address.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator modify collection params body connectivity tracking connections items0 logins items0 interface IP IP based on the context it is used
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAddress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP) contextValidateAddress(ctx context.Context, formats strfmt.Registry) error {

	if o.Address != nil {
		if err := o.Address.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "ip" + "." + "address")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPIP
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks igroup initiator modify collection params body connectivity tracking connections items0 logins items0 interface IP links
swagger:model IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks
*/
type IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this igroup initiator modify collection params body connectivity tracking connections items0 logins items0 interface IP links
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator modify collection params body connectivity tracking connections items0 logins items0 interface IP links based on the context it is used
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("interface" + "." + "ip" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0LoginsItems0InterfaceIPLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0Node igroup initiator modify collection params body connectivity tracking connections items0 node
swagger:model IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0Node
*/
type IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0Node struct {

	// links
	Links *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0NodeLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup initiator modify collection params body connectivity tracking connections items0 node
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0Node) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0Node) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator modify collection params body connectivity tracking connections items0 node based on the context it is used
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0Node) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0Node) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0Node) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0Node) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0Node
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0NodeLinks igroup initiator modify collection params body connectivity tracking connections items0 node links
swagger:model IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0NodeLinks
*/
type IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0NodeLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this igroup initiator modify collection params body connectivity tracking connections items0 node links
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0NodeLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0NodeLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator modify collection params body connectivity tracking connections items0 node links based on the context it is used
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0NodeLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0NodeLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0NodeLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0NodeLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0NodeLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0 A reference to an SVM peer relationship.
swagger:model IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0
*/
type IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0 struct {

	// links
	Links *IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0Links `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup initiator modify collection params body proximity peer svms items0
func (o *IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator modify collection params body proximity peer svms items0 based on the context it is used
func (o *IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0Links igroup initiator modify collection params body proximity peer svms items0 links
swagger:model IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0Links
*/
type IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this igroup initiator modify collection params body proximity peer svms items0 links
func (o *IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator modify collection params body proximity peer svms items0 links based on the context it is used
func (o *IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0Links) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0 A reference to an SVM peer relationship.
swagger:model IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0
*/
type IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0 struct {

	// links
	Links *IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0Links `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup initiator modify collection params body records items0 proximity peer svms items0
func (o *IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator modify collection params body records items0 proximity peer svms items0 based on the context it is used
func (o *IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0Links igroup initiator modify collection params body records items0 proximity peer svms items0 links
swagger:model IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0Links
*/
type IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this igroup initiator modify collection params body records items0 proximity peer svms items0 links
func (o *IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator modify collection params body records items0 proximity peer svms items0 links based on the context it is used
func (o *IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0Links) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorInlineLinks igroup initiator inline links
swagger:model igroup_initiator_inline__links
*/
type IgroupInitiatorInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this igroup initiator inline links
func (o *IgroupInitiatorInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator inline links based on the context it is used
func (o *IgroupInitiatorInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorInlineConnectivityTracking Overview of the initiator's connections to ONTAP.
//
swagger:model igroup_initiator_inline_connectivity_tracking
*/
type IgroupInitiatorInlineConnectivityTracking struct {

	// alerts
	// Read Only: true
	Alerts []*IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0 `json:"alerts,omitempty"`

	// Connection state.
	//
	// Read Only: true
	// Enum: ["full","none","partial","no_lun_maps"]
	ConnectionState *string `json:"connection_state,omitempty"`

	// connections
	Connections []*IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingConnectionsItems0 `json:"connections,omitempty"`
}

// Validate validates this igroup initiator inline connectivity tracking
func (o *IgroupInitiatorInlineConnectivityTracking) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAlerts(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConnectionState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConnections(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorInlineConnectivityTracking) validateAlerts(formats strfmt.Registry) error {
	if swag.IsZero(o.Alerts) { // not required
		return nil
	}

	for i := 0; i < len(o.Alerts); i++ {
		if swag.IsZero(o.Alerts[i]) { // not required
			continue
		}

		if o.Alerts[i] != nil {
			if err := o.Alerts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "connectivity_tracking" + "." + "alerts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var igroupInitiatorInlineConnectivityTrackingTypeConnectionStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["full","none","partial","no_lun_maps"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		igroupInitiatorInlineConnectivityTrackingTypeConnectionStatePropEnum = append(igroupInitiatorInlineConnectivityTrackingTypeConnectionStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// igroup_initiator_inline_connectivity_tracking
	// IgroupInitiatorInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// full
	// END DEBUGGING
	// IgroupInitiatorInlineConnectivityTrackingConnectionStateFull captures enum value "full"
	IgroupInitiatorInlineConnectivityTrackingConnectionStateFull string = "full"

	// BEGIN DEBUGGING
	// igroup_initiator_inline_connectivity_tracking
	// IgroupInitiatorInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// none
	// END DEBUGGING
	// IgroupInitiatorInlineConnectivityTrackingConnectionStateNone captures enum value "none"
	IgroupInitiatorInlineConnectivityTrackingConnectionStateNone string = "none"

	// BEGIN DEBUGGING
	// igroup_initiator_inline_connectivity_tracking
	// IgroupInitiatorInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// partial
	// END DEBUGGING
	// IgroupInitiatorInlineConnectivityTrackingConnectionStatePartial captures enum value "partial"
	IgroupInitiatorInlineConnectivityTrackingConnectionStatePartial string = "partial"

	// BEGIN DEBUGGING
	// igroup_initiator_inline_connectivity_tracking
	// IgroupInitiatorInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// no_lun_maps
	// END DEBUGGING
	// IgroupInitiatorInlineConnectivityTrackingConnectionStateNoLunMaps captures enum value "no_lun_maps"
	IgroupInitiatorInlineConnectivityTrackingConnectionStateNoLunMaps string = "no_lun_maps"
)

// prop value enum
func (o *IgroupInitiatorInlineConnectivityTracking) validateConnectionStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, igroupInitiatorInlineConnectivityTrackingTypeConnectionStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *IgroupInitiatorInlineConnectivityTracking) validateConnectionState(formats strfmt.Registry) error {
	if swag.IsZero(o.ConnectionState) { // not required
		return nil
	}

	// value enum
	if err := o.validateConnectionStateEnum("info"+"."+"connectivity_tracking"+"."+"connection_state", "body", *o.ConnectionState); err != nil {
		return err
	}

	return nil
}

func (o *IgroupInitiatorInlineConnectivityTracking) validateConnections(formats strfmt.Registry) error {
	if swag.IsZero(o.Connections) { // not required
		return nil
	}

	for i := 0; i < len(o.Connections); i++ {
		if swag.IsZero(o.Connections[i]) { // not required
			continue
		}

		if o.Connections[i] != nil {
			if err := o.Connections[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "connectivity_tracking" + "." + "connections" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this igroup initiator inline connectivity tracking based on the context it is used
func (o *IgroupInitiatorInlineConnectivityTracking) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAlerts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConnectionState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConnections(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorInlineConnectivityTracking) contextValidateAlerts(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"connectivity_tracking"+"."+"alerts", "body", []*IgroupInitiatorModifyCollectionParamsBodyConnectivityTrackingAlertsItems0(o.Alerts)); err != nil {
		return err
	}

	for i := 0; i < len(o.Alerts); i++ {

		if o.Alerts[i] != nil {
			if err := o.Alerts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "connectivity_tracking" + "." + "alerts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupInitiatorInlineConnectivityTracking) contextValidateConnectionState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"connectivity_tracking"+"."+"connection_state", "body", o.ConnectionState); err != nil {
		return err
	}

	return nil
}

func (o *IgroupInitiatorInlineConnectivityTracking) contextValidateConnections(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Connections); i++ {

		if o.Connections[i] != nil {
			if err := o.Connections[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "connectivity_tracking" + "." + "connections" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorInlineConnectivityTracking) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorInlineConnectivityTracking) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorInlineConnectivityTracking
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorInlineIgroup The initiator group in which the initiator is found.<br/>
// Note that this does not mean that the initiator cannot also be found in other initiator groups.
//
swagger:model igroup_initiator_inline_igroup
*/
type IgroupInitiatorInlineIgroup struct {

	// links
	Links *models.IgroupInitiatorInlineIgroupInlineLinks `json:"_links,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup initiator inline igroup
func (o *IgroupInitiatorInlineIgroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorInlineIgroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "igroup" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInitiatorInlineIgroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"igroup"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"igroup"+"."+"name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this igroup initiator inline igroup based on the context it is used
func (o *IgroupInitiatorInlineIgroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorInlineIgroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "igroup" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorInlineIgroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorInlineIgroup) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorInlineIgroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorInlineIgroupInlineLinks igroup initiator inline igroup inline links
swagger:model igroup_initiator_inline_igroup_inline__links
*/
type IgroupInitiatorInlineIgroupInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this igroup initiator inline igroup inline links
func (o *IgroupInitiatorInlineIgroupInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorInlineIgroupInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "igroup" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator inline igroup inline links based on the context it is used
func (o *IgroupInitiatorInlineIgroupInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorInlineIgroupInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "igroup" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorInlineIgroupInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorInlineIgroupInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorInlineIgroupInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorInlineProximity Properties that define to what SVMs the initiator is proximal. This information is used to properly report active optimized and active non-optimized network paths via ALUA. If no configuration has been specified for an initiator, the sub-object will not be present in GET.<br/>
// These properties can be set via initiator group POST and PATCH and apply to all instances of the initiator in all initiator groups in the SVM and its peers. The `proximity` sub-object for an initiator is set in POST and PATCH in its entirety and replaces any previously set proximity for the initiator within the SVM for the initiator within the SVM. The `local_svm` property must always be set to `true` or `false` when setting the `proximity` property. To clear any previously set proximity, POST or PATCH the `proximity` object to `null`.
//
swagger:model igroup_initiator_inline_proximity
*/
type IgroupInitiatorInlineProximity struct {

	// A boolean that indicates if the initiator is proximal to the SVM of the containing initiator group. This is required for any POST or PATCH that includes the `proximity` sub-object.
	//
	LocalSvm *bool `json:"local_svm,omitempty"`

	// An array of remote peer SVMs to which the initiator is proximal.
	//
	PeerSvms []*IgroupInitiatorModifyCollectionParamsBodyProximityPeerSvmsItems0 `json:"peer_svms,omitempty"`
}

// Validate validates this igroup initiator inline proximity
func (o *IgroupInitiatorInlineProximity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePeerSvms(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorInlineProximity) validatePeerSvms(formats strfmt.Registry) error {
	if swag.IsZero(o.PeerSvms) { // not required
		return nil
	}

	for i := 0; i < len(o.PeerSvms); i++ {
		if swag.IsZero(o.PeerSvms[i]) { // not required
			continue
		}

		if o.PeerSvms[i] != nil {
			if err := o.PeerSvms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this igroup initiator inline proximity based on the context it is used
func (o *IgroupInitiatorInlineProximity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePeerSvms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorInlineProximity) contextValidatePeerSvms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.PeerSvms); i++ {

		if o.PeerSvms[i] != nil {
			if err := o.PeerSvms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorInlineProximity) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorInlineProximity) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorInlineProximity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorInlineRecordsInlineArrayItem igroup initiator inline records inline array item
swagger:model igroup_initiator_inline_records_inline_array_item
*/
type IgroupInitiatorInlineRecordsInlineArrayItem struct {

	// links
	Links *models.IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// The FC WWPN, iSCSI IQN, or iSCSI EUI that identifies the host initiator. Valid in POST only and not allowed when the `records` property is used.<br/>
	// An FC WWPN consists of 16 hexadecimal digits grouped as 8 pairs separated by colons. The format for an iSCSI IQN is _iqn.yyyy-mm.reverse_domain_name:any_. The iSCSI EUI format consists of the _eui._ prefix followed by 16 hexadecimal characters.
	//
	// Example: iqn.1998-01.com.corp.iscsi:name1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// proximity
	Proximity *models.IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity `json:"proximity,omitempty"`
}

// Validate validates this igroup initiator inline records inline array item
func (o *IgroupInitiatorInlineRecordsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProximity(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorInlineRecordsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInitiatorInlineRecordsInlineArrayItem) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *IgroupInitiatorInlineRecordsInlineArrayItem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

func (o *IgroupInitiatorInlineRecordsInlineArrayItem) validateProximity(formats strfmt.Registry) error {
	if swag.IsZero(o.Proximity) { // not required
		return nil
	}

	if o.Proximity != nil {
		if err := o.Proximity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator inline records inline array item based on the context it is used
func (o *IgroupInitiatorInlineRecordsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProximity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorInlineRecordsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInitiatorInlineRecordsInlineArrayItem) contextValidateProximity(ctx context.Context, formats strfmt.Registry) error {

	if o.Proximity != nil {
		if err := o.Proximity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorInlineRecordsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorInlineRecordsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorInlineRecordsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks igroup initiator inline records inline array item inline links
swagger:model igroup_initiator_inline_records_inline_array_item_inline__links
*/
type IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this igroup initiator inline records inline array item inline links
func (o *IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup initiator inline records inline array item inline links based on the context it is used
func (o *IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorInlineRecordsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity Properties that define to what SVMs the initiator is proximal. This information is used to properly report active optimized and active non-optimized network paths via ALUA. If no configuration has been specified for an initiator, the sub-object will not be present in GET.<br/>
// These properties can be set via initiator group POST and PATCH and apply to all instances of the initiator in all initiator groups in the SVM and its peers. The `proximity` sub-object for an initiator is set in POST and PATCH in its entirety and replaces any previously set proximity for the initiator within the SVM for the initiator within the SVM. The `local_svm` property must always be set to `true` or `false` when setting the `proximity` property. To clear any previously set proximity, POST or PATCH the `proximity` object to `null`.
//
swagger:model igroup_initiator_inline_records_inline_array_item_inline_proximity
*/
type IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity struct {

	// A boolean that indicates if the initiator is proximal to the SVM of the containing initiator group. This is required for any POST or PATCH that includes the `proximity` sub-object.
	//
	LocalSvm *bool `json:"local_svm,omitempty"`

	// An array of remote peer SVMs to which the initiator is proximal.
	//
	PeerSvms []*IgroupInitiatorModifyCollectionParamsBodyRecordsItems0ProximityPeerSvmsItems0 `json:"peer_svms"`
}

// Validate validates this igroup initiator inline records inline array item inline proximity
func (o *IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePeerSvms(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity) validatePeerSvms(formats strfmt.Registry) error {
	if swag.IsZero(o.PeerSvms) { // not required
		return nil
	}

	for i := 0; i < len(o.PeerSvms); i++ {
		if swag.IsZero(o.PeerSvms[i]) { // not required
			continue
		}

		if o.PeerSvms[i] != nil {
			if err := o.PeerSvms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this igroup initiator inline records inline array item inline proximity based on the context it is used
func (o *IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePeerSvms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity) contextValidatePeerSvms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.PeerSvms); i++ {

		if o.PeerSvms[i] != nil {
			if err := o.PeerSvms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity) UnmarshalBinary(b []byte) error {
	var res IgroupInitiatorInlineRecordsInlineArrayItemInlineProximity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
