// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewIgroupModifyCollectionParams creates a new IgroupModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIgroupModifyCollectionParams() *IgroupModifyCollectionParams {
	return &IgroupModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIgroupModifyCollectionParamsWithTimeout creates a new IgroupModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewIgroupModifyCollectionParamsWithTimeout(timeout time.Duration) *IgroupModifyCollectionParams {
	return &IgroupModifyCollectionParams{
		timeout: timeout,
	}
}

// NewIgroupModifyCollectionParamsWithContext creates a new IgroupModifyCollectionParams object
// with the ability to set a context for a request.
func NewIgroupModifyCollectionParamsWithContext(ctx context.Context) *IgroupModifyCollectionParams {
	return &IgroupModifyCollectionParams{
		Context: ctx,
	}
}

// NewIgroupModifyCollectionParamsWithHTTPClient creates a new IgroupModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewIgroupModifyCollectionParamsWithHTTPClient(client *http.Client) *IgroupModifyCollectionParams {
	return &IgroupModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
IgroupModifyCollectionParams contains all the parameters to send to the API endpoint

	for the igroup modify collection operation.

	Typically these are written to a http.Request.
*/
type IgroupModifyCollectionParams struct {

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ConnectivityTrackingAlertsSummaryArgumentsCode.

	   Filter by connectivity_tracking.alerts.summary.arguments.code
	*/
	ConnectivityTrackingAlertsSummaryArgumentsCode *string

	/* ConnectivityTrackingAlertsSummaryArgumentsMessage.

	   Filter by connectivity_tracking.alerts.summary.arguments.message
	*/
	ConnectivityTrackingAlertsSummaryArgumentsMessage *string

	/* ConnectivityTrackingAlertsSummaryCode.

	   Filter by connectivity_tracking.alerts.summary.code
	*/
	ConnectivityTrackingAlertsSummaryCode *string

	/* ConnectivityTrackingAlertsSummaryMessage.

	   Filter by connectivity_tracking.alerts.summary.message
	*/
	ConnectivityTrackingAlertsSummaryMessage *string

	/* ConnectivityTrackingConnectionState.

	   Filter by connectivity_tracking.connection_state
	*/
	ConnectivityTrackingConnectionState *string

	/* ConnectivityTrackingRequiredNodesName.

	   Filter by connectivity_tracking.required_nodes.name
	*/
	ConnectivityTrackingRequiredNodesName *string

	/* ConnectivityTrackingRequiredNodesUUID.

	   Filter by connectivity_tracking.required_nodes.uuid
	*/
	ConnectivityTrackingRequiredNodesUUID *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* DeleteOnUnmap.

	   Filter by delete_on_unmap
	*/
	DeleteOnUnmap *bool

	/* IgroupsComment.

	   Filter by igroups.comment
	*/
	IgroupsComment *string

	/* IgroupsName.

	   Filter by igroups.name
	*/
	IgroupsName *string

	/* IgroupsUUID.

	   Filter by igroups.uuid
	*/
	IgroupsUUID *string

	/* Info.

	   Info specification
	*/
	Info IgroupModifyCollectionBody

	/* InitiatorsComment.

	   Filter by initiators.comment
	*/
	InitiatorsComment *string

	/* InitiatorsConnectivityTrackingConnectionState.

	   Filter by initiators.connectivity_tracking.connection_state
	*/
	InitiatorsConnectivityTrackingConnectionState *string

	/* InitiatorsIgroupName.

	   Filter by initiators.igroup.name
	*/
	InitiatorsIgroupName *string

	/* InitiatorsIgroupUUID.

	   Filter by initiators.igroup.uuid
	*/
	InitiatorsIgroupUUID *string

	/* InitiatorsName.

	   Filter by initiators.name
	*/
	InitiatorsName *string

	/* InitiatorsProximityLocalSvm.

	   Filter by initiators.proximity.local_svm
	*/
	InitiatorsProximityLocalSvm *bool

	/* InitiatorsProximityPeerSvmsName.

	   Filter by initiators.proximity.peer_svms.name
	*/
	InitiatorsProximityPeerSvmsName *string

	/* InitiatorsProximityPeerSvmsUUID.

	   Filter by initiators.proximity.peer_svms.uuid
	*/
	InitiatorsProximityPeerSvmsUUID *string

	/* LunMapsLogicalUnitNumber.

	   Filter by lun_maps.logical_unit_number
	*/
	LunMapsLogicalUnitNumber *int64

	/* LunMapsLunName.

	   Filter by lun_maps.lun.name
	*/
	LunMapsLunName *string

	/* LunMapsLunNodeName.

	   Filter by lun_maps.lun.node.name
	*/
	LunMapsLunNodeName *string

	/* LunMapsLunNodeUUID.

	   Filter by lun_maps.lun.node.uuid
	*/
	LunMapsLunNodeUUID *string

	/* LunMapsLunUUID.

	   Filter by lun_maps.lun.uuid
	*/
	LunMapsLunUUID *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OsType.

	   Filter by os_type
	*/
	OsType *string

	/* ParentIgroupsComment.

	   Filter by parent_igroups.comment
	*/
	ParentIgroupsComment *string

	/* ParentIgroupsName.

	   Filter by parent_igroups.name
	*/
	ParentIgroupsName *string

	/* ParentIgroupsUUID.

	   Filter by parent_igroups.uuid
	*/
	ParentIgroupsUUID *string

	/* PortsetName.

	   Filter by portset.name
	*/
	PortsetName *string

	/* PortsetUUID.

	   Filter by portset.uuid
	*/
	PortsetUUID *string

	/* Protocol.

	   Filter by protocol
	*/
	Protocol *string

	/* ReplicationErrorIgroupLocalSvm.

	   Filter by replication.error.igroup.local_svm
	*/
	ReplicationErrorIgroupLocalSvm *bool

	/* ReplicationErrorIgroupName.

	   Filter by replication.error.igroup.name
	*/
	ReplicationErrorIgroupName *string

	/* ReplicationErrorIgroupUUID.

	   Filter by replication.error.igroup.uuid
	*/
	ReplicationErrorIgroupUUID *string

	/* ReplicationErrorSummaryArgumentsCode.

	   Filter by replication.error.summary.arguments.code
	*/
	ReplicationErrorSummaryArgumentsCode *string

	/* ReplicationErrorSummaryArgumentsMessage.

	   Filter by replication.error.summary.arguments.message
	*/
	ReplicationErrorSummaryArgumentsMessage *string

	/* ReplicationErrorSummaryCode.

	   Filter by replication.error.summary.code
	*/
	ReplicationErrorSummaryCode *string

	/* ReplicationErrorSummaryMessage.

	   Filter by replication.error.summary.message
	*/
	ReplicationErrorSummaryMessage *string

	/* ReplicationPeerSvmName.

	   Filter by replication.peer_svm.name
	*/
	ReplicationPeerSvmName *string

	/* ReplicationPeerSvmUUID.

	   Filter by replication.peer_svm.uuid
	*/
	ReplicationPeerSvmUUID *string

	/* ReplicationState.

	   Filter by replication.state
	*/
	ReplicationState *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SupportsIgroups.

	   Filter by supports_igroups
	*/
	SupportsIgroups *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TargetFirmwareRevision.

	   Filter by target.firmware_revision
	*/
	TargetFirmwareRevision *string

	/* TargetProductID.

	   Filter by target.product_id
	*/
	TargetProductID *string

	/* TargetVendorID.

	   Filter by target.vendor_id
	*/
	TargetVendorID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the igroup modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IgroupModifyCollectionParams) WithDefaults() *IgroupModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the igroup modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IgroupModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := IgroupModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithTimeout(timeout time.Duration) *IgroupModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithContext(ctx context.Context) *IgroupModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithHTTPClient(client *http.Client) *IgroupModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithComment(comment *string) *IgroupModifyCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithConnectivityTrackingAlertsSummaryArgumentsCode adds the connectivityTrackingAlertsSummaryArgumentsCode to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithConnectivityTrackingAlertsSummaryArgumentsCode(connectivityTrackingAlertsSummaryArgumentsCode *string) *IgroupModifyCollectionParams {
	o.SetConnectivityTrackingAlertsSummaryArgumentsCode(connectivityTrackingAlertsSummaryArgumentsCode)
	return o
}

// SetConnectivityTrackingAlertsSummaryArgumentsCode adds the connectivityTrackingAlertsSummaryArgumentsCode to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetConnectivityTrackingAlertsSummaryArgumentsCode(connectivityTrackingAlertsSummaryArgumentsCode *string) {
	o.ConnectivityTrackingAlertsSummaryArgumentsCode = connectivityTrackingAlertsSummaryArgumentsCode
}

// WithConnectivityTrackingAlertsSummaryArgumentsMessage adds the connectivityTrackingAlertsSummaryArgumentsMessage to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithConnectivityTrackingAlertsSummaryArgumentsMessage(connectivityTrackingAlertsSummaryArgumentsMessage *string) *IgroupModifyCollectionParams {
	o.SetConnectivityTrackingAlertsSummaryArgumentsMessage(connectivityTrackingAlertsSummaryArgumentsMessage)
	return o
}

// SetConnectivityTrackingAlertsSummaryArgumentsMessage adds the connectivityTrackingAlertsSummaryArgumentsMessage to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetConnectivityTrackingAlertsSummaryArgumentsMessage(connectivityTrackingAlertsSummaryArgumentsMessage *string) {
	o.ConnectivityTrackingAlertsSummaryArgumentsMessage = connectivityTrackingAlertsSummaryArgumentsMessage
}

// WithConnectivityTrackingAlertsSummaryCode adds the connectivityTrackingAlertsSummaryCode to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithConnectivityTrackingAlertsSummaryCode(connectivityTrackingAlertsSummaryCode *string) *IgroupModifyCollectionParams {
	o.SetConnectivityTrackingAlertsSummaryCode(connectivityTrackingAlertsSummaryCode)
	return o
}

// SetConnectivityTrackingAlertsSummaryCode adds the connectivityTrackingAlertsSummaryCode to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetConnectivityTrackingAlertsSummaryCode(connectivityTrackingAlertsSummaryCode *string) {
	o.ConnectivityTrackingAlertsSummaryCode = connectivityTrackingAlertsSummaryCode
}

// WithConnectivityTrackingAlertsSummaryMessage adds the connectivityTrackingAlertsSummaryMessage to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithConnectivityTrackingAlertsSummaryMessage(connectivityTrackingAlertsSummaryMessage *string) *IgroupModifyCollectionParams {
	o.SetConnectivityTrackingAlertsSummaryMessage(connectivityTrackingAlertsSummaryMessage)
	return o
}

// SetConnectivityTrackingAlertsSummaryMessage adds the connectivityTrackingAlertsSummaryMessage to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetConnectivityTrackingAlertsSummaryMessage(connectivityTrackingAlertsSummaryMessage *string) {
	o.ConnectivityTrackingAlertsSummaryMessage = connectivityTrackingAlertsSummaryMessage
}

// WithConnectivityTrackingConnectionState adds the connectivityTrackingConnectionState to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithConnectivityTrackingConnectionState(connectivityTrackingConnectionState *string) *IgroupModifyCollectionParams {
	o.SetConnectivityTrackingConnectionState(connectivityTrackingConnectionState)
	return o
}

// SetConnectivityTrackingConnectionState adds the connectivityTrackingConnectionState to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetConnectivityTrackingConnectionState(connectivityTrackingConnectionState *string) {
	o.ConnectivityTrackingConnectionState = connectivityTrackingConnectionState
}

// WithConnectivityTrackingRequiredNodesName adds the connectivityTrackingRequiredNodesName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithConnectivityTrackingRequiredNodesName(connectivityTrackingRequiredNodesName *string) *IgroupModifyCollectionParams {
	o.SetConnectivityTrackingRequiredNodesName(connectivityTrackingRequiredNodesName)
	return o
}

// SetConnectivityTrackingRequiredNodesName adds the connectivityTrackingRequiredNodesName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetConnectivityTrackingRequiredNodesName(connectivityTrackingRequiredNodesName *string) {
	o.ConnectivityTrackingRequiredNodesName = connectivityTrackingRequiredNodesName
}

// WithConnectivityTrackingRequiredNodesUUID adds the connectivityTrackingRequiredNodesUUID to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithConnectivityTrackingRequiredNodesUUID(connectivityTrackingRequiredNodesUUID *string) *IgroupModifyCollectionParams {
	o.SetConnectivityTrackingRequiredNodesUUID(connectivityTrackingRequiredNodesUUID)
	return o
}

// SetConnectivityTrackingRequiredNodesUUID adds the connectivityTrackingRequiredNodesUuid to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetConnectivityTrackingRequiredNodesUUID(connectivityTrackingRequiredNodesUUID *string) {
	o.ConnectivityTrackingRequiredNodesUUID = connectivityTrackingRequiredNodesUUID
}

// WithContinueOnFailure adds the continueOnFailure to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *IgroupModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDeleteOnUnmap adds the deleteOnUnmap to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithDeleteOnUnmap(deleteOnUnmap *bool) *IgroupModifyCollectionParams {
	o.SetDeleteOnUnmap(deleteOnUnmap)
	return o
}

// SetDeleteOnUnmap adds the deleteOnUnmap to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetDeleteOnUnmap(deleteOnUnmap *bool) {
	o.DeleteOnUnmap = deleteOnUnmap
}

// WithIgroupsComment adds the igroupsComment to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithIgroupsComment(igroupsComment *string) *IgroupModifyCollectionParams {
	o.SetIgroupsComment(igroupsComment)
	return o
}

// SetIgroupsComment adds the igroupsComment to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetIgroupsComment(igroupsComment *string) {
	o.IgroupsComment = igroupsComment
}

// WithIgroupsName adds the igroupsName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithIgroupsName(igroupsName *string) *IgroupModifyCollectionParams {
	o.SetIgroupsName(igroupsName)
	return o
}

// SetIgroupsName adds the igroupsName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetIgroupsName(igroupsName *string) {
	o.IgroupsName = igroupsName
}

// WithIgroupsUUID adds the igroupsUUID to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithIgroupsUUID(igroupsUUID *string) *IgroupModifyCollectionParams {
	o.SetIgroupsUUID(igroupsUUID)
	return o
}

// SetIgroupsUUID adds the igroupsUuid to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetIgroupsUUID(igroupsUUID *string) {
	o.IgroupsUUID = igroupsUUID
}

// WithInfo adds the info to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithInfo(info IgroupModifyCollectionBody) *IgroupModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetInfo(info IgroupModifyCollectionBody) {
	o.Info = info
}

// WithInitiatorsComment adds the initiatorsComment to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithInitiatorsComment(initiatorsComment *string) *IgroupModifyCollectionParams {
	o.SetInitiatorsComment(initiatorsComment)
	return o
}

// SetInitiatorsComment adds the initiatorsComment to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetInitiatorsComment(initiatorsComment *string) {
	o.InitiatorsComment = initiatorsComment
}

// WithInitiatorsConnectivityTrackingConnectionState adds the initiatorsConnectivityTrackingConnectionState to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithInitiatorsConnectivityTrackingConnectionState(initiatorsConnectivityTrackingConnectionState *string) *IgroupModifyCollectionParams {
	o.SetInitiatorsConnectivityTrackingConnectionState(initiatorsConnectivityTrackingConnectionState)
	return o
}

// SetInitiatorsConnectivityTrackingConnectionState adds the initiatorsConnectivityTrackingConnectionState to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetInitiatorsConnectivityTrackingConnectionState(initiatorsConnectivityTrackingConnectionState *string) {
	o.InitiatorsConnectivityTrackingConnectionState = initiatorsConnectivityTrackingConnectionState
}

// WithInitiatorsIgroupName adds the initiatorsIgroupName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithInitiatorsIgroupName(initiatorsIgroupName *string) *IgroupModifyCollectionParams {
	o.SetInitiatorsIgroupName(initiatorsIgroupName)
	return o
}

// SetInitiatorsIgroupName adds the initiatorsIgroupName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetInitiatorsIgroupName(initiatorsIgroupName *string) {
	o.InitiatorsIgroupName = initiatorsIgroupName
}

// WithInitiatorsIgroupUUID adds the initiatorsIgroupUUID to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithInitiatorsIgroupUUID(initiatorsIgroupUUID *string) *IgroupModifyCollectionParams {
	o.SetInitiatorsIgroupUUID(initiatorsIgroupUUID)
	return o
}

// SetInitiatorsIgroupUUID adds the initiatorsIgroupUuid to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetInitiatorsIgroupUUID(initiatorsIgroupUUID *string) {
	o.InitiatorsIgroupUUID = initiatorsIgroupUUID
}

// WithInitiatorsName adds the initiatorsName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithInitiatorsName(initiatorsName *string) *IgroupModifyCollectionParams {
	o.SetInitiatorsName(initiatorsName)
	return o
}

// SetInitiatorsName adds the initiatorsName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetInitiatorsName(initiatorsName *string) {
	o.InitiatorsName = initiatorsName
}

// WithInitiatorsProximityLocalSvm adds the initiatorsProximityLocalSvm to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithInitiatorsProximityLocalSvm(initiatorsProximityLocalSvm *bool) *IgroupModifyCollectionParams {
	o.SetInitiatorsProximityLocalSvm(initiatorsProximityLocalSvm)
	return o
}

// SetInitiatorsProximityLocalSvm adds the initiatorsProximityLocalSvm to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetInitiatorsProximityLocalSvm(initiatorsProximityLocalSvm *bool) {
	o.InitiatorsProximityLocalSvm = initiatorsProximityLocalSvm
}

// WithInitiatorsProximityPeerSvmsName adds the initiatorsProximityPeerSvmsName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithInitiatorsProximityPeerSvmsName(initiatorsProximityPeerSvmsName *string) *IgroupModifyCollectionParams {
	o.SetInitiatorsProximityPeerSvmsName(initiatorsProximityPeerSvmsName)
	return o
}

// SetInitiatorsProximityPeerSvmsName adds the initiatorsProximityPeerSvmsName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetInitiatorsProximityPeerSvmsName(initiatorsProximityPeerSvmsName *string) {
	o.InitiatorsProximityPeerSvmsName = initiatorsProximityPeerSvmsName
}

// WithInitiatorsProximityPeerSvmsUUID adds the initiatorsProximityPeerSvmsUUID to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithInitiatorsProximityPeerSvmsUUID(initiatorsProximityPeerSvmsUUID *string) *IgroupModifyCollectionParams {
	o.SetInitiatorsProximityPeerSvmsUUID(initiatorsProximityPeerSvmsUUID)
	return o
}

// SetInitiatorsProximityPeerSvmsUUID adds the initiatorsProximityPeerSvmsUuid to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetInitiatorsProximityPeerSvmsUUID(initiatorsProximityPeerSvmsUUID *string) {
	o.InitiatorsProximityPeerSvmsUUID = initiatorsProximityPeerSvmsUUID
}

// WithLunMapsLogicalUnitNumber adds the lunMapsLogicalUnitNumber to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithLunMapsLogicalUnitNumber(lunMapsLogicalUnitNumber *int64) *IgroupModifyCollectionParams {
	o.SetLunMapsLogicalUnitNumber(lunMapsLogicalUnitNumber)
	return o
}

// SetLunMapsLogicalUnitNumber adds the lunMapsLogicalUnitNumber to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetLunMapsLogicalUnitNumber(lunMapsLogicalUnitNumber *int64) {
	o.LunMapsLogicalUnitNumber = lunMapsLogicalUnitNumber
}

// WithLunMapsLunName adds the lunMapsLunName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithLunMapsLunName(lunMapsLunName *string) *IgroupModifyCollectionParams {
	o.SetLunMapsLunName(lunMapsLunName)
	return o
}

// SetLunMapsLunName adds the lunMapsLunName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetLunMapsLunName(lunMapsLunName *string) {
	o.LunMapsLunName = lunMapsLunName
}

// WithLunMapsLunNodeName adds the lunMapsLunNodeName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithLunMapsLunNodeName(lunMapsLunNodeName *string) *IgroupModifyCollectionParams {
	o.SetLunMapsLunNodeName(lunMapsLunNodeName)
	return o
}

// SetLunMapsLunNodeName adds the lunMapsLunNodeName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetLunMapsLunNodeName(lunMapsLunNodeName *string) {
	o.LunMapsLunNodeName = lunMapsLunNodeName
}

// WithLunMapsLunNodeUUID adds the lunMapsLunNodeUUID to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithLunMapsLunNodeUUID(lunMapsLunNodeUUID *string) *IgroupModifyCollectionParams {
	o.SetLunMapsLunNodeUUID(lunMapsLunNodeUUID)
	return o
}

// SetLunMapsLunNodeUUID adds the lunMapsLunNodeUuid to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetLunMapsLunNodeUUID(lunMapsLunNodeUUID *string) {
	o.LunMapsLunNodeUUID = lunMapsLunNodeUUID
}

// WithLunMapsLunUUID adds the lunMapsLunUUID to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithLunMapsLunUUID(lunMapsLunUUID *string) *IgroupModifyCollectionParams {
	o.SetLunMapsLunUUID(lunMapsLunUUID)
	return o
}

// SetLunMapsLunUUID adds the lunMapsLunUuid to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetLunMapsLunUUID(lunMapsLunUUID *string) {
	o.LunMapsLunUUID = lunMapsLunUUID
}

// WithName adds the name to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithName(name *string) *IgroupModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithOsType adds the osType to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithOsType(osType *string) *IgroupModifyCollectionParams {
	o.SetOsType(osType)
	return o
}

// SetOsType adds the osType to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetOsType(osType *string) {
	o.OsType = osType
}

// WithParentIgroupsComment adds the parentIgroupsComment to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithParentIgroupsComment(parentIgroupsComment *string) *IgroupModifyCollectionParams {
	o.SetParentIgroupsComment(parentIgroupsComment)
	return o
}

// SetParentIgroupsComment adds the parentIgroupsComment to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetParentIgroupsComment(parentIgroupsComment *string) {
	o.ParentIgroupsComment = parentIgroupsComment
}

// WithParentIgroupsName adds the parentIgroupsName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithParentIgroupsName(parentIgroupsName *string) *IgroupModifyCollectionParams {
	o.SetParentIgroupsName(parentIgroupsName)
	return o
}

// SetParentIgroupsName adds the parentIgroupsName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetParentIgroupsName(parentIgroupsName *string) {
	o.ParentIgroupsName = parentIgroupsName
}

// WithParentIgroupsUUID adds the parentIgroupsUUID to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithParentIgroupsUUID(parentIgroupsUUID *string) *IgroupModifyCollectionParams {
	o.SetParentIgroupsUUID(parentIgroupsUUID)
	return o
}

// SetParentIgroupsUUID adds the parentIgroupsUuid to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetParentIgroupsUUID(parentIgroupsUUID *string) {
	o.ParentIgroupsUUID = parentIgroupsUUID
}

// WithPortsetName adds the portsetName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithPortsetName(portsetName *string) *IgroupModifyCollectionParams {
	o.SetPortsetName(portsetName)
	return o
}

// SetPortsetName adds the portsetName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetPortsetName(portsetName *string) {
	o.PortsetName = portsetName
}

// WithPortsetUUID adds the portsetUUID to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithPortsetUUID(portsetUUID *string) *IgroupModifyCollectionParams {
	o.SetPortsetUUID(portsetUUID)
	return o
}

// SetPortsetUUID adds the portsetUuid to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetPortsetUUID(portsetUUID *string) {
	o.PortsetUUID = portsetUUID
}

// WithProtocol adds the protocol to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithProtocol(protocol *string) *IgroupModifyCollectionParams {
	o.SetProtocol(protocol)
	return o
}

// SetProtocol adds the protocol to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetProtocol(protocol *string) {
	o.Protocol = protocol
}

// WithReplicationErrorIgroupLocalSvm adds the replicationErrorIgroupLocalSvm to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithReplicationErrorIgroupLocalSvm(replicationErrorIgroupLocalSvm *bool) *IgroupModifyCollectionParams {
	o.SetReplicationErrorIgroupLocalSvm(replicationErrorIgroupLocalSvm)
	return o
}

// SetReplicationErrorIgroupLocalSvm adds the replicationErrorIgroupLocalSvm to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetReplicationErrorIgroupLocalSvm(replicationErrorIgroupLocalSvm *bool) {
	o.ReplicationErrorIgroupLocalSvm = replicationErrorIgroupLocalSvm
}

// WithReplicationErrorIgroupName adds the replicationErrorIgroupName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithReplicationErrorIgroupName(replicationErrorIgroupName *string) *IgroupModifyCollectionParams {
	o.SetReplicationErrorIgroupName(replicationErrorIgroupName)
	return o
}

// SetReplicationErrorIgroupName adds the replicationErrorIgroupName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetReplicationErrorIgroupName(replicationErrorIgroupName *string) {
	o.ReplicationErrorIgroupName = replicationErrorIgroupName
}

// WithReplicationErrorIgroupUUID adds the replicationErrorIgroupUUID to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithReplicationErrorIgroupUUID(replicationErrorIgroupUUID *string) *IgroupModifyCollectionParams {
	o.SetReplicationErrorIgroupUUID(replicationErrorIgroupUUID)
	return o
}

// SetReplicationErrorIgroupUUID adds the replicationErrorIgroupUuid to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetReplicationErrorIgroupUUID(replicationErrorIgroupUUID *string) {
	o.ReplicationErrorIgroupUUID = replicationErrorIgroupUUID
}

// WithReplicationErrorSummaryArgumentsCode adds the replicationErrorSummaryArgumentsCode to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithReplicationErrorSummaryArgumentsCode(replicationErrorSummaryArgumentsCode *string) *IgroupModifyCollectionParams {
	o.SetReplicationErrorSummaryArgumentsCode(replicationErrorSummaryArgumentsCode)
	return o
}

// SetReplicationErrorSummaryArgumentsCode adds the replicationErrorSummaryArgumentsCode to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetReplicationErrorSummaryArgumentsCode(replicationErrorSummaryArgumentsCode *string) {
	o.ReplicationErrorSummaryArgumentsCode = replicationErrorSummaryArgumentsCode
}

// WithReplicationErrorSummaryArgumentsMessage adds the replicationErrorSummaryArgumentsMessage to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithReplicationErrorSummaryArgumentsMessage(replicationErrorSummaryArgumentsMessage *string) *IgroupModifyCollectionParams {
	o.SetReplicationErrorSummaryArgumentsMessage(replicationErrorSummaryArgumentsMessage)
	return o
}

// SetReplicationErrorSummaryArgumentsMessage adds the replicationErrorSummaryArgumentsMessage to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetReplicationErrorSummaryArgumentsMessage(replicationErrorSummaryArgumentsMessage *string) {
	o.ReplicationErrorSummaryArgumentsMessage = replicationErrorSummaryArgumentsMessage
}

// WithReplicationErrorSummaryCode adds the replicationErrorSummaryCode to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithReplicationErrorSummaryCode(replicationErrorSummaryCode *string) *IgroupModifyCollectionParams {
	o.SetReplicationErrorSummaryCode(replicationErrorSummaryCode)
	return o
}

// SetReplicationErrorSummaryCode adds the replicationErrorSummaryCode to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetReplicationErrorSummaryCode(replicationErrorSummaryCode *string) {
	o.ReplicationErrorSummaryCode = replicationErrorSummaryCode
}

// WithReplicationErrorSummaryMessage adds the replicationErrorSummaryMessage to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithReplicationErrorSummaryMessage(replicationErrorSummaryMessage *string) *IgroupModifyCollectionParams {
	o.SetReplicationErrorSummaryMessage(replicationErrorSummaryMessage)
	return o
}

// SetReplicationErrorSummaryMessage adds the replicationErrorSummaryMessage to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetReplicationErrorSummaryMessage(replicationErrorSummaryMessage *string) {
	o.ReplicationErrorSummaryMessage = replicationErrorSummaryMessage
}

// WithReplicationPeerSvmName adds the replicationPeerSvmName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithReplicationPeerSvmName(replicationPeerSvmName *string) *IgroupModifyCollectionParams {
	o.SetReplicationPeerSvmName(replicationPeerSvmName)
	return o
}

// SetReplicationPeerSvmName adds the replicationPeerSvmName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetReplicationPeerSvmName(replicationPeerSvmName *string) {
	o.ReplicationPeerSvmName = replicationPeerSvmName
}

// WithReplicationPeerSvmUUID adds the replicationPeerSvmUUID to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithReplicationPeerSvmUUID(replicationPeerSvmUUID *string) *IgroupModifyCollectionParams {
	o.SetReplicationPeerSvmUUID(replicationPeerSvmUUID)
	return o
}

// SetReplicationPeerSvmUUID adds the replicationPeerSvmUuid to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetReplicationPeerSvmUUID(replicationPeerSvmUUID *string) {
	o.ReplicationPeerSvmUUID = replicationPeerSvmUUID
}

// WithReplicationState adds the replicationState to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithReplicationState(replicationState *string) *IgroupModifyCollectionParams {
	o.SetReplicationState(replicationState)
	return o
}

// SetReplicationState adds the replicationState to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetReplicationState(replicationState *string) {
	o.ReplicationState = replicationState
}

// WithReturnRecords adds the returnRecords to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithReturnRecords(returnRecords *bool) *IgroupModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *IgroupModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithSerialRecords(serialRecords *bool) *IgroupModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSupportsIgroups adds the supportsIgroups to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithSupportsIgroups(supportsIgroups *bool) *IgroupModifyCollectionParams {
	o.SetSupportsIgroups(supportsIgroups)
	return o
}

// SetSupportsIgroups adds the supportsIgroups to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetSupportsIgroups(supportsIgroups *bool) {
	o.SupportsIgroups = supportsIgroups
}

// WithSvmName adds the svmName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithSvmName(svmName *string) *IgroupModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithSvmUUID(svmUUID *string) *IgroupModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTargetFirmwareRevision adds the targetFirmwareRevision to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithTargetFirmwareRevision(targetFirmwareRevision *string) *IgroupModifyCollectionParams {
	o.SetTargetFirmwareRevision(targetFirmwareRevision)
	return o
}

// SetTargetFirmwareRevision adds the targetFirmwareRevision to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetTargetFirmwareRevision(targetFirmwareRevision *string) {
	o.TargetFirmwareRevision = targetFirmwareRevision
}

// WithTargetProductID adds the targetProductID to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithTargetProductID(targetProductID *string) *IgroupModifyCollectionParams {
	o.SetTargetProductID(targetProductID)
	return o
}

// SetTargetProductID adds the targetProductId to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetTargetProductID(targetProductID *string) {
	o.TargetProductID = targetProductID
}

// WithTargetVendorID adds the targetVendorID to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithTargetVendorID(targetVendorID *string) *IgroupModifyCollectionParams {
	o.SetTargetVendorID(targetVendorID)
	return o
}

// SetTargetVendorID adds the targetVendorId to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetTargetVendorID(targetVendorID *string) {
	o.TargetVendorID = targetVendorID
}

// WithUUID adds the uuid to the igroup modify collection params
func (o *IgroupModifyCollectionParams) WithUUID(uuid *string) *IgroupModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the igroup modify collection params
func (o *IgroupModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *IgroupModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityTrackingAlertsSummaryArgumentsCode != nil {

		// query param connectivity_tracking.alerts.summary.arguments.code
		var qrConnectivityTrackingAlertsSummaryArgumentsCode string

		if o.ConnectivityTrackingAlertsSummaryArgumentsCode != nil {
			qrConnectivityTrackingAlertsSummaryArgumentsCode = *o.ConnectivityTrackingAlertsSummaryArgumentsCode
		}
		qConnectivityTrackingAlertsSummaryArgumentsCode := qrConnectivityTrackingAlertsSummaryArgumentsCode
		if qConnectivityTrackingAlertsSummaryArgumentsCode != "" {

			if err := r.SetQueryParam("connectivity_tracking.alerts.summary.arguments.code", qConnectivityTrackingAlertsSummaryArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityTrackingAlertsSummaryArgumentsMessage != nil {

		// query param connectivity_tracking.alerts.summary.arguments.message
		var qrConnectivityTrackingAlertsSummaryArgumentsMessage string

		if o.ConnectivityTrackingAlertsSummaryArgumentsMessage != nil {
			qrConnectivityTrackingAlertsSummaryArgumentsMessage = *o.ConnectivityTrackingAlertsSummaryArgumentsMessage
		}
		qConnectivityTrackingAlertsSummaryArgumentsMessage := qrConnectivityTrackingAlertsSummaryArgumentsMessage
		if qConnectivityTrackingAlertsSummaryArgumentsMessage != "" {

			if err := r.SetQueryParam("connectivity_tracking.alerts.summary.arguments.message", qConnectivityTrackingAlertsSummaryArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityTrackingAlertsSummaryCode != nil {

		// query param connectivity_tracking.alerts.summary.code
		var qrConnectivityTrackingAlertsSummaryCode string

		if o.ConnectivityTrackingAlertsSummaryCode != nil {
			qrConnectivityTrackingAlertsSummaryCode = *o.ConnectivityTrackingAlertsSummaryCode
		}
		qConnectivityTrackingAlertsSummaryCode := qrConnectivityTrackingAlertsSummaryCode
		if qConnectivityTrackingAlertsSummaryCode != "" {

			if err := r.SetQueryParam("connectivity_tracking.alerts.summary.code", qConnectivityTrackingAlertsSummaryCode); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityTrackingAlertsSummaryMessage != nil {

		// query param connectivity_tracking.alerts.summary.message
		var qrConnectivityTrackingAlertsSummaryMessage string

		if o.ConnectivityTrackingAlertsSummaryMessage != nil {
			qrConnectivityTrackingAlertsSummaryMessage = *o.ConnectivityTrackingAlertsSummaryMessage
		}
		qConnectivityTrackingAlertsSummaryMessage := qrConnectivityTrackingAlertsSummaryMessage
		if qConnectivityTrackingAlertsSummaryMessage != "" {

			if err := r.SetQueryParam("connectivity_tracking.alerts.summary.message", qConnectivityTrackingAlertsSummaryMessage); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityTrackingConnectionState != nil {

		// query param connectivity_tracking.connection_state
		var qrConnectivityTrackingConnectionState string

		if o.ConnectivityTrackingConnectionState != nil {
			qrConnectivityTrackingConnectionState = *o.ConnectivityTrackingConnectionState
		}
		qConnectivityTrackingConnectionState := qrConnectivityTrackingConnectionState
		if qConnectivityTrackingConnectionState != "" {

			if err := r.SetQueryParam("connectivity_tracking.connection_state", qConnectivityTrackingConnectionState); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityTrackingRequiredNodesName != nil {

		// query param connectivity_tracking.required_nodes.name
		var qrConnectivityTrackingRequiredNodesName string

		if o.ConnectivityTrackingRequiredNodesName != nil {
			qrConnectivityTrackingRequiredNodesName = *o.ConnectivityTrackingRequiredNodesName
		}
		qConnectivityTrackingRequiredNodesName := qrConnectivityTrackingRequiredNodesName
		if qConnectivityTrackingRequiredNodesName != "" {

			if err := r.SetQueryParam("connectivity_tracking.required_nodes.name", qConnectivityTrackingRequiredNodesName); err != nil {
				return err
			}
		}
	}

	if o.ConnectivityTrackingRequiredNodesUUID != nil {

		// query param connectivity_tracking.required_nodes.uuid
		var qrConnectivityTrackingRequiredNodesUUID string

		if o.ConnectivityTrackingRequiredNodesUUID != nil {
			qrConnectivityTrackingRequiredNodesUUID = *o.ConnectivityTrackingRequiredNodesUUID
		}
		qConnectivityTrackingRequiredNodesUUID := qrConnectivityTrackingRequiredNodesUUID
		if qConnectivityTrackingRequiredNodesUUID != "" {

			if err := r.SetQueryParam("connectivity_tracking.required_nodes.uuid", qConnectivityTrackingRequiredNodesUUID); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.DeleteOnUnmap != nil {

		// query param delete_on_unmap
		var qrDeleteOnUnmap bool

		if o.DeleteOnUnmap != nil {
			qrDeleteOnUnmap = *o.DeleteOnUnmap
		}
		qDeleteOnUnmap := swag.FormatBool(qrDeleteOnUnmap)
		if qDeleteOnUnmap != "" {

			if err := r.SetQueryParam("delete_on_unmap", qDeleteOnUnmap); err != nil {
				return err
			}
		}
	}

	if o.IgroupsComment != nil {

		// query param igroups.comment
		var qrIgroupsComment string

		if o.IgroupsComment != nil {
			qrIgroupsComment = *o.IgroupsComment
		}
		qIgroupsComment := qrIgroupsComment
		if qIgroupsComment != "" {

			if err := r.SetQueryParam("igroups.comment", qIgroupsComment); err != nil {
				return err
			}
		}
	}

	if o.IgroupsName != nil {

		// query param igroups.name
		var qrIgroupsName string

		if o.IgroupsName != nil {
			qrIgroupsName = *o.IgroupsName
		}
		qIgroupsName := qrIgroupsName
		if qIgroupsName != "" {

			if err := r.SetQueryParam("igroups.name", qIgroupsName); err != nil {
				return err
			}
		}
	}

	if o.IgroupsUUID != nil {

		// query param igroups.uuid
		var qrIgroupsUUID string

		if o.IgroupsUUID != nil {
			qrIgroupsUUID = *o.IgroupsUUID
		}
		qIgroupsUUID := qrIgroupsUUID
		if qIgroupsUUID != "" {

			if err := r.SetQueryParam("igroups.uuid", qIgroupsUUID); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.InitiatorsComment != nil {

		// query param initiators.comment
		var qrInitiatorsComment string

		if o.InitiatorsComment != nil {
			qrInitiatorsComment = *o.InitiatorsComment
		}
		qInitiatorsComment := qrInitiatorsComment
		if qInitiatorsComment != "" {

			if err := r.SetQueryParam("initiators.comment", qInitiatorsComment); err != nil {
				return err
			}
		}
	}

	if o.InitiatorsConnectivityTrackingConnectionState != nil {

		// query param initiators.connectivity_tracking.connection_state
		var qrInitiatorsConnectivityTrackingConnectionState string

		if o.InitiatorsConnectivityTrackingConnectionState != nil {
			qrInitiatorsConnectivityTrackingConnectionState = *o.InitiatorsConnectivityTrackingConnectionState
		}
		qInitiatorsConnectivityTrackingConnectionState := qrInitiatorsConnectivityTrackingConnectionState
		if qInitiatorsConnectivityTrackingConnectionState != "" {

			if err := r.SetQueryParam("initiators.connectivity_tracking.connection_state", qInitiatorsConnectivityTrackingConnectionState); err != nil {
				return err
			}
		}
	}

	if o.InitiatorsIgroupName != nil {

		// query param initiators.igroup.name
		var qrInitiatorsIgroupName string

		if o.InitiatorsIgroupName != nil {
			qrInitiatorsIgroupName = *o.InitiatorsIgroupName
		}
		qInitiatorsIgroupName := qrInitiatorsIgroupName
		if qInitiatorsIgroupName != "" {

			if err := r.SetQueryParam("initiators.igroup.name", qInitiatorsIgroupName); err != nil {
				return err
			}
		}
	}

	if o.InitiatorsIgroupUUID != nil {

		// query param initiators.igroup.uuid
		var qrInitiatorsIgroupUUID string

		if o.InitiatorsIgroupUUID != nil {
			qrInitiatorsIgroupUUID = *o.InitiatorsIgroupUUID
		}
		qInitiatorsIgroupUUID := qrInitiatorsIgroupUUID
		if qInitiatorsIgroupUUID != "" {

			if err := r.SetQueryParam("initiators.igroup.uuid", qInitiatorsIgroupUUID); err != nil {
				return err
			}
		}
	}

	if o.InitiatorsName != nil {

		// query param initiators.name
		var qrInitiatorsName string

		if o.InitiatorsName != nil {
			qrInitiatorsName = *o.InitiatorsName
		}
		qInitiatorsName := qrInitiatorsName
		if qInitiatorsName != "" {

			if err := r.SetQueryParam("initiators.name", qInitiatorsName); err != nil {
				return err
			}
		}
	}

	if o.InitiatorsProximityLocalSvm != nil {

		// query param initiators.proximity.local_svm
		var qrInitiatorsProximityLocalSvm bool

		if o.InitiatorsProximityLocalSvm != nil {
			qrInitiatorsProximityLocalSvm = *o.InitiatorsProximityLocalSvm
		}
		qInitiatorsProximityLocalSvm := swag.FormatBool(qrInitiatorsProximityLocalSvm)
		if qInitiatorsProximityLocalSvm != "" {

			if err := r.SetQueryParam("initiators.proximity.local_svm", qInitiatorsProximityLocalSvm); err != nil {
				return err
			}
		}
	}

	if o.InitiatorsProximityPeerSvmsName != nil {

		// query param initiators.proximity.peer_svms.name
		var qrInitiatorsProximityPeerSvmsName string

		if o.InitiatorsProximityPeerSvmsName != nil {
			qrInitiatorsProximityPeerSvmsName = *o.InitiatorsProximityPeerSvmsName
		}
		qInitiatorsProximityPeerSvmsName := qrInitiatorsProximityPeerSvmsName
		if qInitiatorsProximityPeerSvmsName != "" {

			if err := r.SetQueryParam("initiators.proximity.peer_svms.name", qInitiatorsProximityPeerSvmsName); err != nil {
				return err
			}
		}
	}

	if o.InitiatorsProximityPeerSvmsUUID != nil {

		// query param initiators.proximity.peer_svms.uuid
		var qrInitiatorsProximityPeerSvmsUUID string

		if o.InitiatorsProximityPeerSvmsUUID != nil {
			qrInitiatorsProximityPeerSvmsUUID = *o.InitiatorsProximityPeerSvmsUUID
		}
		qInitiatorsProximityPeerSvmsUUID := qrInitiatorsProximityPeerSvmsUUID
		if qInitiatorsProximityPeerSvmsUUID != "" {

			if err := r.SetQueryParam("initiators.proximity.peer_svms.uuid", qInitiatorsProximityPeerSvmsUUID); err != nil {
				return err
			}
		}
	}

	if o.LunMapsLogicalUnitNumber != nil {

		// query param lun_maps.logical_unit_number
		var qrLunMapsLogicalUnitNumber int64

		if o.LunMapsLogicalUnitNumber != nil {
			qrLunMapsLogicalUnitNumber = *o.LunMapsLogicalUnitNumber
		}
		qLunMapsLogicalUnitNumber := swag.FormatInt64(qrLunMapsLogicalUnitNumber)
		if qLunMapsLogicalUnitNumber != "" {

			if err := r.SetQueryParam("lun_maps.logical_unit_number", qLunMapsLogicalUnitNumber); err != nil {
				return err
			}
		}
	}

	if o.LunMapsLunName != nil {

		// query param lun_maps.lun.name
		var qrLunMapsLunName string

		if o.LunMapsLunName != nil {
			qrLunMapsLunName = *o.LunMapsLunName
		}
		qLunMapsLunName := qrLunMapsLunName
		if qLunMapsLunName != "" {

			if err := r.SetQueryParam("lun_maps.lun.name", qLunMapsLunName); err != nil {
				return err
			}
		}
	}

	if o.LunMapsLunNodeName != nil {

		// query param lun_maps.lun.node.name
		var qrLunMapsLunNodeName string

		if o.LunMapsLunNodeName != nil {
			qrLunMapsLunNodeName = *o.LunMapsLunNodeName
		}
		qLunMapsLunNodeName := qrLunMapsLunNodeName
		if qLunMapsLunNodeName != "" {

			if err := r.SetQueryParam("lun_maps.lun.node.name", qLunMapsLunNodeName); err != nil {
				return err
			}
		}
	}

	if o.LunMapsLunNodeUUID != nil {

		// query param lun_maps.lun.node.uuid
		var qrLunMapsLunNodeUUID string

		if o.LunMapsLunNodeUUID != nil {
			qrLunMapsLunNodeUUID = *o.LunMapsLunNodeUUID
		}
		qLunMapsLunNodeUUID := qrLunMapsLunNodeUUID
		if qLunMapsLunNodeUUID != "" {

			if err := r.SetQueryParam("lun_maps.lun.node.uuid", qLunMapsLunNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.LunMapsLunUUID != nil {

		// query param lun_maps.lun.uuid
		var qrLunMapsLunUUID string

		if o.LunMapsLunUUID != nil {
			qrLunMapsLunUUID = *o.LunMapsLunUUID
		}
		qLunMapsLunUUID := qrLunMapsLunUUID
		if qLunMapsLunUUID != "" {

			if err := r.SetQueryParam("lun_maps.lun.uuid", qLunMapsLunUUID); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OsType != nil {

		// query param os_type
		var qrOsType string

		if o.OsType != nil {
			qrOsType = *o.OsType
		}
		qOsType := qrOsType
		if qOsType != "" {

			if err := r.SetQueryParam("os_type", qOsType); err != nil {
				return err
			}
		}
	}

	if o.ParentIgroupsComment != nil {

		// query param parent_igroups.comment
		var qrParentIgroupsComment string

		if o.ParentIgroupsComment != nil {
			qrParentIgroupsComment = *o.ParentIgroupsComment
		}
		qParentIgroupsComment := qrParentIgroupsComment
		if qParentIgroupsComment != "" {

			if err := r.SetQueryParam("parent_igroups.comment", qParentIgroupsComment); err != nil {
				return err
			}
		}
	}

	if o.ParentIgroupsName != nil {

		// query param parent_igroups.name
		var qrParentIgroupsName string

		if o.ParentIgroupsName != nil {
			qrParentIgroupsName = *o.ParentIgroupsName
		}
		qParentIgroupsName := qrParentIgroupsName
		if qParentIgroupsName != "" {

			if err := r.SetQueryParam("parent_igroups.name", qParentIgroupsName); err != nil {
				return err
			}
		}
	}

	if o.ParentIgroupsUUID != nil {

		// query param parent_igroups.uuid
		var qrParentIgroupsUUID string

		if o.ParentIgroupsUUID != nil {
			qrParentIgroupsUUID = *o.ParentIgroupsUUID
		}
		qParentIgroupsUUID := qrParentIgroupsUUID
		if qParentIgroupsUUID != "" {

			if err := r.SetQueryParam("parent_igroups.uuid", qParentIgroupsUUID); err != nil {
				return err
			}
		}
	}

	if o.PortsetName != nil {

		// query param portset.name
		var qrPortsetName string

		if o.PortsetName != nil {
			qrPortsetName = *o.PortsetName
		}
		qPortsetName := qrPortsetName
		if qPortsetName != "" {

			if err := r.SetQueryParam("portset.name", qPortsetName); err != nil {
				return err
			}
		}
	}

	if o.PortsetUUID != nil {

		// query param portset.uuid
		var qrPortsetUUID string

		if o.PortsetUUID != nil {
			qrPortsetUUID = *o.PortsetUUID
		}
		qPortsetUUID := qrPortsetUUID
		if qPortsetUUID != "" {

			if err := r.SetQueryParam("portset.uuid", qPortsetUUID); err != nil {
				return err
			}
		}
	}

	if o.Protocol != nil {

		// query param protocol
		var qrProtocol string

		if o.Protocol != nil {
			qrProtocol = *o.Protocol
		}
		qProtocol := qrProtocol
		if qProtocol != "" {

			if err := r.SetQueryParam("protocol", qProtocol); err != nil {
				return err
			}
		}
	}

	if o.ReplicationErrorIgroupLocalSvm != nil {

		// query param replication.error.igroup.local_svm
		var qrReplicationErrorIgroupLocalSvm bool

		if o.ReplicationErrorIgroupLocalSvm != nil {
			qrReplicationErrorIgroupLocalSvm = *o.ReplicationErrorIgroupLocalSvm
		}
		qReplicationErrorIgroupLocalSvm := swag.FormatBool(qrReplicationErrorIgroupLocalSvm)
		if qReplicationErrorIgroupLocalSvm != "" {

			if err := r.SetQueryParam("replication.error.igroup.local_svm", qReplicationErrorIgroupLocalSvm); err != nil {
				return err
			}
		}
	}

	if o.ReplicationErrorIgroupName != nil {

		// query param replication.error.igroup.name
		var qrReplicationErrorIgroupName string

		if o.ReplicationErrorIgroupName != nil {
			qrReplicationErrorIgroupName = *o.ReplicationErrorIgroupName
		}
		qReplicationErrorIgroupName := qrReplicationErrorIgroupName
		if qReplicationErrorIgroupName != "" {

			if err := r.SetQueryParam("replication.error.igroup.name", qReplicationErrorIgroupName); err != nil {
				return err
			}
		}
	}

	if o.ReplicationErrorIgroupUUID != nil {

		// query param replication.error.igroup.uuid
		var qrReplicationErrorIgroupUUID string

		if o.ReplicationErrorIgroupUUID != nil {
			qrReplicationErrorIgroupUUID = *o.ReplicationErrorIgroupUUID
		}
		qReplicationErrorIgroupUUID := qrReplicationErrorIgroupUUID
		if qReplicationErrorIgroupUUID != "" {

			if err := r.SetQueryParam("replication.error.igroup.uuid", qReplicationErrorIgroupUUID); err != nil {
				return err
			}
		}
	}

	if o.ReplicationErrorSummaryArgumentsCode != nil {

		// query param replication.error.summary.arguments.code
		var qrReplicationErrorSummaryArgumentsCode string

		if o.ReplicationErrorSummaryArgumentsCode != nil {
			qrReplicationErrorSummaryArgumentsCode = *o.ReplicationErrorSummaryArgumentsCode
		}
		qReplicationErrorSummaryArgumentsCode := qrReplicationErrorSummaryArgumentsCode
		if qReplicationErrorSummaryArgumentsCode != "" {

			if err := r.SetQueryParam("replication.error.summary.arguments.code", qReplicationErrorSummaryArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.ReplicationErrorSummaryArgumentsMessage != nil {

		// query param replication.error.summary.arguments.message
		var qrReplicationErrorSummaryArgumentsMessage string

		if o.ReplicationErrorSummaryArgumentsMessage != nil {
			qrReplicationErrorSummaryArgumentsMessage = *o.ReplicationErrorSummaryArgumentsMessage
		}
		qReplicationErrorSummaryArgumentsMessage := qrReplicationErrorSummaryArgumentsMessage
		if qReplicationErrorSummaryArgumentsMessage != "" {

			if err := r.SetQueryParam("replication.error.summary.arguments.message", qReplicationErrorSummaryArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.ReplicationErrorSummaryCode != nil {

		// query param replication.error.summary.code
		var qrReplicationErrorSummaryCode string

		if o.ReplicationErrorSummaryCode != nil {
			qrReplicationErrorSummaryCode = *o.ReplicationErrorSummaryCode
		}
		qReplicationErrorSummaryCode := qrReplicationErrorSummaryCode
		if qReplicationErrorSummaryCode != "" {

			if err := r.SetQueryParam("replication.error.summary.code", qReplicationErrorSummaryCode); err != nil {
				return err
			}
		}
	}

	if o.ReplicationErrorSummaryMessage != nil {

		// query param replication.error.summary.message
		var qrReplicationErrorSummaryMessage string

		if o.ReplicationErrorSummaryMessage != nil {
			qrReplicationErrorSummaryMessage = *o.ReplicationErrorSummaryMessage
		}
		qReplicationErrorSummaryMessage := qrReplicationErrorSummaryMessage
		if qReplicationErrorSummaryMessage != "" {

			if err := r.SetQueryParam("replication.error.summary.message", qReplicationErrorSummaryMessage); err != nil {
				return err
			}
		}
	}

	if o.ReplicationPeerSvmName != nil {

		// query param replication.peer_svm.name
		var qrReplicationPeerSvmName string

		if o.ReplicationPeerSvmName != nil {
			qrReplicationPeerSvmName = *o.ReplicationPeerSvmName
		}
		qReplicationPeerSvmName := qrReplicationPeerSvmName
		if qReplicationPeerSvmName != "" {

			if err := r.SetQueryParam("replication.peer_svm.name", qReplicationPeerSvmName); err != nil {
				return err
			}
		}
	}

	if o.ReplicationPeerSvmUUID != nil {

		// query param replication.peer_svm.uuid
		var qrReplicationPeerSvmUUID string

		if o.ReplicationPeerSvmUUID != nil {
			qrReplicationPeerSvmUUID = *o.ReplicationPeerSvmUUID
		}
		qReplicationPeerSvmUUID := qrReplicationPeerSvmUUID
		if qReplicationPeerSvmUUID != "" {

			if err := r.SetQueryParam("replication.peer_svm.uuid", qReplicationPeerSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.ReplicationState != nil {

		// query param replication.state
		var qrReplicationState string

		if o.ReplicationState != nil {
			qrReplicationState = *o.ReplicationState
		}
		qReplicationState := qrReplicationState
		if qReplicationState != "" {

			if err := r.SetQueryParam("replication.state", qReplicationState); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SupportsIgroups != nil {

		// query param supports_igroups
		var qrSupportsIgroups bool

		if o.SupportsIgroups != nil {
			qrSupportsIgroups = *o.SupportsIgroups
		}
		qSupportsIgroups := swag.FormatBool(qrSupportsIgroups)
		if qSupportsIgroups != "" {

			if err := r.SetQueryParam("supports_igroups", qSupportsIgroups); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TargetFirmwareRevision != nil {

		// query param target.firmware_revision
		var qrTargetFirmwareRevision string

		if o.TargetFirmwareRevision != nil {
			qrTargetFirmwareRevision = *o.TargetFirmwareRevision
		}
		qTargetFirmwareRevision := qrTargetFirmwareRevision
		if qTargetFirmwareRevision != "" {

			if err := r.SetQueryParam("target.firmware_revision", qTargetFirmwareRevision); err != nil {
				return err
			}
		}
	}

	if o.TargetProductID != nil {

		// query param target.product_id
		var qrTargetProductID string

		if o.TargetProductID != nil {
			qrTargetProductID = *o.TargetProductID
		}
		qTargetProductID := qrTargetProductID
		if qTargetProductID != "" {

			if err := r.SetQueryParam("target.product_id", qTargetProductID); err != nil {
				return err
			}
		}
	}

	if o.TargetVendorID != nil {

		// query param target.vendor_id
		var qrTargetVendorID string

		if o.TargetVendorID != nil {
			qrTargetVendorID = *o.TargetVendorID
		}
		qTargetVendorID := qrTargetVendorID
		if qTargetVendorID != "" {

			if err := r.SetQueryParam("target.vendor_id", qTargetVendorID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
