// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IgroupModifyCollectionReader is a Reader for the IgroupModifyCollection structure.
type IgroupModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IgroupModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIgroupModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIgroupModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIgroupModifyCollectionOK creates a IgroupModifyCollectionOK with default headers values
func NewIgroupModifyCollectionOK() *IgroupModifyCollectionOK {
	return &IgroupModifyCollectionOK{}
}

/*
IgroupModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type IgroupModifyCollectionOK struct {
}

// IsSuccess returns true when this igroup modify collection o k response has a 2xx status code
func (o *IgroupModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this igroup modify collection o k response has a 3xx status code
func (o *IgroupModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this igroup modify collection o k response has a 4xx status code
func (o *IgroupModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this igroup modify collection o k response has a 5xx status code
func (o *IgroupModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this igroup modify collection o k response a status code equal to that given
func (o *IgroupModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the igroup modify collection o k response
func (o *IgroupModifyCollectionOK) Code() int {
	return 200
}

func (o *IgroupModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/san/igroups][%d] igroupModifyCollectionOK", 200)
}

func (o *IgroupModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/san/igroups][%d] igroupModifyCollectionOK", 200)
}

func (o *IgroupModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewIgroupModifyCollectionDefault creates a IgroupModifyCollectionDefault with default headers values
func NewIgroupModifyCollectionDefault(code int) *IgroupModifyCollectionDefault {
	return &IgroupModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	IgroupModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1254264 | An attempt was made to bind a portset to an initiator group that is already bound to a portset. |
| 5373958 | An invalid initiator group name was supplied for a rename operation. |
| 5374023 | A rename operation failed because an initiator group with the same name already exists. |
| 5374027 | An attempt was made to bind a portset with no member network interfaces to the initiator group. |
| 5374028 | An attempt was made to bind a portset with an incompatible protocol to the initiator group. |
| 5374733 | An initiator is already in another initiator group with a conflicting operating system type. |
| 5374745 | An attempt was made to add an initiator group as a child to itself. |
| 5374746 | The cluster is currently running in a mixed version and nested initiator groups cannot be created until the effective cluster version reaches 9.9.1. |
| 5374747 | The cluster is currently running in a mixed version and initiator group comments cannot be created until the effective cluster version reaches 9.9.1. |
| 5374749 | An initiator group's replication peer SVM cannot be changed without first being cleared. |
| 5374759 | An error was reported by the peer cluster while modifying a replicated initiator group. The specific error will be included as a nested error. |
| 5374763 | An error was reported by the peer cluster while renaming a replicated initiator group. The specific error will be included as a nested error. |
| 5374765 | An initiator group cannot be replicated if it has unreplicated child initiator groups. |
| 5374766 | A replicated initiator group cannot be changed to unreplicated if it is the child of a replicated initiator group. |
| 5374770 | An unreplicated initiator group cannot be changed to replicated due to a conflict in its LUN maps. |
| 5374852 | The initiator group does not exist. |
| 5374868 | The initiator group was partially modified before an error was encountered while renaming the initiator group. |
| 5375258 | The igroup is already replicated to a different peer SVM. |
| 5376253 | Initiator group replication requires an effective cluster version of 9.15.1. |
| 5376255 | Initiator group replication requires the peer cluster to have an effective cluster version of 9.15.1. |
| 5376488 | An NVMe over Fabrics subsystem already exists with the requested name. |
| 6620376 | SVM peering information is unavailable. |
| 6620384 | The supplied SVMs are not peered. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IgroupModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this igroup modify collection default response has a 2xx status code
func (o *IgroupModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this igroup modify collection default response has a 3xx status code
func (o *IgroupModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this igroup modify collection default response has a 4xx status code
func (o *IgroupModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this igroup modify collection default response has a 5xx status code
func (o *IgroupModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this igroup modify collection default response a status code equal to that given
func (o *IgroupModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the igroup modify collection default response
func (o *IgroupModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *IgroupModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/san/igroups][%d] igroup_modify_collection default %s", o._statusCode, payload)
}

func (o *IgroupModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/san/igroups][%d] igroup_modify_collection default %s", o._statusCode, payload)
}

func (o *IgroupModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IgroupModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
IgroupModifyCollectionBody igroup modify collection body
swagger:model IgroupModifyCollectionBody
*/
type IgroupModifyCollectionBody struct {

	// links
	Links *models.IgroupInlineLinks `json:"_links,omitempty"`

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// connectivity tracking
	ConnectivityTracking *models.IgroupInlineConnectivityTracking `json:"connectivity_tracking,omitempty"`

	// An option that causes the initiator group to be deleted when the last LUN map associated with it is deleted. Optional in POST and PATCH. This property defaults to _false_ when the initiator group is created.
	//
	DeleteOnUnmap *bool `json:"delete_on_unmap,omitempty"`

	// The existing initiator groups that are members of the group. Optional in POST.<br/>
	// This property is mutually exclusive with the _initiators_ property during POST.<br/>
	// This array contains only the direct children of the initiator group. If the member initiator groups have further nested initiator groups, those are reported in the `igroups` property of the child initiator group.<br/>
	// Zero or more nested initiator groups can be supplied when the initiator group is created. The initiator group will act as if it contains the aggregation of all initiators in any nested initiator groups.<br/>
	// After creation, nested initiator groups can be added or removed from the initiator group using the `/protocols/san/igroups/{igroup.uuid}/igroups` endpoint. See [`POST /protocols/san/igroups/{igroup.uuid}/igroups`](#/SAN/igroup_nested_create) and [`DELETE /protocols/san/igroups/{igroup.uuid}/igroups/{uuid}`](#/SAN/igroup_nested_delete) for more details.
	//
	IgroupInlineIgroups []*models.IgroupChild `json:"igroups,omitempty"`

	// The initiators that are members of the group or any group nested below this group. Optional in POST.<br/>
	// This property is mutually exclusive with the _igroups_ property during POST.<br/>
	// During GET, this array contains initiators that are members of this group or any nested initiator groups below this group. When initiators of nested groups are returned, they include links to the initiator group that directly contains the initiator.<br/>
	// Zero or more initiators can be supplied when the initiator group is created. After creation, initiators can be added or removed from the initiator group using the `/protocols/san/igroups/{igroup.uuid}/initiators` endpoint. See [`POST /protocols/san/igroups/{igroup.uuid}/initiators`](#/SAN/igroup_initiator_create) and [`DELETE /protocols/san/igroups/{igroup.uuid}/initiators/{name}`](#/SAN/igroup_initiator_delete) for more details.
	//
	IgroupInlineInitiators []*models.IgroupInlineInitiatorsInlineArrayItem `json:"initiators,omitempty"`

	// All LUN maps with which the initiator is associated.<br/>
	// If the requested igroup is part of a remote, non-local, MetroCluster SVM, the LUN maps are not retrieved.<br/>
	// There is an added computational cost to retrieving property values for `lun_maps`. They are not populated for a GET request unless explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
	//
	// Read Only: true
	IgroupInlineLunMaps []*models.IgroupInlineLunMapsInlineArrayItem `json:"lun_maps,omitempty"`

	// The initiator groups that contain this initiator group as a member.
	//
	// Read Only: true
	IgroupInlineParentIgroups []*models.IgroupParent `json:"parent_igroups,omitempty"`

	// igroup response inline records
	IgroupResponseInlineRecords []*models.Igroup `json:"records,omitempty"`

	// The name of the initiator group. Required in POST; optional in PATCH.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The host operating system of the initiator group. All initiators in the group should be hosts of the same operating system. Required in POST; optional in PATCH.
	//
	// Enum: ["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]
	OsType *string `json:"os_type,omitempty"`

	// portset
	Portset *models.IgroupInlinePortset `json:"portset,omitempty"`

	// The protocols supported by the initiator group. This restricts the type of initiators that can be added to the initiator group. Optional in POST; if not supplied, this defaults to _mixed_.<br/>
	// The protocol of an initiator group cannot be changed after creation of the group.
	//
	// Enum: ["fcp","iscsi","mixed"]
	Protocol *string `json:"protocol,omitempty"`

	// replication
	Replication *models.IgroupInlineReplication `json:"replication,omitempty"`

	// An initiator group may contain either initiators or other initiator groups, but not both simultaneously. This property is _true_ when initiator groups can be added to this initiator group. The `initiators.name` property cannot be used to determine this via a query because it reports initiators inherited from nested igroups.
	//
	// Read Only: true
	SupportsIgroups *bool `json:"supports_igroups,omitempty"`

	// svm
	Svm *models.IgroupInlineSvm `json:"svm,omitempty"`

	// target
	Target *models.IgroupInlineTarget `json:"target,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup modify collection body
func (o *IgroupModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConnectivityTracking(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIgroupInlineIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIgroupInlineInitiators(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIgroupInlineLunMaps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIgroupInlineParentIgroups(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIgroupResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOsType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePortset(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateReplication(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTarget(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupModifyCollectionBody) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *IgroupModifyCollectionBody) validateConnectivityTracking(formats strfmt.Registry) error {
	if swag.IsZero(o.ConnectivityTracking) { // not required
		return nil
	}

	if o.ConnectivityTracking != nil {
		if err := o.ConnectivityTracking.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "connectivity_tracking")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupModifyCollectionBody) validateIgroupInlineIgroups(formats strfmt.Registry) error {
	if swag.IsZero(o.IgroupInlineIgroups) { // not required
		return nil
	}

	for i := 0; i < len(o.IgroupInlineIgroups); i++ {
		if swag.IsZero(o.IgroupInlineIgroups[i]) { // not required
			continue
		}

		if o.IgroupInlineIgroups[i] != nil {
			if err := o.IgroupInlineIgroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupModifyCollectionBody) validateIgroupInlineInitiators(formats strfmt.Registry) error {
	if swag.IsZero(o.IgroupInlineInitiators) { // not required
		return nil
	}

	for i := 0; i < len(o.IgroupInlineInitiators); i++ {
		if swag.IsZero(o.IgroupInlineInitiators[i]) { // not required
			continue
		}

		if o.IgroupInlineInitiators[i] != nil {
			if err := o.IgroupInlineInitiators[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupModifyCollectionBody) validateIgroupInlineLunMaps(formats strfmt.Registry) error {
	if swag.IsZero(o.IgroupInlineLunMaps) { // not required
		return nil
	}

	for i := 0; i < len(o.IgroupInlineLunMaps); i++ {
		if swag.IsZero(o.IgroupInlineLunMaps[i]) { // not required
			continue
		}

		if o.IgroupInlineLunMaps[i] != nil {
			if err := o.IgroupInlineLunMaps[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupModifyCollectionBody) validateIgroupInlineParentIgroups(formats strfmt.Registry) error {
	if swag.IsZero(o.IgroupInlineParentIgroups) { // not required
		return nil
	}

	for i := 0; i < len(o.IgroupInlineParentIgroups); i++ {
		if swag.IsZero(o.IgroupInlineParentIgroups[i]) { // not required
			continue
		}

		if o.IgroupInlineParentIgroups[i] != nil {
			if err := o.IgroupInlineParentIgroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "parent_igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupModifyCollectionBody) validateIgroupResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.IgroupResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.IgroupResponseInlineRecords); i++ {
		if swag.IsZero(o.IgroupResponseInlineRecords[i]) { // not required
			continue
		}

		if o.IgroupResponseInlineRecords[i] != nil {
			if err := o.IgroupResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

var igroupModifyCollectionBodyTypeOsTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["aix","hpux","hyper_v","linux","netware","openvms","solaris","vmware","windows","xen"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		igroupModifyCollectionBodyTypeOsTypePropEnum = append(igroupModifyCollectionBodyTypeOsTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// IgroupModifyCollectionBody
	// IgroupModifyCollectionBody
	// os_type
	// OsType
	// aix
	// END DEBUGGING
	// IgroupModifyCollectionBodyOsTypeAix captures enum value "aix"
	IgroupModifyCollectionBodyOsTypeAix string = "aix"

	// BEGIN DEBUGGING
	// IgroupModifyCollectionBody
	// IgroupModifyCollectionBody
	// os_type
	// OsType
	// hpux
	// END DEBUGGING
	// IgroupModifyCollectionBodyOsTypeHpux captures enum value "hpux"
	IgroupModifyCollectionBodyOsTypeHpux string = "hpux"

	// BEGIN DEBUGGING
	// IgroupModifyCollectionBody
	// IgroupModifyCollectionBody
	// os_type
	// OsType
	// hyper_v
	// END DEBUGGING
	// IgroupModifyCollectionBodyOsTypeHyperv captures enum value "hyper_v"
	IgroupModifyCollectionBodyOsTypeHyperv string = "hyper_v"

	// BEGIN DEBUGGING
	// IgroupModifyCollectionBody
	// IgroupModifyCollectionBody
	// os_type
	// OsType
	// linux
	// END DEBUGGING
	// IgroupModifyCollectionBodyOsTypeLinux captures enum value "linux"
	IgroupModifyCollectionBodyOsTypeLinux string = "linux"

	// BEGIN DEBUGGING
	// IgroupModifyCollectionBody
	// IgroupModifyCollectionBody
	// os_type
	// OsType
	// netware
	// END DEBUGGING
	// IgroupModifyCollectionBodyOsTypeNetware captures enum value "netware"
	IgroupModifyCollectionBodyOsTypeNetware string = "netware"

	// BEGIN DEBUGGING
	// IgroupModifyCollectionBody
	// IgroupModifyCollectionBody
	// os_type
	// OsType
	// openvms
	// END DEBUGGING
	// IgroupModifyCollectionBodyOsTypeOpenvms captures enum value "openvms"
	IgroupModifyCollectionBodyOsTypeOpenvms string = "openvms"

	// BEGIN DEBUGGING
	// IgroupModifyCollectionBody
	// IgroupModifyCollectionBody
	// os_type
	// OsType
	// solaris
	// END DEBUGGING
	// IgroupModifyCollectionBodyOsTypeSolaris captures enum value "solaris"
	IgroupModifyCollectionBodyOsTypeSolaris string = "solaris"

	// BEGIN DEBUGGING
	// IgroupModifyCollectionBody
	// IgroupModifyCollectionBody
	// os_type
	// OsType
	// vmware
	// END DEBUGGING
	// IgroupModifyCollectionBodyOsTypeVmware captures enum value "vmware"
	IgroupModifyCollectionBodyOsTypeVmware string = "vmware"

	// BEGIN DEBUGGING
	// IgroupModifyCollectionBody
	// IgroupModifyCollectionBody
	// os_type
	// OsType
	// windows
	// END DEBUGGING
	// IgroupModifyCollectionBodyOsTypeWindows captures enum value "windows"
	IgroupModifyCollectionBodyOsTypeWindows string = "windows"

	// BEGIN DEBUGGING
	// IgroupModifyCollectionBody
	// IgroupModifyCollectionBody
	// os_type
	// OsType
	// xen
	// END DEBUGGING
	// IgroupModifyCollectionBodyOsTypeXen captures enum value "xen"
	IgroupModifyCollectionBodyOsTypeXen string = "xen"
)

// prop value enum
func (o *IgroupModifyCollectionBody) validateOsTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, igroupModifyCollectionBodyTypeOsTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *IgroupModifyCollectionBody) validateOsType(formats strfmt.Registry) error {
	if swag.IsZero(o.OsType) { // not required
		return nil
	}

	// value enum
	if err := o.validateOsTypeEnum("info"+"."+"os_type", "body", *o.OsType); err != nil {
		return err
	}

	return nil
}

func (o *IgroupModifyCollectionBody) validatePortset(formats strfmt.Registry) error {
	if swag.IsZero(o.Portset) { // not required
		return nil
	}

	if o.Portset != nil {
		if err := o.Portset.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "portset")
			}
			return err
		}
	}

	return nil
}

var igroupModifyCollectionBodyTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fcp","iscsi","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		igroupModifyCollectionBodyTypeProtocolPropEnum = append(igroupModifyCollectionBodyTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// IgroupModifyCollectionBody
	// IgroupModifyCollectionBody
	// protocol
	// Protocol
	// fcp
	// END DEBUGGING
	// IgroupModifyCollectionBodyProtocolFcp captures enum value "fcp"
	IgroupModifyCollectionBodyProtocolFcp string = "fcp"

	// BEGIN DEBUGGING
	// IgroupModifyCollectionBody
	// IgroupModifyCollectionBody
	// protocol
	// Protocol
	// iscsi
	// END DEBUGGING
	// IgroupModifyCollectionBodyProtocolIscsi captures enum value "iscsi"
	IgroupModifyCollectionBodyProtocolIscsi string = "iscsi"

	// BEGIN DEBUGGING
	// IgroupModifyCollectionBody
	// IgroupModifyCollectionBody
	// protocol
	// Protocol
	// mixed
	// END DEBUGGING
	// IgroupModifyCollectionBodyProtocolMixed captures enum value "mixed"
	IgroupModifyCollectionBodyProtocolMixed string = "mixed"
)

// prop value enum
func (o *IgroupModifyCollectionBody) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, igroupModifyCollectionBodyTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *IgroupModifyCollectionBody) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(o.Protocol) { // not required
		return nil
	}

	// value enum
	if err := o.validateProtocolEnum("info"+"."+"protocol", "body", *o.Protocol); err != nil {
		return err
	}

	return nil
}

func (o *IgroupModifyCollectionBody) validateReplication(formats strfmt.Registry) error {
	if swag.IsZero(o.Replication) { // not required
		return nil
	}

	if o.Replication != nil {
		if err := o.Replication.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupModifyCollectionBody) validateTarget(formats strfmt.Registry) error {
	if swag.IsZero(o.Target) { // not required
		return nil
	}

	if o.Target != nil {
		if err := o.Target.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "target")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup modify collection body based on the context it is used
func (o *IgroupModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConnectivityTracking(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIgroupInlineIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIgroupInlineInitiators(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIgroupInlineLunMaps(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIgroupInlineParentIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIgroupResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePortset(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReplication(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSupportsIgroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTarget(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupModifyCollectionBody) contextValidateConnectivityTracking(ctx context.Context, formats strfmt.Registry) error {

	if o.ConnectivityTracking != nil {
		if err := o.ConnectivityTracking.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "connectivity_tracking")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupModifyCollectionBody) contextValidateIgroupInlineIgroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.IgroupInlineIgroups); i++ {

		if o.IgroupInlineIgroups[i] != nil {
			if err := o.IgroupInlineIgroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupModifyCollectionBody) contextValidateIgroupInlineInitiators(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.IgroupInlineInitiators); i++ {

		if o.IgroupInlineInitiators[i] != nil {
			if err := o.IgroupInlineInitiators[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "initiators" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupModifyCollectionBody) contextValidateIgroupInlineLunMaps(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"lun_maps", "body", []*models.IgroupInlineLunMapsInlineArrayItem(o.IgroupInlineLunMaps)); err != nil {
		return err
	}

	for i := 0; i < len(o.IgroupInlineLunMaps); i++ {

		if o.IgroupInlineLunMaps[i] != nil {
			if err := o.IgroupInlineLunMaps[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "lun_maps" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupModifyCollectionBody) contextValidateIgroupInlineParentIgroups(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"parent_igroups", "body", []*models.IgroupParent(o.IgroupInlineParentIgroups)); err != nil {
		return err
	}

	for i := 0; i < len(o.IgroupInlineParentIgroups); i++ {

		if o.IgroupInlineParentIgroups[i] != nil {
			if err := o.IgroupInlineParentIgroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "parent_igroups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupModifyCollectionBody) contextValidateIgroupResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.IgroupResponseInlineRecords); i++ {

		if o.IgroupResponseInlineRecords[i] != nil {
			if err := o.IgroupResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupModifyCollectionBody) contextValidatePortset(ctx context.Context, formats strfmt.Registry) error {

	if o.Portset != nil {
		if err := o.Portset.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "portset")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupModifyCollectionBody) contextValidateReplication(ctx context.Context, formats strfmt.Registry) error {

	if o.Replication != nil {
		if err := o.Replication.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupModifyCollectionBody) contextValidateSupportsIgroups(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"supports_igroups", "body", o.SupportsIgroups); err != nil {
		return err
	}

	return nil
}

func (o *IgroupModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupModifyCollectionBody) contextValidateTarget(ctx context.Context, formats strfmt.Registry) error {

	if o.Target != nil {
		if err := o.Target.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "target")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res IgroupModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0 igroup modify collection params body connectivity tracking alerts items0
swagger:model IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0
*/
type IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0 struct {

	// summary
	Summary *IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary `json:"summary,omitempty"`
}

// Validate validates this igroup modify collection params body connectivity tracking alerts items0
func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSummary(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0) validateSummary(formats strfmt.Registry) error {
	if swag.IsZero(o.Summary) { // not required
		return nil
	}

	if o.Summary != nil {
		if err := o.Summary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("summary")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup modify collection params body connectivity tracking alerts items0 based on the context it is used
func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSummary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0) contextValidateSummary(ctx context.Context, formats strfmt.Registry) error {

	if o.Summary != nil {
		if err := o.Summary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("summary")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0) UnmarshalBinary(b []byte) error {
	var res IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary A user friendly message describing the connection state of the initiator group.
//
swagger:model IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary
*/
type IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary struct {

	// Message arguments
	// Read Only: true
	Arguments []*models.ErrorArguments `json:"arguments"`

	// Error code
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Error message
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this igroup modify collection params body connectivity tracking alerts items0 summary
func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(o.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(o.Arguments); i++ {
		if swag.IsZero(o.Arguments[i]) { // not required
			continue
		}

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("summary" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this igroup modify collection params body connectivity tracking alerts items0 summary based on the context it is used
func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "summary"+"."+"arguments", "body", []*models.ErrorArguments(o.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(o.Arguments); i++ {

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("summary" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "summary"+"."+"code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "summary"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary) UnmarshalBinary(b []byte) error {
	var res IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0Summary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0 igroup modify collection params body connectivity tracking required nodes items0
swagger:model IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0
*/
type IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0 struct {

	// links
	Links *IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0Links `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup modify collection params body connectivity tracking required nodes items0
func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup modify collection params body connectivity tracking required nodes items0 based on the context it is used
func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0) UnmarshalBinary(b []byte) error {
	var res IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0Links igroup modify collection params body connectivity tracking required nodes items0 links
swagger:model IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0Links
*/
type IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this igroup modify collection params body connectivity tracking required nodes items0 links
func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup modify collection params body connectivity tracking required nodes items0 links based on the context it is used
func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0Links) UnmarshalBinary(b []byte) error {
	var res IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0 A reference to an SVM peer relationship.
swagger:model IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0
*/
type IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0 struct {

	// links
	Links *IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0Links `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup modify collection params body initiators items0 proximity peer svms items0
func (o *IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup modify collection params body initiators items0 proximity peer svms items0 based on the context it is used
func (o *IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0) UnmarshalBinary(b []byte) error {
	var res IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0Links igroup modify collection params body initiators items0 proximity peer svms items0 links
swagger:model IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0Links
*/
type IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this igroup modify collection params body initiators items0 proximity peer svms items0 links
func (o *IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup modify collection params body initiators items0 proximity peer svms items0 links based on the context it is used
func (o *IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0Links) UnmarshalBinary(b []byte) error {
	var res IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineLinks igroup inline links
swagger:model igroup_inline__links
*/
type IgroupInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this igroup inline links
func (o *IgroupInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline links based on the context it is used
func (o *IgroupInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineConnectivityTracking An overview of the connections to ONTAP by the initiators in this group.
//
swagger:model igroup_inline_connectivity_tracking
*/
type IgroupInlineConnectivityTracking struct {

	// alerts
	// Read Only: true
	Alerts []*IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0 `json:"alerts,omitempty"`

	// Connection state.
	//
	// Read Only: true
	// Enum: ["full","none","partial","no_initiators","no_lun_maps"]
	ConnectionState *string `json:"connection_state,omitempty"`

	// Nodes to which the initiators in this group should be connected to ensure reliable service. This is the collection of any node hosting a LUN mapped to this igroup as well as the HA partners of those nodes.
	//
	// Read Only: true
	RequiredNodes []*IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0 `json:"required_nodes,omitempty"`
}

// Validate validates this igroup inline connectivity tracking
func (o *IgroupInlineConnectivityTracking) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAlerts(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConnectionState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRequiredNodes(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineConnectivityTracking) validateAlerts(formats strfmt.Registry) error {
	if swag.IsZero(o.Alerts) { // not required
		return nil
	}

	for i := 0; i < len(o.Alerts); i++ {
		if swag.IsZero(o.Alerts[i]) { // not required
			continue
		}

		if o.Alerts[i] != nil {
			if err := o.Alerts[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "connectivity_tracking" + "." + "alerts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var igroupInlineConnectivityTrackingTypeConnectionStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["full","none","partial","no_initiators","no_lun_maps"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		igroupInlineConnectivityTrackingTypeConnectionStatePropEnum = append(igroupInlineConnectivityTrackingTypeConnectionStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// igroup_inline_connectivity_tracking
	// IgroupInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// full
	// END DEBUGGING
	// IgroupInlineConnectivityTrackingConnectionStateFull captures enum value "full"
	IgroupInlineConnectivityTrackingConnectionStateFull string = "full"

	// BEGIN DEBUGGING
	// igroup_inline_connectivity_tracking
	// IgroupInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// none
	// END DEBUGGING
	// IgroupInlineConnectivityTrackingConnectionStateNone captures enum value "none"
	IgroupInlineConnectivityTrackingConnectionStateNone string = "none"

	// BEGIN DEBUGGING
	// igroup_inline_connectivity_tracking
	// IgroupInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// partial
	// END DEBUGGING
	// IgroupInlineConnectivityTrackingConnectionStatePartial captures enum value "partial"
	IgroupInlineConnectivityTrackingConnectionStatePartial string = "partial"

	// BEGIN DEBUGGING
	// igroup_inline_connectivity_tracking
	// IgroupInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// no_initiators
	// END DEBUGGING
	// IgroupInlineConnectivityTrackingConnectionStateNoInitiators captures enum value "no_initiators"
	IgroupInlineConnectivityTrackingConnectionStateNoInitiators string = "no_initiators"

	// BEGIN DEBUGGING
	// igroup_inline_connectivity_tracking
	// IgroupInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// no_lun_maps
	// END DEBUGGING
	// IgroupInlineConnectivityTrackingConnectionStateNoLunMaps captures enum value "no_lun_maps"
	IgroupInlineConnectivityTrackingConnectionStateNoLunMaps string = "no_lun_maps"
)

// prop value enum
func (o *IgroupInlineConnectivityTracking) validateConnectionStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, igroupInlineConnectivityTrackingTypeConnectionStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *IgroupInlineConnectivityTracking) validateConnectionState(formats strfmt.Registry) error {
	if swag.IsZero(o.ConnectionState) { // not required
		return nil
	}

	// value enum
	if err := o.validateConnectionStateEnum("info"+"."+"connectivity_tracking"+"."+"connection_state", "body", *o.ConnectionState); err != nil {
		return err
	}

	return nil
}

func (o *IgroupInlineConnectivityTracking) validateRequiredNodes(formats strfmt.Registry) error {
	if swag.IsZero(o.RequiredNodes) { // not required
		return nil
	}

	for i := 0; i < len(o.RequiredNodes); i++ {
		if swag.IsZero(o.RequiredNodes[i]) { // not required
			continue
		}

		if o.RequiredNodes[i] != nil {
			if err := o.RequiredNodes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "connectivity_tracking" + "." + "required_nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this igroup inline connectivity tracking based on the context it is used
func (o *IgroupInlineConnectivityTracking) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAlerts(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConnectionState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRequiredNodes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineConnectivityTracking) contextValidateAlerts(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"connectivity_tracking"+"."+"alerts", "body", []*IgroupModifyCollectionParamsBodyConnectivityTrackingAlertsItems0(o.Alerts)); err != nil {
		return err
	}

	for i := 0; i < len(o.Alerts); i++ {

		if o.Alerts[i] != nil {
			if err := o.Alerts[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "connectivity_tracking" + "." + "alerts" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupInlineConnectivityTracking) contextValidateConnectionState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"connectivity_tracking"+"."+"connection_state", "body", o.ConnectionState); err != nil {
		return err
	}

	return nil
}

func (o *IgroupInlineConnectivityTracking) contextValidateRequiredNodes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"connectivity_tracking"+"."+"required_nodes", "body", []*IgroupModifyCollectionParamsBodyConnectivityTrackingRequiredNodesItems0(o.RequiredNodes)); err != nil {
		return err
	}

	for i := 0; i < len(o.RequiredNodes); i++ {

		if o.RequiredNodes[i] != nil {
			if err := o.RequiredNodes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "connectivity_tracking" + "." + "required_nodes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineConnectivityTracking) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineConnectivityTracking) UnmarshalBinary(b []byte) error {
	var res IgroupInlineConnectivityTracking
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineInitiatorsInlineArrayItem igroup inline initiators inline array item
swagger:model igroup_inline_initiators_inline_array_item
*/
type IgroupInlineInitiatorsInlineArrayItem struct {

	// links
	Links *models.IgroupInlineInitiatorsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// A comment available for use by the administrator. Valid in POST and PATCH.
	//
	// Max Length: 254
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// connectivity tracking
	ConnectivityTracking *models.IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking `json:"connectivity_tracking,omitempty"`

	// igroup
	Igroup *models.IgroupInlineInitiatorsInlineArrayItemInlineIgroup `json:"igroup,omitempty"`

	// The FC WWPN, iSCSI IQN, or iSCSI EUI that identifies the host initiator. Valid in POST only and not allowed when the `records` property is used.<br/>
	// An FC WWPN consists of 16 hexadecimal digits grouped as 8 pairs separated by colons. The format for an iSCSI IQN is _iqn.yyyy-mm.reverse_domain_name:any_. The iSCSI EUI format consists of the _eui._ prefix followed by 16 hexadecimal characters.
	//
	// Example: iqn.1998-01.com.corp.iscsi:name1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// proximity
	Proximity *models.IgroupInlineInitiatorsInlineArrayItemInlineProximity `json:"proximity,omitempty"`
}

// Validate validates this igroup inline initiators inline array item
func (o *IgroupInlineInitiatorsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConnectivityTracking(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProximity(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItem) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("comment", "body", *o.Comment, 254); err != nil {
		return err
	}

	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItem) validateConnectivityTracking(formats strfmt.Registry) error {
	if swag.IsZero(o.ConnectivityTracking) { // not required
		return nil
	}

	if o.ConnectivityTracking != nil {
		if err := o.ConnectivityTracking.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity_tracking")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItem) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(o.Igroup) { // not required
		return nil
	}

	if o.Igroup != nil {
		if err := o.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItem) validateProximity(formats strfmt.Registry) error {
	if swag.IsZero(o.Proximity) { // not required
		return nil
	}

	if o.Proximity != nil {
		if err := o.Proximity.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline initiators inline array item based on the context it is used
func (o *IgroupInlineInitiatorsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateConnectivityTracking(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProximity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItem) contextValidateConnectivityTracking(ctx context.Context, formats strfmt.Registry) error {

	if o.ConnectivityTracking != nil {
		if err := o.ConnectivityTracking.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("connectivity_tracking")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItem) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if o.Igroup != nil {
		if err := o.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItem) contextValidateProximity(ctx context.Context, formats strfmt.Registry) error {

	if o.Proximity != nil {
		if err := o.Proximity.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("proximity")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineInitiatorsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineInitiatorsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res IgroupInlineInitiatorsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineInitiatorsInlineArrayItemInlineLinks igroup inline initiators inline array item inline links
swagger:model igroup_inline_initiators_inline_array_item_inline__links
*/
type IgroupInlineInitiatorsInlineArrayItemInlineLinks struct {

	// connectivity tracking
	ConnectivityTracking *models.IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineConnectivityTracking `json:"connectivity_tracking,omitempty"`

	// self
	Self *models.IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineSelf `json:"self,omitempty"`
}

// Validate validates this igroup inline initiators inline array item inline links
func (o *IgroupInlineInitiatorsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateConnectivityTracking(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItemInlineLinks) validateConnectivityTracking(formats strfmt.Registry) error {
	if swag.IsZero(o.ConnectivityTracking) { // not required
		return nil
	}

	if o.ConnectivityTracking != nil {
		if err := o.ConnectivityTracking.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "connectivity_tracking")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline initiators inline array item inline links based on the context it is used
func (o *IgroupInlineInitiatorsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateConnectivityTracking(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItemInlineLinks) contextValidateConnectivityTracking(ctx context.Context, formats strfmt.Registry) error {

	if o.ConnectivityTracking != nil {
		if err := o.ConnectivityTracking.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "connectivity_tracking")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineInitiatorsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineInitiatorsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInlineInitiatorsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineConnectivityTracking A link to the initiator with connectivity information relevant to its membership of this initiator group.
//
swagger:model igroup_inline_initiators_inline_array_item_inline__links_inline_connectivity_tracking
*/
type IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineConnectivityTracking struct {

	// href
	// Example: /api/resourcelink
	// Read Only: true
	Href *string `json:"href,omitempty"`
}

// Validate validates this igroup inline initiators inline array item inline links inline connectivity tracking
func (o *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineConnectivityTracking) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this igroup inline initiators inline array item inline links inline connectivity tracking based on the context it is used
func (o *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineConnectivityTracking) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateHref(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineConnectivityTracking) contextValidateHref(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "_links"+"."+"connectivity_tracking"+"."+"href", "body", o.Href); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineConnectivityTracking) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineConnectivityTracking) UnmarshalBinary(b []byte) error {
	var res IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineConnectivityTracking
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineSelf A link to the initiator where mutations can be made. If the initiator is inherited from a nested initiator group, the link refers to the initiator in the nested initiator group. In this case, mutations of the initiator will be applied to all initiator groups referencing the same nested initiator group.
//
swagger:model igroup_inline_initiators_inline_array_item_inline__links_inline_self
*/
type IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineSelf struct {

	// href
	// Example: /api/resourcelink
	// Read Only: true
	Href *string `json:"href,omitempty"`
}

// Validate validates this igroup inline initiators inline array item inline links inline self
func (o *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineSelf) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this igroup inline initiators inline array item inline links inline self based on the context it is used
func (o *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineSelf) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateHref(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineSelf) contextValidateHref(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "_links"+"."+"self"+"."+"href", "body", o.Href); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineSelf) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineSelf) UnmarshalBinary(b []byte) error {
	var res IgroupInlineInitiatorsInlineArrayItemInlineLinksInlineSelf
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking Overview of the initiator's connections to ONTAP.
//
swagger:model igroup_inline_initiators_inline_array_item_inline_connectivity_tracking
*/
type IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking struct {

	// Connection state.
	//
	// Read Only: true
	// Enum: ["full","none","partial","no_lun_maps"]
	ConnectionState *string `json:"connection_state,omitempty"`
}

// Validate validates this igroup inline initiators inline array item inline connectivity tracking
func (o *IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateConnectionState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var igroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingTypeConnectionStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["full","none","partial","no_lun_maps"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		igroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingTypeConnectionStatePropEnum = append(igroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingTypeConnectionStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// igroup_inline_initiators_inline_array_item_inline_connectivity_tracking
	// IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// full
	// END DEBUGGING
	// IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingConnectionStateFull captures enum value "full"
	IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingConnectionStateFull string = "full"

	// BEGIN DEBUGGING
	// igroup_inline_initiators_inline_array_item_inline_connectivity_tracking
	// IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// none
	// END DEBUGGING
	// IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingConnectionStateNone captures enum value "none"
	IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingConnectionStateNone string = "none"

	// BEGIN DEBUGGING
	// igroup_inline_initiators_inline_array_item_inline_connectivity_tracking
	// IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// partial
	// END DEBUGGING
	// IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingConnectionStatePartial captures enum value "partial"
	IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingConnectionStatePartial string = "partial"

	// BEGIN DEBUGGING
	// igroup_inline_initiators_inline_array_item_inline_connectivity_tracking
	// IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking
	// connection_state
	// ConnectionState
	// no_lun_maps
	// END DEBUGGING
	// IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingConnectionStateNoLunMaps captures enum value "no_lun_maps"
	IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingConnectionStateNoLunMaps string = "no_lun_maps"
)

// prop value enum
func (o *IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking) validateConnectionStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, igroupInlineInitiatorsInlineArrayItemInlineConnectivityTrackingTypeConnectionStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking) validateConnectionState(formats strfmt.Registry) error {
	if swag.IsZero(o.ConnectionState) { // not required
		return nil
	}

	// value enum
	if err := o.validateConnectionStateEnum("connectivity_tracking"+"."+"connection_state", "body", *o.ConnectionState); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this igroup inline initiators inline array item inline connectivity tracking based on the context it is used
func (o *IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateConnectionState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking) contextValidateConnectionState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "connectivity_tracking"+"."+"connection_state", "body", o.ConnectionState); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking) UnmarshalBinary(b []byte) error {
	var res IgroupInlineInitiatorsInlineArrayItemInlineConnectivityTracking
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineInitiatorsInlineArrayItemInlineIgroup The initiator group that directly owns the initiator, which is where modification of the initiator is supported. This property will only be populated when the initiator is a member of a nested initiator group.
//
swagger:model igroup_inline_initiators_inline_array_item_inline_igroup
*/
type IgroupInlineInitiatorsInlineArrayItemInlineIgroup struct {

	// links
	Links *models.IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks `json:"_links,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup inline initiators inline array item inline igroup
func (o *IgroupInlineInitiatorsInlineArrayItemInlineIgroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItemInlineIgroup) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItemInlineIgroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("igroup"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("igroup"+"."+"name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this igroup inline initiators inline array item inline igroup based on the context it is used
func (o *IgroupInlineInitiatorsInlineArrayItemInlineIgroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItemInlineIgroup) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineInitiatorsInlineArrayItemInlineIgroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineInitiatorsInlineArrayItemInlineIgroup) UnmarshalBinary(b []byte) error {
	var res IgroupInlineInitiatorsInlineArrayItemInlineIgroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks igroup inline initiators inline array item inline igroup inline links
swagger:model igroup_inline_initiators_inline_array_item_inline_igroup_inline__links
*/
type IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this igroup inline initiators inline array item inline igroup inline links
func (o *IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline initiators inline array item inline igroup inline links based on the context it is used
func (o *IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("igroup" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInlineInitiatorsInlineArrayItemInlineIgroupInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineInitiatorsInlineArrayItemInlineProximity Properties that define to what SVMs the initiator is proximal. This information is used to properly report active optimized and active non-optimized network paths via ALUA. If no configuration has been specified for an initiator, the sub-object will not be present in GET.<br/>
// These properties can be set via initiator group POST and PATCH and apply to all instances of the initiator in all initiator groups in the SVM and its peers. The `proximity` sub-object for an initiator is set in POST and PATCH in its entirety and replaces any previously set proximity for the initiator within the SVM for the initiator within the SVM. The `local_svm` property must always be set to `true` or `false` when setting the `proximity` property. To clear any previously set proximity, POST or PATCH the `proximity` object to `null`.
//
swagger:model igroup_inline_initiators_inline_array_item_inline_proximity
*/
type IgroupInlineInitiatorsInlineArrayItemInlineProximity struct {

	// A boolean that indicates if the initiator is proximal to the SVM of the containing initiator group. This is required for any POST or PATCH that includes the `proximity` sub-object.
	//
	LocalSvm *bool `json:"local_svm,omitempty"`

	// An array of remote peer SVMs to which the initiator is proximal.
	//
	PeerSvms []*IgroupModifyCollectionParamsBodyInitiatorsItems0ProximityPeerSvmsItems0 `json:"peer_svms"`
}

// Validate validates this igroup inline initiators inline array item inline proximity
func (o *IgroupInlineInitiatorsInlineArrayItemInlineProximity) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validatePeerSvms(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItemInlineProximity) validatePeerSvms(formats strfmt.Registry) error {
	if swag.IsZero(o.PeerSvms) { // not required
		return nil
	}

	for i := 0; i < len(o.PeerSvms); i++ {
		if swag.IsZero(o.PeerSvms[i]) { // not required
			continue
		}

		if o.PeerSvms[i] != nil {
			if err := o.PeerSvms[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this igroup inline initiators inline array item inline proximity based on the context it is used
func (o *IgroupInlineInitiatorsInlineArrayItemInlineProximity) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePeerSvms(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineInitiatorsInlineArrayItemInlineProximity) contextValidatePeerSvms(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.PeerSvms); i++ {

		if o.PeerSvms[i] != nil {
			if err := o.PeerSvms[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("proximity" + "." + "peer_svms" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineInitiatorsInlineArrayItemInlineProximity) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineInitiatorsInlineArrayItemInlineProximity) UnmarshalBinary(b []byte) error {
	var res IgroupInlineInitiatorsInlineArrayItemInlineProximity
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineLunMapsInlineArrayItem A LUN map with which the initiator group is associated.
//
swagger:model igroup_inline_lun_maps_inline_array_item
*/
type IgroupInlineLunMapsInlineArrayItem struct {

	// links
	Links *models.IgroupInlineLunMapsInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// The logical unit number assigned to the LUN for initiators in the initiator group.
	//
	// Read Only: true
	LogicalUnitNumber *int64 `json:"logical_unit_number,omitempty"`

	// lun
	Lun *models.IgroupInlineLunMapsInlineArrayItemInlineLun `json:"lun,omitempty"`
}

// Validate validates this igroup inline lun maps inline array item
func (o *IgroupInlineLunMapsInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLun(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItem) validateLun(formats strfmt.Registry) error {
	if swag.IsZero(o.Lun) { // not required
		return nil
	}

	if o.Lun != nil {
		if err := o.Lun.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline lun maps inline array item based on the context it is used
func (o *IgroupInlineLunMapsInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLogicalUnitNumber(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLun(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItem) contextValidateLogicalUnitNumber(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "logical_unit_number", "body", o.LogicalUnitNumber); err != nil {
		return err
	}

	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItem) contextValidateLun(ctx context.Context, formats strfmt.Registry) error {

	if o.Lun != nil {
		if err := o.Lun.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineLunMapsInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineLunMapsInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res IgroupInlineLunMapsInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineLunMapsInlineArrayItemInlineLinks igroup inline lun maps inline array item inline links
swagger:model igroup_inline_lun_maps_inline_array_item_inline__links
*/
type IgroupInlineLunMapsInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this igroup inline lun maps inline array item inline links
func (o *IgroupInlineLunMapsInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline lun maps inline array item inline links based on the context it is used
func (o *IgroupInlineLunMapsInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineLunMapsInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineLunMapsInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInlineLunMapsInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineLunMapsInlineArrayItemInlineLun The LUN to which the initiator group is mapped.
//
swagger:model igroup_inline_lun_maps_inline_array_item_inline_lun
*/
type IgroupInlineLunMapsInlineArrayItemInlineLun struct {

	// links
	Links *models.IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks `json:"_links,omitempty"`

	// The name of the LUN.
	//
	// Example: lun1
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// node
	Node *models.IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode `json:"node,omitempty"`

	// The unique identifier of the LUN.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup inline lun maps inline array item inline lun
func (o *IgroupInlineLunMapsInlineArrayItemInlineLun) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItemInlineLun) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItemInlineLun) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "node")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline lun maps inline array item inline lun based on the context it is used
func (o *IgroupInlineLunMapsInlineArrayItemInlineLun) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItemInlineLun) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItemInlineLun) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "lun"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItemInlineLun) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItemInlineLun) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "lun"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineLunMapsInlineArrayItemInlineLun) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineLunMapsInlineArrayItemInlineLun) UnmarshalBinary(b []byte) error {
	var res IgroupInlineLunMapsInlineArrayItemInlineLun
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks igroup inline lun maps inline array item inline lun inline links
swagger:model igroup_inline_lun_maps_inline_array_item_inline_lun_inline__links
*/
type IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this igroup inline lun maps inline array item inline lun inline links
func (o *IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline lun maps inline array item inline lun inline links based on the context it is used
func (o *IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInlineLunMapsInlineArrayItemInlineLunInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode igroup inline lun maps inline array item inline lun inline node
swagger:model igroup_inline_lun_maps_inline_array_item_inline_lun_inline_node
*/
type IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode struct {

	// links
	Links *models.IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup inline lun maps inline array item inline lun inline node
func (o *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline lun maps inline array item inline lun inline node based on the context it is used
func (o *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode) UnmarshalBinary(b []byte) error {
	var res IgroupInlineLunMapsInlineArrayItemInlineLunInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks igroup inline lun maps inline array item inline lun inline node inline links
swagger:model igroup_inline_lun_maps_inline_array_item_inline_lun_inline_node_inline__links
*/
type IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this igroup inline lun maps inline array item inline lun inline node inline links
func (o *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline lun maps inline array item inline lun inline node inline links based on the context it is used
func (o *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("lun" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInlineLunMapsInlineArrayItemInlineLunInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlinePortset The portset to which the initiator group is bound. Binding the initiator group to a portset restricts the initiators of the group to accessing mapped LUNs only through network interfaces in the portset.<br/>
// In a nested initiator group hierarchy, only a portset bound to the initiator group at the same level at which it is mapped, applies; portsets bound to parent or child initiator groups are ignored.<br/>
// Optional in POST and PATCH. To unbind a portset from the initiator group, PATCH the `portset` object to  `null`, or PATCH `portset.name` to an empty string ("").
//
swagger:model igroup_inline_portset
*/
type IgroupInlinePortset struct {

	// links
	Links *models.IgroupInlinePortsetInlineLinks `json:"_links,omitempty"`

	// The name of the portset.
	//
	// Example: portset1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the portset.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup inline portset
func (o *IgroupInlinePortset) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlinePortset) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "portset" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlinePortset) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"portset"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"portset"+"."+"name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this igroup inline portset based on the context it is used
func (o *IgroupInlinePortset) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlinePortset) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "portset" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlinePortset) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlinePortset) UnmarshalBinary(b []byte) error {
	var res IgroupInlinePortset
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlinePortsetInlineLinks igroup inline portset inline links
swagger:model igroup_inline_portset_inline__links
*/
type IgroupInlinePortsetInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this igroup inline portset inline links
func (o *IgroupInlinePortsetInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlinePortsetInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "portset" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline portset inline links based on the context it is used
func (o *IgroupInlinePortsetInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlinePortsetInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "portset" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlinePortsetInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlinePortsetInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInlinePortsetInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineReplication Properties related to initiator group replication.
//
swagger:model igroup_inline_replication
*/
type IgroupInlineReplication struct {

	// error
	Error *models.IgroupInlineReplicationInlineError `json:"error,omitempty"`

	// peer svm
	PeerSvm *models.IgroupInlineReplicationInlinePeerSvm `json:"peer_svm,omitempty"`

	// The state of the replication queue associated with this igroup. If this igroup is not in the replication queue, the state is reported as _ok_. If this igroup is in the replication queue, but no errors have been encountered, the state is reported as _replicating_. If this igroup is in the replication queue and the queue is blocked by an error, the state is reported as _error_. When in the _error_ state, additional context is provided by the `replication.error` property.
	//
	// Read Only: true
	// Enum: ["ok","replicating","error"]
	State *string `json:"state,omitempty"`
}

// Validate validates this igroup inline replication
func (o *IgroupInlineReplication) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePeerSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineReplication) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineReplication) validatePeerSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.PeerSvm) { // not required
		return nil
	}

	if o.PeerSvm != nil {
		if err := o.PeerSvm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "peer_svm")
			}
			return err
		}
	}

	return nil
}

var igroupInlineReplicationTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","replicating","error"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		igroupInlineReplicationTypeStatePropEnum = append(igroupInlineReplicationTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// igroup_inline_replication
	// IgroupInlineReplication
	// state
	// State
	// ok
	// END DEBUGGING
	// IgroupInlineReplicationStateOk captures enum value "ok"
	IgroupInlineReplicationStateOk string = "ok"

	// BEGIN DEBUGGING
	// igroup_inline_replication
	// IgroupInlineReplication
	// state
	// State
	// replicating
	// END DEBUGGING
	// IgroupInlineReplicationStateReplicating captures enum value "replicating"
	IgroupInlineReplicationStateReplicating string = "replicating"

	// BEGIN DEBUGGING
	// igroup_inline_replication
	// IgroupInlineReplication
	// state
	// State
	// error
	// END DEBUGGING
	// IgroupInlineReplicationStateError captures enum value "error"
	IgroupInlineReplicationStateError string = "error"
)

// prop value enum
func (o *IgroupInlineReplication) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, igroupInlineReplicationTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *IgroupInlineReplication) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"replication"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this igroup inline replication based on the context it is used
func (o *IgroupInlineReplication) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePeerSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineReplication) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineReplication) contextValidatePeerSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.PeerSvm != nil {
		if err := o.PeerSvm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "peer_svm")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineReplication) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"replication"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineReplication) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineReplication) UnmarshalBinary(b []byte) error {
	var res IgroupInlineReplication
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineReplicationInlineError Information about asynchronous errors encountered while replicating this igroup. Igroups within a peering relationship are replicated in the same stream, so the error reported here might be related to this igroup or a prior replicated igroup that is now blocking the replication of this igroup. Both the error information and the igroup encountering the error are reported. If the error is configuration related, it can be corrected on the referenced igroup. The replication is retried using exponential backoff up to a maximum of one retry every 5 minutes. Every operation on the same stream triggers an immediate retry and restarts the exponential backoff starting with a 1 second delay. If the error is system related, the retries should correct the error when the system enters a healthy state.
//
swagger:model igroup_inline_replication_inline_error
*/
type IgroupInlineReplicationInlineError struct {

	// igroup
	Igroup *models.IgroupInlineReplicationInlineErrorInlineIgroup `json:"igroup,omitempty"`

	// summary
	Summary *models.IgroupInlineReplicationInlineErrorInlineSummary `json:"summary,omitempty"`
}

// Validate validates this igroup inline replication inline error
func (o *IgroupInlineReplicationInlineError) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIgroup(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSummary(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineReplicationInlineError) validateIgroup(formats strfmt.Registry) error {
	if swag.IsZero(o.Igroup) { // not required
		return nil
	}

	if o.Igroup != nil {
		if err := o.Igroup.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "error" + "." + "igroup")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineReplicationInlineError) validateSummary(formats strfmt.Registry) error {
	if swag.IsZero(o.Summary) { // not required
		return nil
	}

	if o.Summary != nil {
		if err := o.Summary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "error" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline replication inline error based on the context it is used
func (o *IgroupInlineReplicationInlineError) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIgroup(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSummary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineReplicationInlineError) contextValidateIgroup(ctx context.Context, formats strfmt.Registry) error {

	if o.Igroup != nil {
		if err := o.Igroup.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "error" + "." + "igroup")
			}
			return err
		}
	}

	return nil
}

func (o *IgroupInlineReplicationInlineError) contextValidateSummary(ctx context.Context, formats strfmt.Registry) error {

	if o.Summary != nil {
		if err := o.Summary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "error" + "." + "summary")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineReplicationInlineError) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineReplicationInlineError) UnmarshalBinary(b []byte) error {
	var res IgroupInlineReplicationInlineError
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineReplicationInlineErrorInlineIgroup igroup inline replication inline error inline igroup
swagger:model igroup_inline_replication_inline_error_inline_igroup
*/
type IgroupInlineReplicationInlineErrorInlineIgroup struct {

	// Indicates whether the reported igroup is on the local SVM or the peer SVM. When deleting a replicated igroup, the local copy is deleted first and then the peer copy is deleted. If the error is encountered between these two operations and only the peer igroup remains, the peer igroup is reported and the problem might need to be corrected on the peer cluster.
	//
	// Read Only: true
	LocalSvm *bool `json:"local_svm,omitempty"`

	// The name of the initiator group.
	//
	// Example: igroup1
	// Max Length: 96
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the initiator group.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup inline replication inline error inline igroup
func (o *IgroupInlineReplicationInlineErrorInlineIgroup) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineReplicationInlineErrorInlineIgroup) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"replication"+"."+"error"+"."+"igroup"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"replication"+"."+"error"+"."+"igroup"+"."+"name", "body", *o.Name, 96); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this igroup inline replication inline error inline igroup based on the context it is used
func (o *IgroupInlineReplicationInlineErrorInlineIgroup) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocalSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineReplicationInlineErrorInlineIgroup) contextValidateLocalSvm(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"replication"+"."+"error"+"."+"igroup"+"."+"local_svm", "body", o.LocalSvm); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineReplicationInlineErrorInlineIgroup) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineReplicationInlineErrorInlineIgroup) UnmarshalBinary(b []byte) error {
	var res IgroupInlineReplicationInlineErrorInlineIgroup
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineReplicationInlineErrorInlineSummary A user friendly message describing the error.
//
swagger:model igroup_inline_replication_inline_error_inline_summary
*/
type IgroupInlineReplicationInlineErrorInlineSummary struct {

	// Message arguments
	// Read Only: true
	Arguments []*models.ErrorArguments `json:"arguments,omitempty"`

	// Error code
	// Example: 4
	// Read Only: true
	Code *string `json:"code,omitempty"`

	// Error message
	// Example: entry doesn't exist
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this igroup inline replication inline error inline summary
func (o *IgroupInlineReplicationInlineErrorInlineSummary) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateArguments(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineReplicationInlineErrorInlineSummary) validateArguments(formats strfmt.Registry) error {
	if swag.IsZero(o.Arguments) { // not required
		return nil
	}

	for i := 0; i < len(o.Arguments); i++ {
		if swag.IsZero(o.Arguments[i]) { // not required
			continue
		}

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "replication" + "." + "error" + "." + "summary" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this igroup inline replication inline error inline summary based on the context it is used
func (o *IgroupInlineReplicationInlineErrorInlineSummary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateArguments(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineReplicationInlineErrorInlineSummary) contextValidateArguments(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"replication"+"."+"error"+"."+"summary"+"."+"arguments", "body", []*models.ErrorArguments(o.Arguments)); err != nil {
		return err
	}

	for i := 0; i < len(o.Arguments); i++ {

		if o.Arguments[i] != nil {
			if err := o.Arguments[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "replication" + "." + "error" + "." + "summary" + "." + "arguments" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *IgroupInlineReplicationInlineErrorInlineSummary) contextValidateCode(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"replication"+"."+"error"+"."+"summary"+"."+"code", "body", o.Code); err != nil {
		return err
	}

	return nil
}

func (o *IgroupInlineReplicationInlineErrorInlineSummary) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"replication"+"."+"error"+"."+"summary"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineReplicationInlineErrorInlineSummary) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineReplicationInlineErrorInlineSummary) UnmarshalBinary(b []byte) error {
	var res IgroupInlineReplicationInlineErrorInlineSummary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineReplicationInlinePeerSvm The peered SVM to which the initiator group should be replicated. Optional in POST and PATCH. To clear any previously set replication peer, PATCH the `replication.peer_svm` object to `null`.
//
swagger:model igroup_inline_replication_inline_peer_svm
*/
type IgroupInlineReplicationInlinePeerSvm struct {

	// links
	Links *models.IgroupInlineReplicationInlinePeerSvmInlineLinks `json:"_links,omitempty"`

	// The local name of the peer SVM. This name is unique among all local and peer SVMs.
	//
	// Example: peer1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM peer relationship. This is the UUID of the relationship, not the UUID of the peer SVM itself.
	//
	// Example: 4204cf77-4c82-9bdb-5644-b5a841c097a9
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup inline replication inline peer svm
func (o *IgroupInlineReplicationInlinePeerSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineReplicationInlinePeerSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "peer_svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline replication inline peer svm based on the context it is used
func (o *IgroupInlineReplicationInlinePeerSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineReplicationInlinePeerSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "peer_svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineReplicationInlinePeerSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineReplicationInlinePeerSvm) UnmarshalBinary(b []byte) error {
	var res IgroupInlineReplicationInlinePeerSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineReplicationInlinePeerSvmInlineLinks igroup inline replication inline peer svm inline links
swagger:model igroup_inline_replication_inline_peer_svm_inline__links
*/
type IgroupInlineReplicationInlinePeerSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this igroup inline replication inline peer svm inline links
func (o *IgroupInlineReplicationInlinePeerSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineReplicationInlinePeerSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "peer_svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline replication inline peer svm inline links based on the context it is used
func (o *IgroupInlineReplicationInlinePeerSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineReplicationInlinePeerSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "replication" + "." + "peer_svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineReplicationInlinePeerSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineReplicationInlinePeerSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInlineReplicationInlinePeerSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model igroup_inline_svm
*/
type IgroupInlineSvm struct {

	// links
	Links *models.IgroupInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this igroup inline svm
func (o *IgroupInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline svm based on the context it is used
func (o *IgroupInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineSvm) UnmarshalBinary(b []byte) error {
	var res IgroupInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineSvmInlineLinks igroup inline svm inline links
swagger:model igroup_inline_svm_inline__links
*/
type IgroupInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this igroup inline svm inline links
func (o *IgroupInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this igroup inline svm inline links based on the context it is used
func (o *IgroupInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res IgroupInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
IgroupInlineTarget Properties of the SCSI target to which the initiator group provides access.
//
swagger:model igroup_inline_target
*/
type IgroupInlineTarget struct {

	// The firmware revision of the SCSI target specific to the OS type of the initiator group.
	//
	// Example: 9111
	// Read Only: true
	FirmwareRevision *string `json:"firmware_revision,omitempty"`

	// The product ID of the SCSI target.
	//
	// Example: LUN C-Mode
	// Read Only: true
	ProductID *string `json:"product_id,omitempty"`

	// The vendor ID of the SCSI target.
	//
	// Example: NETAPP
	// Read Only: true
	VendorID *string `json:"vendor_id,omitempty"`
}

// Validate validates this igroup inline target
func (o *IgroupInlineTarget) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this igroup inline target based on the context it is used
func (o *IgroupInlineTarget) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateFirmwareRevision(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProductID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVendorID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *IgroupInlineTarget) contextValidateFirmwareRevision(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"target"+"."+"firmware_revision", "body", o.FirmwareRevision); err != nil {
		return err
	}

	return nil
}

func (o *IgroupInlineTarget) contextValidateProductID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"target"+"."+"product_id", "body", o.ProductID); err != nil {
		return err
	}

	return nil
}

func (o *IgroupInlineTarget) contextValidateVendorID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"target"+"."+"vendor_id", "body", o.VendorID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *IgroupInlineTarget) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *IgroupInlineTarget) UnmarshalBinary(b []byte) error {
	var res IgroupInlineTarget
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
