// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IgroupNestedCollectionGetReader is a Reader for the IgroupNestedCollectionGet structure.
type IgroupNestedCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IgroupNestedCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIgroupNestedCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIgroupNestedCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIgroupNestedCollectionGetOK creates a IgroupNestedCollectionGetOK with default headers values
func NewIgroupNestedCollectionGetOK() *IgroupNestedCollectionGetOK {
	return &IgroupNestedCollectionGetOK{}
}

/*
IgroupNestedCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type IgroupNestedCollectionGetOK struct {
	Payload *models.IgroupNestedResponse
}

// IsSuccess returns true when this igroup nested collection get o k response has a 2xx status code
func (o *IgroupNestedCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this igroup nested collection get o k response has a 3xx status code
func (o *IgroupNestedCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this igroup nested collection get o k response has a 4xx status code
func (o *IgroupNestedCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this igroup nested collection get o k response has a 5xx status code
func (o *IgroupNestedCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this igroup nested collection get o k response a status code equal to that given
func (o *IgroupNestedCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the igroup nested collection get o k response
func (o *IgroupNestedCollectionGetOK) Code() int {
	return 200
}

func (o *IgroupNestedCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/igroups/{igroup.uuid}/igroups][%d] igroupNestedCollectionGetOK %s", 200, payload)
}

func (o *IgroupNestedCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/igroups/{igroup.uuid}/igroups][%d] igroupNestedCollectionGetOK %s", 200, payload)
}

func (o *IgroupNestedCollectionGetOK) GetPayload() *models.IgroupNestedResponse {
	return o.Payload
}

func (o *IgroupNestedCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.IgroupNestedResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewIgroupNestedCollectionGetDefault creates a IgroupNestedCollectionGetDefault with default headers values
func NewIgroupNestedCollectionGetDefault(code int) *IgroupNestedCollectionGetDefault {
	return &IgroupNestedCollectionGetDefault{
		_statusCode: code,
	}
}

/*
	IgroupNestedCollectionGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5374852 | The initiator group specified in the URI does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IgroupNestedCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this igroup nested collection get default response has a 2xx status code
func (o *IgroupNestedCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this igroup nested collection get default response has a 3xx status code
func (o *IgroupNestedCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this igroup nested collection get default response has a 4xx status code
func (o *IgroupNestedCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this igroup nested collection get default response has a 5xx status code
func (o *IgroupNestedCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this igroup nested collection get default response a status code equal to that given
func (o *IgroupNestedCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the igroup nested collection get default response
func (o *IgroupNestedCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *IgroupNestedCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/igroups/{igroup.uuid}/igroups][%d] igroup_nested_collection_get default %s", o._statusCode, payload)
}

func (o *IgroupNestedCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/igroups/{igroup.uuid}/igroups][%d] igroup_nested_collection_get default %s", o._statusCode, payload)
}

func (o *IgroupNestedCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IgroupNestedCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
