// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IgroupNestedCreateReader is a Reader for the IgroupNestedCreate structure.
type IgroupNestedCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IgroupNestedCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewIgroupNestedCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIgroupNestedCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIgroupNestedCreateCreated creates a IgroupNestedCreateCreated with default headers values
func NewIgroupNestedCreateCreated() *IgroupNestedCreateCreated {
	return &IgroupNestedCreateCreated{}
}

/*
IgroupNestedCreateCreated describes a response with status code 201, with default header values.

Created
*/
type IgroupNestedCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.IgroupNestedResponse
}

// IsSuccess returns true when this igroup nested create created response has a 2xx status code
func (o *IgroupNestedCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this igroup nested create created response has a 3xx status code
func (o *IgroupNestedCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this igroup nested create created response has a 4xx status code
func (o *IgroupNestedCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this igroup nested create created response has a 5xx status code
func (o *IgroupNestedCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this igroup nested create created response a status code equal to that given
func (o *IgroupNestedCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the igroup nested create created response
func (o *IgroupNestedCreateCreated) Code() int {
	return 201
}

func (o *IgroupNestedCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/igroups/{igroup.uuid}/igroups][%d] igroupNestedCreateCreated %s", 201, payload)
}

func (o *IgroupNestedCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/igroups/{igroup.uuid}/igroups][%d] igroupNestedCreateCreated %s", 201, payload)
}

func (o *IgroupNestedCreateCreated) GetPayload() *models.IgroupNestedResponse {
	return o.Payload
}

func (o *IgroupNestedCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.IgroupNestedResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewIgroupNestedCreateDefault creates a IgroupNestedCreateDefault with default headers values
func NewIgroupNestedCreateDefault(code int) *IgroupNestedCreateDefault {
	return &IgroupNestedCreateDefault{
		_statusCode: code,
	}
}

/*
	IgroupNestedCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5374735 | An attempt was made to add a child igroup that would exceed the maximum allowable depth. |
| 5374736 | A supplied child initiator group already exists in the parent initiator group's hierarchy. |
| 5374737 | A supplied child initiator group already exists in another initiator group's hierarchy. |
| 5374739 | A supplied child initiator group has an operating system type that differs from the parent initiator group. |
| 5374740 | A supplied child initiator group has an protocol that differs from the parent initiator group. |
| 5374741 | A supplied child initiator group is already owned by a different child in the initiator group's hierarchy. |
| 5374742 | A supplied child initiator group contains an initiator that is already owned by another initiator group in the hierarchy. |
| 5374764 | An unreplicated initiator group cannot be added as a child of a replicated initiator group. |
| 5374852 | The initiator group specified in the URI does not exist. |
| 5374878 | The supplied child initiator group does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IgroupNestedCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this igroup nested create default response has a 2xx status code
func (o *IgroupNestedCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this igroup nested create default response has a 3xx status code
func (o *IgroupNestedCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this igroup nested create default response has a 4xx status code
func (o *IgroupNestedCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this igroup nested create default response has a 5xx status code
func (o *IgroupNestedCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this igroup nested create default response a status code equal to that given
func (o *IgroupNestedCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the igroup nested create default response
func (o *IgroupNestedCreateDefault) Code() int {
	return o._statusCode
}

func (o *IgroupNestedCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/igroups/{igroup.uuid}/igroups][%d] igroup_nested_create default %s", o._statusCode, payload)
}

func (o *IgroupNestedCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/igroups/{igroup.uuid}/igroups][%d] igroup_nested_create default %s", o._statusCode, payload)
}

func (o *IgroupNestedCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IgroupNestedCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
