// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewIgroupNestedDeleteParams creates a new IgroupNestedDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIgroupNestedDeleteParams() *IgroupNestedDeleteParams {
	return &IgroupNestedDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIgroupNestedDeleteParamsWithTimeout creates a new IgroupNestedDeleteParams object
// with the ability to set a timeout on a request.
func NewIgroupNestedDeleteParamsWithTimeout(timeout time.Duration) *IgroupNestedDeleteParams {
	return &IgroupNestedDeleteParams{
		timeout: timeout,
	}
}

// NewIgroupNestedDeleteParamsWithContext creates a new IgroupNestedDeleteParams object
// with the ability to set a context for a request.
func NewIgroupNestedDeleteParamsWithContext(ctx context.Context) *IgroupNestedDeleteParams {
	return &IgroupNestedDeleteParams{
		Context: ctx,
	}
}

// NewIgroupNestedDeleteParamsWithHTTPClient creates a new IgroupNestedDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewIgroupNestedDeleteParamsWithHTTPClient(client *http.Client) *IgroupNestedDeleteParams {
	return &IgroupNestedDeleteParams{
		HTTPClient: client,
	}
}

/*
IgroupNestedDeleteParams contains all the parameters to send to the API endpoint

	for the igroup nested delete operation.

	Typically these are written to a http.Request.
*/
type IgroupNestedDeleteParams struct {

	/* AllowDeleteWhileMapped.

	     Allows the deletion of a nested initiator group from of a mapped initiator group.<br/>
	Deleting a nested initiator group from a mapped initiator group means that the LUNs, to which the initiator group is mapped, are no longer available to the initiators nested below the initiator group being removed.  This might cause a disruption in the availability of data.<br/>
	<b>This parameter should be used with caution.</b>

	*/
	AllowDeleteWhileMapped *bool

	/* IgroupUUID.

	   The unique identifier of the parent initiator group.

	*/
	IgroupUUID string

	/* UUID.

	   The unique identifier of the nested initiator group.

	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the igroup nested delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IgroupNestedDeleteParams) WithDefaults() *IgroupNestedDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the igroup nested delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IgroupNestedDeleteParams) SetDefaults() {
	var (
		allowDeleteWhileMappedDefault = bool(false)
	)

	val := IgroupNestedDeleteParams{
		AllowDeleteWhileMapped: &allowDeleteWhileMappedDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the igroup nested delete params
func (o *IgroupNestedDeleteParams) WithTimeout(timeout time.Duration) *IgroupNestedDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the igroup nested delete params
func (o *IgroupNestedDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the igroup nested delete params
func (o *IgroupNestedDeleteParams) WithContext(ctx context.Context) *IgroupNestedDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the igroup nested delete params
func (o *IgroupNestedDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the igroup nested delete params
func (o *IgroupNestedDeleteParams) WithHTTPClient(client *http.Client) *IgroupNestedDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the igroup nested delete params
func (o *IgroupNestedDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAllowDeleteWhileMapped adds the allowDeleteWhileMapped to the igroup nested delete params
func (o *IgroupNestedDeleteParams) WithAllowDeleteWhileMapped(allowDeleteWhileMapped *bool) *IgroupNestedDeleteParams {
	o.SetAllowDeleteWhileMapped(allowDeleteWhileMapped)
	return o
}

// SetAllowDeleteWhileMapped adds the allowDeleteWhileMapped to the igroup nested delete params
func (o *IgroupNestedDeleteParams) SetAllowDeleteWhileMapped(allowDeleteWhileMapped *bool) {
	o.AllowDeleteWhileMapped = allowDeleteWhileMapped
}

// WithIgroupUUID adds the igroupUUID to the igroup nested delete params
func (o *IgroupNestedDeleteParams) WithIgroupUUID(igroupUUID string) *IgroupNestedDeleteParams {
	o.SetIgroupUUID(igroupUUID)
	return o
}

// SetIgroupUUID adds the igroupUuid to the igroup nested delete params
func (o *IgroupNestedDeleteParams) SetIgroupUUID(igroupUUID string) {
	o.IgroupUUID = igroupUUID
}

// WithUUID adds the uuid to the igroup nested delete params
func (o *IgroupNestedDeleteParams) WithUUID(uuid string) *IgroupNestedDeleteParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the igroup nested delete params
func (o *IgroupNestedDeleteParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *IgroupNestedDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AllowDeleteWhileMapped != nil {

		// query param allow_delete_while_mapped
		var qrAllowDeleteWhileMapped bool

		if o.AllowDeleteWhileMapped != nil {
			qrAllowDeleteWhileMapped = *o.AllowDeleteWhileMapped
		}
		qAllowDeleteWhileMapped := swag.FormatBool(qrAllowDeleteWhileMapped)
		if qAllowDeleteWhileMapped != "" {

			if err := r.SetQueryParam("allow_delete_while_mapped", qAllowDeleteWhileMapped); err != nil {
				return err
			}
		}
	}

	// path param igroup.uuid
	if err := r.SetPathParam("igroup.uuid", o.IgroupUUID); err != nil {
		return err
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
