// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewInitiatorCollectionGetParams creates a new InitiatorCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewInitiatorCollectionGetParams() *InitiatorCollectionGetParams {
	return &InitiatorCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewInitiatorCollectionGetParamsWithTimeout creates a new InitiatorCollectionGetParams object
// with the ability to set a timeout on a request.
func NewInitiatorCollectionGetParamsWithTimeout(timeout time.Duration) *InitiatorCollectionGetParams {
	return &InitiatorCollectionGetParams{
		timeout: timeout,
	}
}

// NewInitiatorCollectionGetParamsWithContext creates a new InitiatorCollectionGetParams object
// with the ability to set a context for a request.
func NewInitiatorCollectionGetParamsWithContext(ctx context.Context) *InitiatorCollectionGetParams {
	return &InitiatorCollectionGetParams{
		Context: ctx,
	}
}

// NewInitiatorCollectionGetParamsWithHTTPClient creates a new InitiatorCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewInitiatorCollectionGetParamsWithHTTPClient(client *http.Client) *InitiatorCollectionGetParams {
	return &InitiatorCollectionGetParams{
		HTTPClient: client,
	}
}

/*
InitiatorCollectionGetParams contains all the parameters to send to the API endpoint

	for the initiator collection get operation.

	Typically these are written to a http.Request.
*/
type InitiatorCollectionGetParams struct {

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Protocol.

	   Filter by protocol
	*/
	Protocol *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the initiator collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *InitiatorCollectionGetParams) WithDefaults() *InitiatorCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the initiator collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *InitiatorCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := InitiatorCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the initiator collection get params
func (o *InitiatorCollectionGetParams) WithTimeout(timeout time.Duration) *InitiatorCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the initiator collection get params
func (o *InitiatorCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the initiator collection get params
func (o *InitiatorCollectionGetParams) WithContext(ctx context.Context) *InitiatorCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the initiator collection get params
func (o *InitiatorCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the initiator collection get params
func (o *InitiatorCollectionGetParams) WithHTTPClient(client *http.Client) *InitiatorCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the initiator collection get params
func (o *InitiatorCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the initiator collection get params
func (o *InitiatorCollectionGetParams) WithComment(comment *string) *InitiatorCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the initiator collection get params
func (o *InitiatorCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithFields adds the fields to the initiator collection get params
func (o *InitiatorCollectionGetParams) WithFields(fields []string) *InitiatorCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the initiator collection get params
func (o *InitiatorCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the initiator collection get params
func (o *InitiatorCollectionGetParams) WithMaxRecords(maxRecords *int64) *InitiatorCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the initiator collection get params
func (o *InitiatorCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the initiator collection get params
func (o *InitiatorCollectionGetParams) WithName(name *string) *InitiatorCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the initiator collection get params
func (o *InitiatorCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the initiator collection get params
func (o *InitiatorCollectionGetParams) WithOrderBy(orderBy []string) *InitiatorCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the initiator collection get params
func (o *InitiatorCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithProtocol adds the protocol to the initiator collection get params
func (o *InitiatorCollectionGetParams) WithProtocol(protocol *string) *InitiatorCollectionGetParams {
	o.SetProtocol(protocol)
	return o
}

// SetProtocol adds the protocol to the initiator collection get params
func (o *InitiatorCollectionGetParams) SetProtocol(protocol *string) {
	o.Protocol = protocol
}

// WithReturnRecords adds the returnRecords to the initiator collection get params
func (o *InitiatorCollectionGetParams) WithReturnRecords(returnRecords *bool) *InitiatorCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the initiator collection get params
func (o *InitiatorCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the initiator collection get params
func (o *InitiatorCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *InitiatorCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the initiator collection get params
func (o *InitiatorCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the initiator collection get params
func (o *InitiatorCollectionGetParams) WithSvmName(svmName *string) *InitiatorCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the initiator collection get params
func (o *InitiatorCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the initiator collection get params
func (o *InitiatorCollectionGetParams) WithSvmUUID(svmUUID *string) *InitiatorCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the initiator collection get params
func (o *InitiatorCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *InitiatorCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Protocol != nil {

		// query param protocol
		var qrProtocol string

		if o.Protocol != nil {
			qrProtocol = *o.Protocol
		}
		qProtocol := qrProtocol
		if qProtocol != "" {

			if err := r.SetQueryParam("protocol", qProtocol); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamInitiatorCollectionGet binds the parameter fields
func (o *InitiatorCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamInitiatorCollectionGet binds the parameter order_by
func (o *InitiatorCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
