// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// InitiatorCollectionGetReader is a Reader for the InitiatorCollectionGet structure.
type InitiatorCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *InitiatorCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewInitiatorCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewInitiatorCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewInitiatorCollectionGetOK creates a InitiatorCollectionGetOK with default headers values
func NewInitiatorCollectionGetOK() *InitiatorCollectionGetOK {
	return &InitiatorCollectionGetOK{}
}

/*
InitiatorCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type InitiatorCollectionGetOK struct {
	Payload *models.InitiatorResponse
}

// IsSuccess returns true when this initiator collection get o k response has a 2xx status code
func (o *InitiatorCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this initiator collection get o k response has a 3xx status code
func (o *InitiatorCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this initiator collection get o k response has a 4xx status code
func (o *InitiatorCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this initiator collection get o k response has a 5xx status code
func (o *InitiatorCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this initiator collection get o k response a status code equal to that given
func (o *InitiatorCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the initiator collection get o k response
func (o *InitiatorCollectionGetOK) Code() int {
	return 200
}

func (o *InitiatorCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/initiators][%d] initiatorCollectionGetOK %s", 200, payload)
}

func (o *InitiatorCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/initiators][%d] initiatorCollectionGetOK %s", 200, payload)
}

func (o *InitiatorCollectionGetOK) GetPayload() *models.InitiatorResponse {
	return o.Payload
}

func (o *InitiatorCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.InitiatorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInitiatorCollectionGetDefault creates a InitiatorCollectionGetDefault with default headers values
func NewInitiatorCollectionGetDefault(code int) *InitiatorCollectionGetDefault {
	return &InitiatorCollectionGetDefault{
		_statusCode: code,
	}
}

/*
InitiatorCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type InitiatorCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this initiator collection get default response has a 2xx status code
func (o *InitiatorCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this initiator collection get default response has a 3xx status code
func (o *InitiatorCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this initiator collection get default response has a 4xx status code
func (o *InitiatorCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this initiator collection get default response has a 5xx status code
func (o *InitiatorCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this initiator collection get default response a status code equal to that given
func (o *InitiatorCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the initiator collection get default response
func (o *InitiatorCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *InitiatorCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/initiators][%d] initiator_collection_get default %s", o._statusCode, payload)
}

func (o *InitiatorCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/initiators][%d] initiator_collection_get default %s", o._statusCode, payload)
}

func (o *InitiatorCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *InitiatorCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
