// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IscsiCredentialsCreateReader is a Reader for the IscsiCredentialsCreate structure.
type IscsiCredentialsCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IscsiCredentialsCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewIscsiCredentialsCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIscsiCredentialsCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIscsiCredentialsCreateCreated creates a IscsiCredentialsCreateCreated with default headers values
func NewIscsiCredentialsCreateCreated() *IscsiCredentialsCreateCreated {
	return &IscsiCredentialsCreateCreated{}
}

/*
IscsiCredentialsCreateCreated describes a response with status code 201, with default header values.

Created
*/
type IscsiCredentialsCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.IscsiCredentialsResponse
}

// IsSuccess returns true when this iscsi credentials create created response has a 2xx status code
func (o *IscsiCredentialsCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this iscsi credentials create created response has a 3xx status code
func (o *IscsiCredentialsCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this iscsi credentials create created response has a 4xx status code
func (o *IscsiCredentialsCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this iscsi credentials create created response has a 5xx status code
func (o *IscsiCredentialsCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this iscsi credentials create created response a status code equal to that given
func (o *IscsiCredentialsCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the iscsi credentials create created response
func (o *IscsiCredentialsCreateCreated) Code() int {
	return 201
}

func (o *IscsiCredentialsCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/iscsi/credentials][%d] iscsiCredentialsCreateCreated %s", 201, payload)
}

func (o *IscsiCredentialsCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/iscsi/credentials][%d] iscsiCredentialsCreateCreated %s", 201, payload)
}

func (o *IscsiCredentialsCreateCreated) GetPayload() *models.IscsiCredentialsResponse {
	return o.Payload
}

func (o *IscsiCredentialsCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.IscsiCredentialsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewIscsiCredentialsCreateDefault creates a IscsiCredentialsCreateDefault with default headers values
func NewIscsiCredentialsCreateDefault(code int) *IscsiCredentialsCreateDefault {
	return &IscsiCredentialsCreateDefault{
		_statusCode: code,
	}
}

/*
	IscsiCredentialsCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2621462 | An SVM with the specified UUID does not exist. |
| 2621706 | Both the SVM UUID and SVM name were supplied, but they do not refer to the same SVM. |
| 2621707 | No SVM was specified. Either `svm.name` or `svm.uuid` must be supplied. |
| 5373969 | A non-empty qualifier is required after the prefix. An example of a valid IQN is _iqn.1995-08.com.example:string_. |
| 5373970 | The IQN prefix is invalid. The correct IQN prefix is _iqn_. An example of a valid IQN is _iqn.1995-08.com.example:string_. |
| 5373971 | The date field is invalid. A valid date field is _yyyy-mm_. An example of a valid IQN is _iqn.1995-08.com.example:string_. |
| 5373972 | The naming authority and string fields can contain only the characters _a-z_, _0-9_, _._, _:_, and _-_. |
| 5373977 | The EUI-64 identifier field must be exactly 16 hexadecimal digits. |
| 5373978 | The EUI formatted initiator name supplied is invalid. A valid EUI format is _eui.XXXXXXXXXXXXXXXX_, where X is a hexadecimal digit. |
| 5373997 | The initiator name supplied in invalid. The valid initiator name formats are _iqn.1995-08.com.example:string_ or _eui.0123456789abcdef_. |
| 5374078 | The iSCSI service does not exist. |
| 5374142 | An iSCSI security credential already exists for the specified initiator. |
| 5374145 | The iSCSI security password must contain an even number of valid hex digits. |
| 5374147 | The CHAP inbound and outbound passwords must be different. |
| 5374149 | The inbound user and password properties are required for CHAP authentication. |
| 5374150 | Outbound CHAP authentication requires an outbound password. |
| 5374855 | The value for property `initiator_address.ranges.start` is greater than the value for property `initiator_address.ranges.end`. |
| 5374856 | The value for property `initiator_address.ranges.start` does not belong to the same IP address family as the value for property `initiator_address.ranges.end`. |
| 5374900 | Setting the CHAP authentication properties are not supported with authentication types _none_ or _deny_. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IscsiCredentialsCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this iscsi credentials create default response has a 2xx status code
func (o *IscsiCredentialsCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this iscsi credentials create default response has a 3xx status code
func (o *IscsiCredentialsCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this iscsi credentials create default response has a 4xx status code
func (o *IscsiCredentialsCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this iscsi credentials create default response has a 5xx status code
func (o *IscsiCredentialsCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this iscsi credentials create default response a status code equal to that given
func (o *IscsiCredentialsCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the iscsi credentials create default response
func (o *IscsiCredentialsCreateDefault) Code() int {
	return o._statusCode
}

func (o *IscsiCredentialsCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/iscsi/credentials][%d] iscsi_credentials_create default %s", o._statusCode, payload)
}

func (o *IscsiCredentialsCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/iscsi/credentials][%d] iscsi_credentials_create default %s", o._statusCode, payload)
}

func (o *IscsiCredentialsCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IscsiCredentialsCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
