// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewIscsiCredentialsDeleteCollectionParams creates a new IscsiCredentialsDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIscsiCredentialsDeleteCollectionParams() *IscsiCredentialsDeleteCollectionParams {
	return &IscsiCredentialsDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIscsiCredentialsDeleteCollectionParamsWithTimeout creates a new IscsiCredentialsDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewIscsiCredentialsDeleteCollectionParamsWithTimeout(timeout time.Duration) *IscsiCredentialsDeleteCollectionParams {
	return &IscsiCredentialsDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewIscsiCredentialsDeleteCollectionParamsWithContext creates a new IscsiCredentialsDeleteCollectionParams object
// with the ability to set a context for a request.
func NewIscsiCredentialsDeleteCollectionParamsWithContext(ctx context.Context) *IscsiCredentialsDeleteCollectionParams {
	return &IscsiCredentialsDeleteCollectionParams{
		Context: ctx,
	}
}

// NewIscsiCredentialsDeleteCollectionParamsWithHTTPClient creates a new IscsiCredentialsDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewIscsiCredentialsDeleteCollectionParamsWithHTTPClient(client *http.Client) *IscsiCredentialsDeleteCollectionParams {
	return &IscsiCredentialsDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
IscsiCredentialsDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the iscsi credentials delete collection operation.

	Typically these are written to a http.Request.
*/
type IscsiCredentialsDeleteCollectionParams struct {

	/* AuthenticationType.

	   Filter by authentication_type
	*/
	AuthenticationType *string

	/* ChapInboundUser.

	   Filter by chap.inbound.user
	*/
	ChapInboundUser *string

	/* ChapOutboundUser.

	   Filter by chap.outbound.user
	*/
	ChapOutboundUser *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info IscsiCredentialsDeleteCollectionBody

	/* Initiator.

	   Filter by initiator
	*/
	Initiator *string

	/* InitiatorAddressMasksAddress.

	   Filter by initiator_address.masks.address
	*/
	InitiatorAddressMasksAddress *string

	/* InitiatorAddressMasksFamily.

	   Filter by initiator_address.masks.family
	*/
	InitiatorAddressMasksFamily *string

	/* InitiatorAddressMasksNetmask.

	   Filter by initiator_address.masks.netmask
	*/
	InitiatorAddressMasksNetmask *string

	/* InitiatorAddressRangesEnd.

	   Filter by initiator_address.ranges.end
	*/
	InitiatorAddressRangesEnd *string

	/* InitiatorAddressRangesFamily.

	   Filter by initiator_address.ranges.family
	*/
	InitiatorAddressRangesFamily *string

	/* InitiatorAddressRangesStart.

	   Filter by initiator_address.ranges.start
	*/
	InitiatorAddressRangesStart *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the iscsi credentials delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IscsiCredentialsDeleteCollectionParams) WithDefaults() *IscsiCredentialsDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the iscsi credentials delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IscsiCredentialsDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := IscsiCredentialsDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithTimeout(timeout time.Duration) *IscsiCredentialsDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithContext(ctx context.Context) *IscsiCredentialsDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithHTTPClient(client *http.Client) *IscsiCredentialsDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAuthenticationType adds the authenticationType to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithAuthenticationType(authenticationType *string) *IscsiCredentialsDeleteCollectionParams {
	o.SetAuthenticationType(authenticationType)
	return o
}

// SetAuthenticationType adds the authenticationType to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetAuthenticationType(authenticationType *string) {
	o.AuthenticationType = authenticationType
}

// WithChapInboundUser adds the chapInboundUser to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithChapInboundUser(chapInboundUser *string) *IscsiCredentialsDeleteCollectionParams {
	o.SetChapInboundUser(chapInboundUser)
	return o
}

// SetChapInboundUser adds the chapInboundUser to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetChapInboundUser(chapInboundUser *string) {
	o.ChapInboundUser = chapInboundUser
}

// WithChapOutboundUser adds the chapOutboundUser to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithChapOutboundUser(chapOutboundUser *string) *IscsiCredentialsDeleteCollectionParams {
	o.SetChapOutboundUser(chapOutboundUser)
	return o
}

// SetChapOutboundUser adds the chapOutboundUser to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetChapOutboundUser(chapOutboundUser *string) {
	o.ChapOutboundUser = chapOutboundUser
}

// WithContinueOnFailure adds the continueOnFailure to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *IscsiCredentialsDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithInfo(info IscsiCredentialsDeleteCollectionBody) *IscsiCredentialsDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetInfo(info IscsiCredentialsDeleteCollectionBody) {
	o.Info = info
}

// WithInitiator adds the initiator to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithInitiator(initiator *string) *IscsiCredentialsDeleteCollectionParams {
	o.SetInitiator(initiator)
	return o
}

// SetInitiator adds the initiator to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetInitiator(initiator *string) {
	o.Initiator = initiator
}

// WithInitiatorAddressMasksAddress adds the initiatorAddressMasksAddress to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithInitiatorAddressMasksAddress(initiatorAddressMasksAddress *string) *IscsiCredentialsDeleteCollectionParams {
	o.SetInitiatorAddressMasksAddress(initiatorAddressMasksAddress)
	return o
}

// SetInitiatorAddressMasksAddress adds the initiatorAddressMasksAddress to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetInitiatorAddressMasksAddress(initiatorAddressMasksAddress *string) {
	o.InitiatorAddressMasksAddress = initiatorAddressMasksAddress
}

// WithInitiatorAddressMasksFamily adds the initiatorAddressMasksFamily to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithInitiatorAddressMasksFamily(initiatorAddressMasksFamily *string) *IscsiCredentialsDeleteCollectionParams {
	o.SetInitiatorAddressMasksFamily(initiatorAddressMasksFamily)
	return o
}

// SetInitiatorAddressMasksFamily adds the initiatorAddressMasksFamily to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetInitiatorAddressMasksFamily(initiatorAddressMasksFamily *string) {
	o.InitiatorAddressMasksFamily = initiatorAddressMasksFamily
}

// WithInitiatorAddressMasksNetmask adds the initiatorAddressMasksNetmask to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithInitiatorAddressMasksNetmask(initiatorAddressMasksNetmask *string) *IscsiCredentialsDeleteCollectionParams {
	o.SetInitiatorAddressMasksNetmask(initiatorAddressMasksNetmask)
	return o
}

// SetInitiatorAddressMasksNetmask adds the initiatorAddressMasksNetmask to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetInitiatorAddressMasksNetmask(initiatorAddressMasksNetmask *string) {
	o.InitiatorAddressMasksNetmask = initiatorAddressMasksNetmask
}

// WithInitiatorAddressRangesEnd adds the initiatorAddressRangesEnd to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithInitiatorAddressRangesEnd(initiatorAddressRangesEnd *string) *IscsiCredentialsDeleteCollectionParams {
	o.SetInitiatorAddressRangesEnd(initiatorAddressRangesEnd)
	return o
}

// SetInitiatorAddressRangesEnd adds the initiatorAddressRangesEnd to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetInitiatorAddressRangesEnd(initiatorAddressRangesEnd *string) {
	o.InitiatorAddressRangesEnd = initiatorAddressRangesEnd
}

// WithInitiatorAddressRangesFamily adds the initiatorAddressRangesFamily to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithInitiatorAddressRangesFamily(initiatorAddressRangesFamily *string) *IscsiCredentialsDeleteCollectionParams {
	o.SetInitiatorAddressRangesFamily(initiatorAddressRangesFamily)
	return o
}

// SetInitiatorAddressRangesFamily adds the initiatorAddressRangesFamily to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetInitiatorAddressRangesFamily(initiatorAddressRangesFamily *string) {
	o.InitiatorAddressRangesFamily = initiatorAddressRangesFamily
}

// WithInitiatorAddressRangesStart adds the initiatorAddressRangesStart to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithInitiatorAddressRangesStart(initiatorAddressRangesStart *string) *IscsiCredentialsDeleteCollectionParams {
	o.SetInitiatorAddressRangesStart(initiatorAddressRangesStart)
	return o
}

// SetInitiatorAddressRangesStart adds the initiatorAddressRangesStart to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetInitiatorAddressRangesStart(initiatorAddressRangesStart *string) {
	o.InitiatorAddressRangesStart = initiatorAddressRangesStart
}

// WithReturnRecords adds the returnRecords to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *IscsiCredentialsDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *IscsiCredentialsDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *IscsiCredentialsDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithSvmName(svmName *string) *IscsiCredentialsDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) WithSvmUUID(svmUUID *string) *IscsiCredentialsDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the iscsi credentials delete collection params
func (o *IscsiCredentialsDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *IscsiCredentialsDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AuthenticationType != nil {

		// query param authentication_type
		var qrAuthenticationType string

		if o.AuthenticationType != nil {
			qrAuthenticationType = *o.AuthenticationType
		}
		qAuthenticationType := qrAuthenticationType
		if qAuthenticationType != "" {

			if err := r.SetQueryParam("authentication_type", qAuthenticationType); err != nil {
				return err
			}
		}
	}

	if o.ChapInboundUser != nil {

		// query param chap.inbound.user
		var qrChapInboundUser string

		if o.ChapInboundUser != nil {
			qrChapInboundUser = *o.ChapInboundUser
		}
		qChapInboundUser := qrChapInboundUser
		if qChapInboundUser != "" {

			if err := r.SetQueryParam("chap.inbound.user", qChapInboundUser); err != nil {
				return err
			}
		}
	}

	if o.ChapOutboundUser != nil {

		// query param chap.outbound.user
		var qrChapOutboundUser string

		if o.ChapOutboundUser != nil {
			qrChapOutboundUser = *o.ChapOutboundUser
		}
		qChapOutboundUser := qrChapOutboundUser
		if qChapOutboundUser != "" {

			if err := r.SetQueryParam("chap.outbound.user", qChapOutboundUser); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Initiator != nil {

		// query param initiator
		var qrInitiator string

		if o.Initiator != nil {
			qrInitiator = *o.Initiator
		}
		qInitiator := qrInitiator
		if qInitiator != "" {

			if err := r.SetQueryParam("initiator", qInitiator); err != nil {
				return err
			}
		}
	}

	if o.InitiatorAddressMasksAddress != nil {

		// query param initiator_address.masks.address
		var qrInitiatorAddressMasksAddress string

		if o.InitiatorAddressMasksAddress != nil {
			qrInitiatorAddressMasksAddress = *o.InitiatorAddressMasksAddress
		}
		qInitiatorAddressMasksAddress := qrInitiatorAddressMasksAddress
		if qInitiatorAddressMasksAddress != "" {

			if err := r.SetQueryParam("initiator_address.masks.address", qInitiatorAddressMasksAddress); err != nil {
				return err
			}
		}
	}

	if o.InitiatorAddressMasksFamily != nil {

		// query param initiator_address.masks.family
		var qrInitiatorAddressMasksFamily string

		if o.InitiatorAddressMasksFamily != nil {
			qrInitiatorAddressMasksFamily = *o.InitiatorAddressMasksFamily
		}
		qInitiatorAddressMasksFamily := qrInitiatorAddressMasksFamily
		if qInitiatorAddressMasksFamily != "" {

			if err := r.SetQueryParam("initiator_address.masks.family", qInitiatorAddressMasksFamily); err != nil {
				return err
			}
		}
	}

	if o.InitiatorAddressMasksNetmask != nil {

		// query param initiator_address.masks.netmask
		var qrInitiatorAddressMasksNetmask string

		if o.InitiatorAddressMasksNetmask != nil {
			qrInitiatorAddressMasksNetmask = *o.InitiatorAddressMasksNetmask
		}
		qInitiatorAddressMasksNetmask := qrInitiatorAddressMasksNetmask
		if qInitiatorAddressMasksNetmask != "" {

			if err := r.SetQueryParam("initiator_address.masks.netmask", qInitiatorAddressMasksNetmask); err != nil {
				return err
			}
		}
	}

	if o.InitiatorAddressRangesEnd != nil {

		// query param initiator_address.ranges.end
		var qrInitiatorAddressRangesEnd string

		if o.InitiatorAddressRangesEnd != nil {
			qrInitiatorAddressRangesEnd = *o.InitiatorAddressRangesEnd
		}
		qInitiatorAddressRangesEnd := qrInitiatorAddressRangesEnd
		if qInitiatorAddressRangesEnd != "" {

			if err := r.SetQueryParam("initiator_address.ranges.end", qInitiatorAddressRangesEnd); err != nil {
				return err
			}
		}
	}

	if o.InitiatorAddressRangesFamily != nil {

		// query param initiator_address.ranges.family
		var qrInitiatorAddressRangesFamily string

		if o.InitiatorAddressRangesFamily != nil {
			qrInitiatorAddressRangesFamily = *o.InitiatorAddressRangesFamily
		}
		qInitiatorAddressRangesFamily := qrInitiatorAddressRangesFamily
		if qInitiatorAddressRangesFamily != "" {

			if err := r.SetQueryParam("initiator_address.ranges.family", qInitiatorAddressRangesFamily); err != nil {
				return err
			}
		}
	}

	if o.InitiatorAddressRangesStart != nil {

		// query param initiator_address.ranges.start
		var qrInitiatorAddressRangesStart string

		if o.InitiatorAddressRangesStart != nil {
			qrInitiatorAddressRangesStart = *o.InitiatorAddressRangesStart
		}
		qInitiatorAddressRangesStart := qrInitiatorAddressRangesStart
		if qInitiatorAddressRangesStart != "" {

			if err := r.SetQueryParam("initiator_address.ranges.start", qInitiatorAddressRangesStart); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
