// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewIscsiCredentialsGetParams creates a new IscsiCredentialsGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIscsiCredentialsGetParams() *IscsiCredentialsGetParams {
	return &IscsiCredentialsGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIscsiCredentialsGetParamsWithTimeout creates a new IscsiCredentialsGetParams object
// with the ability to set a timeout on a request.
func NewIscsiCredentialsGetParamsWithTimeout(timeout time.Duration) *IscsiCredentialsGetParams {
	return &IscsiCredentialsGetParams{
		timeout: timeout,
	}
}

// NewIscsiCredentialsGetParamsWithContext creates a new IscsiCredentialsGetParams object
// with the ability to set a context for a request.
func NewIscsiCredentialsGetParamsWithContext(ctx context.Context) *IscsiCredentialsGetParams {
	return &IscsiCredentialsGetParams{
		Context: ctx,
	}
}

// NewIscsiCredentialsGetParamsWithHTTPClient creates a new IscsiCredentialsGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewIscsiCredentialsGetParamsWithHTTPClient(client *http.Client) *IscsiCredentialsGetParams {
	return &IscsiCredentialsGetParams{
		HTTPClient: client,
	}
}

/*
IscsiCredentialsGetParams contains all the parameters to send to the API endpoint

	for the iscsi credentials get operation.

	Typically these are written to a http.Request.
*/
type IscsiCredentialsGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Initiator.

	   The iSCSI initiator of the credentials object.

	*/
	Initiator string

	/* SvmUUID.

	   The unique identifier of an SVM.

	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the iscsi credentials get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IscsiCredentialsGetParams) WithDefaults() *IscsiCredentialsGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the iscsi credentials get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IscsiCredentialsGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the iscsi credentials get params
func (o *IscsiCredentialsGetParams) WithTimeout(timeout time.Duration) *IscsiCredentialsGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the iscsi credentials get params
func (o *IscsiCredentialsGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the iscsi credentials get params
func (o *IscsiCredentialsGetParams) WithContext(ctx context.Context) *IscsiCredentialsGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the iscsi credentials get params
func (o *IscsiCredentialsGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the iscsi credentials get params
func (o *IscsiCredentialsGetParams) WithHTTPClient(client *http.Client) *IscsiCredentialsGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the iscsi credentials get params
func (o *IscsiCredentialsGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the iscsi credentials get params
func (o *IscsiCredentialsGetParams) WithFields(fields []string) *IscsiCredentialsGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the iscsi credentials get params
func (o *IscsiCredentialsGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithInitiator adds the initiator to the iscsi credentials get params
func (o *IscsiCredentialsGetParams) WithInitiator(initiator string) *IscsiCredentialsGetParams {
	o.SetInitiator(initiator)
	return o
}

// SetInitiator adds the initiator to the iscsi credentials get params
func (o *IscsiCredentialsGetParams) SetInitiator(initiator string) {
	o.Initiator = initiator
}

// WithSvmUUID adds the svmUUID to the iscsi credentials get params
func (o *IscsiCredentialsGetParams) WithSvmUUID(svmUUID string) *IscsiCredentialsGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the iscsi credentials get params
func (o *IscsiCredentialsGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *IscsiCredentialsGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param initiator
	if err := r.SetPathParam("initiator", o.Initiator); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamIscsiCredentialsGet binds the parameter fields
func (o *IscsiCredentialsGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
