// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewIscsiServiceCollectionGetParams creates a new IscsiServiceCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIscsiServiceCollectionGetParams() *IscsiServiceCollectionGetParams {
	return &IscsiServiceCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIscsiServiceCollectionGetParamsWithTimeout creates a new IscsiServiceCollectionGetParams object
// with the ability to set a timeout on a request.
func NewIscsiServiceCollectionGetParamsWithTimeout(timeout time.Duration) *IscsiServiceCollectionGetParams {
	return &IscsiServiceCollectionGetParams{
		timeout: timeout,
	}
}

// NewIscsiServiceCollectionGetParamsWithContext creates a new IscsiServiceCollectionGetParams object
// with the ability to set a context for a request.
func NewIscsiServiceCollectionGetParamsWithContext(ctx context.Context) *IscsiServiceCollectionGetParams {
	return &IscsiServiceCollectionGetParams{
		Context: ctx,
	}
}

// NewIscsiServiceCollectionGetParamsWithHTTPClient creates a new IscsiServiceCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewIscsiServiceCollectionGetParamsWithHTTPClient(client *http.Client) *IscsiServiceCollectionGetParams {
	return &IscsiServiceCollectionGetParams{
		HTTPClient: client,
	}
}

/*
IscsiServiceCollectionGetParams contains all the parameters to send to the API endpoint

	for the iscsi service collection get operation.

	Typically these are written to a http.Request.
*/
type IscsiServiceCollectionGetParams struct {

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* MetricDuration.

	   Filter by metric.duration
	*/
	MetricDuration *string

	/* MetricIopsOther.

	   Filter by metric.iops.other
	*/
	MetricIopsOther *int64

	/* MetricIopsRead.

	   Filter by metric.iops.read
	*/
	MetricIopsRead *int64

	/* MetricIopsTotal.

	   Filter by metric.iops.total
	*/
	MetricIopsTotal *int64

	/* MetricIopsWrite.

	   Filter by metric.iops.write
	*/
	MetricIopsWrite *int64

	/* MetricLatencyOther.

	   Filter by metric.latency.other
	*/
	MetricLatencyOther *int64

	/* MetricLatencyRead.

	   Filter by metric.latency.read
	*/
	MetricLatencyRead *int64

	/* MetricLatencyTotal.

	   Filter by metric.latency.total
	*/
	MetricLatencyTotal *int64

	/* MetricLatencyWrite.

	   Filter by metric.latency.write
	*/
	MetricLatencyWrite *int64

	/* MetricStatus.

	   Filter by metric.status
	*/
	MetricStatus *string

	/* MetricThroughputRead.

	   Filter by metric.throughput.read
	*/
	MetricThroughputRead *int64

	/* MetricThroughputTotal.

	   Filter by metric.throughput.total
	*/
	MetricThroughputTotal *int64

	/* MetricThroughputWrite.

	   Filter by metric.throughput.write
	*/
	MetricThroughputWrite *int64

	/* MetricTimestamp.

	   Filter by metric.timestamp
	*/
	MetricTimestamp *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* StatisticsIopsRawOther.

	   Filter by statistics.iops_raw.other
	*/
	StatisticsIopsRawOther *int64

	/* StatisticsIopsRawRead.

	   Filter by statistics.iops_raw.read
	*/
	StatisticsIopsRawRead *int64

	/* StatisticsIopsRawTotal.

	   Filter by statistics.iops_raw.total
	*/
	StatisticsIopsRawTotal *int64

	/* StatisticsIopsRawWrite.

	   Filter by statistics.iops_raw.write
	*/
	StatisticsIopsRawWrite *int64

	/* StatisticsLatencyRawOther.

	   Filter by statistics.latency_raw.other
	*/
	StatisticsLatencyRawOther *int64

	/* StatisticsLatencyRawRead.

	   Filter by statistics.latency_raw.read
	*/
	StatisticsLatencyRawRead *int64

	/* StatisticsLatencyRawTotal.

	   Filter by statistics.latency_raw.total
	*/
	StatisticsLatencyRawTotal *int64

	/* StatisticsLatencyRawWrite.

	   Filter by statistics.latency_raw.write
	*/
	StatisticsLatencyRawWrite *int64

	/* StatisticsStatus.

	   Filter by statistics.status
	*/
	StatisticsStatus *string

	/* StatisticsThroughputRawRead.

	   Filter by statistics.throughput_raw.read
	*/
	StatisticsThroughputRawRead *int64

	/* StatisticsThroughputRawTotal.

	   Filter by statistics.throughput_raw.total
	*/
	StatisticsThroughputRawTotal *int64

	/* StatisticsThroughputRawWrite.

	   Filter by statistics.throughput_raw.write
	*/
	StatisticsThroughputRawWrite *int64

	/* StatisticsTimestamp.

	   Filter by statistics.timestamp
	*/
	StatisticsTimestamp *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TargetAlias.

	   Filter by target.alias
	*/
	TargetAlias *string

	/* TargetName.

	   Filter by target.name
	*/
	TargetName *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the iscsi service collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IscsiServiceCollectionGetParams) WithDefaults() *IscsiServiceCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the iscsi service collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IscsiServiceCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := IscsiServiceCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithTimeout(timeout time.Duration) *IscsiServiceCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithContext(ctx context.Context) *IscsiServiceCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithHTTPClient(client *http.Client) *IscsiServiceCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithEnabled adds the enabled to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithEnabled(enabled *bool) *IscsiServiceCollectionGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFields adds the fields to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithFields(fields []string) *IscsiServiceCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithMaxRecords(maxRecords *int64) *IscsiServiceCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMetricDuration adds the metricDuration to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithMetricDuration(metricDuration *string) *IscsiServiceCollectionGetParams {
	o.SetMetricDuration(metricDuration)
	return o
}

// SetMetricDuration adds the metricDuration to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetMetricDuration(metricDuration *string) {
	o.MetricDuration = metricDuration
}

// WithMetricIopsOther adds the metricIopsOther to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithMetricIopsOther(metricIopsOther *int64) *IscsiServiceCollectionGetParams {
	o.SetMetricIopsOther(metricIopsOther)
	return o
}

// SetMetricIopsOther adds the metricIopsOther to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetMetricIopsOther(metricIopsOther *int64) {
	o.MetricIopsOther = metricIopsOther
}

// WithMetricIopsRead adds the metricIopsRead to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithMetricIopsRead(metricIopsRead *int64) *IscsiServiceCollectionGetParams {
	o.SetMetricIopsRead(metricIopsRead)
	return o
}

// SetMetricIopsRead adds the metricIopsRead to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetMetricIopsRead(metricIopsRead *int64) {
	o.MetricIopsRead = metricIopsRead
}

// WithMetricIopsTotal adds the metricIopsTotal to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithMetricIopsTotal(metricIopsTotal *int64) *IscsiServiceCollectionGetParams {
	o.SetMetricIopsTotal(metricIopsTotal)
	return o
}

// SetMetricIopsTotal adds the metricIopsTotal to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetMetricIopsTotal(metricIopsTotal *int64) {
	o.MetricIopsTotal = metricIopsTotal
}

// WithMetricIopsWrite adds the metricIopsWrite to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithMetricIopsWrite(metricIopsWrite *int64) *IscsiServiceCollectionGetParams {
	o.SetMetricIopsWrite(metricIopsWrite)
	return o
}

// SetMetricIopsWrite adds the metricIopsWrite to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetMetricIopsWrite(metricIopsWrite *int64) {
	o.MetricIopsWrite = metricIopsWrite
}

// WithMetricLatencyOther adds the metricLatencyOther to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithMetricLatencyOther(metricLatencyOther *int64) *IscsiServiceCollectionGetParams {
	o.SetMetricLatencyOther(metricLatencyOther)
	return o
}

// SetMetricLatencyOther adds the metricLatencyOther to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetMetricLatencyOther(metricLatencyOther *int64) {
	o.MetricLatencyOther = metricLatencyOther
}

// WithMetricLatencyRead adds the metricLatencyRead to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithMetricLatencyRead(metricLatencyRead *int64) *IscsiServiceCollectionGetParams {
	o.SetMetricLatencyRead(metricLatencyRead)
	return o
}

// SetMetricLatencyRead adds the metricLatencyRead to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetMetricLatencyRead(metricLatencyRead *int64) {
	o.MetricLatencyRead = metricLatencyRead
}

// WithMetricLatencyTotal adds the metricLatencyTotal to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithMetricLatencyTotal(metricLatencyTotal *int64) *IscsiServiceCollectionGetParams {
	o.SetMetricLatencyTotal(metricLatencyTotal)
	return o
}

// SetMetricLatencyTotal adds the metricLatencyTotal to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetMetricLatencyTotal(metricLatencyTotal *int64) {
	o.MetricLatencyTotal = metricLatencyTotal
}

// WithMetricLatencyWrite adds the metricLatencyWrite to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithMetricLatencyWrite(metricLatencyWrite *int64) *IscsiServiceCollectionGetParams {
	o.SetMetricLatencyWrite(metricLatencyWrite)
	return o
}

// SetMetricLatencyWrite adds the metricLatencyWrite to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetMetricLatencyWrite(metricLatencyWrite *int64) {
	o.MetricLatencyWrite = metricLatencyWrite
}

// WithMetricStatus adds the metricStatus to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithMetricStatus(metricStatus *string) *IscsiServiceCollectionGetParams {
	o.SetMetricStatus(metricStatus)
	return o
}

// SetMetricStatus adds the metricStatus to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetMetricStatus(metricStatus *string) {
	o.MetricStatus = metricStatus
}

// WithMetricThroughputRead adds the metricThroughputRead to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithMetricThroughputRead(metricThroughputRead *int64) *IscsiServiceCollectionGetParams {
	o.SetMetricThroughputRead(metricThroughputRead)
	return o
}

// SetMetricThroughputRead adds the metricThroughputRead to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetMetricThroughputRead(metricThroughputRead *int64) {
	o.MetricThroughputRead = metricThroughputRead
}

// WithMetricThroughputTotal adds the metricThroughputTotal to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithMetricThroughputTotal(metricThroughputTotal *int64) *IscsiServiceCollectionGetParams {
	o.SetMetricThroughputTotal(metricThroughputTotal)
	return o
}

// SetMetricThroughputTotal adds the metricThroughputTotal to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetMetricThroughputTotal(metricThroughputTotal *int64) {
	o.MetricThroughputTotal = metricThroughputTotal
}

// WithMetricThroughputWrite adds the metricThroughputWrite to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithMetricThroughputWrite(metricThroughputWrite *int64) *IscsiServiceCollectionGetParams {
	o.SetMetricThroughputWrite(metricThroughputWrite)
	return o
}

// SetMetricThroughputWrite adds the metricThroughputWrite to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetMetricThroughputWrite(metricThroughputWrite *int64) {
	o.MetricThroughputWrite = metricThroughputWrite
}

// WithMetricTimestamp adds the metricTimestamp to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithMetricTimestamp(metricTimestamp *string) *IscsiServiceCollectionGetParams {
	o.SetMetricTimestamp(metricTimestamp)
	return o
}

// SetMetricTimestamp adds the metricTimestamp to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetMetricTimestamp(metricTimestamp *string) {
	o.MetricTimestamp = metricTimestamp
}

// WithOrderBy adds the orderBy to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithOrderBy(orderBy []string) *IscsiServiceCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithReturnRecords(returnRecords *bool) *IscsiServiceCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *IscsiServiceCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithStatisticsIopsRawOther adds the statisticsIopsRawOther to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithStatisticsIopsRawOther(statisticsIopsRawOther *int64) *IscsiServiceCollectionGetParams {
	o.SetStatisticsIopsRawOther(statisticsIopsRawOther)
	return o
}

// SetStatisticsIopsRawOther adds the statisticsIopsRawOther to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetStatisticsIopsRawOther(statisticsIopsRawOther *int64) {
	o.StatisticsIopsRawOther = statisticsIopsRawOther
}

// WithStatisticsIopsRawRead adds the statisticsIopsRawRead to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithStatisticsIopsRawRead(statisticsIopsRawRead *int64) *IscsiServiceCollectionGetParams {
	o.SetStatisticsIopsRawRead(statisticsIopsRawRead)
	return o
}

// SetStatisticsIopsRawRead adds the statisticsIopsRawRead to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetStatisticsIopsRawRead(statisticsIopsRawRead *int64) {
	o.StatisticsIopsRawRead = statisticsIopsRawRead
}

// WithStatisticsIopsRawTotal adds the statisticsIopsRawTotal to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithStatisticsIopsRawTotal(statisticsIopsRawTotal *int64) *IscsiServiceCollectionGetParams {
	o.SetStatisticsIopsRawTotal(statisticsIopsRawTotal)
	return o
}

// SetStatisticsIopsRawTotal adds the statisticsIopsRawTotal to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetStatisticsIopsRawTotal(statisticsIopsRawTotal *int64) {
	o.StatisticsIopsRawTotal = statisticsIopsRawTotal
}

// WithStatisticsIopsRawWrite adds the statisticsIopsRawWrite to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithStatisticsIopsRawWrite(statisticsIopsRawWrite *int64) *IscsiServiceCollectionGetParams {
	o.SetStatisticsIopsRawWrite(statisticsIopsRawWrite)
	return o
}

// SetStatisticsIopsRawWrite adds the statisticsIopsRawWrite to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetStatisticsIopsRawWrite(statisticsIopsRawWrite *int64) {
	o.StatisticsIopsRawWrite = statisticsIopsRawWrite
}

// WithStatisticsLatencyRawOther adds the statisticsLatencyRawOther to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithStatisticsLatencyRawOther(statisticsLatencyRawOther *int64) *IscsiServiceCollectionGetParams {
	o.SetStatisticsLatencyRawOther(statisticsLatencyRawOther)
	return o
}

// SetStatisticsLatencyRawOther adds the statisticsLatencyRawOther to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetStatisticsLatencyRawOther(statisticsLatencyRawOther *int64) {
	o.StatisticsLatencyRawOther = statisticsLatencyRawOther
}

// WithStatisticsLatencyRawRead adds the statisticsLatencyRawRead to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithStatisticsLatencyRawRead(statisticsLatencyRawRead *int64) *IscsiServiceCollectionGetParams {
	o.SetStatisticsLatencyRawRead(statisticsLatencyRawRead)
	return o
}

// SetStatisticsLatencyRawRead adds the statisticsLatencyRawRead to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetStatisticsLatencyRawRead(statisticsLatencyRawRead *int64) {
	o.StatisticsLatencyRawRead = statisticsLatencyRawRead
}

// WithStatisticsLatencyRawTotal adds the statisticsLatencyRawTotal to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithStatisticsLatencyRawTotal(statisticsLatencyRawTotal *int64) *IscsiServiceCollectionGetParams {
	o.SetStatisticsLatencyRawTotal(statisticsLatencyRawTotal)
	return o
}

// SetStatisticsLatencyRawTotal adds the statisticsLatencyRawTotal to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetStatisticsLatencyRawTotal(statisticsLatencyRawTotal *int64) {
	o.StatisticsLatencyRawTotal = statisticsLatencyRawTotal
}

// WithStatisticsLatencyRawWrite adds the statisticsLatencyRawWrite to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithStatisticsLatencyRawWrite(statisticsLatencyRawWrite *int64) *IscsiServiceCollectionGetParams {
	o.SetStatisticsLatencyRawWrite(statisticsLatencyRawWrite)
	return o
}

// SetStatisticsLatencyRawWrite adds the statisticsLatencyRawWrite to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetStatisticsLatencyRawWrite(statisticsLatencyRawWrite *int64) {
	o.StatisticsLatencyRawWrite = statisticsLatencyRawWrite
}

// WithStatisticsStatus adds the statisticsStatus to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithStatisticsStatus(statisticsStatus *string) *IscsiServiceCollectionGetParams {
	o.SetStatisticsStatus(statisticsStatus)
	return o
}

// SetStatisticsStatus adds the statisticsStatus to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetStatisticsStatus(statisticsStatus *string) {
	o.StatisticsStatus = statisticsStatus
}

// WithStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) *IscsiServiceCollectionGetParams {
	o.SetStatisticsThroughputRawRead(statisticsThroughputRawRead)
	return o
}

// SetStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) {
	o.StatisticsThroughputRawRead = statisticsThroughputRawRead
}

// WithStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) *IscsiServiceCollectionGetParams {
	o.SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal)
	return o
}

// SetStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) {
	o.StatisticsThroughputRawTotal = statisticsThroughputRawTotal
}

// WithStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) *IscsiServiceCollectionGetParams {
	o.SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite)
	return o
}

// SetStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) {
	o.StatisticsThroughputRawWrite = statisticsThroughputRawWrite
}

// WithStatisticsTimestamp adds the statisticsTimestamp to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithStatisticsTimestamp(statisticsTimestamp *string) *IscsiServiceCollectionGetParams {
	o.SetStatisticsTimestamp(statisticsTimestamp)
	return o
}

// SetStatisticsTimestamp adds the statisticsTimestamp to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetStatisticsTimestamp(statisticsTimestamp *string) {
	o.StatisticsTimestamp = statisticsTimestamp
}

// WithSvmName adds the svmName to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithSvmName(svmName *string) *IscsiServiceCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithSvmUUID(svmUUID *string) *IscsiServiceCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTargetAlias adds the targetAlias to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithTargetAlias(targetAlias *string) *IscsiServiceCollectionGetParams {
	o.SetTargetAlias(targetAlias)
	return o
}

// SetTargetAlias adds the targetAlias to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetTargetAlias(targetAlias *string) {
	o.TargetAlias = targetAlias
}

// WithTargetName adds the targetName to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) WithTargetName(targetName *string) *IscsiServiceCollectionGetParams {
	o.SetTargetName(targetName)
	return o
}

// SetTargetName adds the targetName to the iscsi service collection get params
func (o *IscsiServiceCollectionGetParams) SetTargetName(targetName *string) {
	o.TargetName = targetName
}

// WriteToRequest writes these params to a swagger request
func (o *IscsiServiceCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.MetricDuration != nil {

		// query param metric.duration
		var qrMetricDuration string

		if o.MetricDuration != nil {
			qrMetricDuration = *o.MetricDuration
		}
		qMetricDuration := qrMetricDuration
		if qMetricDuration != "" {

			if err := r.SetQueryParam("metric.duration", qMetricDuration); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsOther != nil {

		// query param metric.iops.other
		var qrMetricIopsOther int64

		if o.MetricIopsOther != nil {
			qrMetricIopsOther = *o.MetricIopsOther
		}
		qMetricIopsOther := swag.FormatInt64(qrMetricIopsOther)
		if qMetricIopsOther != "" {

			if err := r.SetQueryParam("metric.iops.other", qMetricIopsOther); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsRead != nil {

		// query param metric.iops.read
		var qrMetricIopsRead int64

		if o.MetricIopsRead != nil {
			qrMetricIopsRead = *o.MetricIopsRead
		}
		qMetricIopsRead := swag.FormatInt64(qrMetricIopsRead)
		if qMetricIopsRead != "" {

			if err := r.SetQueryParam("metric.iops.read", qMetricIopsRead); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsTotal != nil {

		// query param metric.iops.total
		var qrMetricIopsTotal int64

		if o.MetricIopsTotal != nil {
			qrMetricIopsTotal = *o.MetricIopsTotal
		}
		qMetricIopsTotal := swag.FormatInt64(qrMetricIopsTotal)
		if qMetricIopsTotal != "" {

			if err := r.SetQueryParam("metric.iops.total", qMetricIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsWrite != nil {

		// query param metric.iops.write
		var qrMetricIopsWrite int64

		if o.MetricIopsWrite != nil {
			qrMetricIopsWrite = *o.MetricIopsWrite
		}
		qMetricIopsWrite := swag.FormatInt64(qrMetricIopsWrite)
		if qMetricIopsWrite != "" {

			if err := r.SetQueryParam("metric.iops.write", qMetricIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyOther != nil {

		// query param metric.latency.other
		var qrMetricLatencyOther int64

		if o.MetricLatencyOther != nil {
			qrMetricLatencyOther = *o.MetricLatencyOther
		}
		qMetricLatencyOther := swag.FormatInt64(qrMetricLatencyOther)
		if qMetricLatencyOther != "" {

			if err := r.SetQueryParam("metric.latency.other", qMetricLatencyOther); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyRead != nil {

		// query param metric.latency.read
		var qrMetricLatencyRead int64

		if o.MetricLatencyRead != nil {
			qrMetricLatencyRead = *o.MetricLatencyRead
		}
		qMetricLatencyRead := swag.FormatInt64(qrMetricLatencyRead)
		if qMetricLatencyRead != "" {

			if err := r.SetQueryParam("metric.latency.read", qMetricLatencyRead); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyTotal != nil {

		// query param metric.latency.total
		var qrMetricLatencyTotal int64

		if o.MetricLatencyTotal != nil {
			qrMetricLatencyTotal = *o.MetricLatencyTotal
		}
		qMetricLatencyTotal := swag.FormatInt64(qrMetricLatencyTotal)
		if qMetricLatencyTotal != "" {

			if err := r.SetQueryParam("metric.latency.total", qMetricLatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyWrite != nil {

		// query param metric.latency.write
		var qrMetricLatencyWrite int64

		if o.MetricLatencyWrite != nil {
			qrMetricLatencyWrite = *o.MetricLatencyWrite
		}
		qMetricLatencyWrite := swag.FormatInt64(qrMetricLatencyWrite)
		if qMetricLatencyWrite != "" {

			if err := r.SetQueryParam("metric.latency.write", qMetricLatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricStatus != nil {

		// query param metric.status
		var qrMetricStatus string

		if o.MetricStatus != nil {
			qrMetricStatus = *o.MetricStatus
		}
		qMetricStatus := qrMetricStatus
		if qMetricStatus != "" {

			if err := r.SetQueryParam("metric.status", qMetricStatus); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputRead != nil {

		// query param metric.throughput.read
		var qrMetricThroughputRead int64

		if o.MetricThroughputRead != nil {
			qrMetricThroughputRead = *o.MetricThroughputRead
		}
		qMetricThroughputRead := swag.FormatInt64(qrMetricThroughputRead)
		if qMetricThroughputRead != "" {

			if err := r.SetQueryParam("metric.throughput.read", qMetricThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputTotal != nil {

		// query param metric.throughput.total
		var qrMetricThroughputTotal int64

		if o.MetricThroughputTotal != nil {
			qrMetricThroughputTotal = *o.MetricThroughputTotal
		}
		qMetricThroughputTotal := swag.FormatInt64(qrMetricThroughputTotal)
		if qMetricThroughputTotal != "" {

			if err := r.SetQueryParam("metric.throughput.total", qMetricThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputWrite != nil {

		// query param metric.throughput.write
		var qrMetricThroughputWrite int64

		if o.MetricThroughputWrite != nil {
			qrMetricThroughputWrite = *o.MetricThroughputWrite
		}
		qMetricThroughputWrite := swag.FormatInt64(qrMetricThroughputWrite)
		if qMetricThroughputWrite != "" {

			if err := r.SetQueryParam("metric.throughput.write", qMetricThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricTimestamp != nil {

		// query param metric.timestamp
		var qrMetricTimestamp string

		if o.MetricTimestamp != nil {
			qrMetricTimestamp = *o.MetricTimestamp
		}
		qMetricTimestamp := qrMetricTimestamp
		if qMetricTimestamp != "" {

			if err := r.SetQueryParam("metric.timestamp", qMetricTimestamp); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawOther != nil {

		// query param statistics.iops_raw.other
		var qrStatisticsIopsRawOther int64

		if o.StatisticsIopsRawOther != nil {
			qrStatisticsIopsRawOther = *o.StatisticsIopsRawOther
		}
		qStatisticsIopsRawOther := swag.FormatInt64(qrStatisticsIopsRawOther)
		if qStatisticsIopsRawOther != "" {

			if err := r.SetQueryParam("statistics.iops_raw.other", qStatisticsIopsRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawRead != nil {

		// query param statistics.iops_raw.read
		var qrStatisticsIopsRawRead int64

		if o.StatisticsIopsRawRead != nil {
			qrStatisticsIopsRawRead = *o.StatisticsIopsRawRead
		}
		qStatisticsIopsRawRead := swag.FormatInt64(qrStatisticsIopsRawRead)
		if qStatisticsIopsRawRead != "" {

			if err := r.SetQueryParam("statistics.iops_raw.read", qStatisticsIopsRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawTotal != nil {

		// query param statistics.iops_raw.total
		var qrStatisticsIopsRawTotal int64

		if o.StatisticsIopsRawTotal != nil {
			qrStatisticsIopsRawTotal = *o.StatisticsIopsRawTotal
		}
		qStatisticsIopsRawTotal := swag.FormatInt64(qrStatisticsIopsRawTotal)
		if qStatisticsIopsRawTotal != "" {

			if err := r.SetQueryParam("statistics.iops_raw.total", qStatisticsIopsRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawWrite != nil {

		// query param statistics.iops_raw.write
		var qrStatisticsIopsRawWrite int64

		if o.StatisticsIopsRawWrite != nil {
			qrStatisticsIopsRawWrite = *o.StatisticsIopsRawWrite
		}
		qStatisticsIopsRawWrite := swag.FormatInt64(qrStatisticsIopsRawWrite)
		if qStatisticsIopsRawWrite != "" {

			if err := r.SetQueryParam("statistics.iops_raw.write", qStatisticsIopsRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawOther != nil {

		// query param statistics.latency_raw.other
		var qrStatisticsLatencyRawOther int64

		if o.StatisticsLatencyRawOther != nil {
			qrStatisticsLatencyRawOther = *o.StatisticsLatencyRawOther
		}
		qStatisticsLatencyRawOther := swag.FormatInt64(qrStatisticsLatencyRawOther)
		if qStatisticsLatencyRawOther != "" {

			if err := r.SetQueryParam("statistics.latency_raw.other", qStatisticsLatencyRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawRead != nil {

		// query param statistics.latency_raw.read
		var qrStatisticsLatencyRawRead int64

		if o.StatisticsLatencyRawRead != nil {
			qrStatisticsLatencyRawRead = *o.StatisticsLatencyRawRead
		}
		qStatisticsLatencyRawRead := swag.FormatInt64(qrStatisticsLatencyRawRead)
		if qStatisticsLatencyRawRead != "" {

			if err := r.SetQueryParam("statistics.latency_raw.read", qStatisticsLatencyRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawTotal != nil {

		// query param statistics.latency_raw.total
		var qrStatisticsLatencyRawTotal int64

		if o.StatisticsLatencyRawTotal != nil {
			qrStatisticsLatencyRawTotal = *o.StatisticsLatencyRawTotal
		}
		qStatisticsLatencyRawTotal := swag.FormatInt64(qrStatisticsLatencyRawTotal)
		if qStatisticsLatencyRawTotal != "" {

			if err := r.SetQueryParam("statistics.latency_raw.total", qStatisticsLatencyRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawWrite != nil {

		// query param statistics.latency_raw.write
		var qrStatisticsLatencyRawWrite int64

		if o.StatisticsLatencyRawWrite != nil {
			qrStatisticsLatencyRawWrite = *o.StatisticsLatencyRawWrite
		}
		qStatisticsLatencyRawWrite := swag.FormatInt64(qrStatisticsLatencyRawWrite)
		if qStatisticsLatencyRawWrite != "" {

			if err := r.SetQueryParam("statistics.latency_raw.write", qStatisticsLatencyRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsStatus != nil {

		// query param statistics.status
		var qrStatisticsStatus string

		if o.StatisticsStatus != nil {
			qrStatisticsStatus = *o.StatisticsStatus
		}
		qStatisticsStatus := qrStatisticsStatus
		if qStatisticsStatus != "" {

			if err := r.SetQueryParam("statistics.status", qStatisticsStatus); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawRead != nil {

		// query param statistics.throughput_raw.read
		var qrStatisticsThroughputRawRead int64

		if o.StatisticsThroughputRawRead != nil {
			qrStatisticsThroughputRawRead = *o.StatisticsThroughputRawRead
		}
		qStatisticsThroughputRawRead := swag.FormatInt64(qrStatisticsThroughputRawRead)
		if qStatisticsThroughputRawRead != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.read", qStatisticsThroughputRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawTotal != nil {

		// query param statistics.throughput_raw.total
		var qrStatisticsThroughputRawTotal int64

		if o.StatisticsThroughputRawTotal != nil {
			qrStatisticsThroughputRawTotal = *o.StatisticsThroughputRawTotal
		}
		qStatisticsThroughputRawTotal := swag.FormatInt64(qrStatisticsThroughputRawTotal)
		if qStatisticsThroughputRawTotal != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.total", qStatisticsThroughputRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawWrite != nil {

		// query param statistics.throughput_raw.write
		var qrStatisticsThroughputRawWrite int64

		if o.StatisticsThroughputRawWrite != nil {
			qrStatisticsThroughputRawWrite = *o.StatisticsThroughputRawWrite
		}
		qStatisticsThroughputRawWrite := swag.FormatInt64(qrStatisticsThroughputRawWrite)
		if qStatisticsThroughputRawWrite != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.write", qStatisticsThroughputRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsTimestamp != nil {

		// query param statistics.timestamp
		var qrStatisticsTimestamp string

		if o.StatisticsTimestamp != nil {
			qrStatisticsTimestamp = *o.StatisticsTimestamp
		}
		qStatisticsTimestamp := qrStatisticsTimestamp
		if qStatisticsTimestamp != "" {

			if err := r.SetQueryParam("statistics.timestamp", qStatisticsTimestamp); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TargetAlias != nil {

		// query param target.alias
		var qrTargetAlias string

		if o.TargetAlias != nil {
			qrTargetAlias = *o.TargetAlias
		}
		qTargetAlias := qrTargetAlias
		if qTargetAlias != "" {

			if err := r.SetQueryParam("target.alias", qTargetAlias); err != nil {
				return err
			}
		}
	}

	if o.TargetName != nil {

		// query param target.name
		var qrTargetName string

		if o.TargetName != nil {
			qrTargetName = *o.TargetName
		}
		qTargetName := qrTargetName
		if qTargetName != "" {

			if err := r.SetQueryParam("target.name", qTargetName); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamIscsiServiceCollectionGet binds the parameter fields
func (o *IscsiServiceCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamIscsiServiceCollectionGet binds the parameter order_by
func (o *IscsiServiceCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
