// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IscsiServiceCreateReader is a Reader for the IscsiServiceCreate structure.
type IscsiServiceCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IscsiServiceCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewIscsiServiceCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIscsiServiceCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIscsiServiceCreateCreated creates a IscsiServiceCreateCreated with default headers values
func NewIscsiServiceCreateCreated() *IscsiServiceCreateCreated {
	return &IscsiServiceCreateCreated{}
}

/*
IscsiServiceCreateCreated describes a response with status code 201, with default header values.

Created
*/
type IscsiServiceCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.IscsiServiceResponse
}

// IsSuccess returns true when this iscsi service create created response has a 2xx status code
func (o *IscsiServiceCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this iscsi service create created response has a 3xx status code
func (o *IscsiServiceCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this iscsi service create created response has a 4xx status code
func (o *IscsiServiceCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this iscsi service create created response has a 5xx status code
func (o *IscsiServiceCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this iscsi service create created response a status code equal to that given
func (o *IscsiServiceCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the iscsi service create created response
func (o *IscsiServiceCreateCreated) Code() int {
	return 201
}

func (o *IscsiServiceCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/iscsi/services][%d] iscsiServiceCreateCreated %s", 201, payload)
}

func (o *IscsiServiceCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/iscsi/services][%d] iscsiServiceCreateCreated %s", 201, payload)
}

func (o *IscsiServiceCreateCreated) GetPayload() *models.IscsiServiceResponse {
	return o.Payload
}

func (o *IscsiServiceCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.IscsiServiceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewIscsiServiceCreateDefault creates a IscsiServiceCreateDefault with default headers values
func NewIscsiServiceCreateDefault(code int) *IscsiServiceCreateDefault {
	return &IscsiServiceCreateDefault{
		_statusCode: code,
	}
}

/*
	IscsiServiceCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 1115127 | The cluster lacks a valid iSCSI license. |
| 2621462 | The supplied SVM does not exist. |
| 2621507 | The iSCSI protocol is not allowed for the specified SVM. |
| 2621706 | The specified `svm.uuid` and `svm.name` do not refer to the same SVM. |
| 2621707 | No SVM was specified. Either `svm.name` or `svm.uuid` must be supplied. |
| 5373966 | An iSCSI service cannot be created in an SVM that is configured for NVMe. |
| 5374077 | An iSCSI service already exists for the specified SVM. |
| 5374893 | The SVM is stopped. The SVM must be running to create an iSCSI service. |
| 5376452 | Service POST and DELETE are not supported on ASA r2. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IscsiServiceCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this iscsi service create default response has a 2xx status code
func (o *IscsiServiceCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this iscsi service create default response has a 3xx status code
func (o *IscsiServiceCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this iscsi service create default response has a 4xx status code
func (o *IscsiServiceCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this iscsi service create default response has a 5xx status code
func (o *IscsiServiceCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this iscsi service create default response a status code equal to that given
func (o *IscsiServiceCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the iscsi service create default response
func (o *IscsiServiceCreateDefault) Code() int {
	return o._statusCode
}

func (o *IscsiServiceCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/iscsi/services][%d] iscsi_service_create default %s", o._statusCode, payload)
}

func (o *IscsiServiceCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/san/iscsi/services][%d] iscsi_service_create default %s", o._statusCode, payload)
}

func (o *IscsiServiceCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IscsiServiceCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
