// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewIscsiServiceDeleteCollectionParams creates a new IscsiServiceDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIscsiServiceDeleteCollectionParams() *IscsiServiceDeleteCollectionParams {
	return &IscsiServiceDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIscsiServiceDeleteCollectionParamsWithTimeout creates a new IscsiServiceDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewIscsiServiceDeleteCollectionParamsWithTimeout(timeout time.Duration) *IscsiServiceDeleteCollectionParams {
	return &IscsiServiceDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewIscsiServiceDeleteCollectionParamsWithContext creates a new IscsiServiceDeleteCollectionParams object
// with the ability to set a context for a request.
func NewIscsiServiceDeleteCollectionParamsWithContext(ctx context.Context) *IscsiServiceDeleteCollectionParams {
	return &IscsiServiceDeleteCollectionParams{
		Context: ctx,
	}
}

// NewIscsiServiceDeleteCollectionParamsWithHTTPClient creates a new IscsiServiceDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewIscsiServiceDeleteCollectionParamsWithHTTPClient(client *http.Client) *IscsiServiceDeleteCollectionParams {
	return &IscsiServiceDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
IscsiServiceDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the iscsi service delete collection operation.

	Typically these are written to a http.Request.
*/
type IscsiServiceDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Info.

	   Info specification
	*/
	Info IscsiServiceDeleteCollectionBody

	/* MetricDuration.

	   Filter by metric.duration
	*/
	MetricDuration *string

	/* MetricIopsOther.

	   Filter by metric.iops.other
	*/
	MetricIopsOther *int64

	/* MetricIopsRead.

	   Filter by metric.iops.read
	*/
	MetricIopsRead *int64

	/* MetricIopsTotal.

	   Filter by metric.iops.total
	*/
	MetricIopsTotal *int64

	/* MetricIopsWrite.

	   Filter by metric.iops.write
	*/
	MetricIopsWrite *int64

	/* MetricLatencyOther.

	   Filter by metric.latency.other
	*/
	MetricLatencyOther *int64

	/* MetricLatencyRead.

	   Filter by metric.latency.read
	*/
	MetricLatencyRead *int64

	/* MetricLatencyTotal.

	   Filter by metric.latency.total
	*/
	MetricLatencyTotal *int64

	/* MetricLatencyWrite.

	   Filter by metric.latency.write
	*/
	MetricLatencyWrite *int64

	/* MetricStatus.

	   Filter by metric.status
	*/
	MetricStatus *string

	/* MetricThroughputRead.

	   Filter by metric.throughput.read
	*/
	MetricThroughputRead *int64

	/* MetricThroughputTotal.

	   Filter by metric.throughput.total
	*/
	MetricThroughputTotal *int64

	/* MetricThroughputWrite.

	   Filter by metric.throughput.write
	*/
	MetricThroughputWrite *int64

	/* MetricTimestamp.

	   Filter by metric.timestamp
	*/
	MetricTimestamp *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* StatisticsIopsRawOther.

	   Filter by statistics.iops_raw.other
	*/
	StatisticsIopsRawOther *int64

	/* StatisticsIopsRawRead.

	   Filter by statistics.iops_raw.read
	*/
	StatisticsIopsRawRead *int64

	/* StatisticsIopsRawTotal.

	   Filter by statistics.iops_raw.total
	*/
	StatisticsIopsRawTotal *int64

	/* StatisticsIopsRawWrite.

	   Filter by statistics.iops_raw.write
	*/
	StatisticsIopsRawWrite *int64

	/* StatisticsLatencyRawOther.

	   Filter by statistics.latency_raw.other
	*/
	StatisticsLatencyRawOther *int64

	/* StatisticsLatencyRawRead.

	   Filter by statistics.latency_raw.read
	*/
	StatisticsLatencyRawRead *int64

	/* StatisticsLatencyRawTotal.

	   Filter by statistics.latency_raw.total
	*/
	StatisticsLatencyRawTotal *int64

	/* StatisticsLatencyRawWrite.

	   Filter by statistics.latency_raw.write
	*/
	StatisticsLatencyRawWrite *int64

	/* StatisticsStatus.

	   Filter by statistics.status
	*/
	StatisticsStatus *string

	/* StatisticsThroughputRawRead.

	   Filter by statistics.throughput_raw.read
	*/
	StatisticsThroughputRawRead *int64

	/* StatisticsThroughputRawTotal.

	   Filter by statistics.throughput_raw.total
	*/
	StatisticsThroughputRawTotal *int64

	/* StatisticsThroughputRawWrite.

	   Filter by statistics.throughput_raw.write
	*/
	StatisticsThroughputRawWrite *int64

	/* StatisticsTimestamp.

	   Filter by statistics.timestamp
	*/
	StatisticsTimestamp *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TargetAlias.

	   Filter by target.alias
	*/
	TargetAlias *string

	/* TargetName.

	   Filter by target.name
	*/
	TargetName *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the iscsi service delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IscsiServiceDeleteCollectionParams) WithDefaults() *IscsiServiceDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the iscsi service delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IscsiServiceDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := IscsiServiceDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithTimeout(timeout time.Duration) *IscsiServiceDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithContext(ctx context.Context) *IscsiServiceDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithHTTPClient(client *http.Client) *IscsiServiceDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *IscsiServiceDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithEnabled adds the enabled to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithEnabled(enabled *bool) *IscsiServiceDeleteCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithInfo adds the info to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithInfo(info IscsiServiceDeleteCollectionBody) *IscsiServiceDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetInfo(info IscsiServiceDeleteCollectionBody) {
	o.Info = info
}

// WithMetricDuration adds the metricDuration to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithMetricDuration(metricDuration *string) *IscsiServiceDeleteCollectionParams {
	o.SetMetricDuration(metricDuration)
	return o
}

// SetMetricDuration adds the metricDuration to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetMetricDuration(metricDuration *string) {
	o.MetricDuration = metricDuration
}

// WithMetricIopsOther adds the metricIopsOther to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithMetricIopsOther(metricIopsOther *int64) *IscsiServiceDeleteCollectionParams {
	o.SetMetricIopsOther(metricIopsOther)
	return o
}

// SetMetricIopsOther adds the metricIopsOther to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetMetricIopsOther(metricIopsOther *int64) {
	o.MetricIopsOther = metricIopsOther
}

// WithMetricIopsRead adds the metricIopsRead to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithMetricIopsRead(metricIopsRead *int64) *IscsiServiceDeleteCollectionParams {
	o.SetMetricIopsRead(metricIopsRead)
	return o
}

// SetMetricIopsRead adds the metricIopsRead to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetMetricIopsRead(metricIopsRead *int64) {
	o.MetricIopsRead = metricIopsRead
}

// WithMetricIopsTotal adds the metricIopsTotal to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithMetricIopsTotal(metricIopsTotal *int64) *IscsiServiceDeleteCollectionParams {
	o.SetMetricIopsTotal(metricIopsTotal)
	return o
}

// SetMetricIopsTotal adds the metricIopsTotal to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetMetricIopsTotal(metricIopsTotal *int64) {
	o.MetricIopsTotal = metricIopsTotal
}

// WithMetricIopsWrite adds the metricIopsWrite to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithMetricIopsWrite(metricIopsWrite *int64) *IscsiServiceDeleteCollectionParams {
	o.SetMetricIopsWrite(metricIopsWrite)
	return o
}

// SetMetricIopsWrite adds the metricIopsWrite to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetMetricIopsWrite(metricIopsWrite *int64) {
	o.MetricIopsWrite = metricIopsWrite
}

// WithMetricLatencyOther adds the metricLatencyOther to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithMetricLatencyOther(metricLatencyOther *int64) *IscsiServiceDeleteCollectionParams {
	o.SetMetricLatencyOther(metricLatencyOther)
	return o
}

// SetMetricLatencyOther adds the metricLatencyOther to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetMetricLatencyOther(metricLatencyOther *int64) {
	o.MetricLatencyOther = metricLatencyOther
}

// WithMetricLatencyRead adds the metricLatencyRead to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithMetricLatencyRead(metricLatencyRead *int64) *IscsiServiceDeleteCollectionParams {
	o.SetMetricLatencyRead(metricLatencyRead)
	return o
}

// SetMetricLatencyRead adds the metricLatencyRead to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetMetricLatencyRead(metricLatencyRead *int64) {
	o.MetricLatencyRead = metricLatencyRead
}

// WithMetricLatencyTotal adds the metricLatencyTotal to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithMetricLatencyTotal(metricLatencyTotal *int64) *IscsiServiceDeleteCollectionParams {
	o.SetMetricLatencyTotal(metricLatencyTotal)
	return o
}

// SetMetricLatencyTotal adds the metricLatencyTotal to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetMetricLatencyTotal(metricLatencyTotal *int64) {
	o.MetricLatencyTotal = metricLatencyTotal
}

// WithMetricLatencyWrite adds the metricLatencyWrite to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithMetricLatencyWrite(metricLatencyWrite *int64) *IscsiServiceDeleteCollectionParams {
	o.SetMetricLatencyWrite(metricLatencyWrite)
	return o
}

// SetMetricLatencyWrite adds the metricLatencyWrite to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetMetricLatencyWrite(metricLatencyWrite *int64) {
	o.MetricLatencyWrite = metricLatencyWrite
}

// WithMetricStatus adds the metricStatus to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithMetricStatus(metricStatus *string) *IscsiServiceDeleteCollectionParams {
	o.SetMetricStatus(metricStatus)
	return o
}

// SetMetricStatus adds the metricStatus to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetMetricStatus(metricStatus *string) {
	o.MetricStatus = metricStatus
}

// WithMetricThroughputRead adds the metricThroughputRead to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithMetricThroughputRead(metricThroughputRead *int64) *IscsiServiceDeleteCollectionParams {
	o.SetMetricThroughputRead(metricThroughputRead)
	return o
}

// SetMetricThroughputRead adds the metricThroughputRead to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetMetricThroughputRead(metricThroughputRead *int64) {
	o.MetricThroughputRead = metricThroughputRead
}

// WithMetricThroughputTotal adds the metricThroughputTotal to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithMetricThroughputTotal(metricThroughputTotal *int64) *IscsiServiceDeleteCollectionParams {
	o.SetMetricThroughputTotal(metricThroughputTotal)
	return o
}

// SetMetricThroughputTotal adds the metricThroughputTotal to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetMetricThroughputTotal(metricThroughputTotal *int64) {
	o.MetricThroughputTotal = metricThroughputTotal
}

// WithMetricThroughputWrite adds the metricThroughputWrite to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithMetricThroughputWrite(metricThroughputWrite *int64) *IscsiServiceDeleteCollectionParams {
	o.SetMetricThroughputWrite(metricThroughputWrite)
	return o
}

// SetMetricThroughputWrite adds the metricThroughputWrite to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetMetricThroughputWrite(metricThroughputWrite *int64) {
	o.MetricThroughputWrite = metricThroughputWrite
}

// WithMetricTimestamp adds the metricTimestamp to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithMetricTimestamp(metricTimestamp *string) *IscsiServiceDeleteCollectionParams {
	o.SetMetricTimestamp(metricTimestamp)
	return o
}

// SetMetricTimestamp adds the metricTimestamp to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetMetricTimestamp(metricTimestamp *string) {
	o.MetricTimestamp = metricTimestamp
}

// WithReturnRecords adds the returnRecords to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *IscsiServiceDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *IscsiServiceDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *IscsiServiceDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithStatisticsIopsRawOther adds the statisticsIopsRawOther to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithStatisticsIopsRawOther(statisticsIopsRawOther *int64) *IscsiServiceDeleteCollectionParams {
	o.SetStatisticsIopsRawOther(statisticsIopsRawOther)
	return o
}

// SetStatisticsIopsRawOther adds the statisticsIopsRawOther to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetStatisticsIopsRawOther(statisticsIopsRawOther *int64) {
	o.StatisticsIopsRawOther = statisticsIopsRawOther
}

// WithStatisticsIopsRawRead adds the statisticsIopsRawRead to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithStatisticsIopsRawRead(statisticsIopsRawRead *int64) *IscsiServiceDeleteCollectionParams {
	o.SetStatisticsIopsRawRead(statisticsIopsRawRead)
	return o
}

// SetStatisticsIopsRawRead adds the statisticsIopsRawRead to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetStatisticsIopsRawRead(statisticsIopsRawRead *int64) {
	o.StatisticsIopsRawRead = statisticsIopsRawRead
}

// WithStatisticsIopsRawTotal adds the statisticsIopsRawTotal to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithStatisticsIopsRawTotal(statisticsIopsRawTotal *int64) *IscsiServiceDeleteCollectionParams {
	o.SetStatisticsIopsRawTotal(statisticsIopsRawTotal)
	return o
}

// SetStatisticsIopsRawTotal adds the statisticsIopsRawTotal to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetStatisticsIopsRawTotal(statisticsIopsRawTotal *int64) {
	o.StatisticsIopsRawTotal = statisticsIopsRawTotal
}

// WithStatisticsIopsRawWrite adds the statisticsIopsRawWrite to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithStatisticsIopsRawWrite(statisticsIopsRawWrite *int64) *IscsiServiceDeleteCollectionParams {
	o.SetStatisticsIopsRawWrite(statisticsIopsRawWrite)
	return o
}

// SetStatisticsIopsRawWrite adds the statisticsIopsRawWrite to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetStatisticsIopsRawWrite(statisticsIopsRawWrite *int64) {
	o.StatisticsIopsRawWrite = statisticsIopsRawWrite
}

// WithStatisticsLatencyRawOther adds the statisticsLatencyRawOther to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithStatisticsLatencyRawOther(statisticsLatencyRawOther *int64) *IscsiServiceDeleteCollectionParams {
	o.SetStatisticsLatencyRawOther(statisticsLatencyRawOther)
	return o
}

// SetStatisticsLatencyRawOther adds the statisticsLatencyRawOther to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetStatisticsLatencyRawOther(statisticsLatencyRawOther *int64) {
	o.StatisticsLatencyRawOther = statisticsLatencyRawOther
}

// WithStatisticsLatencyRawRead adds the statisticsLatencyRawRead to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithStatisticsLatencyRawRead(statisticsLatencyRawRead *int64) *IscsiServiceDeleteCollectionParams {
	o.SetStatisticsLatencyRawRead(statisticsLatencyRawRead)
	return o
}

// SetStatisticsLatencyRawRead adds the statisticsLatencyRawRead to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetStatisticsLatencyRawRead(statisticsLatencyRawRead *int64) {
	o.StatisticsLatencyRawRead = statisticsLatencyRawRead
}

// WithStatisticsLatencyRawTotal adds the statisticsLatencyRawTotal to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithStatisticsLatencyRawTotal(statisticsLatencyRawTotal *int64) *IscsiServiceDeleteCollectionParams {
	o.SetStatisticsLatencyRawTotal(statisticsLatencyRawTotal)
	return o
}

// SetStatisticsLatencyRawTotal adds the statisticsLatencyRawTotal to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetStatisticsLatencyRawTotal(statisticsLatencyRawTotal *int64) {
	o.StatisticsLatencyRawTotal = statisticsLatencyRawTotal
}

// WithStatisticsLatencyRawWrite adds the statisticsLatencyRawWrite to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithStatisticsLatencyRawWrite(statisticsLatencyRawWrite *int64) *IscsiServiceDeleteCollectionParams {
	o.SetStatisticsLatencyRawWrite(statisticsLatencyRawWrite)
	return o
}

// SetStatisticsLatencyRawWrite adds the statisticsLatencyRawWrite to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetStatisticsLatencyRawWrite(statisticsLatencyRawWrite *int64) {
	o.StatisticsLatencyRawWrite = statisticsLatencyRawWrite
}

// WithStatisticsStatus adds the statisticsStatus to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithStatisticsStatus(statisticsStatus *string) *IscsiServiceDeleteCollectionParams {
	o.SetStatisticsStatus(statisticsStatus)
	return o
}

// SetStatisticsStatus adds the statisticsStatus to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetStatisticsStatus(statisticsStatus *string) {
	o.StatisticsStatus = statisticsStatus
}

// WithStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) *IscsiServiceDeleteCollectionParams {
	o.SetStatisticsThroughputRawRead(statisticsThroughputRawRead)
	return o
}

// SetStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) {
	o.StatisticsThroughputRawRead = statisticsThroughputRawRead
}

// WithStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) *IscsiServiceDeleteCollectionParams {
	o.SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal)
	return o
}

// SetStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) {
	o.StatisticsThroughputRawTotal = statisticsThroughputRawTotal
}

// WithStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) *IscsiServiceDeleteCollectionParams {
	o.SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite)
	return o
}

// SetStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) {
	o.StatisticsThroughputRawWrite = statisticsThroughputRawWrite
}

// WithStatisticsTimestamp adds the statisticsTimestamp to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithStatisticsTimestamp(statisticsTimestamp *string) *IscsiServiceDeleteCollectionParams {
	o.SetStatisticsTimestamp(statisticsTimestamp)
	return o
}

// SetStatisticsTimestamp adds the statisticsTimestamp to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetStatisticsTimestamp(statisticsTimestamp *string) {
	o.StatisticsTimestamp = statisticsTimestamp
}

// WithSvmName adds the svmName to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithSvmName(svmName *string) *IscsiServiceDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithSvmUUID(svmUUID *string) *IscsiServiceDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTargetAlias adds the targetAlias to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithTargetAlias(targetAlias *string) *IscsiServiceDeleteCollectionParams {
	o.SetTargetAlias(targetAlias)
	return o
}

// SetTargetAlias adds the targetAlias to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetTargetAlias(targetAlias *string) {
	o.TargetAlias = targetAlias
}

// WithTargetName adds the targetName to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) WithTargetName(targetName *string) *IscsiServiceDeleteCollectionParams {
	o.SetTargetName(targetName)
	return o
}

// SetTargetName adds the targetName to the iscsi service delete collection params
func (o *IscsiServiceDeleteCollectionParams) SetTargetName(targetName *string) {
	o.TargetName = targetName
}

// WriteToRequest writes these params to a swagger request
func (o *IscsiServiceDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.MetricDuration != nil {

		// query param metric.duration
		var qrMetricDuration string

		if o.MetricDuration != nil {
			qrMetricDuration = *o.MetricDuration
		}
		qMetricDuration := qrMetricDuration
		if qMetricDuration != "" {

			if err := r.SetQueryParam("metric.duration", qMetricDuration); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsOther != nil {

		// query param metric.iops.other
		var qrMetricIopsOther int64

		if o.MetricIopsOther != nil {
			qrMetricIopsOther = *o.MetricIopsOther
		}
		qMetricIopsOther := swag.FormatInt64(qrMetricIopsOther)
		if qMetricIopsOther != "" {

			if err := r.SetQueryParam("metric.iops.other", qMetricIopsOther); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsRead != nil {

		// query param metric.iops.read
		var qrMetricIopsRead int64

		if o.MetricIopsRead != nil {
			qrMetricIopsRead = *o.MetricIopsRead
		}
		qMetricIopsRead := swag.FormatInt64(qrMetricIopsRead)
		if qMetricIopsRead != "" {

			if err := r.SetQueryParam("metric.iops.read", qMetricIopsRead); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsTotal != nil {

		// query param metric.iops.total
		var qrMetricIopsTotal int64

		if o.MetricIopsTotal != nil {
			qrMetricIopsTotal = *o.MetricIopsTotal
		}
		qMetricIopsTotal := swag.FormatInt64(qrMetricIopsTotal)
		if qMetricIopsTotal != "" {

			if err := r.SetQueryParam("metric.iops.total", qMetricIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsWrite != nil {

		// query param metric.iops.write
		var qrMetricIopsWrite int64

		if o.MetricIopsWrite != nil {
			qrMetricIopsWrite = *o.MetricIopsWrite
		}
		qMetricIopsWrite := swag.FormatInt64(qrMetricIopsWrite)
		if qMetricIopsWrite != "" {

			if err := r.SetQueryParam("metric.iops.write", qMetricIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyOther != nil {

		// query param metric.latency.other
		var qrMetricLatencyOther int64

		if o.MetricLatencyOther != nil {
			qrMetricLatencyOther = *o.MetricLatencyOther
		}
		qMetricLatencyOther := swag.FormatInt64(qrMetricLatencyOther)
		if qMetricLatencyOther != "" {

			if err := r.SetQueryParam("metric.latency.other", qMetricLatencyOther); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyRead != nil {

		// query param metric.latency.read
		var qrMetricLatencyRead int64

		if o.MetricLatencyRead != nil {
			qrMetricLatencyRead = *o.MetricLatencyRead
		}
		qMetricLatencyRead := swag.FormatInt64(qrMetricLatencyRead)
		if qMetricLatencyRead != "" {

			if err := r.SetQueryParam("metric.latency.read", qMetricLatencyRead); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyTotal != nil {

		// query param metric.latency.total
		var qrMetricLatencyTotal int64

		if o.MetricLatencyTotal != nil {
			qrMetricLatencyTotal = *o.MetricLatencyTotal
		}
		qMetricLatencyTotal := swag.FormatInt64(qrMetricLatencyTotal)
		if qMetricLatencyTotal != "" {

			if err := r.SetQueryParam("metric.latency.total", qMetricLatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyWrite != nil {

		// query param metric.latency.write
		var qrMetricLatencyWrite int64

		if o.MetricLatencyWrite != nil {
			qrMetricLatencyWrite = *o.MetricLatencyWrite
		}
		qMetricLatencyWrite := swag.FormatInt64(qrMetricLatencyWrite)
		if qMetricLatencyWrite != "" {

			if err := r.SetQueryParam("metric.latency.write", qMetricLatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricStatus != nil {

		// query param metric.status
		var qrMetricStatus string

		if o.MetricStatus != nil {
			qrMetricStatus = *o.MetricStatus
		}
		qMetricStatus := qrMetricStatus
		if qMetricStatus != "" {

			if err := r.SetQueryParam("metric.status", qMetricStatus); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputRead != nil {

		// query param metric.throughput.read
		var qrMetricThroughputRead int64

		if o.MetricThroughputRead != nil {
			qrMetricThroughputRead = *o.MetricThroughputRead
		}
		qMetricThroughputRead := swag.FormatInt64(qrMetricThroughputRead)
		if qMetricThroughputRead != "" {

			if err := r.SetQueryParam("metric.throughput.read", qMetricThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputTotal != nil {

		// query param metric.throughput.total
		var qrMetricThroughputTotal int64

		if o.MetricThroughputTotal != nil {
			qrMetricThroughputTotal = *o.MetricThroughputTotal
		}
		qMetricThroughputTotal := swag.FormatInt64(qrMetricThroughputTotal)
		if qMetricThroughputTotal != "" {

			if err := r.SetQueryParam("metric.throughput.total", qMetricThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputWrite != nil {

		// query param metric.throughput.write
		var qrMetricThroughputWrite int64

		if o.MetricThroughputWrite != nil {
			qrMetricThroughputWrite = *o.MetricThroughputWrite
		}
		qMetricThroughputWrite := swag.FormatInt64(qrMetricThroughputWrite)
		if qMetricThroughputWrite != "" {

			if err := r.SetQueryParam("metric.throughput.write", qMetricThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricTimestamp != nil {

		// query param metric.timestamp
		var qrMetricTimestamp string

		if o.MetricTimestamp != nil {
			qrMetricTimestamp = *o.MetricTimestamp
		}
		qMetricTimestamp := qrMetricTimestamp
		if qMetricTimestamp != "" {

			if err := r.SetQueryParam("metric.timestamp", qMetricTimestamp); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawOther != nil {

		// query param statistics.iops_raw.other
		var qrStatisticsIopsRawOther int64

		if o.StatisticsIopsRawOther != nil {
			qrStatisticsIopsRawOther = *o.StatisticsIopsRawOther
		}
		qStatisticsIopsRawOther := swag.FormatInt64(qrStatisticsIopsRawOther)
		if qStatisticsIopsRawOther != "" {

			if err := r.SetQueryParam("statistics.iops_raw.other", qStatisticsIopsRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawRead != nil {

		// query param statistics.iops_raw.read
		var qrStatisticsIopsRawRead int64

		if o.StatisticsIopsRawRead != nil {
			qrStatisticsIopsRawRead = *o.StatisticsIopsRawRead
		}
		qStatisticsIopsRawRead := swag.FormatInt64(qrStatisticsIopsRawRead)
		if qStatisticsIopsRawRead != "" {

			if err := r.SetQueryParam("statistics.iops_raw.read", qStatisticsIopsRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawTotal != nil {

		// query param statistics.iops_raw.total
		var qrStatisticsIopsRawTotal int64

		if o.StatisticsIopsRawTotal != nil {
			qrStatisticsIopsRawTotal = *o.StatisticsIopsRawTotal
		}
		qStatisticsIopsRawTotal := swag.FormatInt64(qrStatisticsIopsRawTotal)
		if qStatisticsIopsRawTotal != "" {

			if err := r.SetQueryParam("statistics.iops_raw.total", qStatisticsIopsRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawWrite != nil {

		// query param statistics.iops_raw.write
		var qrStatisticsIopsRawWrite int64

		if o.StatisticsIopsRawWrite != nil {
			qrStatisticsIopsRawWrite = *o.StatisticsIopsRawWrite
		}
		qStatisticsIopsRawWrite := swag.FormatInt64(qrStatisticsIopsRawWrite)
		if qStatisticsIopsRawWrite != "" {

			if err := r.SetQueryParam("statistics.iops_raw.write", qStatisticsIopsRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawOther != nil {

		// query param statistics.latency_raw.other
		var qrStatisticsLatencyRawOther int64

		if o.StatisticsLatencyRawOther != nil {
			qrStatisticsLatencyRawOther = *o.StatisticsLatencyRawOther
		}
		qStatisticsLatencyRawOther := swag.FormatInt64(qrStatisticsLatencyRawOther)
		if qStatisticsLatencyRawOther != "" {

			if err := r.SetQueryParam("statistics.latency_raw.other", qStatisticsLatencyRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawRead != nil {

		// query param statistics.latency_raw.read
		var qrStatisticsLatencyRawRead int64

		if o.StatisticsLatencyRawRead != nil {
			qrStatisticsLatencyRawRead = *o.StatisticsLatencyRawRead
		}
		qStatisticsLatencyRawRead := swag.FormatInt64(qrStatisticsLatencyRawRead)
		if qStatisticsLatencyRawRead != "" {

			if err := r.SetQueryParam("statistics.latency_raw.read", qStatisticsLatencyRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawTotal != nil {

		// query param statistics.latency_raw.total
		var qrStatisticsLatencyRawTotal int64

		if o.StatisticsLatencyRawTotal != nil {
			qrStatisticsLatencyRawTotal = *o.StatisticsLatencyRawTotal
		}
		qStatisticsLatencyRawTotal := swag.FormatInt64(qrStatisticsLatencyRawTotal)
		if qStatisticsLatencyRawTotal != "" {

			if err := r.SetQueryParam("statistics.latency_raw.total", qStatisticsLatencyRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawWrite != nil {

		// query param statistics.latency_raw.write
		var qrStatisticsLatencyRawWrite int64

		if o.StatisticsLatencyRawWrite != nil {
			qrStatisticsLatencyRawWrite = *o.StatisticsLatencyRawWrite
		}
		qStatisticsLatencyRawWrite := swag.FormatInt64(qrStatisticsLatencyRawWrite)
		if qStatisticsLatencyRawWrite != "" {

			if err := r.SetQueryParam("statistics.latency_raw.write", qStatisticsLatencyRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsStatus != nil {

		// query param statistics.status
		var qrStatisticsStatus string

		if o.StatisticsStatus != nil {
			qrStatisticsStatus = *o.StatisticsStatus
		}
		qStatisticsStatus := qrStatisticsStatus
		if qStatisticsStatus != "" {

			if err := r.SetQueryParam("statistics.status", qStatisticsStatus); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawRead != nil {

		// query param statistics.throughput_raw.read
		var qrStatisticsThroughputRawRead int64

		if o.StatisticsThroughputRawRead != nil {
			qrStatisticsThroughputRawRead = *o.StatisticsThroughputRawRead
		}
		qStatisticsThroughputRawRead := swag.FormatInt64(qrStatisticsThroughputRawRead)
		if qStatisticsThroughputRawRead != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.read", qStatisticsThroughputRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawTotal != nil {

		// query param statistics.throughput_raw.total
		var qrStatisticsThroughputRawTotal int64

		if o.StatisticsThroughputRawTotal != nil {
			qrStatisticsThroughputRawTotal = *o.StatisticsThroughputRawTotal
		}
		qStatisticsThroughputRawTotal := swag.FormatInt64(qrStatisticsThroughputRawTotal)
		if qStatisticsThroughputRawTotal != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.total", qStatisticsThroughputRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawWrite != nil {

		// query param statistics.throughput_raw.write
		var qrStatisticsThroughputRawWrite int64

		if o.StatisticsThroughputRawWrite != nil {
			qrStatisticsThroughputRawWrite = *o.StatisticsThroughputRawWrite
		}
		qStatisticsThroughputRawWrite := swag.FormatInt64(qrStatisticsThroughputRawWrite)
		if qStatisticsThroughputRawWrite != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.write", qStatisticsThroughputRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsTimestamp != nil {

		// query param statistics.timestamp
		var qrStatisticsTimestamp string

		if o.StatisticsTimestamp != nil {
			qrStatisticsTimestamp = *o.StatisticsTimestamp
		}
		qStatisticsTimestamp := qrStatisticsTimestamp
		if qStatisticsTimestamp != "" {

			if err := r.SetQueryParam("statistics.timestamp", qStatisticsTimestamp); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TargetAlias != nil {

		// query param target.alias
		var qrTargetAlias string

		if o.TargetAlias != nil {
			qrTargetAlias = *o.TargetAlias
		}
		qTargetAlias := qrTargetAlias
		if qTargetAlias != "" {

			if err := r.SetQueryParam("target.alias", qTargetAlias); err != nil {
				return err
			}
		}
	}

	if o.TargetName != nil {

		// query param target.name
		var qrTargetName string

		if o.TargetName != nil {
			qrTargetName = *o.TargetName
		}
		qTargetName := qrTargetName
		if qTargetName != "" {

			if err := r.SetQueryParam("target.name", qTargetName); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
