// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewIscsiSessionCollectionGetParams creates a new IscsiSessionCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIscsiSessionCollectionGetParams() *IscsiSessionCollectionGetParams {
	return &IscsiSessionCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIscsiSessionCollectionGetParamsWithTimeout creates a new IscsiSessionCollectionGetParams object
// with the ability to set a timeout on a request.
func NewIscsiSessionCollectionGetParamsWithTimeout(timeout time.Duration) *IscsiSessionCollectionGetParams {
	return &IscsiSessionCollectionGetParams{
		timeout: timeout,
	}
}

// NewIscsiSessionCollectionGetParamsWithContext creates a new IscsiSessionCollectionGetParams object
// with the ability to set a context for a request.
func NewIscsiSessionCollectionGetParamsWithContext(ctx context.Context) *IscsiSessionCollectionGetParams {
	return &IscsiSessionCollectionGetParams{
		Context: ctx,
	}
}

// NewIscsiSessionCollectionGetParamsWithHTTPClient creates a new IscsiSessionCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewIscsiSessionCollectionGetParamsWithHTTPClient(client *http.Client) *IscsiSessionCollectionGetParams {
	return &IscsiSessionCollectionGetParams{
		HTTPClient: client,
	}
}

/*
IscsiSessionCollectionGetParams contains all the parameters to send to the API endpoint

	for the iscsi session collection get operation.

	Typically these are written to a http.Request.
*/
type IscsiSessionCollectionGetParams struct {

	/* ConnectionsAuthenticationType.

	   Filter by connections.authentication_type
	*/
	ConnectionsAuthenticationType *string

	/* ConnectionsCid.

	   Filter by connections.cid
	*/
	ConnectionsCid *int64

	/* ConnectionsInitiatorAddressAddress.

	   Filter by connections.initiator_address.address
	*/
	ConnectionsInitiatorAddressAddress *string

	/* ConnectionsInitiatorAddressPort.

	   Filter by connections.initiator_address.port
	*/
	ConnectionsInitiatorAddressPort *int64

	/* ConnectionsInterfaceIPAddress.

	   Filter by connections.interface.ip.address
	*/
	ConnectionsInterfaceIPAddress *string

	/* ConnectionsInterfaceIPPort.

	   Filter by connections.interface.ip.port
	*/
	ConnectionsInterfaceIPPort *int64

	/* ConnectionsInterfaceName.

	   Filter by connections.interface.name
	*/
	ConnectionsInterfaceName *string

	/* ConnectionsInterfaceUUID.

	   Filter by connections.interface.uuid
	*/
	ConnectionsInterfaceUUID *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IgroupsName.

	   Filter by igroups.name
	*/
	IgroupsName *string

	/* IgroupsUUID.

	   Filter by igroups.uuid
	*/
	IgroupsUUID *string

	/* InitiatorAlias.

	   Filter by initiator.alias
	*/
	InitiatorAlias *string

	/* InitiatorComment.

	   Filter by initiator.comment
	*/
	InitiatorComment *string

	/* InitiatorName.

	   Filter by initiator.name
	*/
	InitiatorName *string

	/* Isid.

	   Filter by isid
	*/
	Isid *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TargetPortalGroup.

	   Filter by target_portal_group
	*/
	TargetPortalGroup *string

	/* TargetPortalGroupTag.

	   Filter by target_portal_group_tag
	*/
	TargetPortalGroupTag *int64

	/* Tsih.

	   Filter by tsih
	*/
	Tsih *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the iscsi session collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IscsiSessionCollectionGetParams) WithDefaults() *IscsiSessionCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the iscsi session collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IscsiSessionCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := IscsiSessionCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithTimeout(timeout time.Duration) *IscsiSessionCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithContext(ctx context.Context) *IscsiSessionCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithHTTPClient(client *http.Client) *IscsiSessionCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithConnectionsAuthenticationType adds the connectionsAuthenticationType to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithConnectionsAuthenticationType(connectionsAuthenticationType *string) *IscsiSessionCollectionGetParams {
	o.SetConnectionsAuthenticationType(connectionsAuthenticationType)
	return o
}

// SetConnectionsAuthenticationType adds the connectionsAuthenticationType to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetConnectionsAuthenticationType(connectionsAuthenticationType *string) {
	o.ConnectionsAuthenticationType = connectionsAuthenticationType
}

// WithConnectionsCid adds the connectionsCid to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithConnectionsCid(connectionsCid *int64) *IscsiSessionCollectionGetParams {
	o.SetConnectionsCid(connectionsCid)
	return o
}

// SetConnectionsCid adds the connectionsCid to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetConnectionsCid(connectionsCid *int64) {
	o.ConnectionsCid = connectionsCid
}

// WithConnectionsInitiatorAddressAddress adds the connectionsInitiatorAddressAddress to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithConnectionsInitiatorAddressAddress(connectionsInitiatorAddressAddress *string) *IscsiSessionCollectionGetParams {
	o.SetConnectionsInitiatorAddressAddress(connectionsInitiatorAddressAddress)
	return o
}

// SetConnectionsInitiatorAddressAddress adds the connectionsInitiatorAddressAddress to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetConnectionsInitiatorAddressAddress(connectionsInitiatorAddressAddress *string) {
	o.ConnectionsInitiatorAddressAddress = connectionsInitiatorAddressAddress
}

// WithConnectionsInitiatorAddressPort adds the connectionsInitiatorAddressPort to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithConnectionsInitiatorAddressPort(connectionsInitiatorAddressPort *int64) *IscsiSessionCollectionGetParams {
	o.SetConnectionsInitiatorAddressPort(connectionsInitiatorAddressPort)
	return o
}

// SetConnectionsInitiatorAddressPort adds the connectionsInitiatorAddressPort to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetConnectionsInitiatorAddressPort(connectionsInitiatorAddressPort *int64) {
	o.ConnectionsInitiatorAddressPort = connectionsInitiatorAddressPort
}

// WithConnectionsInterfaceIPAddress adds the connectionsInterfaceIPAddress to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithConnectionsInterfaceIPAddress(connectionsInterfaceIPAddress *string) *IscsiSessionCollectionGetParams {
	o.SetConnectionsInterfaceIPAddress(connectionsInterfaceIPAddress)
	return o
}

// SetConnectionsInterfaceIPAddress adds the connectionsInterfaceIpAddress to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetConnectionsInterfaceIPAddress(connectionsInterfaceIPAddress *string) {
	o.ConnectionsInterfaceIPAddress = connectionsInterfaceIPAddress
}

// WithConnectionsInterfaceIPPort adds the connectionsInterfaceIPPort to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithConnectionsInterfaceIPPort(connectionsInterfaceIPPort *int64) *IscsiSessionCollectionGetParams {
	o.SetConnectionsInterfaceIPPort(connectionsInterfaceIPPort)
	return o
}

// SetConnectionsInterfaceIPPort adds the connectionsInterfaceIpPort to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetConnectionsInterfaceIPPort(connectionsInterfaceIPPort *int64) {
	o.ConnectionsInterfaceIPPort = connectionsInterfaceIPPort
}

// WithConnectionsInterfaceName adds the connectionsInterfaceName to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithConnectionsInterfaceName(connectionsInterfaceName *string) *IscsiSessionCollectionGetParams {
	o.SetConnectionsInterfaceName(connectionsInterfaceName)
	return o
}

// SetConnectionsInterfaceName adds the connectionsInterfaceName to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetConnectionsInterfaceName(connectionsInterfaceName *string) {
	o.ConnectionsInterfaceName = connectionsInterfaceName
}

// WithConnectionsInterfaceUUID adds the connectionsInterfaceUUID to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithConnectionsInterfaceUUID(connectionsInterfaceUUID *string) *IscsiSessionCollectionGetParams {
	o.SetConnectionsInterfaceUUID(connectionsInterfaceUUID)
	return o
}

// SetConnectionsInterfaceUUID adds the connectionsInterfaceUuid to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetConnectionsInterfaceUUID(connectionsInterfaceUUID *string) {
	o.ConnectionsInterfaceUUID = connectionsInterfaceUUID
}

// WithFields adds the fields to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithFields(fields []string) *IscsiSessionCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIgroupsName adds the igroupsName to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithIgroupsName(igroupsName *string) *IscsiSessionCollectionGetParams {
	o.SetIgroupsName(igroupsName)
	return o
}

// SetIgroupsName adds the igroupsName to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetIgroupsName(igroupsName *string) {
	o.IgroupsName = igroupsName
}

// WithIgroupsUUID adds the igroupsUUID to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithIgroupsUUID(igroupsUUID *string) *IscsiSessionCollectionGetParams {
	o.SetIgroupsUUID(igroupsUUID)
	return o
}

// SetIgroupsUUID adds the igroupsUuid to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetIgroupsUUID(igroupsUUID *string) {
	o.IgroupsUUID = igroupsUUID
}

// WithInitiatorAlias adds the initiatorAlias to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithInitiatorAlias(initiatorAlias *string) *IscsiSessionCollectionGetParams {
	o.SetInitiatorAlias(initiatorAlias)
	return o
}

// SetInitiatorAlias adds the initiatorAlias to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetInitiatorAlias(initiatorAlias *string) {
	o.InitiatorAlias = initiatorAlias
}

// WithInitiatorComment adds the initiatorComment to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithInitiatorComment(initiatorComment *string) *IscsiSessionCollectionGetParams {
	o.SetInitiatorComment(initiatorComment)
	return o
}

// SetInitiatorComment adds the initiatorComment to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetInitiatorComment(initiatorComment *string) {
	o.InitiatorComment = initiatorComment
}

// WithInitiatorName adds the initiatorName to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithInitiatorName(initiatorName *string) *IscsiSessionCollectionGetParams {
	o.SetInitiatorName(initiatorName)
	return o
}

// SetInitiatorName adds the initiatorName to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetInitiatorName(initiatorName *string) {
	o.InitiatorName = initiatorName
}

// WithIsid adds the isid to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithIsid(isid *string) *IscsiSessionCollectionGetParams {
	o.SetIsid(isid)
	return o
}

// SetIsid adds the isid to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetIsid(isid *string) {
	o.Isid = isid
}

// WithMaxRecords adds the maxRecords to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithMaxRecords(maxRecords *int64) *IscsiSessionCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithOrderBy(orderBy []string) *IscsiSessionCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithReturnRecords(returnRecords *bool) *IscsiSessionCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *IscsiSessionCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithSvmName(svmName *string) *IscsiSessionCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithSvmUUID(svmUUID *string) *IscsiSessionCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTargetPortalGroup adds the targetPortalGroup to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithTargetPortalGroup(targetPortalGroup *string) *IscsiSessionCollectionGetParams {
	o.SetTargetPortalGroup(targetPortalGroup)
	return o
}

// SetTargetPortalGroup adds the targetPortalGroup to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetTargetPortalGroup(targetPortalGroup *string) {
	o.TargetPortalGroup = targetPortalGroup
}

// WithTargetPortalGroupTag adds the targetPortalGroupTag to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithTargetPortalGroupTag(targetPortalGroupTag *int64) *IscsiSessionCollectionGetParams {
	o.SetTargetPortalGroupTag(targetPortalGroupTag)
	return o
}

// SetTargetPortalGroupTag adds the targetPortalGroupTag to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetTargetPortalGroupTag(targetPortalGroupTag *int64) {
	o.TargetPortalGroupTag = targetPortalGroupTag
}

// WithTsih adds the tsih to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) WithTsih(tsih *int64) *IscsiSessionCollectionGetParams {
	o.SetTsih(tsih)
	return o
}

// SetTsih adds the tsih to the iscsi session collection get params
func (o *IscsiSessionCollectionGetParams) SetTsih(tsih *int64) {
	o.Tsih = tsih
}

// WriteToRequest writes these params to a swagger request
func (o *IscsiSessionCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ConnectionsAuthenticationType != nil {

		// query param connections.authentication_type
		var qrConnectionsAuthenticationType string

		if o.ConnectionsAuthenticationType != nil {
			qrConnectionsAuthenticationType = *o.ConnectionsAuthenticationType
		}
		qConnectionsAuthenticationType := qrConnectionsAuthenticationType
		if qConnectionsAuthenticationType != "" {

			if err := r.SetQueryParam("connections.authentication_type", qConnectionsAuthenticationType); err != nil {
				return err
			}
		}
	}

	if o.ConnectionsCid != nil {

		// query param connections.cid
		var qrConnectionsCid int64

		if o.ConnectionsCid != nil {
			qrConnectionsCid = *o.ConnectionsCid
		}
		qConnectionsCid := swag.FormatInt64(qrConnectionsCid)
		if qConnectionsCid != "" {

			if err := r.SetQueryParam("connections.cid", qConnectionsCid); err != nil {
				return err
			}
		}
	}

	if o.ConnectionsInitiatorAddressAddress != nil {

		// query param connections.initiator_address.address
		var qrConnectionsInitiatorAddressAddress string

		if o.ConnectionsInitiatorAddressAddress != nil {
			qrConnectionsInitiatorAddressAddress = *o.ConnectionsInitiatorAddressAddress
		}
		qConnectionsInitiatorAddressAddress := qrConnectionsInitiatorAddressAddress
		if qConnectionsInitiatorAddressAddress != "" {

			if err := r.SetQueryParam("connections.initiator_address.address", qConnectionsInitiatorAddressAddress); err != nil {
				return err
			}
		}
	}

	if o.ConnectionsInitiatorAddressPort != nil {

		// query param connections.initiator_address.port
		var qrConnectionsInitiatorAddressPort int64

		if o.ConnectionsInitiatorAddressPort != nil {
			qrConnectionsInitiatorAddressPort = *o.ConnectionsInitiatorAddressPort
		}
		qConnectionsInitiatorAddressPort := swag.FormatInt64(qrConnectionsInitiatorAddressPort)
		if qConnectionsInitiatorAddressPort != "" {

			if err := r.SetQueryParam("connections.initiator_address.port", qConnectionsInitiatorAddressPort); err != nil {
				return err
			}
		}
	}

	if o.ConnectionsInterfaceIPAddress != nil {

		// query param connections.interface.ip.address
		var qrConnectionsInterfaceIPAddress string

		if o.ConnectionsInterfaceIPAddress != nil {
			qrConnectionsInterfaceIPAddress = *o.ConnectionsInterfaceIPAddress
		}
		qConnectionsInterfaceIPAddress := qrConnectionsInterfaceIPAddress
		if qConnectionsInterfaceIPAddress != "" {

			if err := r.SetQueryParam("connections.interface.ip.address", qConnectionsInterfaceIPAddress); err != nil {
				return err
			}
		}
	}

	if o.ConnectionsInterfaceIPPort != nil {

		// query param connections.interface.ip.port
		var qrConnectionsInterfaceIPPort int64

		if o.ConnectionsInterfaceIPPort != nil {
			qrConnectionsInterfaceIPPort = *o.ConnectionsInterfaceIPPort
		}
		qConnectionsInterfaceIPPort := swag.FormatInt64(qrConnectionsInterfaceIPPort)
		if qConnectionsInterfaceIPPort != "" {

			if err := r.SetQueryParam("connections.interface.ip.port", qConnectionsInterfaceIPPort); err != nil {
				return err
			}
		}
	}

	if o.ConnectionsInterfaceName != nil {

		// query param connections.interface.name
		var qrConnectionsInterfaceName string

		if o.ConnectionsInterfaceName != nil {
			qrConnectionsInterfaceName = *o.ConnectionsInterfaceName
		}
		qConnectionsInterfaceName := qrConnectionsInterfaceName
		if qConnectionsInterfaceName != "" {

			if err := r.SetQueryParam("connections.interface.name", qConnectionsInterfaceName); err != nil {
				return err
			}
		}
	}

	if o.ConnectionsInterfaceUUID != nil {

		// query param connections.interface.uuid
		var qrConnectionsInterfaceUUID string

		if o.ConnectionsInterfaceUUID != nil {
			qrConnectionsInterfaceUUID = *o.ConnectionsInterfaceUUID
		}
		qConnectionsInterfaceUUID := qrConnectionsInterfaceUUID
		if qConnectionsInterfaceUUID != "" {

			if err := r.SetQueryParam("connections.interface.uuid", qConnectionsInterfaceUUID); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.IgroupsName != nil {

		// query param igroups.name
		var qrIgroupsName string

		if o.IgroupsName != nil {
			qrIgroupsName = *o.IgroupsName
		}
		qIgroupsName := qrIgroupsName
		if qIgroupsName != "" {

			if err := r.SetQueryParam("igroups.name", qIgroupsName); err != nil {
				return err
			}
		}
	}

	if o.IgroupsUUID != nil {

		// query param igroups.uuid
		var qrIgroupsUUID string

		if o.IgroupsUUID != nil {
			qrIgroupsUUID = *o.IgroupsUUID
		}
		qIgroupsUUID := qrIgroupsUUID
		if qIgroupsUUID != "" {

			if err := r.SetQueryParam("igroups.uuid", qIgroupsUUID); err != nil {
				return err
			}
		}
	}

	if o.InitiatorAlias != nil {

		// query param initiator.alias
		var qrInitiatorAlias string

		if o.InitiatorAlias != nil {
			qrInitiatorAlias = *o.InitiatorAlias
		}
		qInitiatorAlias := qrInitiatorAlias
		if qInitiatorAlias != "" {

			if err := r.SetQueryParam("initiator.alias", qInitiatorAlias); err != nil {
				return err
			}
		}
	}

	if o.InitiatorComment != nil {

		// query param initiator.comment
		var qrInitiatorComment string

		if o.InitiatorComment != nil {
			qrInitiatorComment = *o.InitiatorComment
		}
		qInitiatorComment := qrInitiatorComment
		if qInitiatorComment != "" {

			if err := r.SetQueryParam("initiator.comment", qInitiatorComment); err != nil {
				return err
			}
		}
	}

	if o.InitiatorName != nil {

		// query param initiator.name
		var qrInitiatorName string

		if o.InitiatorName != nil {
			qrInitiatorName = *o.InitiatorName
		}
		qInitiatorName := qrInitiatorName
		if qInitiatorName != "" {

			if err := r.SetQueryParam("initiator.name", qInitiatorName); err != nil {
				return err
			}
		}
	}

	if o.Isid != nil {

		// query param isid
		var qrIsid string

		if o.Isid != nil {
			qrIsid = *o.Isid
		}
		qIsid := qrIsid
		if qIsid != "" {

			if err := r.SetQueryParam("isid", qIsid); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TargetPortalGroup != nil {

		// query param target_portal_group
		var qrTargetPortalGroup string

		if o.TargetPortalGroup != nil {
			qrTargetPortalGroup = *o.TargetPortalGroup
		}
		qTargetPortalGroup := qrTargetPortalGroup
		if qTargetPortalGroup != "" {

			if err := r.SetQueryParam("target_portal_group", qTargetPortalGroup); err != nil {
				return err
			}
		}
	}

	if o.TargetPortalGroupTag != nil {

		// query param target_portal_group_tag
		var qrTargetPortalGroupTag int64

		if o.TargetPortalGroupTag != nil {
			qrTargetPortalGroupTag = *o.TargetPortalGroupTag
		}
		qTargetPortalGroupTag := swag.FormatInt64(qrTargetPortalGroupTag)
		if qTargetPortalGroupTag != "" {

			if err := r.SetQueryParam("target_portal_group_tag", qTargetPortalGroupTag); err != nil {
				return err
			}
		}
	}

	if o.Tsih != nil {

		// query param tsih
		var qrTsih int64

		if o.Tsih != nil {
			qrTsih = *o.Tsih
		}
		qTsih := swag.FormatInt64(qrTsih)
		if qTsih != "" {

			if err := r.SetQueryParam("tsih", qTsih); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamIscsiSessionCollectionGet binds the parameter fields
func (o *IscsiSessionCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamIscsiSessionCollectionGet binds the parameter order_by
func (o *IscsiSessionCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
