// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewIscsiSessionGetParams creates a new IscsiSessionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewIscsiSessionGetParams() *IscsiSessionGetParams {
	return &IscsiSessionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewIscsiSessionGetParamsWithTimeout creates a new IscsiSessionGetParams object
// with the ability to set a timeout on a request.
func NewIscsiSessionGetParamsWithTimeout(timeout time.Duration) *IscsiSessionGetParams {
	return &IscsiSessionGetParams{
		timeout: timeout,
	}
}

// NewIscsiSessionGetParamsWithContext creates a new IscsiSessionGetParams object
// with the ability to set a context for a request.
func NewIscsiSessionGetParamsWithContext(ctx context.Context) *IscsiSessionGetParams {
	return &IscsiSessionGetParams{
		Context: ctx,
	}
}

// NewIscsiSessionGetParamsWithHTTPClient creates a new IscsiSessionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewIscsiSessionGetParamsWithHTTPClient(client *http.Client) *IscsiSessionGetParams {
	return &IscsiSessionGetParams{
		HTTPClient: client,
	}
}

/*
IscsiSessionGetParams contains all the parameters to send to the API endpoint

	for the iscsi session get operation.

	Typically these are written to a http.Request.
*/
type IscsiSessionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* SvmUUID.

	   The unique identifier of the SVM of the iSCSI session.

	*/
	SvmUUID string

	/* Tpgroup.

	   The target portal group of the iSCSI session.

	*/
	Tpgroup string

	/* Tsih.

	   The target session identifying handle.

	*/
	Tsih int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the iscsi session get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IscsiSessionGetParams) WithDefaults() *IscsiSessionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the iscsi session get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *IscsiSessionGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the iscsi session get params
func (o *IscsiSessionGetParams) WithTimeout(timeout time.Duration) *IscsiSessionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the iscsi session get params
func (o *IscsiSessionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the iscsi session get params
func (o *IscsiSessionGetParams) WithContext(ctx context.Context) *IscsiSessionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the iscsi session get params
func (o *IscsiSessionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the iscsi session get params
func (o *IscsiSessionGetParams) WithHTTPClient(client *http.Client) *IscsiSessionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the iscsi session get params
func (o *IscsiSessionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the iscsi session get params
func (o *IscsiSessionGetParams) WithFields(fields []string) *IscsiSessionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the iscsi session get params
func (o *IscsiSessionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithSvmUUID adds the svmUUID to the iscsi session get params
func (o *IscsiSessionGetParams) WithSvmUUID(svmUUID string) *IscsiSessionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the iscsi session get params
func (o *IscsiSessionGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithTpgroup adds the tpgroup to the iscsi session get params
func (o *IscsiSessionGetParams) WithTpgroup(tpgroup string) *IscsiSessionGetParams {
	o.SetTpgroup(tpgroup)
	return o
}

// SetTpgroup adds the tpgroup to the iscsi session get params
func (o *IscsiSessionGetParams) SetTpgroup(tpgroup string) {
	o.Tpgroup = tpgroup
}

// WithTsih adds the tsih to the iscsi session get params
func (o *IscsiSessionGetParams) WithTsih(tsih int64) *IscsiSessionGetParams {
	o.SetTsih(tsih)
	return o
}

// SetTsih adds the tsih to the iscsi session get params
func (o *IscsiSessionGetParams) SetTsih(tsih int64) {
	o.Tsih = tsih
}

// WriteToRequest writes these params to a swagger request
func (o *IscsiSessionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	// path param tpgroup
	if err := r.SetPathParam("tpgroup", o.Tpgroup); err != nil {
		return err
	}

	// path param tsih
	if err := r.SetPathParam("tsih", swag.FormatInt64(o.Tsih)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamIscsiSessionGet binds the parameter fields
func (o *IscsiSessionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
