// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// IscsiSessionGetReader is a Reader for the IscsiSessionGet structure.
type IscsiSessionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IscsiSessionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIscsiSessionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIscsiSessionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIscsiSessionGetOK creates a IscsiSessionGetOK with default headers values
func NewIscsiSessionGetOK() *IscsiSessionGetOK {
	return &IscsiSessionGetOK{}
}

/*
IscsiSessionGetOK describes a response with status code 200, with default header values.

OK
*/
type IscsiSessionGetOK struct {
	Payload *models.IscsiSession
}

// IsSuccess returns true when this iscsi session get o k response has a 2xx status code
func (o *IscsiSessionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this iscsi session get o k response has a 3xx status code
func (o *IscsiSessionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this iscsi session get o k response has a 4xx status code
func (o *IscsiSessionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this iscsi session get o k response has a 5xx status code
func (o *IscsiSessionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this iscsi session get o k response a status code equal to that given
func (o *IscsiSessionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the iscsi session get o k response
func (o *IscsiSessionGetOK) Code() int {
	return 200
}

func (o *IscsiSessionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/iscsi/sessions/{svm.uuid}/{tpgroup}/{tsih}][%d] iscsiSessionGetOK %s", 200, payload)
}

func (o *IscsiSessionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/iscsi/sessions/{svm.uuid}/{tpgroup}/{tsih}][%d] iscsiSessionGetOK %s", 200, payload)
}

func (o *IscsiSessionGetOK) GetPayload() *models.IscsiSession {
	return o.Payload
}

func (o *IscsiSessionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.IscsiSession)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewIscsiSessionGetDefault creates a IscsiSessionGetDefault with default headers values
func NewIscsiSessionGetDefault(code int) *IscsiSessionGetDefault {
	return &IscsiSessionGetDefault{
		_statusCode: code,
	}
}

/*
	IscsiSessionGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 2621462 | An SVM with the specified UUID does not exist. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type IscsiSessionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this iscsi session get default response has a 2xx status code
func (o *IscsiSessionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this iscsi session get default response has a 3xx status code
func (o *IscsiSessionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this iscsi session get default response has a 4xx status code
func (o *IscsiSessionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this iscsi session get default response has a 5xx status code
func (o *IscsiSessionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this iscsi session get default response a status code equal to that given
func (o *IscsiSessionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the iscsi session get default response
func (o *IscsiSessionGetDefault) Code() int {
	return o._statusCode
}

func (o *IscsiSessionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/iscsi/sessions/{svm.uuid}/{tpgroup}/{tsih}][%d] iscsi_session_get default %s", o._statusCode, payload)
}

func (o *IscsiSessionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/san/iscsi/sessions/{svm.uuid}/{tpgroup}/{tsih}][%d] iscsi_session_get default %s", o._statusCode, payload)
}

func (o *IscsiSessionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *IscsiSessionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
