// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LunAttributeDeleteCollectionReader is a Reader for the LunAttributeDeleteCollection structure.
type LunAttributeDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LunAttributeDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLunAttributeDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLunAttributeDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLunAttributeDeleteCollectionOK creates a LunAttributeDeleteCollectionOK with default headers values
func NewLunAttributeDeleteCollectionOK() *LunAttributeDeleteCollectionOK {
	return &LunAttributeDeleteCollectionOK{}
}

/*
LunAttributeDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type LunAttributeDeleteCollectionOK struct {
}

// IsSuccess returns true when this lun attribute delete collection o k response has a 2xx status code
func (o *LunAttributeDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this lun attribute delete collection o k response has a 3xx status code
func (o *LunAttributeDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this lun attribute delete collection o k response has a 4xx status code
func (o *LunAttributeDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this lun attribute delete collection o k response has a 5xx status code
func (o *LunAttributeDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this lun attribute delete collection o k response a status code equal to that given
func (o *LunAttributeDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the lun attribute delete collection o k response
func (o *LunAttributeDeleteCollectionOK) Code() int {
	return 200
}

func (o *LunAttributeDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /storage/luns/{lun.uuid}/attributes][%d] lunAttributeDeleteCollectionOK", 200)
}

func (o *LunAttributeDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /storage/luns/{lun.uuid}/attributes][%d] lunAttributeDeleteCollectionOK", 200)
}

func (o *LunAttributeDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLunAttributeDeleteCollectionDefault creates a LunAttributeDeleteCollectionDefault with default headers values
func NewLunAttributeDeleteCollectionDefault(code int) *LunAttributeDeleteCollectionDefault {
	return &LunAttributeDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	LunAttributeDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5374875 | The specified LUN was not found. |
| 5374931 | The specified attribute was not found. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type LunAttributeDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this lun attribute delete collection default response has a 2xx status code
func (o *LunAttributeDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this lun attribute delete collection default response has a 3xx status code
func (o *LunAttributeDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this lun attribute delete collection default response has a 4xx status code
func (o *LunAttributeDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this lun attribute delete collection default response has a 5xx status code
func (o *LunAttributeDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this lun attribute delete collection default response a status code equal to that given
func (o *LunAttributeDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the lun attribute delete collection default response
func (o *LunAttributeDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *LunAttributeDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/luns/{lun.uuid}/attributes][%d] lun_attribute_delete_collection default %s", o._statusCode, payload)
}

func (o *LunAttributeDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/luns/{lun.uuid}/attributes][%d] lun_attribute_delete_collection default %s", o._statusCode, payload)
}

func (o *LunAttributeDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LunAttributeDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
LunAttributeDeleteCollectionBody lun attribute delete collection body
swagger:model LunAttributeDeleteCollectionBody
*/
type LunAttributeDeleteCollectionBody struct {

	// lun attribute response inline records
	LunAttributeResponseInlineRecords []*models.LunAttribute `json:"records,omitempty"`
}

// Validate validates this lun attribute delete collection body
func (o *LunAttributeDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLunAttributeResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LunAttributeDeleteCollectionBody) validateLunAttributeResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.LunAttributeResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.LunAttributeResponseInlineRecords); i++ {
		if swag.IsZero(o.LunAttributeResponseInlineRecords[i]) { // not required
			continue
		}

		if o.LunAttributeResponseInlineRecords[i] != nil {
			if err := o.LunAttributeResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this lun attribute delete collection body based on the context it is used
func (o *LunAttributeDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLunAttributeResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LunAttributeDeleteCollectionBody) contextValidateLunAttributeResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.LunAttributeResponseInlineRecords); i++ {

		if o.LunAttributeResponseInlineRecords[i] != nil {
			if err := o.LunAttributeResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *LunAttributeDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LunAttributeDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res LunAttributeDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
