// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewLunAttributeModifyCollectionParams creates a new LunAttributeModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLunAttributeModifyCollectionParams() *LunAttributeModifyCollectionParams {
	return &LunAttributeModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLunAttributeModifyCollectionParamsWithTimeout creates a new LunAttributeModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewLunAttributeModifyCollectionParamsWithTimeout(timeout time.Duration) *LunAttributeModifyCollectionParams {
	return &LunAttributeModifyCollectionParams{
		timeout: timeout,
	}
}

// NewLunAttributeModifyCollectionParamsWithContext creates a new LunAttributeModifyCollectionParams object
// with the ability to set a context for a request.
func NewLunAttributeModifyCollectionParamsWithContext(ctx context.Context) *LunAttributeModifyCollectionParams {
	return &LunAttributeModifyCollectionParams{
		Context: ctx,
	}
}

// NewLunAttributeModifyCollectionParamsWithHTTPClient creates a new LunAttributeModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewLunAttributeModifyCollectionParamsWithHTTPClient(client *http.Client) *LunAttributeModifyCollectionParams {
	return &LunAttributeModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
LunAttributeModifyCollectionParams contains all the parameters to send to the API endpoint

	for the lun attribute modify collection operation.

	Typically these are written to a http.Request.
*/
type LunAttributeModifyCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info LunAttributeModifyCollectionBody

	/* LunUUID.

	   The unique identifier of the LUN.

	*/
	LunUUID string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* Value.

	   Filter by value
	*/
	Value *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the lun attribute modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LunAttributeModifyCollectionParams) WithDefaults() *LunAttributeModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the lun attribute modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LunAttributeModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := LunAttributeModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) WithTimeout(timeout time.Duration) *LunAttributeModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) WithContext(ctx context.Context) *LunAttributeModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) WithHTTPClient(client *http.Client) *LunAttributeModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *LunAttributeModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) WithInfo(info LunAttributeModifyCollectionBody) *LunAttributeModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) SetInfo(info LunAttributeModifyCollectionBody) {
	o.Info = info
}

// WithLunUUID adds the lunUUID to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) WithLunUUID(lunUUID string) *LunAttributeModifyCollectionParams {
	o.SetLunUUID(lunUUID)
	return o
}

// SetLunUUID adds the lunUuid to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) SetLunUUID(lunUUID string) {
	o.LunUUID = lunUUID
}

// WithName adds the name to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) WithName(name *string) *LunAttributeModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithReturnRecords adds the returnRecords to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) WithReturnRecords(returnRecords *bool) *LunAttributeModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *LunAttributeModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) WithSerialRecords(serialRecords *bool) *LunAttributeModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithValue adds the value to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) WithValue(value *string) *LunAttributeModifyCollectionParams {
	o.SetValue(value)
	return o
}

// SetValue adds the value to the lun attribute modify collection params
func (o *LunAttributeModifyCollectionParams) SetValue(value *string) {
	o.Value = value
}

// WriteToRequest writes these params to a swagger request
func (o *LunAttributeModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	// path param lun.uuid
	if err := r.SetPathParam("lun.uuid", o.LunUUID); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.Value != nil {

		// query param value
		var qrValue string

		if o.Value != nil {
			qrValue = *o.Value
		}
		qValue := qrValue
		if qValue != "" {

			if err := r.SetQueryParam("value", qValue); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
