// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LunAttributeModifyCollectionReader is a Reader for the LunAttributeModifyCollection structure.
type LunAttributeModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LunAttributeModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLunAttributeModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLunAttributeModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLunAttributeModifyCollectionOK creates a LunAttributeModifyCollectionOK with default headers values
func NewLunAttributeModifyCollectionOK() *LunAttributeModifyCollectionOK {
	return &LunAttributeModifyCollectionOK{}
}

/*
LunAttributeModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type LunAttributeModifyCollectionOK struct {
}

// IsSuccess returns true when this lun attribute modify collection o k response has a 2xx status code
func (o *LunAttributeModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this lun attribute modify collection o k response has a 3xx status code
func (o *LunAttributeModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this lun attribute modify collection o k response has a 4xx status code
func (o *LunAttributeModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this lun attribute modify collection o k response has a 5xx status code
func (o *LunAttributeModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this lun attribute modify collection o k response a status code equal to that given
func (o *LunAttributeModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the lun attribute modify collection o k response
func (o *LunAttributeModifyCollectionOK) Code() int {
	return 200
}

func (o *LunAttributeModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /storage/luns/{lun.uuid}/attributes][%d] lunAttributeModifyCollectionOK", 200)
}

func (o *LunAttributeModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /storage/luns/{lun.uuid}/attributes][%d] lunAttributeModifyCollectionOK", 200)
}

func (o *LunAttributeModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLunAttributeModifyCollectionDefault creates a LunAttributeModifyCollectionDefault with default headers values
func NewLunAttributeModifyCollectionDefault(code int) *LunAttributeModifyCollectionDefault {
	return &LunAttributeModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	LunAttributeModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5374875 | The specified LUN was not found. |
| 5374929 | The combined sizes of an attribute name and value are too large. |
| 5374931 | The specified attribute was not found. |
| 5375060 | The move start operation failed. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type LunAttributeModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this lun attribute modify collection default response has a 2xx status code
func (o *LunAttributeModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this lun attribute modify collection default response has a 3xx status code
func (o *LunAttributeModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this lun attribute modify collection default response has a 4xx status code
func (o *LunAttributeModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this lun attribute modify collection default response has a 5xx status code
func (o *LunAttributeModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this lun attribute modify collection default response a status code equal to that given
func (o *LunAttributeModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the lun attribute modify collection default response
func (o *LunAttributeModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *LunAttributeModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/luns/{lun.uuid}/attributes][%d] lun_attribute_modify_collection default %s", o._statusCode, payload)
}

func (o *LunAttributeModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/luns/{lun.uuid}/attributes][%d] lun_attribute_modify_collection default %s", o._statusCode, payload)
}

func (o *LunAttributeModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LunAttributeModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
LunAttributeModifyCollectionBody lun attribute modify collection body
swagger:model LunAttributeModifyCollectionBody
*/
type LunAttributeModifyCollectionBody struct {

	// links
	Links *models.LunAttributeInlineLinks `json:"_links,omitempty"`

	// lun
	Lun *models.LunAttributeInlineLun `json:"lun,omitempty"`

	// lun attribute response inline records
	LunAttributeResponseInlineRecords []*models.LunAttribute `json:"records,omitempty"`

	// The attribute name. Required in POST.
	//
	// Example: name1
	// Max Length: 4091
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// The attribute value. Required in POST; valid in PATCH.
	//
	// Example: value1
	// Max Length: 4091
	// Min Length: 1
	Value *string `json:"value,omitempty"`
}

// Validate validates this lun attribute modify collection body
func (o *LunAttributeModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLun(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLunAttributeResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateValue(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LunAttributeModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *LunAttributeModifyCollectionBody) validateLun(formats strfmt.Registry) error {
	if swag.IsZero(o.Lun) { // not required
		return nil
	}

	if o.Lun != nil {
		if err := o.Lun.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "lun")
			}
			return err
		}
	}

	return nil
}

func (o *LunAttributeModifyCollectionBody) validateLunAttributeResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.LunAttributeResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.LunAttributeResponseInlineRecords); i++ {
		if swag.IsZero(o.LunAttributeResponseInlineRecords[i]) { // not required
			continue
		}

		if o.LunAttributeResponseInlineRecords[i] != nil {
			if err := o.LunAttributeResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *LunAttributeModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 4091); err != nil {
		return err
	}

	return nil
}

func (o *LunAttributeModifyCollectionBody) validateValue(formats strfmt.Registry) error {
	if swag.IsZero(o.Value) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"value", "body", *o.Value, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"value", "body", *o.Value, 4091); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this lun attribute modify collection body based on the context it is used
func (o *LunAttributeModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLun(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLunAttributeResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LunAttributeModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *LunAttributeModifyCollectionBody) contextValidateLun(ctx context.Context, formats strfmt.Registry) error {

	if o.Lun != nil {
		if err := o.Lun.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "lun")
			}
			return err
		}
	}

	return nil
}

func (o *LunAttributeModifyCollectionBody) contextValidateLunAttributeResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.LunAttributeResponseInlineRecords); i++ {

		if o.LunAttributeResponseInlineRecords[i] != nil {
			if err := o.LunAttributeResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *LunAttributeModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LunAttributeModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res LunAttributeModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LunAttributeInlineLinks lun attribute inline links
swagger:model lun_attribute_inline__links
*/
type LunAttributeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this lun attribute inline links
func (o *LunAttributeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LunAttributeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun attribute inline links based on the context it is used
func (o *LunAttributeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LunAttributeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LunAttributeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LunAttributeInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunAttributeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LunAttributeInlineLun The LUN for which the attribute is set.
//
swagger:model lun_attribute_inline_lun
*/
type LunAttributeInlineLun struct {

	// links
	Links *models.LunAttributeInlineLunInlineLinks `json:"_links,omitempty"`

	// The unique identifier of the LUN.
	//
	// Example: 4ea7a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this lun attribute inline lun
func (o *LunAttributeInlineLun) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LunAttributeInlineLun) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "lun" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun attribute inline lun based on the context it is used
func (o *LunAttributeInlineLun) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LunAttributeInlineLun) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "lun" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *LunAttributeInlineLun) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"lun"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LunAttributeInlineLun) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LunAttributeInlineLun) UnmarshalBinary(b []byte) error {
	var res LunAttributeInlineLun
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
LunAttributeInlineLunInlineLinks lun attribute inline lun inline links
swagger:model lun_attribute_inline_lun_inline__links
*/
type LunAttributeInlineLunInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this lun attribute inline lun inline links
func (o *LunAttributeInlineLunInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LunAttributeInlineLunInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "lun" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this lun attribute inline lun inline links based on the context it is used
func (o *LunAttributeInlineLunInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *LunAttributeInlineLunInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "lun" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *LunAttributeInlineLunInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *LunAttributeInlineLunInlineLinks) UnmarshalBinary(b []byte) error {
	var res LunAttributeInlineLunInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
