// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LunAttributeModifyReader is a Reader for the LunAttributeModify structure.
type LunAttributeModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LunAttributeModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLunAttributeModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLunAttributeModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLunAttributeModifyOK creates a LunAttributeModifyOK with default headers values
func NewLunAttributeModifyOK() *LunAttributeModifyOK {
	return &LunAttributeModifyOK{}
}

/*
LunAttributeModifyOK describes a response with status code 200, with default header values.

OK
*/
type LunAttributeModifyOK struct {
}

// IsSuccess returns true when this lun attribute modify o k response has a 2xx status code
func (o *LunAttributeModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this lun attribute modify o k response has a 3xx status code
func (o *LunAttributeModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this lun attribute modify o k response has a 4xx status code
func (o *LunAttributeModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this lun attribute modify o k response has a 5xx status code
func (o *LunAttributeModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this lun attribute modify o k response a status code equal to that given
func (o *LunAttributeModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the lun attribute modify o k response
func (o *LunAttributeModifyOK) Code() int {
	return 200
}

func (o *LunAttributeModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /storage/luns/{lun.uuid}/attributes/{name}][%d] lunAttributeModifyOK", 200)
}

func (o *LunAttributeModifyOK) String() string {
	return fmt.Sprintf("[PATCH /storage/luns/{lun.uuid}/attributes/{name}][%d] lunAttributeModifyOK", 200)
}

func (o *LunAttributeModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewLunAttributeModifyDefault creates a LunAttributeModifyDefault with default headers values
func NewLunAttributeModifyDefault(code int) *LunAttributeModifyDefault {
	return &LunAttributeModifyDefault{
		_statusCode: code,
	}
}

/*
	LunAttributeModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5374875 | The specified LUN was not found. |
| 5374929 | The combined sizes of an attribute name and value are too large. |
| 5374931 | The specified attribute was not found. |
| 5375060 | The move start operation failed. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type LunAttributeModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this lun attribute modify default response has a 2xx status code
func (o *LunAttributeModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this lun attribute modify default response has a 3xx status code
func (o *LunAttributeModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this lun attribute modify default response has a 4xx status code
func (o *LunAttributeModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this lun attribute modify default response has a 5xx status code
func (o *LunAttributeModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this lun attribute modify default response a status code equal to that given
func (o *LunAttributeModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the lun attribute modify default response
func (o *LunAttributeModifyDefault) Code() int {
	return o._statusCode
}

func (o *LunAttributeModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/luns/{lun.uuid}/attributes/{name}][%d] lun_attribute_modify default %s", o._statusCode, payload)
}

func (o *LunAttributeModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/luns/{lun.uuid}/attributes/{name}][%d] lun_attribute_modify default %s", o._statusCode, payload)
}

func (o *LunAttributeModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LunAttributeModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
