// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewLunCollectionGetParams creates a new LunCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewLunCollectionGetParams() *LunCollectionGetParams {
	return &LunCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewLunCollectionGetParamsWithTimeout creates a new LunCollectionGetParams object
// with the ability to set a timeout on a request.
func NewLunCollectionGetParamsWithTimeout(timeout time.Duration) *LunCollectionGetParams {
	return &LunCollectionGetParams{
		timeout: timeout,
	}
}

// NewLunCollectionGetParamsWithContext creates a new LunCollectionGetParams object
// with the ability to set a context for a request.
func NewLunCollectionGetParamsWithContext(ctx context.Context) *LunCollectionGetParams {
	return &LunCollectionGetParams{
		Context: ctx,
	}
}

// NewLunCollectionGetParamsWithHTTPClient creates a new LunCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewLunCollectionGetParamsWithHTTPClient(client *http.Client) *LunCollectionGetParams {
	return &LunCollectionGetParams{
		HTTPClient: client,
	}
}

/*
LunCollectionGetParams contains all the parameters to send to the API endpoint

	for the lun collection get operation.

	Typically these are written to a http.Request.
*/
type LunCollectionGetParams struct {

	/* AttributesName.

	   Filter by attributes.name
	*/
	AttributesName *string

	/* AttributesValue.

	   Filter by attributes.value
	*/
	AttributesValue *string

	/* AutoDelete.

	   Filter by auto_delete
	*/
	AutoDelete *bool

	/* Class.

	   Filter by class
	*/
	Class *string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ConsistencyGroupName.

	   Filter by consistency_group.name
	*/
	ConsistencyGroupName *string

	/* ConsistencyGroupUUID.

	   Filter by consistency_group.uuid
	*/
	ConsistencyGroupUUID *string

	/* CopyDestinationsMaxThroughput.

	   Filter by copy.destinations.max_throughput
	*/
	CopyDestinationsMaxThroughput *int64

	/* CopyDestinationsName.

	   Filter by copy.destinations.name
	*/
	CopyDestinationsName *string

	/* CopyDestinationsPeerName.

	   Filter by copy.destinations.peer.name
	*/
	CopyDestinationsPeerName *string

	/* CopyDestinationsPeerUUID.

	   Filter by copy.destinations.peer.uuid
	*/
	CopyDestinationsPeerUUID *string

	/* CopyDestinationsProgressElapsed.

	   Filter by copy.destinations.progress.elapsed
	*/
	CopyDestinationsProgressElapsed *int64

	/* CopyDestinationsProgressFailureArgumentsCode.

	   Filter by copy.destinations.progress.failure.arguments.code
	*/
	CopyDestinationsProgressFailureArgumentsCode *string

	/* CopyDestinationsProgressFailureArgumentsMessage.

	   Filter by copy.destinations.progress.failure.arguments.message
	*/
	CopyDestinationsProgressFailureArgumentsMessage *string

	/* CopyDestinationsProgressFailureCode.

	   Filter by copy.destinations.progress.failure.code
	*/
	CopyDestinationsProgressFailureCode *string

	/* CopyDestinationsProgressFailureMessage.

	   Filter by copy.destinations.progress.failure.message
	*/
	CopyDestinationsProgressFailureMessage *string

	/* CopyDestinationsProgressPercentComplete.

	   Filter by copy.destinations.progress.percent_complete
	*/
	CopyDestinationsProgressPercentComplete *int64

	/* CopyDestinationsProgressState.

	   Filter by copy.destinations.progress.state
	*/
	CopyDestinationsProgressState *string

	/* CopyDestinationsProgressVolumeSnapshotBlocked.

	   Filter by copy.destinations.progress.volume_snapshot_blocked
	*/
	CopyDestinationsProgressVolumeSnapshotBlocked *bool

	/* CopyDestinationsUUID.

	   Filter by copy.destinations.uuid
	*/
	CopyDestinationsUUID *string

	/* CopySourceMaxThroughput.

	   Filter by copy.source.max_throughput
	*/
	CopySourceMaxThroughput *int64

	/* CopySourceName.

	   Filter by copy.source.name
	*/
	CopySourceName *string

	/* CopySourcePeerName.

	   Filter by copy.source.peer.name
	*/
	CopySourcePeerName *string

	/* CopySourcePeerUUID.

	   Filter by copy.source.peer.uuid
	*/
	CopySourcePeerUUID *string

	/* CopySourceProgressElapsed.

	   Filter by copy.source.progress.elapsed
	*/
	CopySourceProgressElapsed *int64

	/* CopySourceProgressFailureArgumentsCode.

	   Filter by copy.source.progress.failure.arguments.code
	*/
	CopySourceProgressFailureArgumentsCode *string

	/* CopySourceProgressFailureArgumentsMessage.

	   Filter by copy.source.progress.failure.arguments.message
	*/
	CopySourceProgressFailureArgumentsMessage *string

	/* CopySourceProgressFailureCode.

	   Filter by copy.source.progress.failure.code
	*/
	CopySourceProgressFailureCode *string

	/* CopySourceProgressFailureMessage.

	   Filter by copy.source.progress.failure.message
	*/
	CopySourceProgressFailureMessage *string

	/* CopySourceProgressPercentComplete.

	   Filter by copy.source.progress.percent_complete
	*/
	CopySourceProgressPercentComplete *int64

	/* CopySourceProgressState.

	   Filter by copy.source.progress.state
	*/
	CopySourceProgressState *string

	/* CopySourceProgressVolumeSnapshotBlocked.

	   Filter by copy.source.progress.volume_snapshot_blocked
	*/
	CopySourceProgressVolumeSnapshotBlocked *bool

	/* CopySourceUUID.

	   Filter by copy.source.uuid
	*/
	CopySourceUUID *string

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* EncryptionState.

	   Filter by encryption.state
	*/
	EncryptionState *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* LocationLogicalUnit.

	   Filter by location.logical_unit
	*/
	LocationLogicalUnit *string

	/* LocationNodeName.

	   Filter by location.node.name
	*/
	LocationNodeName *string

	/* LocationNodeUUID.

	   Filter by location.node.uuid
	*/
	LocationNodeUUID *string

	/* LocationQtreeID.

	   Filter by location.qtree.id
	*/
	LocationQtreeID *int64

	/* LocationQtreeName.

	   Filter by location.qtree.name
	*/
	LocationQtreeName *string

	/* LocationStorageAvailabilityZoneName.

	   Filter by location.storage_availability_zone.name
	*/
	LocationStorageAvailabilityZoneName *string

	/* LocationStorageAvailabilityZoneUUID.

	   Filter by location.storage_availability_zone.uuid
	*/
	LocationStorageAvailabilityZoneUUID *string

	/* LocationVolumeName.

	   Filter by location.volume.name
	*/
	LocationVolumeName *string

	/* LocationVolumeUUID.

	   Filter by location.volume.uuid
	*/
	LocationVolumeUUID *string

	/* LunMapsIgroupComment.

	   Filter by lun_maps.igroup.comment
	*/
	LunMapsIgroupComment *string

	/* LunMapsIgroupIgroupsName.

	   Filter by lun_maps.igroup.igroups.name
	*/
	LunMapsIgroupIgroupsName *string

	/* LunMapsIgroupIgroupsUUID.

	   Filter by lun_maps.igroup.igroups.uuid
	*/
	LunMapsIgroupIgroupsUUID *string

	/* LunMapsIgroupInitiatorsComment.

	   Filter by lun_maps.igroup.initiators.comment
	*/
	LunMapsIgroupInitiatorsComment *string

	/* LunMapsIgroupInitiatorsName.

	   Filter by lun_maps.igroup.initiators.name
	*/
	LunMapsIgroupInitiatorsName *string

	/* LunMapsIgroupName.

	   Filter by lun_maps.igroup.name
	*/
	LunMapsIgroupName *string

	/* LunMapsIgroupOsType.

	   Filter by lun_maps.igroup.os_type
	*/
	LunMapsIgroupOsType *string

	/* LunMapsIgroupProtocol.

	   Filter by lun_maps.igroup.protocol
	*/
	LunMapsIgroupProtocol *string

	/* LunMapsIgroupUUID.

	   Filter by lun_maps.igroup.uuid
	*/
	LunMapsIgroupUUID *string

	/* LunMapsLogicalUnitNumber.

	   Filter by lun_maps.logical_unit_number
	*/
	LunMapsLogicalUnitNumber *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* MetricDuration.

	   Filter by metric.duration
	*/
	MetricDuration *string

	/* MetricIopsOther.

	   Filter by metric.iops.other
	*/
	MetricIopsOther *int64

	/* MetricIopsRead.

	   Filter by metric.iops.read
	*/
	MetricIopsRead *int64

	/* MetricIopsTotal.

	   Filter by metric.iops.total
	*/
	MetricIopsTotal *int64

	/* MetricIopsWrite.

	   Filter by metric.iops.write
	*/
	MetricIopsWrite *int64

	/* MetricLatencyOther.

	   Filter by metric.latency.other
	*/
	MetricLatencyOther *int64

	/* MetricLatencyRead.

	   Filter by metric.latency.read
	*/
	MetricLatencyRead *int64

	/* MetricLatencyTotal.

	   Filter by metric.latency.total
	*/
	MetricLatencyTotal *int64

	/* MetricLatencyWrite.

	   Filter by metric.latency.write
	*/
	MetricLatencyWrite *int64

	/* MetricStatus.

	   Filter by metric.status
	*/
	MetricStatus *string

	/* MetricThroughputOther.

	   Filter by metric.throughput.other
	*/
	MetricThroughputOther *int64

	/* MetricThroughputRead.

	   Filter by metric.throughput.read
	*/
	MetricThroughputRead *int64

	/* MetricThroughputTotal.

	   Filter by metric.throughput.total
	*/
	MetricThroughputTotal *int64

	/* MetricThroughputWrite.

	   Filter by metric.throughput.write
	*/
	MetricThroughputWrite *int64

	/* MetricTimestamp.

	   Filter by metric.timestamp
	*/
	MetricTimestamp *string

	/* MovementMaxThroughput.

	   Filter by movement.max_throughput
	*/
	MovementMaxThroughput *int64

	/* MovementPathsDestination.

	   Filter by movement.paths.destination
	*/
	MovementPathsDestination *string

	/* MovementPathsSource.

	   Filter by movement.paths.source
	*/
	MovementPathsSource *string

	/* MovementProgressElapsed.

	   Filter by movement.progress.elapsed
	*/
	MovementProgressElapsed *int64

	/* MovementProgressFailureArgumentsCode.

	   Filter by movement.progress.failure.arguments.code
	*/
	MovementProgressFailureArgumentsCode *string

	/* MovementProgressFailureArgumentsMessage.

	   Filter by movement.progress.failure.arguments.message
	*/
	MovementProgressFailureArgumentsMessage *string

	/* MovementProgressFailureCode.

	   Filter by movement.progress.failure.code
	*/
	MovementProgressFailureCode *string

	/* MovementProgressFailureMessage.

	   Filter by movement.progress.failure.message
	*/
	MovementProgressFailureMessage *string

	/* MovementProgressPercentComplete.

	   Filter by movement.progress.percent_complete
	*/
	MovementProgressPercentComplete *int64

	/* MovementProgressState.

	   Filter by movement.progress.state
	*/
	MovementProgressState *string

	/* MovementProgressVolumeSnapshotBlocked.

	   Filter by movement.progress.volume_snapshot_blocked
	*/
	MovementProgressVolumeSnapshotBlocked *bool

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* OsType.

	   Filter by os_type
	*/
	OsType *string

	/* QosPolicyName.

	   Filter by qos_policy.name
	*/
	QosPolicyName *string

	/* QosPolicyUUID.

	   Filter by qos_policy.uuid
	*/
	QosPolicyUUID *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialNumber.

	   Filter by serial_number
	*/
	SerialNumber *string

	/* SerialNumberHex.

	   Filter by serial_number_hex
	*/
	SerialNumberHex *string

	/* SpaceEfficiencyRatio.

	   Filter by space.efficiency_ratio
	*/
	SpaceEfficiencyRatio *float64

	/* SpaceGuaranteeRequested.

	   Filter by space.guarantee.requested
	*/
	SpaceGuaranteeRequested *bool

	/* SpaceGuaranteeReserved.

	   Filter by space.guarantee.reserved
	*/
	SpaceGuaranteeReserved *bool

	/* SpacePhysicalUsed.

	   Filter by space.physical_used
	*/
	SpacePhysicalUsed *int64

	/* SpacePhysicalUsedBySnapshots.

	   Filter by space.physical_used_by_snapshots
	*/
	SpacePhysicalUsedBySnapshots *int64

	/* SpaceScsiThinProvisioningSupportEnabled.

	   Filter by space.scsi_thin_provisioning_support_enabled
	*/
	SpaceScsiThinProvisioningSupportEnabled *bool

	/* SpaceSize.

	   Filter by space.size
	*/
	SpaceSize *int64

	/* SpaceSnapshotAutodeleteEnabled.

	   Filter by space.snapshot.autodelete.enabled
	*/
	SpaceSnapshotAutodeleteEnabled *bool

	/* SpaceSnapshotReserveAvailable.

	   Filter by space.snapshot.reserve_available
	*/
	SpaceSnapshotReserveAvailable *int64

	/* SpaceSnapshotReservePercent.

	   Filter by space.snapshot.reserve_percent
	*/
	SpaceSnapshotReservePercent *int64

	/* SpaceSnapshotReserveSize.

	   Filter by space.snapshot.reserve_size
	*/
	SpaceSnapshotReserveSize *int64

	/* SpaceSnapshotSpaceUsedPercent.

	   Filter by space.snapshot.space_used_percent
	*/
	SpaceSnapshotSpaceUsedPercent *int64

	/* SpaceSnapshotUsed.

	   Filter by space.snapshot.used
	*/
	SpaceSnapshotUsed *int64

	/* SpaceUsed.

	   Filter by space.used
	*/
	SpaceUsed *int64

	/* StatisticsIopsRawOther.

	   Filter by statistics.iops_raw.other
	*/
	StatisticsIopsRawOther *int64

	/* StatisticsIopsRawRead.

	   Filter by statistics.iops_raw.read
	*/
	StatisticsIopsRawRead *int64

	/* StatisticsIopsRawTotal.

	   Filter by statistics.iops_raw.total
	*/
	StatisticsIopsRawTotal *int64

	/* StatisticsIopsRawWrite.

	   Filter by statistics.iops_raw.write
	*/
	StatisticsIopsRawWrite *int64

	/* StatisticsLatencyRawOther.

	   Filter by statistics.latency_raw.other
	*/
	StatisticsLatencyRawOther *int64

	/* StatisticsLatencyRawRead.

	   Filter by statistics.latency_raw.read
	*/
	StatisticsLatencyRawRead *int64

	/* StatisticsLatencyRawTotal.

	   Filter by statistics.latency_raw.total
	*/
	StatisticsLatencyRawTotal *int64

	/* StatisticsLatencyRawWrite.

	   Filter by statistics.latency_raw.write
	*/
	StatisticsLatencyRawWrite *int64

	/* StatisticsStatus.

	   Filter by statistics.status
	*/
	StatisticsStatus *string

	/* StatisticsThroughputRawOther.

	   Filter by statistics.throughput_raw.other
	*/
	StatisticsThroughputRawOther *int64

	/* StatisticsThroughputRawRead.

	   Filter by statistics.throughput_raw.read
	*/
	StatisticsThroughputRawRead *int64

	/* StatisticsThroughputRawTotal.

	   Filter by statistics.throughput_raw.total
	*/
	StatisticsThroughputRawTotal *int64

	/* StatisticsThroughputRawWrite.

	   Filter by statistics.throughput_raw.write
	*/
	StatisticsThroughputRawWrite *int64

	/* StatisticsTimestamp.

	   Filter by statistics.timestamp
	*/
	StatisticsTimestamp *string

	/* StatusContainerState.

	   Filter by status.container_state
	*/
	StatusContainerState *string

	/* StatusMapped.

	   Filter by status.mapped
	*/
	StatusMapped *bool

	/* StatusReadOnly.

	   Filter by status.read_only
	*/
	StatusReadOnly *bool

	/* StatusState.

	   Filter by status.state
	*/
	StatusState *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VvolBindingsID.

	   Filter by vvol.bindings.id
	*/
	VvolBindingsID *int64

	/* VvolBindingsPartnerName.

	   Filter by vvol.bindings.partner.name
	*/
	VvolBindingsPartnerName *string

	/* VvolBindingsPartnerUUID.

	   Filter by vvol.bindings.partner.uuid
	*/
	VvolBindingsPartnerUUID *string

	/* VvolBindingsSecondaryID.

	   Filter by vvol.bindings.secondary_id
	*/
	VvolBindingsSecondaryID *string

	/* VvolIsBound.

	   Filter by vvol.is_bound
	*/
	VvolIsBound *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the lun collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LunCollectionGetParams) WithDefaults() *LunCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the lun collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *LunCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := LunCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the lun collection get params
func (o *LunCollectionGetParams) WithTimeout(timeout time.Duration) *LunCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the lun collection get params
func (o *LunCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the lun collection get params
func (o *LunCollectionGetParams) WithContext(ctx context.Context) *LunCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the lun collection get params
func (o *LunCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the lun collection get params
func (o *LunCollectionGetParams) WithHTTPClient(client *http.Client) *LunCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the lun collection get params
func (o *LunCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAttributesName adds the attributesName to the lun collection get params
func (o *LunCollectionGetParams) WithAttributesName(attributesName *string) *LunCollectionGetParams {
	o.SetAttributesName(attributesName)
	return o
}

// SetAttributesName adds the attributesName to the lun collection get params
func (o *LunCollectionGetParams) SetAttributesName(attributesName *string) {
	o.AttributesName = attributesName
}

// WithAttributesValue adds the attributesValue to the lun collection get params
func (o *LunCollectionGetParams) WithAttributesValue(attributesValue *string) *LunCollectionGetParams {
	o.SetAttributesValue(attributesValue)
	return o
}

// SetAttributesValue adds the attributesValue to the lun collection get params
func (o *LunCollectionGetParams) SetAttributesValue(attributesValue *string) {
	o.AttributesValue = attributesValue
}

// WithAutoDelete adds the autoDelete to the lun collection get params
func (o *LunCollectionGetParams) WithAutoDelete(autoDelete *bool) *LunCollectionGetParams {
	o.SetAutoDelete(autoDelete)
	return o
}

// SetAutoDelete adds the autoDelete to the lun collection get params
func (o *LunCollectionGetParams) SetAutoDelete(autoDelete *bool) {
	o.AutoDelete = autoDelete
}

// WithClass adds the class to the lun collection get params
func (o *LunCollectionGetParams) WithClass(class *string) *LunCollectionGetParams {
	o.SetClass(class)
	return o
}

// SetClass adds the class to the lun collection get params
func (o *LunCollectionGetParams) SetClass(class *string) {
	o.Class = class
}

// WithComment adds the comment to the lun collection get params
func (o *LunCollectionGetParams) WithComment(comment *string) *LunCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the lun collection get params
func (o *LunCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithConsistencyGroupName adds the consistencyGroupName to the lun collection get params
func (o *LunCollectionGetParams) WithConsistencyGroupName(consistencyGroupName *string) *LunCollectionGetParams {
	o.SetConsistencyGroupName(consistencyGroupName)
	return o
}

// SetConsistencyGroupName adds the consistencyGroupName to the lun collection get params
func (o *LunCollectionGetParams) SetConsistencyGroupName(consistencyGroupName *string) {
	o.ConsistencyGroupName = consistencyGroupName
}

// WithConsistencyGroupUUID adds the consistencyGroupUUID to the lun collection get params
func (o *LunCollectionGetParams) WithConsistencyGroupUUID(consistencyGroupUUID *string) *LunCollectionGetParams {
	o.SetConsistencyGroupUUID(consistencyGroupUUID)
	return o
}

// SetConsistencyGroupUUID adds the consistencyGroupUuid to the lun collection get params
func (o *LunCollectionGetParams) SetConsistencyGroupUUID(consistencyGroupUUID *string) {
	o.ConsistencyGroupUUID = consistencyGroupUUID
}

// WithCopyDestinationsMaxThroughput adds the copyDestinationsMaxThroughput to the lun collection get params
func (o *LunCollectionGetParams) WithCopyDestinationsMaxThroughput(copyDestinationsMaxThroughput *int64) *LunCollectionGetParams {
	o.SetCopyDestinationsMaxThroughput(copyDestinationsMaxThroughput)
	return o
}

// SetCopyDestinationsMaxThroughput adds the copyDestinationsMaxThroughput to the lun collection get params
func (o *LunCollectionGetParams) SetCopyDestinationsMaxThroughput(copyDestinationsMaxThroughput *int64) {
	o.CopyDestinationsMaxThroughput = copyDestinationsMaxThroughput
}

// WithCopyDestinationsName adds the copyDestinationsName to the lun collection get params
func (o *LunCollectionGetParams) WithCopyDestinationsName(copyDestinationsName *string) *LunCollectionGetParams {
	o.SetCopyDestinationsName(copyDestinationsName)
	return o
}

// SetCopyDestinationsName adds the copyDestinationsName to the lun collection get params
func (o *LunCollectionGetParams) SetCopyDestinationsName(copyDestinationsName *string) {
	o.CopyDestinationsName = copyDestinationsName
}

// WithCopyDestinationsPeerName adds the copyDestinationsPeerName to the lun collection get params
func (o *LunCollectionGetParams) WithCopyDestinationsPeerName(copyDestinationsPeerName *string) *LunCollectionGetParams {
	o.SetCopyDestinationsPeerName(copyDestinationsPeerName)
	return o
}

// SetCopyDestinationsPeerName adds the copyDestinationsPeerName to the lun collection get params
func (o *LunCollectionGetParams) SetCopyDestinationsPeerName(copyDestinationsPeerName *string) {
	o.CopyDestinationsPeerName = copyDestinationsPeerName
}

// WithCopyDestinationsPeerUUID adds the copyDestinationsPeerUUID to the lun collection get params
func (o *LunCollectionGetParams) WithCopyDestinationsPeerUUID(copyDestinationsPeerUUID *string) *LunCollectionGetParams {
	o.SetCopyDestinationsPeerUUID(copyDestinationsPeerUUID)
	return o
}

// SetCopyDestinationsPeerUUID adds the copyDestinationsPeerUuid to the lun collection get params
func (o *LunCollectionGetParams) SetCopyDestinationsPeerUUID(copyDestinationsPeerUUID *string) {
	o.CopyDestinationsPeerUUID = copyDestinationsPeerUUID
}

// WithCopyDestinationsProgressElapsed adds the copyDestinationsProgressElapsed to the lun collection get params
func (o *LunCollectionGetParams) WithCopyDestinationsProgressElapsed(copyDestinationsProgressElapsed *int64) *LunCollectionGetParams {
	o.SetCopyDestinationsProgressElapsed(copyDestinationsProgressElapsed)
	return o
}

// SetCopyDestinationsProgressElapsed adds the copyDestinationsProgressElapsed to the lun collection get params
func (o *LunCollectionGetParams) SetCopyDestinationsProgressElapsed(copyDestinationsProgressElapsed *int64) {
	o.CopyDestinationsProgressElapsed = copyDestinationsProgressElapsed
}

// WithCopyDestinationsProgressFailureArgumentsCode adds the copyDestinationsProgressFailureArgumentsCode to the lun collection get params
func (o *LunCollectionGetParams) WithCopyDestinationsProgressFailureArgumentsCode(copyDestinationsProgressFailureArgumentsCode *string) *LunCollectionGetParams {
	o.SetCopyDestinationsProgressFailureArgumentsCode(copyDestinationsProgressFailureArgumentsCode)
	return o
}

// SetCopyDestinationsProgressFailureArgumentsCode adds the copyDestinationsProgressFailureArgumentsCode to the lun collection get params
func (o *LunCollectionGetParams) SetCopyDestinationsProgressFailureArgumentsCode(copyDestinationsProgressFailureArgumentsCode *string) {
	o.CopyDestinationsProgressFailureArgumentsCode = copyDestinationsProgressFailureArgumentsCode
}

// WithCopyDestinationsProgressFailureArgumentsMessage adds the copyDestinationsProgressFailureArgumentsMessage to the lun collection get params
func (o *LunCollectionGetParams) WithCopyDestinationsProgressFailureArgumentsMessage(copyDestinationsProgressFailureArgumentsMessage *string) *LunCollectionGetParams {
	o.SetCopyDestinationsProgressFailureArgumentsMessage(copyDestinationsProgressFailureArgumentsMessage)
	return o
}

// SetCopyDestinationsProgressFailureArgumentsMessage adds the copyDestinationsProgressFailureArgumentsMessage to the lun collection get params
func (o *LunCollectionGetParams) SetCopyDestinationsProgressFailureArgumentsMessage(copyDestinationsProgressFailureArgumentsMessage *string) {
	o.CopyDestinationsProgressFailureArgumentsMessage = copyDestinationsProgressFailureArgumentsMessage
}

// WithCopyDestinationsProgressFailureCode adds the copyDestinationsProgressFailureCode to the lun collection get params
func (o *LunCollectionGetParams) WithCopyDestinationsProgressFailureCode(copyDestinationsProgressFailureCode *string) *LunCollectionGetParams {
	o.SetCopyDestinationsProgressFailureCode(copyDestinationsProgressFailureCode)
	return o
}

// SetCopyDestinationsProgressFailureCode adds the copyDestinationsProgressFailureCode to the lun collection get params
func (o *LunCollectionGetParams) SetCopyDestinationsProgressFailureCode(copyDestinationsProgressFailureCode *string) {
	o.CopyDestinationsProgressFailureCode = copyDestinationsProgressFailureCode
}

// WithCopyDestinationsProgressFailureMessage adds the copyDestinationsProgressFailureMessage to the lun collection get params
func (o *LunCollectionGetParams) WithCopyDestinationsProgressFailureMessage(copyDestinationsProgressFailureMessage *string) *LunCollectionGetParams {
	o.SetCopyDestinationsProgressFailureMessage(copyDestinationsProgressFailureMessage)
	return o
}

// SetCopyDestinationsProgressFailureMessage adds the copyDestinationsProgressFailureMessage to the lun collection get params
func (o *LunCollectionGetParams) SetCopyDestinationsProgressFailureMessage(copyDestinationsProgressFailureMessage *string) {
	o.CopyDestinationsProgressFailureMessage = copyDestinationsProgressFailureMessage
}

// WithCopyDestinationsProgressPercentComplete adds the copyDestinationsProgressPercentComplete to the lun collection get params
func (o *LunCollectionGetParams) WithCopyDestinationsProgressPercentComplete(copyDestinationsProgressPercentComplete *int64) *LunCollectionGetParams {
	o.SetCopyDestinationsProgressPercentComplete(copyDestinationsProgressPercentComplete)
	return o
}

// SetCopyDestinationsProgressPercentComplete adds the copyDestinationsProgressPercentComplete to the lun collection get params
func (o *LunCollectionGetParams) SetCopyDestinationsProgressPercentComplete(copyDestinationsProgressPercentComplete *int64) {
	o.CopyDestinationsProgressPercentComplete = copyDestinationsProgressPercentComplete
}

// WithCopyDestinationsProgressState adds the copyDestinationsProgressState to the lun collection get params
func (o *LunCollectionGetParams) WithCopyDestinationsProgressState(copyDestinationsProgressState *string) *LunCollectionGetParams {
	o.SetCopyDestinationsProgressState(copyDestinationsProgressState)
	return o
}

// SetCopyDestinationsProgressState adds the copyDestinationsProgressState to the lun collection get params
func (o *LunCollectionGetParams) SetCopyDestinationsProgressState(copyDestinationsProgressState *string) {
	o.CopyDestinationsProgressState = copyDestinationsProgressState
}

// WithCopyDestinationsProgressVolumeSnapshotBlocked adds the copyDestinationsProgressVolumeSnapshotBlocked to the lun collection get params
func (o *LunCollectionGetParams) WithCopyDestinationsProgressVolumeSnapshotBlocked(copyDestinationsProgressVolumeSnapshotBlocked *bool) *LunCollectionGetParams {
	o.SetCopyDestinationsProgressVolumeSnapshotBlocked(copyDestinationsProgressVolumeSnapshotBlocked)
	return o
}

// SetCopyDestinationsProgressVolumeSnapshotBlocked adds the copyDestinationsProgressVolumeSnapshotBlocked to the lun collection get params
func (o *LunCollectionGetParams) SetCopyDestinationsProgressVolumeSnapshotBlocked(copyDestinationsProgressVolumeSnapshotBlocked *bool) {
	o.CopyDestinationsProgressVolumeSnapshotBlocked = copyDestinationsProgressVolumeSnapshotBlocked
}

// WithCopyDestinationsUUID adds the copyDestinationsUUID to the lun collection get params
func (o *LunCollectionGetParams) WithCopyDestinationsUUID(copyDestinationsUUID *string) *LunCollectionGetParams {
	o.SetCopyDestinationsUUID(copyDestinationsUUID)
	return o
}

// SetCopyDestinationsUUID adds the copyDestinationsUuid to the lun collection get params
func (o *LunCollectionGetParams) SetCopyDestinationsUUID(copyDestinationsUUID *string) {
	o.CopyDestinationsUUID = copyDestinationsUUID
}

// WithCopySourceMaxThroughput adds the copySourceMaxThroughput to the lun collection get params
func (o *LunCollectionGetParams) WithCopySourceMaxThroughput(copySourceMaxThroughput *int64) *LunCollectionGetParams {
	o.SetCopySourceMaxThroughput(copySourceMaxThroughput)
	return o
}

// SetCopySourceMaxThroughput adds the copySourceMaxThroughput to the lun collection get params
func (o *LunCollectionGetParams) SetCopySourceMaxThroughput(copySourceMaxThroughput *int64) {
	o.CopySourceMaxThroughput = copySourceMaxThroughput
}

// WithCopySourceName adds the copySourceName to the lun collection get params
func (o *LunCollectionGetParams) WithCopySourceName(copySourceName *string) *LunCollectionGetParams {
	o.SetCopySourceName(copySourceName)
	return o
}

// SetCopySourceName adds the copySourceName to the lun collection get params
func (o *LunCollectionGetParams) SetCopySourceName(copySourceName *string) {
	o.CopySourceName = copySourceName
}

// WithCopySourcePeerName adds the copySourcePeerName to the lun collection get params
func (o *LunCollectionGetParams) WithCopySourcePeerName(copySourcePeerName *string) *LunCollectionGetParams {
	o.SetCopySourcePeerName(copySourcePeerName)
	return o
}

// SetCopySourcePeerName adds the copySourcePeerName to the lun collection get params
func (o *LunCollectionGetParams) SetCopySourcePeerName(copySourcePeerName *string) {
	o.CopySourcePeerName = copySourcePeerName
}

// WithCopySourcePeerUUID adds the copySourcePeerUUID to the lun collection get params
func (o *LunCollectionGetParams) WithCopySourcePeerUUID(copySourcePeerUUID *string) *LunCollectionGetParams {
	o.SetCopySourcePeerUUID(copySourcePeerUUID)
	return o
}

// SetCopySourcePeerUUID adds the copySourcePeerUuid to the lun collection get params
func (o *LunCollectionGetParams) SetCopySourcePeerUUID(copySourcePeerUUID *string) {
	o.CopySourcePeerUUID = copySourcePeerUUID
}

// WithCopySourceProgressElapsed adds the copySourceProgressElapsed to the lun collection get params
func (o *LunCollectionGetParams) WithCopySourceProgressElapsed(copySourceProgressElapsed *int64) *LunCollectionGetParams {
	o.SetCopySourceProgressElapsed(copySourceProgressElapsed)
	return o
}

// SetCopySourceProgressElapsed adds the copySourceProgressElapsed to the lun collection get params
func (o *LunCollectionGetParams) SetCopySourceProgressElapsed(copySourceProgressElapsed *int64) {
	o.CopySourceProgressElapsed = copySourceProgressElapsed
}

// WithCopySourceProgressFailureArgumentsCode adds the copySourceProgressFailureArgumentsCode to the lun collection get params
func (o *LunCollectionGetParams) WithCopySourceProgressFailureArgumentsCode(copySourceProgressFailureArgumentsCode *string) *LunCollectionGetParams {
	o.SetCopySourceProgressFailureArgumentsCode(copySourceProgressFailureArgumentsCode)
	return o
}

// SetCopySourceProgressFailureArgumentsCode adds the copySourceProgressFailureArgumentsCode to the lun collection get params
func (o *LunCollectionGetParams) SetCopySourceProgressFailureArgumentsCode(copySourceProgressFailureArgumentsCode *string) {
	o.CopySourceProgressFailureArgumentsCode = copySourceProgressFailureArgumentsCode
}

// WithCopySourceProgressFailureArgumentsMessage adds the copySourceProgressFailureArgumentsMessage to the lun collection get params
func (o *LunCollectionGetParams) WithCopySourceProgressFailureArgumentsMessage(copySourceProgressFailureArgumentsMessage *string) *LunCollectionGetParams {
	o.SetCopySourceProgressFailureArgumentsMessage(copySourceProgressFailureArgumentsMessage)
	return o
}

// SetCopySourceProgressFailureArgumentsMessage adds the copySourceProgressFailureArgumentsMessage to the lun collection get params
func (o *LunCollectionGetParams) SetCopySourceProgressFailureArgumentsMessage(copySourceProgressFailureArgumentsMessage *string) {
	o.CopySourceProgressFailureArgumentsMessage = copySourceProgressFailureArgumentsMessage
}

// WithCopySourceProgressFailureCode adds the copySourceProgressFailureCode to the lun collection get params
func (o *LunCollectionGetParams) WithCopySourceProgressFailureCode(copySourceProgressFailureCode *string) *LunCollectionGetParams {
	o.SetCopySourceProgressFailureCode(copySourceProgressFailureCode)
	return o
}

// SetCopySourceProgressFailureCode adds the copySourceProgressFailureCode to the lun collection get params
func (o *LunCollectionGetParams) SetCopySourceProgressFailureCode(copySourceProgressFailureCode *string) {
	o.CopySourceProgressFailureCode = copySourceProgressFailureCode
}

// WithCopySourceProgressFailureMessage adds the copySourceProgressFailureMessage to the lun collection get params
func (o *LunCollectionGetParams) WithCopySourceProgressFailureMessage(copySourceProgressFailureMessage *string) *LunCollectionGetParams {
	o.SetCopySourceProgressFailureMessage(copySourceProgressFailureMessage)
	return o
}

// SetCopySourceProgressFailureMessage adds the copySourceProgressFailureMessage to the lun collection get params
func (o *LunCollectionGetParams) SetCopySourceProgressFailureMessage(copySourceProgressFailureMessage *string) {
	o.CopySourceProgressFailureMessage = copySourceProgressFailureMessage
}

// WithCopySourceProgressPercentComplete adds the copySourceProgressPercentComplete to the lun collection get params
func (o *LunCollectionGetParams) WithCopySourceProgressPercentComplete(copySourceProgressPercentComplete *int64) *LunCollectionGetParams {
	o.SetCopySourceProgressPercentComplete(copySourceProgressPercentComplete)
	return o
}

// SetCopySourceProgressPercentComplete adds the copySourceProgressPercentComplete to the lun collection get params
func (o *LunCollectionGetParams) SetCopySourceProgressPercentComplete(copySourceProgressPercentComplete *int64) {
	o.CopySourceProgressPercentComplete = copySourceProgressPercentComplete
}

// WithCopySourceProgressState adds the copySourceProgressState to the lun collection get params
func (o *LunCollectionGetParams) WithCopySourceProgressState(copySourceProgressState *string) *LunCollectionGetParams {
	o.SetCopySourceProgressState(copySourceProgressState)
	return o
}

// SetCopySourceProgressState adds the copySourceProgressState to the lun collection get params
func (o *LunCollectionGetParams) SetCopySourceProgressState(copySourceProgressState *string) {
	o.CopySourceProgressState = copySourceProgressState
}

// WithCopySourceProgressVolumeSnapshotBlocked adds the copySourceProgressVolumeSnapshotBlocked to the lun collection get params
func (o *LunCollectionGetParams) WithCopySourceProgressVolumeSnapshotBlocked(copySourceProgressVolumeSnapshotBlocked *bool) *LunCollectionGetParams {
	o.SetCopySourceProgressVolumeSnapshotBlocked(copySourceProgressVolumeSnapshotBlocked)
	return o
}

// SetCopySourceProgressVolumeSnapshotBlocked adds the copySourceProgressVolumeSnapshotBlocked to the lun collection get params
func (o *LunCollectionGetParams) SetCopySourceProgressVolumeSnapshotBlocked(copySourceProgressVolumeSnapshotBlocked *bool) {
	o.CopySourceProgressVolumeSnapshotBlocked = copySourceProgressVolumeSnapshotBlocked
}

// WithCopySourceUUID adds the copySourceUUID to the lun collection get params
func (o *LunCollectionGetParams) WithCopySourceUUID(copySourceUUID *string) *LunCollectionGetParams {
	o.SetCopySourceUUID(copySourceUUID)
	return o
}

// SetCopySourceUUID adds the copySourceUuid to the lun collection get params
func (o *LunCollectionGetParams) SetCopySourceUUID(copySourceUUID *string) {
	o.CopySourceUUID = copySourceUUID
}

// WithCreateTime adds the createTime to the lun collection get params
func (o *LunCollectionGetParams) WithCreateTime(createTime *string) *LunCollectionGetParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the lun collection get params
func (o *LunCollectionGetParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithEnabled adds the enabled to the lun collection get params
func (o *LunCollectionGetParams) WithEnabled(enabled *bool) *LunCollectionGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the lun collection get params
func (o *LunCollectionGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithEncryptionState adds the encryptionState to the lun collection get params
func (o *LunCollectionGetParams) WithEncryptionState(encryptionState *string) *LunCollectionGetParams {
	o.SetEncryptionState(encryptionState)
	return o
}

// SetEncryptionState adds the encryptionState to the lun collection get params
func (o *LunCollectionGetParams) SetEncryptionState(encryptionState *string) {
	o.EncryptionState = encryptionState
}

// WithFields adds the fields to the lun collection get params
func (o *LunCollectionGetParams) WithFields(fields []string) *LunCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the lun collection get params
func (o *LunCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithLocationLogicalUnit adds the locationLogicalUnit to the lun collection get params
func (o *LunCollectionGetParams) WithLocationLogicalUnit(locationLogicalUnit *string) *LunCollectionGetParams {
	o.SetLocationLogicalUnit(locationLogicalUnit)
	return o
}

// SetLocationLogicalUnit adds the locationLogicalUnit to the lun collection get params
func (o *LunCollectionGetParams) SetLocationLogicalUnit(locationLogicalUnit *string) {
	o.LocationLogicalUnit = locationLogicalUnit
}

// WithLocationNodeName adds the locationNodeName to the lun collection get params
func (o *LunCollectionGetParams) WithLocationNodeName(locationNodeName *string) *LunCollectionGetParams {
	o.SetLocationNodeName(locationNodeName)
	return o
}

// SetLocationNodeName adds the locationNodeName to the lun collection get params
func (o *LunCollectionGetParams) SetLocationNodeName(locationNodeName *string) {
	o.LocationNodeName = locationNodeName
}

// WithLocationNodeUUID adds the locationNodeUUID to the lun collection get params
func (o *LunCollectionGetParams) WithLocationNodeUUID(locationNodeUUID *string) *LunCollectionGetParams {
	o.SetLocationNodeUUID(locationNodeUUID)
	return o
}

// SetLocationNodeUUID adds the locationNodeUuid to the lun collection get params
func (o *LunCollectionGetParams) SetLocationNodeUUID(locationNodeUUID *string) {
	o.LocationNodeUUID = locationNodeUUID
}

// WithLocationQtreeID adds the locationQtreeID to the lun collection get params
func (o *LunCollectionGetParams) WithLocationQtreeID(locationQtreeID *int64) *LunCollectionGetParams {
	o.SetLocationQtreeID(locationQtreeID)
	return o
}

// SetLocationQtreeID adds the locationQtreeId to the lun collection get params
func (o *LunCollectionGetParams) SetLocationQtreeID(locationQtreeID *int64) {
	o.LocationQtreeID = locationQtreeID
}

// WithLocationQtreeName adds the locationQtreeName to the lun collection get params
func (o *LunCollectionGetParams) WithLocationQtreeName(locationQtreeName *string) *LunCollectionGetParams {
	o.SetLocationQtreeName(locationQtreeName)
	return o
}

// SetLocationQtreeName adds the locationQtreeName to the lun collection get params
func (o *LunCollectionGetParams) SetLocationQtreeName(locationQtreeName *string) {
	o.LocationQtreeName = locationQtreeName
}

// WithLocationStorageAvailabilityZoneName adds the locationStorageAvailabilityZoneName to the lun collection get params
func (o *LunCollectionGetParams) WithLocationStorageAvailabilityZoneName(locationStorageAvailabilityZoneName *string) *LunCollectionGetParams {
	o.SetLocationStorageAvailabilityZoneName(locationStorageAvailabilityZoneName)
	return o
}

// SetLocationStorageAvailabilityZoneName adds the locationStorageAvailabilityZoneName to the lun collection get params
func (o *LunCollectionGetParams) SetLocationStorageAvailabilityZoneName(locationStorageAvailabilityZoneName *string) {
	o.LocationStorageAvailabilityZoneName = locationStorageAvailabilityZoneName
}

// WithLocationStorageAvailabilityZoneUUID adds the locationStorageAvailabilityZoneUUID to the lun collection get params
func (o *LunCollectionGetParams) WithLocationStorageAvailabilityZoneUUID(locationStorageAvailabilityZoneUUID *string) *LunCollectionGetParams {
	o.SetLocationStorageAvailabilityZoneUUID(locationStorageAvailabilityZoneUUID)
	return o
}

// SetLocationStorageAvailabilityZoneUUID adds the locationStorageAvailabilityZoneUuid to the lun collection get params
func (o *LunCollectionGetParams) SetLocationStorageAvailabilityZoneUUID(locationStorageAvailabilityZoneUUID *string) {
	o.LocationStorageAvailabilityZoneUUID = locationStorageAvailabilityZoneUUID
}

// WithLocationVolumeName adds the locationVolumeName to the lun collection get params
func (o *LunCollectionGetParams) WithLocationVolumeName(locationVolumeName *string) *LunCollectionGetParams {
	o.SetLocationVolumeName(locationVolumeName)
	return o
}

// SetLocationVolumeName adds the locationVolumeName to the lun collection get params
func (o *LunCollectionGetParams) SetLocationVolumeName(locationVolumeName *string) {
	o.LocationVolumeName = locationVolumeName
}

// WithLocationVolumeUUID adds the locationVolumeUUID to the lun collection get params
func (o *LunCollectionGetParams) WithLocationVolumeUUID(locationVolumeUUID *string) *LunCollectionGetParams {
	o.SetLocationVolumeUUID(locationVolumeUUID)
	return o
}

// SetLocationVolumeUUID adds the locationVolumeUuid to the lun collection get params
func (o *LunCollectionGetParams) SetLocationVolumeUUID(locationVolumeUUID *string) {
	o.LocationVolumeUUID = locationVolumeUUID
}

// WithLunMapsIgroupComment adds the lunMapsIgroupComment to the lun collection get params
func (o *LunCollectionGetParams) WithLunMapsIgroupComment(lunMapsIgroupComment *string) *LunCollectionGetParams {
	o.SetLunMapsIgroupComment(lunMapsIgroupComment)
	return o
}

// SetLunMapsIgroupComment adds the lunMapsIgroupComment to the lun collection get params
func (o *LunCollectionGetParams) SetLunMapsIgroupComment(lunMapsIgroupComment *string) {
	o.LunMapsIgroupComment = lunMapsIgroupComment
}

// WithLunMapsIgroupIgroupsName adds the lunMapsIgroupIgroupsName to the lun collection get params
func (o *LunCollectionGetParams) WithLunMapsIgroupIgroupsName(lunMapsIgroupIgroupsName *string) *LunCollectionGetParams {
	o.SetLunMapsIgroupIgroupsName(lunMapsIgroupIgroupsName)
	return o
}

// SetLunMapsIgroupIgroupsName adds the lunMapsIgroupIgroupsName to the lun collection get params
func (o *LunCollectionGetParams) SetLunMapsIgroupIgroupsName(lunMapsIgroupIgroupsName *string) {
	o.LunMapsIgroupIgroupsName = lunMapsIgroupIgroupsName
}

// WithLunMapsIgroupIgroupsUUID adds the lunMapsIgroupIgroupsUUID to the lun collection get params
func (o *LunCollectionGetParams) WithLunMapsIgroupIgroupsUUID(lunMapsIgroupIgroupsUUID *string) *LunCollectionGetParams {
	o.SetLunMapsIgroupIgroupsUUID(lunMapsIgroupIgroupsUUID)
	return o
}

// SetLunMapsIgroupIgroupsUUID adds the lunMapsIgroupIgroupsUuid to the lun collection get params
func (o *LunCollectionGetParams) SetLunMapsIgroupIgroupsUUID(lunMapsIgroupIgroupsUUID *string) {
	o.LunMapsIgroupIgroupsUUID = lunMapsIgroupIgroupsUUID
}

// WithLunMapsIgroupInitiatorsComment adds the lunMapsIgroupInitiatorsComment to the lun collection get params
func (o *LunCollectionGetParams) WithLunMapsIgroupInitiatorsComment(lunMapsIgroupInitiatorsComment *string) *LunCollectionGetParams {
	o.SetLunMapsIgroupInitiatorsComment(lunMapsIgroupInitiatorsComment)
	return o
}

// SetLunMapsIgroupInitiatorsComment adds the lunMapsIgroupInitiatorsComment to the lun collection get params
func (o *LunCollectionGetParams) SetLunMapsIgroupInitiatorsComment(lunMapsIgroupInitiatorsComment *string) {
	o.LunMapsIgroupInitiatorsComment = lunMapsIgroupInitiatorsComment
}

// WithLunMapsIgroupInitiatorsName adds the lunMapsIgroupInitiatorsName to the lun collection get params
func (o *LunCollectionGetParams) WithLunMapsIgroupInitiatorsName(lunMapsIgroupInitiatorsName *string) *LunCollectionGetParams {
	o.SetLunMapsIgroupInitiatorsName(lunMapsIgroupInitiatorsName)
	return o
}

// SetLunMapsIgroupInitiatorsName adds the lunMapsIgroupInitiatorsName to the lun collection get params
func (o *LunCollectionGetParams) SetLunMapsIgroupInitiatorsName(lunMapsIgroupInitiatorsName *string) {
	o.LunMapsIgroupInitiatorsName = lunMapsIgroupInitiatorsName
}

// WithLunMapsIgroupName adds the lunMapsIgroupName to the lun collection get params
func (o *LunCollectionGetParams) WithLunMapsIgroupName(lunMapsIgroupName *string) *LunCollectionGetParams {
	o.SetLunMapsIgroupName(lunMapsIgroupName)
	return o
}

// SetLunMapsIgroupName adds the lunMapsIgroupName to the lun collection get params
func (o *LunCollectionGetParams) SetLunMapsIgroupName(lunMapsIgroupName *string) {
	o.LunMapsIgroupName = lunMapsIgroupName
}

// WithLunMapsIgroupOsType adds the lunMapsIgroupOsType to the lun collection get params
func (o *LunCollectionGetParams) WithLunMapsIgroupOsType(lunMapsIgroupOsType *string) *LunCollectionGetParams {
	o.SetLunMapsIgroupOsType(lunMapsIgroupOsType)
	return o
}

// SetLunMapsIgroupOsType adds the lunMapsIgroupOsType to the lun collection get params
func (o *LunCollectionGetParams) SetLunMapsIgroupOsType(lunMapsIgroupOsType *string) {
	o.LunMapsIgroupOsType = lunMapsIgroupOsType
}

// WithLunMapsIgroupProtocol adds the lunMapsIgroupProtocol to the lun collection get params
func (o *LunCollectionGetParams) WithLunMapsIgroupProtocol(lunMapsIgroupProtocol *string) *LunCollectionGetParams {
	o.SetLunMapsIgroupProtocol(lunMapsIgroupProtocol)
	return o
}

// SetLunMapsIgroupProtocol adds the lunMapsIgroupProtocol to the lun collection get params
func (o *LunCollectionGetParams) SetLunMapsIgroupProtocol(lunMapsIgroupProtocol *string) {
	o.LunMapsIgroupProtocol = lunMapsIgroupProtocol
}

// WithLunMapsIgroupUUID adds the lunMapsIgroupUUID to the lun collection get params
func (o *LunCollectionGetParams) WithLunMapsIgroupUUID(lunMapsIgroupUUID *string) *LunCollectionGetParams {
	o.SetLunMapsIgroupUUID(lunMapsIgroupUUID)
	return o
}

// SetLunMapsIgroupUUID adds the lunMapsIgroupUuid to the lun collection get params
func (o *LunCollectionGetParams) SetLunMapsIgroupUUID(lunMapsIgroupUUID *string) {
	o.LunMapsIgroupUUID = lunMapsIgroupUUID
}

// WithLunMapsLogicalUnitNumber adds the lunMapsLogicalUnitNumber to the lun collection get params
func (o *LunCollectionGetParams) WithLunMapsLogicalUnitNumber(lunMapsLogicalUnitNumber *int64) *LunCollectionGetParams {
	o.SetLunMapsLogicalUnitNumber(lunMapsLogicalUnitNumber)
	return o
}

// SetLunMapsLogicalUnitNumber adds the lunMapsLogicalUnitNumber to the lun collection get params
func (o *LunCollectionGetParams) SetLunMapsLogicalUnitNumber(lunMapsLogicalUnitNumber *int64) {
	o.LunMapsLogicalUnitNumber = lunMapsLogicalUnitNumber
}

// WithMaxRecords adds the maxRecords to the lun collection get params
func (o *LunCollectionGetParams) WithMaxRecords(maxRecords *int64) *LunCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the lun collection get params
func (o *LunCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMetricDuration adds the metricDuration to the lun collection get params
func (o *LunCollectionGetParams) WithMetricDuration(metricDuration *string) *LunCollectionGetParams {
	o.SetMetricDuration(metricDuration)
	return o
}

// SetMetricDuration adds the metricDuration to the lun collection get params
func (o *LunCollectionGetParams) SetMetricDuration(metricDuration *string) {
	o.MetricDuration = metricDuration
}

// WithMetricIopsOther adds the metricIopsOther to the lun collection get params
func (o *LunCollectionGetParams) WithMetricIopsOther(metricIopsOther *int64) *LunCollectionGetParams {
	o.SetMetricIopsOther(metricIopsOther)
	return o
}

// SetMetricIopsOther adds the metricIopsOther to the lun collection get params
func (o *LunCollectionGetParams) SetMetricIopsOther(metricIopsOther *int64) {
	o.MetricIopsOther = metricIopsOther
}

// WithMetricIopsRead adds the metricIopsRead to the lun collection get params
func (o *LunCollectionGetParams) WithMetricIopsRead(metricIopsRead *int64) *LunCollectionGetParams {
	o.SetMetricIopsRead(metricIopsRead)
	return o
}

// SetMetricIopsRead adds the metricIopsRead to the lun collection get params
func (o *LunCollectionGetParams) SetMetricIopsRead(metricIopsRead *int64) {
	o.MetricIopsRead = metricIopsRead
}

// WithMetricIopsTotal adds the metricIopsTotal to the lun collection get params
func (o *LunCollectionGetParams) WithMetricIopsTotal(metricIopsTotal *int64) *LunCollectionGetParams {
	o.SetMetricIopsTotal(metricIopsTotal)
	return o
}

// SetMetricIopsTotal adds the metricIopsTotal to the lun collection get params
func (o *LunCollectionGetParams) SetMetricIopsTotal(metricIopsTotal *int64) {
	o.MetricIopsTotal = metricIopsTotal
}

// WithMetricIopsWrite adds the metricIopsWrite to the lun collection get params
func (o *LunCollectionGetParams) WithMetricIopsWrite(metricIopsWrite *int64) *LunCollectionGetParams {
	o.SetMetricIopsWrite(metricIopsWrite)
	return o
}

// SetMetricIopsWrite adds the metricIopsWrite to the lun collection get params
func (o *LunCollectionGetParams) SetMetricIopsWrite(metricIopsWrite *int64) {
	o.MetricIopsWrite = metricIopsWrite
}

// WithMetricLatencyOther adds the metricLatencyOther to the lun collection get params
func (o *LunCollectionGetParams) WithMetricLatencyOther(metricLatencyOther *int64) *LunCollectionGetParams {
	o.SetMetricLatencyOther(metricLatencyOther)
	return o
}

// SetMetricLatencyOther adds the metricLatencyOther to the lun collection get params
func (o *LunCollectionGetParams) SetMetricLatencyOther(metricLatencyOther *int64) {
	o.MetricLatencyOther = metricLatencyOther
}

// WithMetricLatencyRead adds the metricLatencyRead to the lun collection get params
func (o *LunCollectionGetParams) WithMetricLatencyRead(metricLatencyRead *int64) *LunCollectionGetParams {
	o.SetMetricLatencyRead(metricLatencyRead)
	return o
}

// SetMetricLatencyRead adds the metricLatencyRead to the lun collection get params
func (o *LunCollectionGetParams) SetMetricLatencyRead(metricLatencyRead *int64) {
	o.MetricLatencyRead = metricLatencyRead
}

// WithMetricLatencyTotal adds the metricLatencyTotal to the lun collection get params
func (o *LunCollectionGetParams) WithMetricLatencyTotal(metricLatencyTotal *int64) *LunCollectionGetParams {
	o.SetMetricLatencyTotal(metricLatencyTotal)
	return o
}

// SetMetricLatencyTotal adds the metricLatencyTotal to the lun collection get params
func (o *LunCollectionGetParams) SetMetricLatencyTotal(metricLatencyTotal *int64) {
	o.MetricLatencyTotal = metricLatencyTotal
}

// WithMetricLatencyWrite adds the metricLatencyWrite to the lun collection get params
func (o *LunCollectionGetParams) WithMetricLatencyWrite(metricLatencyWrite *int64) *LunCollectionGetParams {
	o.SetMetricLatencyWrite(metricLatencyWrite)
	return o
}

// SetMetricLatencyWrite adds the metricLatencyWrite to the lun collection get params
func (o *LunCollectionGetParams) SetMetricLatencyWrite(metricLatencyWrite *int64) {
	o.MetricLatencyWrite = metricLatencyWrite
}

// WithMetricStatus adds the metricStatus to the lun collection get params
func (o *LunCollectionGetParams) WithMetricStatus(metricStatus *string) *LunCollectionGetParams {
	o.SetMetricStatus(metricStatus)
	return o
}

// SetMetricStatus adds the metricStatus to the lun collection get params
func (o *LunCollectionGetParams) SetMetricStatus(metricStatus *string) {
	o.MetricStatus = metricStatus
}

// WithMetricThroughputOther adds the metricThroughputOther to the lun collection get params
func (o *LunCollectionGetParams) WithMetricThroughputOther(metricThroughputOther *int64) *LunCollectionGetParams {
	o.SetMetricThroughputOther(metricThroughputOther)
	return o
}

// SetMetricThroughputOther adds the metricThroughputOther to the lun collection get params
func (o *LunCollectionGetParams) SetMetricThroughputOther(metricThroughputOther *int64) {
	o.MetricThroughputOther = metricThroughputOther
}

// WithMetricThroughputRead adds the metricThroughputRead to the lun collection get params
func (o *LunCollectionGetParams) WithMetricThroughputRead(metricThroughputRead *int64) *LunCollectionGetParams {
	o.SetMetricThroughputRead(metricThroughputRead)
	return o
}

// SetMetricThroughputRead adds the metricThroughputRead to the lun collection get params
func (o *LunCollectionGetParams) SetMetricThroughputRead(metricThroughputRead *int64) {
	o.MetricThroughputRead = metricThroughputRead
}

// WithMetricThroughputTotal adds the metricThroughputTotal to the lun collection get params
func (o *LunCollectionGetParams) WithMetricThroughputTotal(metricThroughputTotal *int64) *LunCollectionGetParams {
	o.SetMetricThroughputTotal(metricThroughputTotal)
	return o
}

// SetMetricThroughputTotal adds the metricThroughputTotal to the lun collection get params
func (o *LunCollectionGetParams) SetMetricThroughputTotal(metricThroughputTotal *int64) {
	o.MetricThroughputTotal = metricThroughputTotal
}

// WithMetricThroughputWrite adds the metricThroughputWrite to the lun collection get params
func (o *LunCollectionGetParams) WithMetricThroughputWrite(metricThroughputWrite *int64) *LunCollectionGetParams {
	o.SetMetricThroughputWrite(metricThroughputWrite)
	return o
}

// SetMetricThroughputWrite adds the metricThroughputWrite to the lun collection get params
func (o *LunCollectionGetParams) SetMetricThroughputWrite(metricThroughputWrite *int64) {
	o.MetricThroughputWrite = metricThroughputWrite
}

// WithMetricTimestamp adds the metricTimestamp to the lun collection get params
func (o *LunCollectionGetParams) WithMetricTimestamp(metricTimestamp *string) *LunCollectionGetParams {
	o.SetMetricTimestamp(metricTimestamp)
	return o
}

// SetMetricTimestamp adds the metricTimestamp to the lun collection get params
func (o *LunCollectionGetParams) SetMetricTimestamp(metricTimestamp *string) {
	o.MetricTimestamp = metricTimestamp
}

// WithMovementMaxThroughput adds the movementMaxThroughput to the lun collection get params
func (o *LunCollectionGetParams) WithMovementMaxThroughput(movementMaxThroughput *int64) *LunCollectionGetParams {
	o.SetMovementMaxThroughput(movementMaxThroughput)
	return o
}

// SetMovementMaxThroughput adds the movementMaxThroughput to the lun collection get params
func (o *LunCollectionGetParams) SetMovementMaxThroughput(movementMaxThroughput *int64) {
	o.MovementMaxThroughput = movementMaxThroughput
}

// WithMovementPathsDestination adds the movementPathsDestination to the lun collection get params
func (o *LunCollectionGetParams) WithMovementPathsDestination(movementPathsDestination *string) *LunCollectionGetParams {
	o.SetMovementPathsDestination(movementPathsDestination)
	return o
}

// SetMovementPathsDestination adds the movementPathsDestination to the lun collection get params
func (o *LunCollectionGetParams) SetMovementPathsDestination(movementPathsDestination *string) {
	o.MovementPathsDestination = movementPathsDestination
}

// WithMovementPathsSource adds the movementPathsSource to the lun collection get params
func (o *LunCollectionGetParams) WithMovementPathsSource(movementPathsSource *string) *LunCollectionGetParams {
	o.SetMovementPathsSource(movementPathsSource)
	return o
}

// SetMovementPathsSource adds the movementPathsSource to the lun collection get params
func (o *LunCollectionGetParams) SetMovementPathsSource(movementPathsSource *string) {
	o.MovementPathsSource = movementPathsSource
}

// WithMovementProgressElapsed adds the movementProgressElapsed to the lun collection get params
func (o *LunCollectionGetParams) WithMovementProgressElapsed(movementProgressElapsed *int64) *LunCollectionGetParams {
	o.SetMovementProgressElapsed(movementProgressElapsed)
	return o
}

// SetMovementProgressElapsed adds the movementProgressElapsed to the lun collection get params
func (o *LunCollectionGetParams) SetMovementProgressElapsed(movementProgressElapsed *int64) {
	o.MovementProgressElapsed = movementProgressElapsed
}

// WithMovementProgressFailureArgumentsCode adds the movementProgressFailureArgumentsCode to the lun collection get params
func (o *LunCollectionGetParams) WithMovementProgressFailureArgumentsCode(movementProgressFailureArgumentsCode *string) *LunCollectionGetParams {
	o.SetMovementProgressFailureArgumentsCode(movementProgressFailureArgumentsCode)
	return o
}

// SetMovementProgressFailureArgumentsCode adds the movementProgressFailureArgumentsCode to the lun collection get params
func (o *LunCollectionGetParams) SetMovementProgressFailureArgumentsCode(movementProgressFailureArgumentsCode *string) {
	o.MovementProgressFailureArgumentsCode = movementProgressFailureArgumentsCode
}

// WithMovementProgressFailureArgumentsMessage adds the movementProgressFailureArgumentsMessage to the lun collection get params
func (o *LunCollectionGetParams) WithMovementProgressFailureArgumentsMessage(movementProgressFailureArgumentsMessage *string) *LunCollectionGetParams {
	o.SetMovementProgressFailureArgumentsMessage(movementProgressFailureArgumentsMessage)
	return o
}

// SetMovementProgressFailureArgumentsMessage adds the movementProgressFailureArgumentsMessage to the lun collection get params
func (o *LunCollectionGetParams) SetMovementProgressFailureArgumentsMessage(movementProgressFailureArgumentsMessage *string) {
	o.MovementProgressFailureArgumentsMessage = movementProgressFailureArgumentsMessage
}

// WithMovementProgressFailureCode adds the movementProgressFailureCode to the lun collection get params
func (o *LunCollectionGetParams) WithMovementProgressFailureCode(movementProgressFailureCode *string) *LunCollectionGetParams {
	o.SetMovementProgressFailureCode(movementProgressFailureCode)
	return o
}

// SetMovementProgressFailureCode adds the movementProgressFailureCode to the lun collection get params
func (o *LunCollectionGetParams) SetMovementProgressFailureCode(movementProgressFailureCode *string) {
	o.MovementProgressFailureCode = movementProgressFailureCode
}

// WithMovementProgressFailureMessage adds the movementProgressFailureMessage to the lun collection get params
func (o *LunCollectionGetParams) WithMovementProgressFailureMessage(movementProgressFailureMessage *string) *LunCollectionGetParams {
	o.SetMovementProgressFailureMessage(movementProgressFailureMessage)
	return o
}

// SetMovementProgressFailureMessage adds the movementProgressFailureMessage to the lun collection get params
func (o *LunCollectionGetParams) SetMovementProgressFailureMessage(movementProgressFailureMessage *string) {
	o.MovementProgressFailureMessage = movementProgressFailureMessage
}

// WithMovementProgressPercentComplete adds the movementProgressPercentComplete to the lun collection get params
func (o *LunCollectionGetParams) WithMovementProgressPercentComplete(movementProgressPercentComplete *int64) *LunCollectionGetParams {
	o.SetMovementProgressPercentComplete(movementProgressPercentComplete)
	return o
}

// SetMovementProgressPercentComplete adds the movementProgressPercentComplete to the lun collection get params
func (o *LunCollectionGetParams) SetMovementProgressPercentComplete(movementProgressPercentComplete *int64) {
	o.MovementProgressPercentComplete = movementProgressPercentComplete
}

// WithMovementProgressState adds the movementProgressState to the lun collection get params
func (o *LunCollectionGetParams) WithMovementProgressState(movementProgressState *string) *LunCollectionGetParams {
	o.SetMovementProgressState(movementProgressState)
	return o
}

// SetMovementProgressState adds the movementProgressState to the lun collection get params
func (o *LunCollectionGetParams) SetMovementProgressState(movementProgressState *string) {
	o.MovementProgressState = movementProgressState
}

// WithMovementProgressVolumeSnapshotBlocked adds the movementProgressVolumeSnapshotBlocked to the lun collection get params
func (o *LunCollectionGetParams) WithMovementProgressVolumeSnapshotBlocked(movementProgressVolumeSnapshotBlocked *bool) *LunCollectionGetParams {
	o.SetMovementProgressVolumeSnapshotBlocked(movementProgressVolumeSnapshotBlocked)
	return o
}

// SetMovementProgressVolumeSnapshotBlocked adds the movementProgressVolumeSnapshotBlocked to the lun collection get params
func (o *LunCollectionGetParams) SetMovementProgressVolumeSnapshotBlocked(movementProgressVolumeSnapshotBlocked *bool) {
	o.MovementProgressVolumeSnapshotBlocked = movementProgressVolumeSnapshotBlocked
}

// WithName adds the name to the lun collection get params
func (o *LunCollectionGetParams) WithName(name *string) *LunCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the lun collection get params
func (o *LunCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the lun collection get params
func (o *LunCollectionGetParams) WithOrderBy(orderBy []string) *LunCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the lun collection get params
func (o *LunCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithOsType adds the osType to the lun collection get params
func (o *LunCollectionGetParams) WithOsType(osType *string) *LunCollectionGetParams {
	o.SetOsType(osType)
	return o
}

// SetOsType adds the osType to the lun collection get params
func (o *LunCollectionGetParams) SetOsType(osType *string) {
	o.OsType = osType
}

// WithQosPolicyName adds the qosPolicyName to the lun collection get params
func (o *LunCollectionGetParams) WithQosPolicyName(qosPolicyName *string) *LunCollectionGetParams {
	o.SetQosPolicyName(qosPolicyName)
	return o
}

// SetQosPolicyName adds the qosPolicyName to the lun collection get params
func (o *LunCollectionGetParams) SetQosPolicyName(qosPolicyName *string) {
	o.QosPolicyName = qosPolicyName
}

// WithQosPolicyUUID adds the qosPolicyUUID to the lun collection get params
func (o *LunCollectionGetParams) WithQosPolicyUUID(qosPolicyUUID *string) *LunCollectionGetParams {
	o.SetQosPolicyUUID(qosPolicyUUID)
	return o
}

// SetQosPolicyUUID adds the qosPolicyUuid to the lun collection get params
func (o *LunCollectionGetParams) SetQosPolicyUUID(qosPolicyUUID *string) {
	o.QosPolicyUUID = qosPolicyUUID
}

// WithReturnRecords adds the returnRecords to the lun collection get params
func (o *LunCollectionGetParams) WithReturnRecords(returnRecords *bool) *LunCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the lun collection get params
func (o *LunCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the lun collection get params
func (o *LunCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *LunCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the lun collection get params
func (o *LunCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialNumber adds the serialNumber to the lun collection get params
func (o *LunCollectionGetParams) WithSerialNumber(serialNumber *string) *LunCollectionGetParams {
	o.SetSerialNumber(serialNumber)
	return o
}

// SetSerialNumber adds the serialNumber to the lun collection get params
func (o *LunCollectionGetParams) SetSerialNumber(serialNumber *string) {
	o.SerialNumber = serialNumber
}

// WithSerialNumberHex adds the serialNumberHex to the lun collection get params
func (o *LunCollectionGetParams) WithSerialNumberHex(serialNumberHex *string) *LunCollectionGetParams {
	o.SetSerialNumberHex(serialNumberHex)
	return o
}

// SetSerialNumberHex adds the serialNumberHex to the lun collection get params
func (o *LunCollectionGetParams) SetSerialNumberHex(serialNumberHex *string) {
	o.SerialNumberHex = serialNumberHex
}

// WithSpaceEfficiencyRatio adds the spaceEfficiencyRatio to the lun collection get params
func (o *LunCollectionGetParams) WithSpaceEfficiencyRatio(spaceEfficiencyRatio *float64) *LunCollectionGetParams {
	o.SetSpaceEfficiencyRatio(spaceEfficiencyRatio)
	return o
}

// SetSpaceEfficiencyRatio adds the spaceEfficiencyRatio to the lun collection get params
func (o *LunCollectionGetParams) SetSpaceEfficiencyRatio(spaceEfficiencyRatio *float64) {
	o.SpaceEfficiencyRatio = spaceEfficiencyRatio
}

// WithSpaceGuaranteeRequested adds the spaceGuaranteeRequested to the lun collection get params
func (o *LunCollectionGetParams) WithSpaceGuaranteeRequested(spaceGuaranteeRequested *bool) *LunCollectionGetParams {
	o.SetSpaceGuaranteeRequested(spaceGuaranteeRequested)
	return o
}

// SetSpaceGuaranteeRequested adds the spaceGuaranteeRequested to the lun collection get params
func (o *LunCollectionGetParams) SetSpaceGuaranteeRequested(spaceGuaranteeRequested *bool) {
	o.SpaceGuaranteeRequested = spaceGuaranteeRequested
}

// WithSpaceGuaranteeReserved adds the spaceGuaranteeReserved to the lun collection get params
func (o *LunCollectionGetParams) WithSpaceGuaranteeReserved(spaceGuaranteeReserved *bool) *LunCollectionGetParams {
	o.SetSpaceGuaranteeReserved(spaceGuaranteeReserved)
	return o
}

// SetSpaceGuaranteeReserved adds the spaceGuaranteeReserved to the lun collection get params
func (o *LunCollectionGetParams) SetSpaceGuaranteeReserved(spaceGuaranteeReserved *bool) {
	o.SpaceGuaranteeReserved = spaceGuaranteeReserved
}

// WithSpacePhysicalUsed adds the spacePhysicalUsed to the lun collection get params
func (o *LunCollectionGetParams) WithSpacePhysicalUsed(spacePhysicalUsed *int64) *LunCollectionGetParams {
	o.SetSpacePhysicalUsed(spacePhysicalUsed)
	return o
}

// SetSpacePhysicalUsed adds the spacePhysicalUsed to the lun collection get params
func (o *LunCollectionGetParams) SetSpacePhysicalUsed(spacePhysicalUsed *int64) {
	o.SpacePhysicalUsed = spacePhysicalUsed
}

// WithSpacePhysicalUsedBySnapshots adds the spacePhysicalUsedBySnapshots to the lun collection get params
func (o *LunCollectionGetParams) WithSpacePhysicalUsedBySnapshots(spacePhysicalUsedBySnapshots *int64) *LunCollectionGetParams {
	o.SetSpacePhysicalUsedBySnapshots(spacePhysicalUsedBySnapshots)
	return o
}

// SetSpacePhysicalUsedBySnapshots adds the spacePhysicalUsedBySnapshots to the lun collection get params
func (o *LunCollectionGetParams) SetSpacePhysicalUsedBySnapshots(spacePhysicalUsedBySnapshots *int64) {
	o.SpacePhysicalUsedBySnapshots = spacePhysicalUsedBySnapshots
}

// WithSpaceScsiThinProvisioningSupportEnabled adds the spaceScsiThinProvisioningSupportEnabled to the lun collection get params
func (o *LunCollectionGetParams) WithSpaceScsiThinProvisioningSupportEnabled(spaceScsiThinProvisioningSupportEnabled *bool) *LunCollectionGetParams {
	o.SetSpaceScsiThinProvisioningSupportEnabled(spaceScsiThinProvisioningSupportEnabled)
	return o
}

// SetSpaceScsiThinProvisioningSupportEnabled adds the spaceScsiThinProvisioningSupportEnabled to the lun collection get params
func (o *LunCollectionGetParams) SetSpaceScsiThinProvisioningSupportEnabled(spaceScsiThinProvisioningSupportEnabled *bool) {
	o.SpaceScsiThinProvisioningSupportEnabled = spaceScsiThinProvisioningSupportEnabled
}

// WithSpaceSize adds the spaceSize to the lun collection get params
func (o *LunCollectionGetParams) WithSpaceSize(spaceSize *int64) *LunCollectionGetParams {
	o.SetSpaceSize(spaceSize)
	return o
}

// SetSpaceSize adds the spaceSize to the lun collection get params
func (o *LunCollectionGetParams) SetSpaceSize(spaceSize *int64) {
	o.SpaceSize = spaceSize
}

// WithSpaceSnapshotAutodeleteEnabled adds the spaceSnapshotAutodeleteEnabled to the lun collection get params
func (o *LunCollectionGetParams) WithSpaceSnapshotAutodeleteEnabled(spaceSnapshotAutodeleteEnabled *bool) *LunCollectionGetParams {
	o.SetSpaceSnapshotAutodeleteEnabled(spaceSnapshotAutodeleteEnabled)
	return o
}

// SetSpaceSnapshotAutodeleteEnabled adds the spaceSnapshotAutodeleteEnabled to the lun collection get params
func (o *LunCollectionGetParams) SetSpaceSnapshotAutodeleteEnabled(spaceSnapshotAutodeleteEnabled *bool) {
	o.SpaceSnapshotAutodeleteEnabled = spaceSnapshotAutodeleteEnabled
}

// WithSpaceSnapshotReserveAvailable adds the spaceSnapshotReserveAvailable to the lun collection get params
func (o *LunCollectionGetParams) WithSpaceSnapshotReserveAvailable(spaceSnapshotReserveAvailable *int64) *LunCollectionGetParams {
	o.SetSpaceSnapshotReserveAvailable(spaceSnapshotReserveAvailable)
	return o
}

// SetSpaceSnapshotReserveAvailable adds the spaceSnapshotReserveAvailable to the lun collection get params
func (o *LunCollectionGetParams) SetSpaceSnapshotReserveAvailable(spaceSnapshotReserveAvailable *int64) {
	o.SpaceSnapshotReserveAvailable = spaceSnapshotReserveAvailable
}

// WithSpaceSnapshotReservePercent adds the spaceSnapshotReservePercent to the lun collection get params
func (o *LunCollectionGetParams) WithSpaceSnapshotReservePercent(spaceSnapshotReservePercent *int64) *LunCollectionGetParams {
	o.SetSpaceSnapshotReservePercent(spaceSnapshotReservePercent)
	return o
}

// SetSpaceSnapshotReservePercent adds the spaceSnapshotReservePercent to the lun collection get params
func (o *LunCollectionGetParams) SetSpaceSnapshotReservePercent(spaceSnapshotReservePercent *int64) {
	o.SpaceSnapshotReservePercent = spaceSnapshotReservePercent
}

// WithSpaceSnapshotReserveSize adds the spaceSnapshotReserveSize to the lun collection get params
func (o *LunCollectionGetParams) WithSpaceSnapshotReserveSize(spaceSnapshotReserveSize *int64) *LunCollectionGetParams {
	o.SetSpaceSnapshotReserveSize(spaceSnapshotReserveSize)
	return o
}

// SetSpaceSnapshotReserveSize adds the spaceSnapshotReserveSize to the lun collection get params
func (o *LunCollectionGetParams) SetSpaceSnapshotReserveSize(spaceSnapshotReserveSize *int64) {
	o.SpaceSnapshotReserveSize = spaceSnapshotReserveSize
}

// WithSpaceSnapshotSpaceUsedPercent adds the spaceSnapshotSpaceUsedPercent to the lun collection get params
func (o *LunCollectionGetParams) WithSpaceSnapshotSpaceUsedPercent(spaceSnapshotSpaceUsedPercent *int64) *LunCollectionGetParams {
	o.SetSpaceSnapshotSpaceUsedPercent(spaceSnapshotSpaceUsedPercent)
	return o
}

// SetSpaceSnapshotSpaceUsedPercent adds the spaceSnapshotSpaceUsedPercent to the lun collection get params
func (o *LunCollectionGetParams) SetSpaceSnapshotSpaceUsedPercent(spaceSnapshotSpaceUsedPercent *int64) {
	o.SpaceSnapshotSpaceUsedPercent = spaceSnapshotSpaceUsedPercent
}

// WithSpaceSnapshotUsed adds the spaceSnapshotUsed to the lun collection get params
func (o *LunCollectionGetParams) WithSpaceSnapshotUsed(spaceSnapshotUsed *int64) *LunCollectionGetParams {
	o.SetSpaceSnapshotUsed(spaceSnapshotUsed)
	return o
}

// SetSpaceSnapshotUsed adds the spaceSnapshotUsed to the lun collection get params
func (o *LunCollectionGetParams) SetSpaceSnapshotUsed(spaceSnapshotUsed *int64) {
	o.SpaceSnapshotUsed = spaceSnapshotUsed
}

// WithSpaceUsed adds the spaceUsed to the lun collection get params
func (o *LunCollectionGetParams) WithSpaceUsed(spaceUsed *int64) *LunCollectionGetParams {
	o.SetSpaceUsed(spaceUsed)
	return o
}

// SetSpaceUsed adds the spaceUsed to the lun collection get params
func (o *LunCollectionGetParams) SetSpaceUsed(spaceUsed *int64) {
	o.SpaceUsed = spaceUsed
}

// WithStatisticsIopsRawOther adds the statisticsIopsRawOther to the lun collection get params
func (o *LunCollectionGetParams) WithStatisticsIopsRawOther(statisticsIopsRawOther *int64) *LunCollectionGetParams {
	o.SetStatisticsIopsRawOther(statisticsIopsRawOther)
	return o
}

// SetStatisticsIopsRawOther adds the statisticsIopsRawOther to the lun collection get params
func (o *LunCollectionGetParams) SetStatisticsIopsRawOther(statisticsIopsRawOther *int64) {
	o.StatisticsIopsRawOther = statisticsIopsRawOther
}

// WithStatisticsIopsRawRead adds the statisticsIopsRawRead to the lun collection get params
func (o *LunCollectionGetParams) WithStatisticsIopsRawRead(statisticsIopsRawRead *int64) *LunCollectionGetParams {
	o.SetStatisticsIopsRawRead(statisticsIopsRawRead)
	return o
}

// SetStatisticsIopsRawRead adds the statisticsIopsRawRead to the lun collection get params
func (o *LunCollectionGetParams) SetStatisticsIopsRawRead(statisticsIopsRawRead *int64) {
	o.StatisticsIopsRawRead = statisticsIopsRawRead
}

// WithStatisticsIopsRawTotal adds the statisticsIopsRawTotal to the lun collection get params
func (o *LunCollectionGetParams) WithStatisticsIopsRawTotal(statisticsIopsRawTotal *int64) *LunCollectionGetParams {
	o.SetStatisticsIopsRawTotal(statisticsIopsRawTotal)
	return o
}

// SetStatisticsIopsRawTotal adds the statisticsIopsRawTotal to the lun collection get params
func (o *LunCollectionGetParams) SetStatisticsIopsRawTotal(statisticsIopsRawTotal *int64) {
	o.StatisticsIopsRawTotal = statisticsIopsRawTotal
}

// WithStatisticsIopsRawWrite adds the statisticsIopsRawWrite to the lun collection get params
func (o *LunCollectionGetParams) WithStatisticsIopsRawWrite(statisticsIopsRawWrite *int64) *LunCollectionGetParams {
	o.SetStatisticsIopsRawWrite(statisticsIopsRawWrite)
	return o
}

// SetStatisticsIopsRawWrite adds the statisticsIopsRawWrite to the lun collection get params
func (o *LunCollectionGetParams) SetStatisticsIopsRawWrite(statisticsIopsRawWrite *int64) {
	o.StatisticsIopsRawWrite = statisticsIopsRawWrite
}

// WithStatisticsLatencyRawOther adds the statisticsLatencyRawOther to the lun collection get params
func (o *LunCollectionGetParams) WithStatisticsLatencyRawOther(statisticsLatencyRawOther *int64) *LunCollectionGetParams {
	o.SetStatisticsLatencyRawOther(statisticsLatencyRawOther)
	return o
}

// SetStatisticsLatencyRawOther adds the statisticsLatencyRawOther to the lun collection get params
func (o *LunCollectionGetParams) SetStatisticsLatencyRawOther(statisticsLatencyRawOther *int64) {
	o.StatisticsLatencyRawOther = statisticsLatencyRawOther
}

// WithStatisticsLatencyRawRead adds the statisticsLatencyRawRead to the lun collection get params
func (o *LunCollectionGetParams) WithStatisticsLatencyRawRead(statisticsLatencyRawRead *int64) *LunCollectionGetParams {
	o.SetStatisticsLatencyRawRead(statisticsLatencyRawRead)
	return o
}

// SetStatisticsLatencyRawRead adds the statisticsLatencyRawRead to the lun collection get params
func (o *LunCollectionGetParams) SetStatisticsLatencyRawRead(statisticsLatencyRawRead *int64) {
	o.StatisticsLatencyRawRead = statisticsLatencyRawRead
}

// WithStatisticsLatencyRawTotal adds the statisticsLatencyRawTotal to the lun collection get params
func (o *LunCollectionGetParams) WithStatisticsLatencyRawTotal(statisticsLatencyRawTotal *int64) *LunCollectionGetParams {
	o.SetStatisticsLatencyRawTotal(statisticsLatencyRawTotal)
	return o
}

// SetStatisticsLatencyRawTotal adds the statisticsLatencyRawTotal to the lun collection get params
func (o *LunCollectionGetParams) SetStatisticsLatencyRawTotal(statisticsLatencyRawTotal *int64) {
	o.StatisticsLatencyRawTotal = statisticsLatencyRawTotal
}

// WithStatisticsLatencyRawWrite adds the statisticsLatencyRawWrite to the lun collection get params
func (o *LunCollectionGetParams) WithStatisticsLatencyRawWrite(statisticsLatencyRawWrite *int64) *LunCollectionGetParams {
	o.SetStatisticsLatencyRawWrite(statisticsLatencyRawWrite)
	return o
}

// SetStatisticsLatencyRawWrite adds the statisticsLatencyRawWrite to the lun collection get params
func (o *LunCollectionGetParams) SetStatisticsLatencyRawWrite(statisticsLatencyRawWrite *int64) {
	o.StatisticsLatencyRawWrite = statisticsLatencyRawWrite
}

// WithStatisticsStatus adds the statisticsStatus to the lun collection get params
func (o *LunCollectionGetParams) WithStatisticsStatus(statisticsStatus *string) *LunCollectionGetParams {
	o.SetStatisticsStatus(statisticsStatus)
	return o
}

// SetStatisticsStatus adds the statisticsStatus to the lun collection get params
func (o *LunCollectionGetParams) SetStatisticsStatus(statisticsStatus *string) {
	o.StatisticsStatus = statisticsStatus
}

// WithStatisticsThroughputRawOther adds the statisticsThroughputRawOther to the lun collection get params
func (o *LunCollectionGetParams) WithStatisticsThroughputRawOther(statisticsThroughputRawOther *int64) *LunCollectionGetParams {
	o.SetStatisticsThroughputRawOther(statisticsThroughputRawOther)
	return o
}

// SetStatisticsThroughputRawOther adds the statisticsThroughputRawOther to the lun collection get params
func (o *LunCollectionGetParams) SetStatisticsThroughputRawOther(statisticsThroughputRawOther *int64) {
	o.StatisticsThroughputRawOther = statisticsThroughputRawOther
}

// WithStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the lun collection get params
func (o *LunCollectionGetParams) WithStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) *LunCollectionGetParams {
	o.SetStatisticsThroughputRawRead(statisticsThroughputRawRead)
	return o
}

// SetStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the lun collection get params
func (o *LunCollectionGetParams) SetStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) {
	o.StatisticsThroughputRawRead = statisticsThroughputRawRead
}

// WithStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the lun collection get params
func (o *LunCollectionGetParams) WithStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) *LunCollectionGetParams {
	o.SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal)
	return o
}

// SetStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the lun collection get params
func (o *LunCollectionGetParams) SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) {
	o.StatisticsThroughputRawTotal = statisticsThroughputRawTotal
}

// WithStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the lun collection get params
func (o *LunCollectionGetParams) WithStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) *LunCollectionGetParams {
	o.SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite)
	return o
}

// SetStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the lun collection get params
func (o *LunCollectionGetParams) SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) {
	o.StatisticsThroughputRawWrite = statisticsThroughputRawWrite
}

// WithStatisticsTimestamp adds the statisticsTimestamp to the lun collection get params
func (o *LunCollectionGetParams) WithStatisticsTimestamp(statisticsTimestamp *string) *LunCollectionGetParams {
	o.SetStatisticsTimestamp(statisticsTimestamp)
	return o
}

// SetStatisticsTimestamp adds the statisticsTimestamp to the lun collection get params
func (o *LunCollectionGetParams) SetStatisticsTimestamp(statisticsTimestamp *string) {
	o.StatisticsTimestamp = statisticsTimestamp
}

// WithStatusContainerState adds the statusContainerState to the lun collection get params
func (o *LunCollectionGetParams) WithStatusContainerState(statusContainerState *string) *LunCollectionGetParams {
	o.SetStatusContainerState(statusContainerState)
	return o
}

// SetStatusContainerState adds the statusContainerState to the lun collection get params
func (o *LunCollectionGetParams) SetStatusContainerState(statusContainerState *string) {
	o.StatusContainerState = statusContainerState
}

// WithStatusMapped adds the statusMapped to the lun collection get params
func (o *LunCollectionGetParams) WithStatusMapped(statusMapped *bool) *LunCollectionGetParams {
	o.SetStatusMapped(statusMapped)
	return o
}

// SetStatusMapped adds the statusMapped to the lun collection get params
func (o *LunCollectionGetParams) SetStatusMapped(statusMapped *bool) {
	o.StatusMapped = statusMapped
}

// WithStatusReadOnly adds the statusReadOnly to the lun collection get params
func (o *LunCollectionGetParams) WithStatusReadOnly(statusReadOnly *bool) *LunCollectionGetParams {
	o.SetStatusReadOnly(statusReadOnly)
	return o
}

// SetStatusReadOnly adds the statusReadOnly to the lun collection get params
func (o *LunCollectionGetParams) SetStatusReadOnly(statusReadOnly *bool) {
	o.StatusReadOnly = statusReadOnly
}

// WithStatusState adds the statusState to the lun collection get params
func (o *LunCollectionGetParams) WithStatusState(statusState *string) *LunCollectionGetParams {
	o.SetStatusState(statusState)
	return o
}

// SetStatusState adds the statusState to the lun collection get params
func (o *LunCollectionGetParams) SetStatusState(statusState *string) {
	o.StatusState = statusState
}

// WithSvmName adds the svmName to the lun collection get params
func (o *LunCollectionGetParams) WithSvmName(svmName *string) *LunCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the lun collection get params
func (o *LunCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the lun collection get params
func (o *LunCollectionGetParams) WithSvmUUID(svmUUID *string) *LunCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the lun collection get params
func (o *LunCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the lun collection get params
func (o *LunCollectionGetParams) WithUUID(uuid *string) *LunCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the lun collection get params
func (o *LunCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVvolBindingsID adds the vvolBindingsID to the lun collection get params
func (o *LunCollectionGetParams) WithVvolBindingsID(vvolBindingsID *int64) *LunCollectionGetParams {
	o.SetVvolBindingsID(vvolBindingsID)
	return o
}

// SetVvolBindingsID adds the vvolBindingsId to the lun collection get params
func (o *LunCollectionGetParams) SetVvolBindingsID(vvolBindingsID *int64) {
	o.VvolBindingsID = vvolBindingsID
}

// WithVvolBindingsPartnerName adds the vvolBindingsPartnerName to the lun collection get params
func (o *LunCollectionGetParams) WithVvolBindingsPartnerName(vvolBindingsPartnerName *string) *LunCollectionGetParams {
	o.SetVvolBindingsPartnerName(vvolBindingsPartnerName)
	return o
}

// SetVvolBindingsPartnerName adds the vvolBindingsPartnerName to the lun collection get params
func (o *LunCollectionGetParams) SetVvolBindingsPartnerName(vvolBindingsPartnerName *string) {
	o.VvolBindingsPartnerName = vvolBindingsPartnerName
}

// WithVvolBindingsPartnerUUID adds the vvolBindingsPartnerUUID to the lun collection get params
func (o *LunCollectionGetParams) WithVvolBindingsPartnerUUID(vvolBindingsPartnerUUID *string) *LunCollectionGetParams {
	o.SetVvolBindingsPartnerUUID(vvolBindingsPartnerUUID)
	return o
}

// SetVvolBindingsPartnerUUID adds the vvolBindingsPartnerUuid to the lun collection get params
func (o *LunCollectionGetParams) SetVvolBindingsPartnerUUID(vvolBindingsPartnerUUID *string) {
	o.VvolBindingsPartnerUUID = vvolBindingsPartnerUUID
}

// WithVvolBindingsSecondaryID adds the vvolBindingsSecondaryID to the lun collection get params
func (o *LunCollectionGetParams) WithVvolBindingsSecondaryID(vvolBindingsSecondaryID *string) *LunCollectionGetParams {
	o.SetVvolBindingsSecondaryID(vvolBindingsSecondaryID)
	return o
}

// SetVvolBindingsSecondaryID adds the vvolBindingsSecondaryId to the lun collection get params
func (o *LunCollectionGetParams) SetVvolBindingsSecondaryID(vvolBindingsSecondaryID *string) {
	o.VvolBindingsSecondaryID = vvolBindingsSecondaryID
}

// WithVvolIsBound adds the vvolIsBound to the lun collection get params
func (o *LunCollectionGetParams) WithVvolIsBound(vvolIsBound *bool) *LunCollectionGetParams {
	o.SetVvolIsBound(vvolIsBound)
	return o
}

// SetVvolIsBound adds the vvolIsBound to the lun collection get params
func (o *LunCollectionGetParams) SetVvolIsBound(vvolIsBound *bool) {
	o.VvolIsBound = vvolIsBound
}

// WriteToRequest writes these params to a swagger request
func (o *LunCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AttributesName != nil {

		// query param attributes.name
		var qrAttributesName string

		if o.AttributesName != nil {
			qrAttributesName = *o.AttributesName
		}
		qAttributesName := qrAttributesName
		if qAttributesName != "" {

			if err := r.SetQueryParam("attributes.name", qAttributesName); err != nil {
				return err
			}
		}
	}

	if o.AttributesValue != nil {

		// query param attributes.value
		var qrAttributesValue string

		if o.AttributesValue != nil {
			qrAttributesValue = *o.AttributesValue
		}
		qAttributesValue := qrAttributesValue
		if qAttributesValue != "" {

			if err := r.SetQueryParam("attributes.value", qAttributesValue); err != nil {
				return err
			}
		}
	}

	if o.AutoDelete != nil {

		// query param auto_delete
		var qrAutoDelete bool

		if o.AutoDelete != nil {
			qrAutoDelete = *o.AutoDelete
		}
		qAutoDelete := swag.FormatBool(qrAutoDelete)
		if qAutoDelete != "" {

			if err := r.SetQueryParam("auto_delete", qAutoDelete); err != nil {
				return err
			}
		}
	}

	if o.Class != nil {

		// query param class
		var qrClass string

		if o.Class != nil {
			qrClass = *o.Class
		}
		qClass := qrClass
		if qClass != "" {

			if err := r.SetQueryParam("class", qClass); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ConsistencyGroupName != nil {

		// query param consistency_group.name
		var qrConsistencyGroupName string

		if o.ConsistencyGroupName != nil {
			qrConsistencyGroupName = *o.ConsistencyGroupName
		}
		qConsistencyGroupName := qrConsistencyGroupName
		if qConsistencyGroupName != "" {

			if err := r.SetQueryParam("consistency_group.name", qConsistencyGroupName); err != nil {
				return err
			}
		}
	}

	if o.ConsistencyGroupUUID != nil {

		// query param consistency_group.uuid
		var qrConsistencyGroupUUID string

		if o.ConsistencyGroupUUID != nil {
			qrConsistencyGroupUUID = *o.ConsistencyGroupUUID
		}
		qConsistencyGroupUUID := qrConsistencyGroupUUID
		if qConsistencyGroupUUID != "" {

			if err := r.SetQueryParam("consistency_group.uuid", qConsistencyGroupUUID); err != nil {
				return err
			}
		}
	}

	if o.CopyDestinationsMaxThroughput != nil {

		// query param copy.destinations.max_throughput
		var qrCopyDestinationsMaxThroughput int64

		if o.CopyDestinationsMaxThroughput != nil {
			qrCopyDestinationsMaxThroughput = *o.CopyDestinationsMaxThroughput
		}
		qCopyDestinationsMaxThroughput := swag.FormatInt64(qrCopyDestinationsMaxThroughput)
		if qCopyDestinationsMaxThroughput != "" {

			if err := r.SetQueryParam("copy.destinations.max_throughput", qCopyDestinationsMaxThroughput); err != nil {
				return err
			}
		}
	}

	if o.CopyDestinationsName != nil {

		// query param copy.destinations.name
		var qrCopyDestinationsName string

		if o.CopyDestinationsName != nil {
			qrCopyDestinationsName = *o.CopyDestinationsName
		}
		qCopyDestinationsName := qrCopyDestinationsName
		if qCopyDestinationsName != "" {

			if err := r.SetQueryParam("copy.destinations.name", qCopyDestinationsName); err != nil {
				return err
			}
		}
	}

	if o.CopyDestinationsPeerName != nil {

		// query param copy.destinations.peer.name
		var qrCopyDestinationsPeerName string

		if o.CopyDestinationsPeerName != nil {
			qrCopyDestinationsPeerName = *o.CopyDestinationsPeerName
		}
		qCopyDestinationsPeerName := qrCopyDestinationsPeerName
		if qCopyDestinationsPeerName != "" {

			if err := r.SetQueryParam("copy.destinations.peer.name", qCopyDestinationsPeerName); err != nil {
				return err
			}
		}
	}

	if o.CopyDestinationsPeerUUID != nil {

		// query param copy.destinations.peer.uuid
		var qrCopyDestinationsPeerUUID string

		if o.CopyDestinationsPeerUUID != nil {
			qrCopyDestinationsPeerUUID = *o.CopyDestinationsPeerUUID
		}
		qCopyDestinationsPeerUUID := qrCopyDestinationsPeerUUID
		if qCopyDestinationsPeerUUID != "" {

			if err := r.SetQueryParam("copy.destinations.peer.uuid", qCopyDestinationsPeerUUID); err != nil {
				return err
			}
		}
	}

	if o.CopyDestinationsProgressElapsed != nil {

		// query param copy.destinations.progress.elapsed
		var qrCopyDestinationsProgressElapsed int64

		if o.CopyDestinationsProgressElapsed != nil {
			qrCopyDestinationsProgressElapsed = *o.CopyDestinationsProgressElapsed
		}
		qCopyDestinationsProgressElapsed := swag.FormatInt64(qrCopyDestinationsProgressElapsed)
		if qCopyDestinationsProgressElapsed != "" {

			if err := r.SetQueryParam("copy.destinations.progress.elapsed", qCopyDestinationsProgressElapsed); err != nil {
				return err
			}
		}
	}

	if o.CopyDestinationsProgressFailureArgumentsCode != nil {

		// query param copy.destinations.progress.failure.arguments.code
		var qrCopyDestinationsProgressFailureArgumentsCode string

		if o.CopyDestinationsProgressFailureArgumentsCode != nil {
			qrCopyDestinationsProgressFailureArgumentsCode = *o.CopyDestinationsProgressFailureArgumentsCode
		}
		qCopyDestinationsProgressFailureArgumentsCode := qrCopyDestinationsProgressFailureArgumentsCode
		if qCopyDestinationsProgressFailureArgumentsCode != "" {

			if err := r.SetQueryParam("copy.destinations.progress.failure.arguments.code", qCopyDestinationsProgressFailureArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.CopyDestinationsProgressFailureArgumentsMessage != nil {

		// query param copy.destinations.progress.failure.arguments.message
		var qrCopyDestinationsProgressFailureArgumentsMessage string

		if o.CopyDestinationsProgressFailureArgumentsMessage != nil {
			qrCopyDestinationsProgressFailureArgumentsMessage = *o.CopyDestinationsProgressFailureArgumentsMessage
		}
		qCopyDestinationsProgressFailureArgumentsMessage := qrCopyDestinationsProgressFailureArgumentsMessage
		if qCopyDestinationsProgressFailureArgumentsMessage != "" {

			if err := r.SetQueryParam("copy.destinations.progress.failure.arguments.message", qCopyDestinationsProgressFailureArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.CopyDestinationsProgressFailureCode != nil {

		// query param copy.destinations.progress.failure.code
		var qrCopyDestinationsProgressFailureCode string

		if o.CopyDestinationsProgressFailureCode != nil {
			qrCopyDestinationsProgressFailureCode = *o.CopyDestinationsProgressFailureCode
		}
		qCopyDestinationsProgressFailureCode := qrCopyDestinationsProgressFailureCode
		if qCopyDestinationsProgressFailureCode != "" {

			if err := r.SetQueryParam("copy.destinations.progress.failure.code", qCopyDestinationsProgressFailureCode); err != nil {
				return err
			}
		}
	}

	if o.CopyDestinationsProgressFailureMessage != nil {

		// query param copy.destinations.progress.failure.message
		var qrCopyDestinationsProgressFailureMessage string

		if o.CopyDestinationsProgressFailureMessage != nil {
			qrCopyDestinationsProgressFailureMessage = *o.CopyDestinationsProgressFailureMessage
		}
		qCopyDestinationsProgressFailureMessage := qrCopyDestinationsProgressFailureMessage
		if qCopyDestinationsProgressFailureMessage != "" {

			if err := r.SetQueryParam("copy.destinations.progress.failure.message", qCopyDestinationsProgressFailureMessage); err != nil {
				return err
			}
		}
	}

	if o.CopyDestinationsProgressPercentComplete != nil {

		// query param copy.destinations.progress.percent_complete
		var qrCopyDestinationsProgressPercentComplete int64

		if o.CopyDestinationsProgressPercentComplete != nil {
			qrCopyDestinationsProgressPercentComplete = *o.CopyDestinationsProgressPercentComplete
		}
		qCopyDestinationsProgressPercentComplete := swag.FormatInt64(qrCopyDestinationsProgressPercentComplete)
		if qCopyDestinationsProgressPercentComplete != "" {

			if err := r.SetQueryParam("copy.destinations.progress.percent_complete", qCopyDestinationsProgressPercentComplete); err != nil {
				return err
			}
		}
	}

	if o.CopyDestinationsProgressState != nil {

		// query param copy.destinations.progress.state
		var qrCopyDestinationsProgressState string

		if o.CopyDestinationsProgressState != nil {
			qrCopyDestinationsProgressState = *o.CopyDestinationsProgressState
		}
		qCopyDestinationsProgressState := qrCopyDestinationsProgressState
		if qCopyDestinationsProgressState != "" {

			if err := r.SetQueryParam("copy.destinations.progress.state", qCopyDestinationsProgressState); err != nil {
				return err
			}
		}
	}

	if o.CopyDestinationsProgressVolumeSnapshotBlocked != nil {

		// query param copy.destinations.progress.volume_snapshot_blocked
		var qrCopyDestinationsProgressVolumeSnapshotBlocked bool

		if o.CopyDestinationsProgressVolumeSnapshotBlocked != nil {
			qrCopyDestinationsProgressVolumeSnapshotBlocked = *o.CopyDestinationsProgressVolumeSnapshotBlocked
		}
		qCopyDestinationsProgressVolumeSnapshotBlocked := swag.FormatBool(qrCopyDestinationsProgressVolumeSnapshotBlocked)
		if qCopyDestinationsProgressVolumeSnapshotBlocked != "" {

			if err := r.SetQueryParam("copy.destinations.progress.volume_snapshot_blocked", qCopyDestinationsProgressVolumeSnapshotBlocked); err != nil {
				return err
			}
		}
	}

	if o.CopyDestinationsUUID != nil {

		// query param copy.destinations.uuid
		var qrCopyDestinationsUUID string

		if o.CopyDestinationsUUID != nil {
			qrCopyDestinationsUUID = *o.CopyDestinationsUUID
		}
		qCopyDestinationsUUID := qrCopyDestinationsUUID
		if qCopyDestinationsUUID != "" {

			if err := r.SetQueryParam("copy.destinations.uuid", qCopyDestinationsUUID); err != nil {
				return err
			}
		}
	}

	if o.CopySourceMaxThroughput != nil {

		// query param copy.source.max_throughput
		var qrCopySourceMaxThroughput int64

		if o.CopySourceMaxThroughput != nil {
			qrCopySourceMaxThroughput = *o.CopySourceMaxThroughput
		}
		qCopySourceMaxThroughput := swag.FormatInt64(qrCopySourceMaxThroughput)
		if qCopySourceMaxThroughput != "" {

			if err := r.SetQueryParam("copy.source.max_throughput", qCopySourceMaxThroughput); err != nil {
				return err
			}
		}
	}

	if o.CopySourceName != nil {

		// query param copy.source.name
		var qrCopySourceName string

		if o.CopySourceName != nil {
			qrCopySourceName = *o.CopySourceName
		}
		qCopySourceName := qrCopySourceName
		if qCopySourceName != "" {

			if err := r.SetQueryParam("copy.source.name", qCopySourceName); err != nil {
				return err
			}
		}
	}

	if o.CopySourcePeerName != nil {

		// query param copy.source.peer.name
		var qrCopySourcePeerName string

		if o.CopySourcePeerName != nil {
			qrCopySourcePeerName = *o.CopySourcePeerName
		}
		qCopySourcePeerName := qrCopySourcePeerName
		if qCopySourcePeerName != "" {

			if err := r.SetQueryParam("copy.source.peer.name", qCopySourcePeerName); err != nil {
				return err
			}
		}
	}

	if o.CopySourcePeerUUID != nil {

		// query param copy.source.peer.uuid
		var qrCopySourcePeerUUID string

		if o.CopySourcePeerUUID != nil {
			qrCopySourcePeerUUID = *o.CopySourcePeerUUID
		}
		qCopySourcePeerUUID := qrCopySourcePeerUUID
		if qCopySourcePeerUUID != "" {

			if err := r.SetQueryParam("copy.source.peer.uuid", qCopySourcePeerUUID); err != nil {
				return err
			}
		}
	}

	if o.CopySourceProgressElapsed != nil {

		// query param copy.source.progress.elapsed
		var qrCopySourceProgressElapsed int64

		if o.CopySourceProgressElapsed != nil {
			qrCopySourceProgressElapsed = *o.CopySourceProgressElapsed
		}
		qCopySourceProgressElapsed := swag.FormatInt64(qrCopySourceProgressElapsed)
		if qCopySourceProgressElapsed != "" {

			if err := r.SetQueryParam("copy.source.progress.elapsed", qCopySourceProgressElapsed); err != nil {
				return err
			}
		}
	}

	if o.CopySourceProgressFailureArgumentsCode != nil {

		// query param copy.source.progress.failure.arguments.code
		var qrCopySourceProgressFailureArgumentsCode string

		if o.CopySourceProgressFailureArgumentsCode != nil {
			qrCopySourceProgressFailureArgumentsCode = *o.CopySourceProgressFailureArgumentsCode
		}
		qCopySourceProgressFailureArgumentsCode := qrCopySourceProgressFailureArgumentsCode
		if qCopySourceProgressFailureArgumentsCode != "" {

			if err := r.SetQueryParam("copy.source.progress.failure.arguments.code", qCopySourceProgressFailureArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.CopySourceProgressFailureArgumentsMessage != nil {

		// query param copy.source.progress.failure.arguments.message
		var qrCopySourceProgressFailureArgumentsMessage string

		if o.CopySourceProgressFailureArgumentsMessage != nil {
			qrCopySourceProgressFailureArgumentsMessage = *o.CopySourceProgressFailureArgumentsMessage
		}
		qCopySourceProgressFailureArgumentsMessage := qrCopySourceProgressFailureArgumentsMessage
		if qCopySourceProgressFailureArgumentsMessage != "" {

			if err := r.SetQueryParam("copy.source.progress.failure.arguments.message", qCopySourceProgressFailureArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.CopySourceProgressFailureCode != nil {

		// query param copy.source.progress.failure.code
		var qrCopySourceProgressFailureCode string

		if o.CopySourceProgressFailureCode != nil {
			qrCopySourceProgressFailureCode = *o.CopySourceProgressFailureCode
		}
		qCopySourceProgressFailureCode := qrCopySourceProgressFailureCode
		if qCopySourceProgressFailureCode != "" {

			if err := r.SetQueryParam("copy.source.progress.failure.code", qCopySourceProgressFailureCode); err != nil {
				return err
			}
		}
	}

	if o.CopySourceProgressFailureMessage != nil {

		// query param copy.source.progress.failure.message
		var qrCopySourceProgressFailureMessage string

		if o.CopySourceProgressFailureMessage != nil {
			qrCopySourceProgressFailureMessage = *o.CopySourceProgressFailureMessage
		}
		qCopySourceProgressFailureMessage := qrCopySourceProgressFailureMessage
		if qCopySourceProgressFailureMessage != "" {

			if err := r.SetQueryParam("copy.source.progress.failure.message", qCopySourceProgressFailureMessage); err != nil {
				return err
			}
		}
	}

	if o.CopySourceProgressPercentComplete != nil {

		// query param copy.source.progress.percent_complete
		var qrCopySourceProgressPercentComplete int64

		if o.CopySourceProgressPercentComplete != nil {
			qrCopySourceProgressPercentComplete = *o.CopySourceProgressPercentComplete
		}
		qCopySourceProgressPercentComplete := swag.FormatInt64(qrCopySourceProgressPercentComplete)
		if qCopySourceProgressPercentComplete != "" {

			if err := r.SetQueryParam("copy.source.progress.percent_complete", qCopySourceProgressPercentComplete); err != nil {
				return err
			}
		}
	}

	if o.CopySourceProgressState != nil {

		// query param copy.source.progress.state
		var qrCopySourceProgressState string

		if o.CopySourceProgressState != nil {
			qrCopySourceProgressState = *o.CopySourceProgressState
		}
		qCopySourceProgressState := qrCopySourceProgressState
		if qCopySourceProgressState != "" {

			if err := r.SetQueryParam("copy.source.progress.state", qCopySourceProgressState); err != nil {
				return err
			}
		}
	}

	if o.CopySourceProgressVolumeSnapshotBlocked != nil {

		// query param copy.source.progress.volume_snapshot_blocked
		var qrCopySourceProgressVolumeSnapshotBlocked bool

		if o.CopySourceProgressVolumeSnapshotBlocked != nil {
			qrCopySourceProgressVolumeSnapshotBlocked = *o.CopySourceProgressVolumeSnapshotBlocked
		}
		qCopySourceProgressVolumeSnapshotBlocked := swag.FormatBool(qrCopySourceProgressVolumeSnapshotBlocked)
		if qCopySourceProgressVolumeSnapshotBlocked != "" {

			if err := r.SetQueryParam("copy.source.progress.volume_snapshot_blocked", qCopySourceProgressVolumeSnapshotBlocked); err != nil {
				return err
			}
		}
	}

	if o.CopySourceUUID != nil {

		// query param copy.source.uuid
		var qrCopySourceUUID string

		if o.CopySourceUUID != nil {
			qrCopySourceUUID = *o.CopySourceUUID
		}
		qCopySourceUUID := qrCopySourceUUID
		if qCopySourceUUID != "" {

			if err := r.SetQueryParam("copy.source.uuid", qCopySourceUUID); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.EncryptionState != nil {

		// query param encryption.state
		var qrEncryptionState string

		if o.EncryptionState != nil {
			qrEncryptionState = *o.EncryptionState
		}
		qEncryptionState := qrEncryptionState
		if qEncryptionState != "" {

			if err := r.SetQueryParam("encryption.state", qEncryptionState); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.LocationLogicalUnit != nil {

		// query param location.logical_unit
		var qrLocationLogicalUnit string

		if o.LocationLogicalUnit != nil {
			qrLocationLogicalUnit = *o.LocationLogicalUnit
		}
		qLocationLogicalUnit := qrLocationLogicalUnit
		if qLocationLogicalUnit != "" {

			if err := r.SetQueryParam("location.logical_unit", qLocationLogicalUnit); err != nil {
				return err
			}
		}
	}

	if o.LocationNodeName != nil {

		// query param location.node.name
		var qrLocationNodeName string

		if o.LocationNodeName != nil {
			qrLocationNodeName = *o.LocationNodeName
		}
		qLocationNodeName := qrLocationNodeName
		if qLocationNodeName != "" {

			if err := r.SetQueryParam("location.node.name", qLocationNodeName); err != nil {
				return err
			}
		}
	}

	if o.LocationNodeUUID != nil {

		// query param location.node.uuid
		var qrLocationNodeUUID string

		if o.LocationNodeUUID != nil {
			qrLocationNodeUUID = *o.LocationNodeUUID
		}
		qLocationNodeUUID := qrLocationNodeUUID
		if qLocationNodeUUID != "" {

			if err := r.SetQueryParam("location.node.uuid", qLocationNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.LocationQtreeID != nil {

		// query param location.qtree.id
		var qrLocationQtreeID int64

		if o.LocationQtreeID != nil {
			qrLocationQtreeID = *o.LocationQtreeID
		}
		qLocationQtreeID := swag.FormatInt64(qrLocationQtreeID)
		if qLocationQtreeID != "" {

			if err := r.SetQueryParam("location.qtree.id", qLocationQtreeID); err != nil {
				return err
			}
		}
	}

	if o.LocationQtreeName != nil {

		// query param location.qtree.name
		var qrLocationQtreeName string

		if o.LocationQtreeName != nil {
			qrLocationQtreeName = *o.LocationQtreeName
		}
		qLocationQtreeName := qrLocationQtreeName
		if qLocationQtreeName != "" {

			if err := r.SetQueryParam("location.qtree.name", qLocationQtreeName); err != nil {
				return err
			}
		}
	}

	if o.LocationStorageAvailabilityZoneName != nil {

		// query param location.storage_availability_zone.name
		var qrLocationStorageAvailabilityZoneName string

		if o.LocationStorageAvailabilityZoneName != nil {
			qrLocationStorageAvailabilityZoneName = *o.LocationStorageAvailabilityZoneName
		}
		qLocationStorageAvailabilityZoneName := qrLocationStorageAvailabilityZoneName
		if qLocationStorageAvailabilityZoneName != "" {

			if err := r.SetQueryParam("location.storage_availability_zone.name", qLocationStorageAvailabilityZoneName); err != nil {
				return err
			}
		}
	}

	if o.LocationStorageAvailabilityZoneUUID != nil {

		// query param location.storage_availability_zone.uuid
		var qrLocationStorageAvailabilityZoneUUID string

		if o.LocationStorageAvailabilityZoneUUID != nil {
			qrLocationStorageAvailabilityZoneUUID = *o.LocationStorageAvailabilityZoneUUID
		}
		qLocationStorageAvailabilityZoneUUID := qrLocationStorageAvailabilityZoneUUID
		if qLocationStorageAvailabilityZoneUUID != "" {

			if err := r.SetQueryParam("location.storage_availability_zone.uuid", qLocationStorageAvailabilityZoneUUID); err != nil {
				return err
			}
		}
	}

	if o.LocationVolumeName != nil {

		// query param location.volume.name
		var qrLocationVolumeName string

		if o.LocationVolumeName != nil {
			qrLocationVolumeName = *o.LocationVolumeName
		}
		qLocationVolumeName := qrLocationVolumeName
		if qLocationVolumeName != "" {

			if err := r.SetQueryParam("location.volume.name", qLocationVolumeName); err != nil {
				return err
			}
		}
	}

	if o.LocationVolumeUUID != nil {

		// query param location.volume.uuid
		var qrLocationVolumeUUID string

		if o.LocationVolumeUUID != nil {
			qrLocationVolumeUUID = *o.LocationVolumeUUID
		}
		qLocationVolumeUUID := qrLocationVolumeUUID
		if qLocationVolumeUUID != "" {

			if err := r.SetQueryParam("location.volume.uuid", qLocationVolumeUUID); err != nil {
				return err
			}
		}
	}

	if o.LunMapsIgroupComment != nil {

		// query param lun_maps.igroup.comment
		var qrLunMapsIgroupComment string

		if o.LunMapsIgroupComment != nil {
			qrLunMapsIgroupComment = *o.LunMapsIgroupComment
		}
		qLunMapsIgroupComment := qrLunMapsIgroupComment
		if qLunMapsIgroupComment != "" {

			if err := r.SetQueryParam("lun_maps.igroup.comment", qLunMapsIgroupComment); err != nil {
				return err
			}
		}
	}

	if o.LunMapsIgroupIgroupsName != nil {

		// query param lun_maps.igroup.igroups.name
		var qrLunMapsIgroupIgroupsName string

		if o.LunMapsIgroupIgroupsName != nil {
			qrLunMapsIgroupIgroupsName = *o.LunMapsIgroupIgroupsName
		}
		qLunMapsIgroupIgroupsName := qrLunMapsIgroupIgroupsName
		if qLunMapsIgroupIgroupsName != "" {

			if err := r.SetQueryParam("lun_maps.igroup.igroups.name", qLunMapsIgroupIgroupsName); err != nil {
				return err
			}
		}
	}

	if o.LunMapsIgroupIgroupsUUID != nil {

		// query param lun_maps.igroup.igroups.uuid
		var qrLunMapsIgroupIgroupsUUID string

		if o.LunMapsIgroupIgroupsUUID != nil {
			qrLunMapsIgroupIgroupsUUID = *o.LunMapsIgroupIgroupsUUID
		}
		qLunMapsIgroupIgroupsUUID := qrLunMapsIgroupIgroupsUUID
		if qLunMapsIgroupIgroupsUUID != "" {

			if err := r.SetQueryParam("lun_maps.igroup.igroups.uuid", qLunMapsIgroupIgroupsUUID); err != nil {
				return err
			}
		}
	}

	if o.LunMapsIgroupInitiatorsComment != nil {

		// query param lun_maps.igroup.initiators.comment
		var qrLunMapsIgroupInitiatorsComment string

		if o.LunMapsIgroupInitiatorsComment != nil {
			qrLunMapsIgroupInitiatorsComment = *o.LunMapsIgroupInitiatorsComment
		}
		qLunMapsIgroupInitiatorsComment := qrLunMapsIgroupInitiatorsComment
		if qLunMapsIgroupInitiatorsComment != "" {

			if err := r.SetQueryParam("lun_maps.igroup.initiators.comment", qLunMapsIgroupInitiatorsComment); err != nil {
				return err
			}
		}
	}

	if o.LunMapsIgroupInitiatorsName != nil {

		// query param lun_maps.igroup.initiators.name
		var qrLunMapsIgroupInitiatorsName string

		if o.LunMapsIgroupInitiatorsName != nil {
			qrLunMapsIgroupInitiatorsName = *o.LunMapsIgroupInitiatorsName
		}
		qLunMapsIgroupInitiatorsName := qrLunMapsIgroupInitiatorsName
		if qLunMapsIgroupInitiatorsName != "" {

			if err := r.SetQueryParam("lun_maps.igroup.initiators.name", qLunMapsIgroupInitiatorsName); err != nil {
				return err
			}
		}
	}

	if o.LunMapsIgroupName != nil {

		// query param lun_maps.igroup.name
		var qrLunMapsIgroupName string

		if o.LunMapsIgroupName != nil {
			qrLunMapsIgroupName = *o.LunMapsIgroupName
		}
		qLunMapsIgroupName := qrLunMapsIgroupName
		if qLunMapsIgroupName != "" {

			if err := r.SetQueryParam("lun_maps.igroup.name", qLunMapsIgroupName); err != nil {
				return err
			}
		}
	}

	if o.LunMapsIgroupOsType != nil {

		// query param lun_maps.igroup.os_type
		var qrLunMapsIgroupOsType string

		if o.LunMapsIgroupOsType != nil {
			qrLunMapsIgroupOsType = *o.LunMapsIgroupOsType
		}
		qLunMapsIgroupOsType := qrLunMapsIgroupOsType
		if qLunMapsIgroupOsType != "" {

			if err := r.SetQueryParam("lun_maps.igroup.os_type", qLunMapsIgroupOsType); err != nil {
				return err
			}
		}
	}

	if o.LunMapsIgroupProtocol != nil {

		// query param lun_maps.igroup.protocol
		var qrLunMapsIgroupProtocol string

		if o.LunMapsIgroupProtocol != nil {
			qrLunMapsIgroupProtocol = *o.LunMapsIgroupProtocol
		}
		qLunMapsIgroupProtocol := qrLunMapsIgroupProtocol
		if qLunMapsIgroupProtocol != "" {

			if err := r.SetQueryParam("lun_maps.igroup.protocol", qLunMapsIgroupProtocol); err != nil {
				return err
			}
		}
	}

	if o.LunMapsIgroupUUID != nil {

		// query param lun_maps.igroup.uuid
		var qrLunMapsIgroupUUID string

		if o.LunMapsIgroupUUID != nil {
			qrLunMapsIgroupUUID = *o.LunMapsIgroupUUID
		}
		qLunMapsIgroupUUID := qrLunMapsIgroupUUID
		if qLunMapsIgroupUUID != "" {

			if err := r.SetQueryParam("lun_maps.igroup.uuid", qLunMapsIgroupUUID); err != nil {
				return err
			}
		}
	}

	if o.LunMapsLogicalUnitNumber != nil {

		// query param lun_maps.logical_unit_number
		var qrLunMapsLogicalUnitNumber int64

		if o.LunMapsLogicalUnitNumber != nil {
			qrLunMapsLogicalUnitNumber = *o.LunMapsLogicalUnitNumber
		}
		qLunMapsLogicalUnitNumber := swag.FormatInt64(qrLunMapsLogicalUnitNumber)
		if qLunMapsLogicalUnitNumber != "" {

			if err := r.SetQueryParam("lun_maps.logical_unit_number", qLunMapsLogicalUnitNumber); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.MetricDuration != nil {

		// query param metric.duration
		var qrMetricDuration string

		if o.MetricDuration != nil {
			qrMetricDuration = *o.MetricDuration
		}
		qMetricDuration := qrMetricDuration
		if qMetricDuration != "" {

			if err := r.SetQueryParam("metric.duration", qMetricDuration); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsOther != nil {

		// query param metric.iops.other
		var qrMetricIopsOther int64

		if o.MetricIopsOther != nil {
			qrMetricIopsOther = *o.MetricIopsOther
		}
		qMetricIopsOther := swag.FormatInt64(qrMetricIopsOther)
		if qMetricIopsOther != "" {

			if err := r.SetQueryParam("metric.iops.other", qMetricIopsOther); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsRead != nil {

		// query param metric.iops.read
		var qrMetricIopsRead int64

		if o.MetricIopsRead != nil {
			qrMetricIopsRead = *o.MetricIopsRead
		}
		qMetricIopsRead := swag.FormatInt64(qrMetricIopsRead)
		if qMetricIopsRead != "" {

			if err := r.SetQueryParam("metric.iops.read", qMetricIopsRead); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsTotal != nil {

		// query param metric.iops.total
		var qrMetricIopsTotal int64

		if o.MetricIopsTotal != nil {
			qrMetricIopsTotal = *o.MetricIopsTotal
		}
		qMetricIopsTotal := swag.FormatInt64(qrMetricIopsTotal)
		if qMetricIopsTotal != "" {

			if err := r.SetQueryParam("metric.iops.total", qMetricIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsWrite != nil {

		// query param metric.iops.write
		var qrMetricIopsWrite int64

		if o.MetricIopsWrite != nil {
			qrMetricIopsWrite = *o.MetricIopsWrite
		}
		qMetricIopsWrite := swag.FormatInt64(qrMetricIopsWrite)
		if qMetricIopsWrite != "" {

			if err := r.SetQueryParam("metric.iops.write", qMetricIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyOther != nil {

		// query param metric.latency.other
		var qrMetricLatencyOther int64

		if o.MetricLatencyOther != nil {
			qrMetricLatencyOther = *o.MetricLatencyOther
		}
		qMetricLatencyOther := swag.FormatInt64(qrMetricLatencyOther)
		if qMetricLatencyOther != "" {

			if err := r.SetQueryParam("metric.latency.other", qMetricLatencyOther); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyRead != nil {

		// query param metric.latency.read
		var qrMetricLatencyRead int64

		if o.MetricLatencyRead != nil {
			qrMetricLatencyRead = *o.MetricLatencyRead
		}
		qMetricLatencyRead := swag.FormatInt64(qrMetricLatencyRead)
		if qMetricLatencyRead != "" {

			if err := r.SetQueryParam("metric.latency.read", qMetricLatencyRead); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyTotal != nil {

		// query param metric.latency.total
		var qrMetricLatencyTotal int64

		if o.MetricLatencyTotal != nil {
			qrMetricLatencyTotal = *o.MetricLatencyTotal
		}
		qMetricLatencyTotal := swag.FormatInt64(qrMetricLatencyTotal)
		if qMetricLatencyTotal != "" {

			if err := r.SetQueryParam("metric.latency.total", qMetricLatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyWrite != nil {

		// query param metric.latency.write
		var qrMetricLatencyWrite int64

		if o.MetricLatencyWrite != nil {
			qrMetricLatencyWrite = *o.MetricLatencyWrite
		}
		qMetricLatencyWrite := swag.FormatInt64(qrMetricLatencyWrite)
		if qMetricLatencyWrite != "" {

			if err := r.SetQueryParam("metric.latency.write", qMetricLatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricStatus != nil {

		// query param metric.status
		var qrMetricStatus string

		if o.MetricStatus != nil {
			qrMetricStatus = *o.MetricStatus
		}
		qMetricStatus := qrMetricStatus
		if qMetricStatus != "" {

			if err := r.SetQueryParam("metric.status", qMetricStatus); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputOther != nil {

		// query param metric.throughput.other
		var qrMetricThroughputOther int64

		if o.MetricThroughputOther != nil {
			qrMetricThroughputOther = *o.MetricThroughputOther
		}
		qMetricThroughputOther := swag.FormatInt64(qrMetricThroughputOther)
		if qMetricThroughputOther != "" {

			if err := r.SetQueryParam("metric.throughput.other", qMetricThroughputOther); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputRead != nil {

		// query param metric.throughput.read
		var qrMetricThroughputRead int64

		if o.MetricThroughputRead != nil {
			qrMetricThroughputRead = *o.MetricThroughputRead
		}
		qMetricThroughputRead := swag.FormatInt64(qrMetricThroughputRead)
		if qMetricThroughputRead != "" {

			if err := r.SetQueryParam("metric.throughput.read", qMetricThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputTotal != nil {

		// query param metric.throughput.total
		var qrMetricThroughputTotal int64

		if o.MetricThroughputTotal != nil {
			qrMetricThroughputTotal = *o.MetricThroughputTotal
		}
		qMetricThroughputTotal := swag.FormatInt64(qrMetricThroughputTotal)
		if qMetricThroughputTotal != "" {

			if err := r.SetQueryParam("metric.throughput.total", qMetricThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputWrite != nil {

		// query param metric.throughput.write
		var qrMetricThroughputWrite int64

		if o.MetricThroughputWrite != nil {
			qrMetricThroughputWrite = *o.MetricThroughputWrite
		}
		qMetricThroughputWrite := swag.FormatInt64(qrMetricThroughputWrite)
		if qMetricThroughputWrite != "" {

			if err := r.SetQueryParam("metric.throughput.write", qMetricThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricTimestamp != nil {

		// query param metric.timestamp
		var qrMetricTimestamp string

		if o.MetricTimestamp != nil {
			qrMetricTimestamp = *o.MetricTimestamp
		}
		qMetricTimestamp := qrMetricTimestamp
		if qMetricTimestamp != "" {

			if err := r.SetQueryParam("metric.timestamp", qMetricTimestamp); err != nil {
				return err
			}
		}
	}

	if o.MovementMaxThroughput != nil {

		// query param movement.max_throughput
		var qrMovementMaxThroughput int64

		if o.MovementMaxThroughput != nil {
			qrMovementMaxThroughput = *o.MovementMaxThroughput
		}
		qMovementMaxThroughput := swag.FormatInt64(qrMovementMaxThroughput)
		if qMovementMaxThroughput != "" {

			if err := r.SetQueryParam("movement.max_throughput", qMovementMaxThroughput); err != nil {
				return err
			}
		}
	}

	if o.MovementPathsDestination != nil {

		// query param movement.paths.destination
		var qrMovementPathsDestination string

		if o.MovementPathsDestination != nil {
			qrMovementPathsDestination = *o.MovementPathsDestination
		}
		qMovementPathsDestination := qrMovementPathsDestination
		if qMovementPathsDestination != "" {

			if err := r.SetQueryParam("movement.paths.destination", qMovementPathsDestination); err != nil {
				return err
			}
		}
	}

	if o.MovementPathsSource != nil {

		// query param movement.paths.source
		var qrMovementPathsSource string

		if o.MovementPathsSource != nil {
			qrMovementPathsSource = *o.MovementPathsSource
		}
		qMovementPathsSource := qrMovementPathsSource
		if qMovementPathsSource != "" {

			if err := r.SetQueryParam("movement.paths.source", qMovementPathsSource); err != nil {
				return err
			}
		}
	}

	if o.MovementProgressElapsed != nil {

		// query param movement.progress.elapsed
		var qrMovementProgressElapsed int64

		if o.MovementProgressElapsed != nil {
			qrMovementProgressElapsed = *o.MovementProgressElapsed
		}
		qMovementProgressElapsed := swag.FormatInt64(qrMovementProgressElapsed)
		if qMovementProgressElapsed != "" {

			if err := r.SetQueryParam("movement.progress.elapsed", qMovementProgressElapsed); err != nil {
				return err
			}
		}
	}

	if o.MovementProgressFailureArgumentsCode != nil {

		// query param movement.progress.failure.arguments.code
		var qrMovementProgressFailureArgumentsCode string

		if o.MovementProgressFailureArgumentsCode != nil {
			qrMovementProgressFailureArgumentsCode = *o.MovementProgressFailureArgumentsCode
		}
		qMovementProgressFailureArgumentsCode := qrMovementProgressFailureArgumentsCode
		if qMovementProgressFailureArgumentsCode != "" {

			if err := r.SetQueryParam("movement.progress.failure.arguments.code", qMovementProgressFailureArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.MovementProgressFailureArgumentsMessage != nil {

		// query param movement.progress.failure.arguments.message
		var qrMovementProgressFailureArgumentsMessage string

		if o.MovementProgressFailureArgumentsMessage != nil {
			qrMovementProgressFailureArgumentsMessage = *o.MovementProgressFailureArgumentsMessage
		}
		qMovementProgressFailureArgumentsMessage := qrMovementProgressFailureArgumentsMessage
		if qMovementProgressFailureArgumentsMessage != "" {

			if err := r.SetQueryParam("movement.progress.failure.arguments.message", qMovementProgressFailureArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.MovementProgressFailureCode != nil {

		// query param movement.progress.failure.code
		var qrMovementProgressFailureCode string

		if o.MovementProgressFailureCode != nil {
			qrMovementProgressFailureCode = *o.MovementProgressFailureCode
		}
		qMovementProgressFailureCode := qrMovementProgressFailureCode
		if qMovementProgressFailureCode != "" {

			if err := r.SetQueryParam("movement.progress.failure.code", qMovementProgressFailureCode); err != nil {
				return err
			}
		}
	}

	if o.MovementProgressFailureMessage != nil {

		// query param movement.progress.failure.message
		var qrMovementProgressFailureMessage string

		if o.MovementProgressFailureMessage != nil {
			qrMovementProgressFailureMessage = *o.MovementProgressFailureMessage
		}
		qMovementProgressFailureMessage := qrMovementProgressFailureMessage
		if qMovementProgressFailureMessage != "" {

			if err := r.SetQueryParam("movement.progress.failure.message", qMovementProgressFailureMessage); err != nil {
				return err
			}
		}
	}

	if o.MovementProgressPercentComplete != nil {

		// query param movement.progress.percent_complete
		var qrMovementProgressPercentComplete int64

		if o.MovementProgressPercentComplete != nil {
			qrMovementProgressPercentComplete = *o.MovementProgressPercentComplete
		}
		qMovementProgressPercentComplete := swag.FormatInt64(qrMovementProgressPercentComplete)
		if qMovementProgressPercentComplete != "" {

			if err := r.SetQueryParam("movement.progress.percent_complete", qMovementProgressPercentComplete); err != nil {
				return err
			}
		}
	}

	if o.MovementProgressState != nil {

		// query param movement.progress.state
		var qrMovementProgressState string

		if o.MovementProgressState != nil {
			qrMovementProgressState = *o.MovementProgressState
		}
		qMovementProgressState := qrMovementProgressState
		if qMovementProgressState != "" {

			if err := r.SetQueryParam("movement.progress.state", qMovementProgressState); err != nil {
				return err
			}
		}
	}

	if o.MovementProgressVolumeSnapshotBlocked != nil {

		// query param movement.progress.volume_snapshot_blocked
		var qrMovementProgressVolumeSnapshotBlocked bool

		if o.MovementProgressVolumeSnapshotBlocked != nil {
			qrMovementProgressVolumeSnapshotBlocked = *o.MovementProgressVolumeSnapshotBlocked
		}
		qMovementProgressVolumeSnapshotBlocked := swag.FormatBool(qrMovementProgressVolumeSnapshotBlocked)
		if qMovementProgressVolumeSnapshotBlocked != "" {

			if err := r.SetQueryParam("movement.progress.volume_snapshot_blocked", qMovementProgressVolumeSnapshotBlocked); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.OsType != nil {

		// query param os_type
		var qrOsType string

		if o.OsType != nil {
			qrOsType = *o.OsType
		}
		qOsType := qrOsType
		if qOsType != "" {

			if err := r.SetQueryParam("os_type", qOsType); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyName != nil {

		// query param qos_policy.name
		var qrQosPolicyName string

		if o.QosPolicyName != nil {
			qrQosPolicyName = *o.QosPolicyName
		}
		qQosPolicyName := qrQosPolicyName
		if qQosPolicyName != "" {

			if err := r.SetQueryParam("qos_policy.name", qQosPolicyName); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyUUID != nil {

		// query param qos_policy.uuid
		var qrQosPolicyUUID string

		if o.QosPolicyUUID != nil {
			qrQosPolicyUUID = *o.QosPolicyUUID
		}
		qQosPolicyUUID := qrQosPolicyUUID
		if qQosPolicyUUID != "" {

			if err := r.SetQueryParam("qos_policy.uuid", qQosPolicyUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialNumber != nil {

		// query param serial_number
		var qrSerialNumber string

		if o.SerialNumber != nil {
			qrSerialNumber = *o.SerialNumber
		}
		qSerialNumber := qrSerialNumber
		if qSerialNumber != "" {

			if err := r.SetQueryParam("serial_number", qSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.SerialNumberHex != nil {

		// query param serial_number_hex
		var qrSerialNumberHex string

		if o.SerialNumberHex != nil {
			qrSerialNumberHex = *o.SerialNumberHex
		}
		qSerialNumberHex := qrSerialNumberHex
		if qSerialNumberHex != "" {

			if err := r.SetQueryParam("serial_number_hex", qSerialNumberHex); err != nil {
				return err
			}
		}
	}

	if o.SpaceEfficiencyRatio != nil {

		// query param space.efficiency_ratio
		var qrSpaceEfficiencyRatio float64

		if o.SpaceEfficiencyRatio != nil {
			qrSpaceEfficiencyRatio = *o.SpaceEfficiencyRatio
		}
		qSpaceEfficiencyRatio := swag.FormatFloat64(qrSpaceEfficiencyRatio)
		if qSpaceEfficiencyRatio != "" {

			if err := r.SetQueryParam("space.efficiency_ratio", qSpaceEfficiencyRatio); err != nil {
				return err
			}
		}
	}

	if o.SpaceGuaranteeRequested != nil {

		// query param space.guarantee.requested
		var qrSpaceGuaranteeRequested bool

		if o.SpaceGuaranteeRequested != nil {
			qrSpaceGuaranteeRequested = *o.SpaceGuaranteeRequested
		}
		qSpaceGuaranteeRequested := swag.FormatBool(qrSpaceGuaranteeRequested)
		if qSpaceGuaranteeRequested != "" {

			if err := r.SetQueryParam("space.guarantee.requested", qSpaceGuaranteeRequested); err != nil {
				return err
			}
		}
	}

	if o.SpaceGuaranteeReserved != nil {

		// query param space.guarantee.reserved
		var qrSpaceGuaranteeReserved bool

		if o.SpaceGuaranteeReserved != nil {
			qrSpaceGuaranteeReserved = *o.SpaceGuaranteeReserved
		}
		qSpaceGuaranteeReserved := swag.FormatBool(qrSpaceGuaranteeReserved)
		if qSpaceGuaranteeReserved != "" {

			if err := r.SetQueryParam("space.guarantee.reserved", qSpaceGuaranteeReserved); err != nil {
				return err
			}
		}
	}

	if o.SpacePhysicalUsed != nil {

		// query param space.physical_used
		var qrSpacePhysicalUsed int64

		if o.SpacePhysicalUsed != nil {
			qrSpacePhysicalUsed = *o.SpacePhysicalUsed
		}
		qSpacePhysicalUsed := swag.FormatInt64(qrSpacePhysicalUsed)
		if qSpacePhysicalUsed != "" {

			if err := r.SetQueryParam("space.physical_used", qSpacePhysicalUsed); err != nil {
				return err
			}
		}
	}

	if o.SpacePhysicalUsedBySnapshots != nil {

		// query param space.physical_used_by_snapshots
		var qrSpacePhysicalUsedBySnapshots int64

		if o.SpacePhysicalUsedBySnapshots != nil {
			qrSpacePhysicalUsedBySnapshots = *o.SpacePhysicalUsedBySnapshots
		}
		qSpacePhysicalUsedBySnapshots := swag.FormatInt64(qrSpacePhysicalUsedBySnapshots)
		if qSpacePhysicalUsedBySnapshots != "" {

			if err := r.SetQueryParam("space.physical_used_by_snapshots", qSpacePhysicalUsedBySnapshots); err != nil {
				return err
			}
		}
	}

	if o.SpaceScsiThinProvisioningSupportEnabled != nil {

		// query param space.scsi_thin_provisioning_support_enabled
		var qrSpaceScsiThinProvisioningSupportEnabled bool

		if o.SpaceScsiThinProvisioningSupportEnabled != nil {
			qrSpaceScsiThinProvisioningSupportEnabled = *o.SpaceScsiThinProvisioningSupportEnabled
		}
		qSpaceScsiThinProvisioningSupportEnabled := swag.FormatBool(qrSpaceScsiThinProvisioningSupportEnabled)
		if qSpaceScsiThinProvisioningSupportEnabled != "" {

			if err := r.SetQueryParam("space.scsi_thin_provisioning_support_enabled", qSpaceScsiThinProvisioningSupportEnabled); err != nil {
				return err
			}
		}
	}

	if o.SpaceSize != nil {

		// query param space.size
		var qrSpaceSize int64

		if o.SpaceSize != nil {
			qrSpaceSize = *o.SpaceSize
		}
		qSpaceSize := swag.FormatInt64(qrSpaceSize)
		if qSpaceSize != "" {

			if err := r.SetQueryParam("space.size", qSpaceSize); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotAutodeleteEnabled != nil {

		// query param space.snapshot.autodelete.enabled
		var qrSpaceSnapshotAutodeleteEnabled bool

		if o.SpaceSnapshotAutodeleteEnabled != nil {
			qrSpaceSnapshotAutodeleteEnabled = *o.SpaceSnapshotAutodeleteEnabled
		}
		qSpaceSnapshotAutodeleteEnabled := swag.FormatBool(qrSpaceSnapshotAutodeleteEnabled)
		if qSpaceSnapshotAutodeleteEnabled != "" {

			if err := r.SetQueryParam("space.snapshot.autodelete.enabled", qSpaceSnapshotAutodeleteEnabled); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotReserveAvailable != nil {

		// query param space.snapshot.reserve_available
		var qrSpaceSnapshotReserveAvailable int64

		if o.SpaceSnapshotReserveAvailable != nil {
			qrSpaceSnapshotReserveAvailable = *o.SpaceSnapshotReserveAvailable
		}
		qSpaceSnapshotReserveAvailable := swag.FormatInt64(qrSpaceSnapshotReserveAvailable)
		if qSpaceSnapshotReserveAvailable != "" {

			if err := r.SetQueryParam("space.snapshot.reserve_available", qSpaceSnapshotReserveAvailable); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotReservePercent != nil {

		// query param space.snapshot.reserve_percent
		var qrSpaceSnapshotReservePercent int64

		if o.SpaceSnapshotReservePercent != nil {
			qrSpaceSnapshotReservePercent = *o.SpaceSnapshotReservePercent
		}
		qSpaceSnapshotReservePercent := swag.FormatInt64(qrSpaceSnapshotReservePercent)
		if qSpaceSnapshotReservePercent != "" {

			if err := r.SetQueryParam("space.snapshot.reserve_percent", qSpaceSnapshotReservePercent); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotReserveSize != nil {

		// query param space.snapshot.reserve_size
		var qrSpaceSnapshotReserveSize int64

		if o.SpaceSnapshotReserveSize != nil {
			qrSpaceSnapshotReserveSize = *o.SpaceSnapshotReserveSize
		}
		qSpaceSnapshotReserveSize := swag.FormatInt64(qrSpaceSnapshotReserveSize)
		if qSpaceSnapshotReserveSize != "" {

			if err := r.SetQueryParam("space.snapshot.reserve_size", qSpaceSnapshotReserveSize); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotSpaceUsedPercent != nil {

		// query param space.snapshot.space_used_percent
		var qrSpaceSnapshotSpaceUsedPercent int64

		if o.SpaceSnapshotSpaceUsedPercent != nil {
			qrSpaceSnapshotSpaceUsedPercent = *o.SpaceSnapshotSpaceUsedPercent
		}
		qSpaceSnapshotSpaceUsedPercent := swag.FormatInt64(qrSpaceSnapshotSpaceUsedPercent)
		if qSpaceSnapshotSpaceUsedPercent != "" {

			if err := r.SetQueryParam("space.snapshot.space_used_percent", qSpaceSnapshotSpaceUsedPercent); err != nil {
				return err
			}
		}
	}

	if o.SpaceSnapshotUsed != nil {

		// query param space.snapshot.used
		var qrSpaceSnapshotUsed int64

		if o.SpaceSnapshotUsed != nil {
			qrSpaceSnapshotUsed = *o.SpaceSnapshotUsed
		}
		qSpaceSnapshotUsed := swag.FormatInt64(qrSpaceSnapshotUsed)
		if qSpaceSnapshotUsed != "" {

			if err := r.SetQueryParam("space.snapshot.used", qSpaceSnapshotUsed); err != nil {
				return err
			}
		}
	}

	if o.SpaceUsed != nil {

		// query param space.used
		var qrSpaceUsed int64

		if o.SpaceUsed != nil {
			qrSpaceUsed = *o.SpaceUsed
		}
		qSpaceUsed := swag.FormatInt64(qrSpaceUsed)
		if qSpaceUsed != "" {

			if err := r.SetQueryParam("space.used", qSpaceUsed); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawOther != nil {

		// query param statistics.iops_raw.other
		var qrStatisticsIopsRawOther int64

		if o.StatisticsIopsRawOther != nil {
			qrStatisticsIopsRawOther = *o.StatisticsIopsRawOther
		}
		qStatisticsIopsRawOther := swag.FormatInt64(qrStatisticsIopsRawOther)
		if qStatisticsIopsRawOther != "" {

			if err := r.SetQueryParam("statistics.iops_raw.other", qStatisticsIopsRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawRead != nil {

		// query param statistics.iops_raw.read
		var qrStatisticsIopsRawRead int64

		if o.StatisticsIopsRawRead != nil {
			qrStatisticsIopsRawRead = *o.StatisticsIopsRawRead
		}
		qStatisticsIopsRawRead := swag.FormatInt64(qrStatisticsIopsRawRead)
		if qStatisticsIopsRawRead != "" {

			if err := r.SetQueryParam("statistics.iops_raw.read", qStatisticsIopsRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawTotal != nil {

		// query param statistics.iops_raw.total
		var qrStatisticsIopsRawTotal int64

		if o.StatisticsIopsRawTotal != nil {
			qrStatisticsIopsRawTotal = *o.StatisticsIopsRawTotal
		}
		qStatisticsIopsRawTotal := swag.FormatInt64(qrStatisticsIopsRawTotal)
		if qStatisticsIopsRawTotal != "" {

			if err := r.SetQueryParam("statistics.iops_raw.total", qStatisticsIopsRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawWrite != nil {

		// query param statistics.iops_raw.write
		var qrStatisticsIopsRawWrite int64

		if o.StatisticsIopsRawWrite != nil {
			qrStatisticsIopsRawWrite = *o.StatisticsIopsRawWrite
		}
		qStatisticsIopsRawWrite := swag.FormatInt64(qrStatisticsIopsRawWrite)
		if qStatisticsIopsRawWrite != "" {

			if err := r.SetQueryParam("statistics.iops_raw.write", qStatisticsIopsRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawOther != nil {

		// query param statistics.latency_raw.other
		var qrStatisticsLatencyRawOther int64

		if o.StatisticsLatencyRawOther != nil {
			qrStatisticsLatencyRawOther = *o.StatisticsLatencyRawOther
		}
		qStatisticsLatencyRawOther := swag.FormatInt64(qrStatisticsLatencyRawOther)
		if qStatisticsLatencyRawOther != "" {

			if err := r.SetQueryParam("statistics.latency_raw.other", qStatisticsLatencyRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawRead != nil {

		// query param statistics.latency_raw.read
		var qrStatisticsLatencyRawRead int64

		if o.StatisticsLatencyRawRead != nil {
			qrStatisticsLatencyRawRead = *o.StatisticsLatencyRawRead
		}
		qStatisticsLatencyRawRead := swag.FormatInt64(qrStatisticsLatencyRawRead)
		if qStatisticsLatencyRawRead != "" {

			if err := r.SetQueryParam("statistics.latency_raw.read", qStatisticsLatencyRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawTotal != nil {

		// query param statistics.latency_raw.total
		var qrStatisticsLatencyRawTotal int64

		if o.StatisticsLatencyRawTotal != nil {
			qrStatisticsLatencyRawTotal = *o.StatisticsLatencyRawTotal
		}
		qStatisticsLatencyRawTotal := swag.FormatInt64(qrStatisticsLatencyRawTotal)
		if qStatisticsLatencyRawTotal != "" {

			if err := r.SetQueryParam("statistics.latency_raw.total", qStatisticsLatencyRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawWrite != nil {

		// query param statistics.latency_raw.write
		var qrStatisticsLatencyRawWrite int64

		if o.StatisticsLatencyRawWrite != nil {
			qrStatisticsLatencyRawWrite = *o.StatisticsLatencyRawWrite
		}
		qStatisticsLatencyRawWrite := swag.FormatInt64(qrStatisticsLatencyRawWrite)
		if qStatisticsLatencyRawWrite != "" {

			if err := r.SetQueryParam("statistics.latency_raw.write", qStatisticsLatencyRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsStatus != nil {

		// query param statistics.status
		var qrStatisticsStatus string

		if o.StatisticsStatus != nil {
			qrStatisticsStatus = *o.StatisticsStatus
		}
		qStatisticsStatus := qrStatisticsStatus
		if qStatisticsStatus != "" {

			if err := r.SetQueryParam("statistics.status", qStatisticsStatus); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawOther != nil {

		// query param statistics.throughput_raw.other
		var qrStatisticsThroughputRawOther int64

		if o.StatisticsThroughputRawOther != nil {
			qrStatisticsThroughputRawOther = *o.StatisticsThroughputRawOther
		}
		qStatisticsThroughputRawOther := swag.FormatInt64(qrStatisticsThroughputRawOther)
		if qStatisticsThroughputRawOther != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.other", qStatisticsThroughputRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawRead != nil {

		// query param statistics.throughput_raw.read
		var qrStatisticsThroughputRawRead int64

		if o.StatisticsThroughputRawRead != nil {
			qrStatisticsThroughputRawRead = *o.StatisticsThroughputRawRead
		}
		qStatisticsThroughputRawRead := swag.FormatInt64(qrStatisticsThroughputRawRead)
		if qStatisticsThroughputRawRead != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.read", qStatisticsThroughputRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawTotal != nil {

		// query param statistics.throughput_raw.total
		var qrStatisticsThroughputRawTotal int64

		if o.StatisticsThroughputRawTotal != nil {
			qrStatisticsThroughputRawTotal = *o.StatisticsThroughputRawTotal
		}
		qStatisticsThroughputRawTotal := swag.FormatInt64(qrStatisticsThroughputRawTotal)
		if qStatisticsThroughputRawTotal != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.total", qStatisticsThroughputRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawWrite != nil {

		// query param statistics.throughput_raw.write
		var qrStatisticsThroughputRawWrite int64

		if o.StatisticsThroughputRawWrite != nil {
			qrStatisticsThroughputRawWrite = *o.StatisticsThroughputRawWrite
		}
		qStatisticsThroughputRawWrite := swag.FormatInt64(qrStatisticsThroughputRawWrite)
		if qStatisticsThroughputRawWrite != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.write", qStatisticsThroughputRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsTimestamp != nil {

		// query param statistics.timestamp
		var qrStatisticsTimestamp string

		if o.StatisticsTimestamp != nil {
			qrStatisticsTimestamp = *o.StatisticsTimestamp
		}
		qStatisticsTimestamp := qrStatisticsTimestamp
		if qStatisticsTimestamp != "" {

			if err := r.SetQueryParam("statistics.timestamp", qStatisticsTimestamp); err != nil {
				return err
			}
		}
	}

	if o.StatusContainerState != nil {

		// query param status.container_state
		var qrStatusContainerState string

		if o.StatusContainerState != nil {
			qrStatusContainerState = *o.StatusContainerState
		}
		qStatusContainerState := qrStatusContainerState
		if qStatusContainerState != "" {

			if err := r.SetQueryParam("status.container_state", qStatusContainerState); err != nil {
				return err
			}
		}
	}

	if o.StatusMapped != nil {

		// query param status.mapped
		var qrStatusMapped bool

		if o.StatusMapped != nil {
			qrStatusMapped = *o.StatusMapped
		}
		qStatusMapped := swag.FormatBool(qrStatusMapped)
		if qStatusMapped != "" {

			if err := r.SetQueryParam("status.mapped", qStatusMapped); err != nil {
				return err
			}
		}
	}

	if o.StatusReadOnly != nil {

		// query param status.read_only
		var qrStatusReadOnly bool

		if o.StatusReadOnly != nil {
			qrStatusReadOnly = *o.StatusReadOnly
		}
		qStatusReadOnly := swag.FormatBool(qrStatusReadOnly)
		if qStatusReadOnly != "" {

			if err := r.SetQueryParam("status.read_only", qStatusReadOnly); err != nil {
				return err
			}
		}
	}

	if o.StatusState != nil {

		// query param status.state
		var qrStatusState string

		if o.StatusState != nil {
			qrStatusState = *o.StatusState
		}
		qStatusState := qrStatusState
		if qStatusState != "" {

			if err := r.SetQueryParam("status.state", qStatusState); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VvolBindingsID != nil {

		// query param vvol.bindings.id
		var qrVvolBindingsID int64

		if o.VvolBindingsID != nil {
			qrVvolBindingsID = *o.VvolBindingsID
		}
		qVvolBindingsID := swag.FormatInt64(qrVvolBindingsID)
		if qVvolBindingsID != "" {

			if err := r.SetQueryParam("vvol.bindings.id", qVvolBindingsID); err != nil {
				return err
			}
		}
	}

	if o.VvolBindingsPartnerName != nil {

		// query param vvol.bindings.partner.name
		var qrVvolBindingsPartnerName string

		if o.VvolBindingsPartnerName != nil {
			qrVvolBindingsPartnerName = *o.VvolBindingsPartnerName
		}
		qVvolBindingsPartnerName := qrVvolBindingsPartnerName
		if qVvolBindingsPartnerName != "" {

			if err := r.SetQueryParam("vvol.bindings.partner.name", qVvolBindingsPartnerName); err != nil {
				return err
			}
		}
	}

	if o.VvolBindingsPartnerUUID != nil {

		// query param vvol.bindings.partner.uuid
		var qrVvolBindingsPartnerUUID string

		if o.VvolBindingsPartnerUUID != nil {
			qrVvolBindingsPartnerUUID = *o.VvolBindingsPartnerUUID
		}
		qVvolBindingsPartnerUUID := qrVvolBindingsPartnerUUID
		if qVvolBindingsPartnerUUID != "" {

			if err := r.SetQueryParam("vvol.bindings.partner.uuid", qVvolBindingsPartnerUUID); err != nil {
				return err
			}
		}
	}

	if o.VvolBindingsSecondaryID != nil {

		// query param vvol.bindings.secondary_id
		var qrVvolBindingsSecondaryID string

		if o.VvolBindingsSecondaryID != nil {
			qrVvolBindingsSecondaryID = *o.VvolBindingsSecondaryID
		}
		qVvolBindingsSecondaryID := qrVvolBindingsSecondaryID
		if qVvolBindingsSecondaryID != "" {

			if err := r.SetQueryParam("vvol.bindings.secondary_id", qVvolBindingsSecondaryID); err != nil {
				return err
			}
		}
	}

	if o.VvolIsBound != nil {

		// query param vvol.is_bound
		var qrVvolIsBound bool

		if o.VvolIsBound != nil {
			qrVvolIsBound = *o.VvolIsBound
		}
		qVvolIsBound := swag.FormatBool(qrVvolIsBound)
		if qVvolIsBound != "" {

			if err := r.SetQueryParam("vvol.is_bound", qVvolIsBound); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamLunCollectionGet binds the parameter fields
func (o *LunCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamLunCollectionGet binds the parameter order_by
func (o *LunCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
