// Code generated by go-swagger; DO NOT EDIT.

package s_a_n

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// LunCollectionGetReader is a Reader for the LunCollectionGet structure.
type LunCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LunCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLunCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLunCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLunCollectionGetOK creates a LunCollectionGetOK with default headers values
func NewLunCollectionGetOK() *LunCollectionGetOK {
	return &LunCollectionGetOK{}
}

/*
LunCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type LunCollectionGetOK struct {
	Payload *models.LunResponse
}

// IsSuccess returns true when this lun collection get o k response has a 2xx status code
func (o *LunCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this lun collection get o k response has a 3xx status code
func (o *LunCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this lun collection get o k response has a 4xx status code
func (o *LunCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this lun collection get o k response has a 5xx status code
func (o *LunCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this lun collection get o k response a status code equal to that given
func (o *LunCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the lun collection get o k response
func (o *LunCollectionGetOK) Code() int {
	return 200
}

func (o *LunCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/luns][%d] lunCollectionGetOK %s", 200, payload)
}

func (o *LunCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/luns][%d] lunCollectionGetOK %s", 200, payload)
}

func (o *LunCollectionGetOK) GetPayload() *models.LunResponse {
	return o.Payload
}

func (o *LunCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LunResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLunCollectionGetDefault creates a LunCollectionGetDefault with default headers values
func NewLunCollectionGetDefault(code int) *LunCollectionGetDefault {
	return &LunCollectionGetDefault{
		_statusCode: code,
	}
}

/*
LunCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type LunCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this lun collection get default response has a 2xx status code
func (o *LunCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this lun collection get default response has a 3xx status code
func (o *LunCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this lun collection get default response has a 4xx status code
func (o *LunCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this lun collection get default response has a 5xx status code
func (o *LunCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this lun collection get default response a status code equal to that given
func (o *LunCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the lun collection get default response
func (o *LunCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *LunCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/luns][%d] lun_collection_get default %s", o._statusCode, payload)
}

func (o *LunCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/luns][%d] lun_collection_get default %s", o._statusCode, payload)
}

func (o *LunCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *LunCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
